/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.uiframe.utils;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.base.uiframe.SysMenuItemInfo;
import com.kingdee.eas.base.uiframe.utils.MenuUpdateManager;
import com.kingdee.eas.framework.TreeBaseInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SysMenuUpdateManager
implements MenuUpdateManager {
    private DefaultKingdeeTreeNode olderNode = null;
    private SysMenuItemInfo newInfo = null;
    private SysMenuItemInfo updatedInfo = null;
    private boolean isNameChanaged = false;
    private boolean isNumberChanged = false;
    private boolean isUpdate = false;
    private Map<String, TreeBaseInfo> changedNodeInfos = new HashMap<String, TreeBaseInfo>();
    private boolean isVisibleChanged = false;
    private boolean isVisible = true;

    public SysMenuUpdateManager(DefaultKingdeeTreeNode olderNode, SysMenuItemInfo newInfo) {
        this.olderNode = olderNode;
        this.newInfo = newInfo;
    }

    @Override
    public void doCompare() {
        this.compare();
        if (this.isNumberChanged) {
            this.updateSubNodeLongNumber(this.olderNode);
        }
        if (this.isVisibleChanged) {
            this.updateSubNodeVisible(this.olderNode);
        } else if (this.isUpdate && !this.isNumberChanged && !this.isVisibleChanged) {
            this.changedNodeInfos.put(this.updatedInfo.getId().toString(), this.updatedInfo);
        }
    }

    private void updateSubNodeVisible(DefaultKingdeeTreeNode kdTreeNode) {
        SysMenuItemInfo menuInfo = (SysMenuItemInfo)kdTreeNode.getUserObject();
        menuInfo.setVisible(this.isVisible);
        kdTreeNode.setUserObject((Object)menuInfo);
        if (this.changedNodeInfos.get(menuInfo.getId().toString()) == null) {
            this.changedNodeInfos.put(menuInfo.getId().toString(), menuInfo);
        }
        if (kdTreeNode.getChildCount() > 0) {
            SysMenuItemInfo subNodeInfo = null;
            int j = kdTreeNode.getChildCount();
            for (int i = 0; i < j; ++i) {
                subNodeInfo = (SysMenuItemInfo)((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i)).getUserObject();
                subNodeInfo.setVisible(this.isVisible);
                this.updateSubNodeVisible((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i));
            }
        }
    }

    public SysMenuItemInfo getComparedInfo() {
        return this.updatedInfo;
    }

    @Override
    public TreeBaseInfo getUpdateInfo() {
        return this.updatedInfo;
    }

    @Override
    public Map<String, TreeBaseInfo> getChangedCollection() {
        return this.changedNodeInfos;
    }

    @Override
    public boolean isNeedUpdateUITree() {
        return this.isNameChanaged;
    }

    @Override
    public boolean isInfoUpdate() {
        return this.isUpdate;
    }

    private void updateSubNodeLongNumber(DefaultKingdeeTreeNode kdTreeNode) {
        SysMenuItemInfo menuInfo = (SysMenuItemInfo)kdTreeNode.getUserObject();
        menuInfo.setLongNumber(this.changeLongNumber(menuInfo.getLongNumber(), menuInfo.getNumber()));
        kdTreeNode.setUserObject((Object)menuInfo);
        this.changedNodeInfos.put(menuInfo.getId().toString(), menuInfo);
        if (kdTreeNode.getChildCount() > 0) {
            SysMenuItemInfo subNodeInfo = null;
            int j = kdTreeNode.getChildCount();
            for (int i = 0; i < j; ++i) {
                subNodeInfo = (SysMenuItemInfo)((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i)).getUserObject();
                subNodeInfo.setLongNumber(menuInfo.getLongNumber() + "!" + subNodeInfo.getNumber());
                this.updateSubNodeLongNumber((DefaultKingdeeTreeNode)kdTreeNode.getChildAt(i));
            }
        }
    }

    private void compare() {
        SysMenuItemInfo olderInfo = (SysMenuItemInfo)this.olderNode.getUserObject();
        this.updatedInfo = (SysMenuItemInfo)this.olderNode.getUserObject();
        boolean propChangedTag = false;
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo currentLang2 = null;
        while (iter.hasNext()) {
            currentLang2 = (LanguageInfo)iter.next();
            propChangedTag = !this.isSameString(olderInfo.getName(currentLang2.getLocale()), this.newInfo.getName(currentLang2.getLocale()));
            this.isNameChanaged = propChangedTag | this.isNameChanaged;
            this.isUpdate |= propChangedTag;
            if (!propChangedTag) continue;
            this.updatedInfo.setName(this.newInfo.getName(currentLang2.getLocale()), currentLang2.getLocale());
        }
        this.isNumberChanged = propChangedTag = !this.isSameString(olderInfo.getNumber(), this.newInfo.getNumber());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setNumber(this.newInfo.getNumber());
        }
        propChangedTag = olderInfo.getIndustry() != this.newInfo.getIndustry();
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setIndustry(this.newInfo.getIndustry());
        }
        propChangedTag = !this.isSameString(olderInfo.getNoSuit(), this.newInfo.getNoSuit());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setNoSuit(this.newInfo.getNoSuit());
        }
        propChangedTag = !this.isSameString(olderInfo.getImagePath(), this.newInfo.getImagePath());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setImagePath(this.newInfo.getImagePath());
        }
        propChangedTag = !this.isSameString(olderInfo.getUiClassName(), this.newInfo.getUiClassName());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setUiClassName(this.newInfo.getUiClassName());
        }
        propChangedTag = null == olderInfo.getOpenMethod() && null != this.newInfo.getOpenMethod() || null != olderInfo.getOpenMethod() && null == this.newInfo.getOpenMethod() ? true : (null == olderInfo.getOpenMethod() && null == this.newInfo.getOpenMethod() ? false : olderInfo.getOpenMethod().getValue() != this.newInfo.getOpenMethod().getValue());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setOpenMethod(this.newInfo.getOpenMethod());
        }
        propChangedTag = !this.isSameString(olderInfo.getShortcutCode(), this.newInfo.getShortcutCode());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setShortcutCode(this.newInfo.getShortcutCode());
        }
        propChangedTag = null == olderInfo.getFunction() && null != this.newInfo.getFunction() || null != olderInfo.getFunction() && null == this.newInfo.getFunction() ? true : (null == olderInfo.getFunction() && null == this.newInfo.getFunction() ? false : !olderInfo.getFunction().getId().toString().trim().equals(this.newInfo.getFunction().getId().toString().trim()));
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setFunction(this.newInfo.getFunction());
        }
        langList = KDBizMultiLangBox.getLanguageList();
        for (LanguageInfo currentLang2 : langList) {
            propChangedTag = !this.isSameString(olderInfo.getDescription(currentLang2.getLocale()), this.newInfo.getDescription(currentLang2.getLocale()));
            this.isUpdate |= propChangedTag;
            if (!propChangedTag) continue;
            this.updatedInfo.setDescription(this.newInfo.getDescription(currentLang2.getLocale()), currentLang2.getLocale());
        }
        propChangedTag = !this.isSameString(olderInfo.getUiClassParam(), this.newInfo.getUiClassParam());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setUiClassParam(this.newInfo.getUiClassParam());
        }
        propChangedTag = !this.isSameString(olderInfo.getUiOprt(), this.newInfo.getUiOprt());
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setUiOprt(this.newInfo.getUiOprt());
        }
        propChangedTag = olderInfo.isEnabled() != this.newInfo.isEnabled();
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setEnabled(this.newInfo.isEnabled());
        }
        propChangedTag = olderInfo.isVisible() != this.newInfo.isVisible();
        this.isVisible = this.newInfo.isVisible();
        this.isVisibleChanged = propChangedTag;
        this.isUpdate |= propChangedTag;
        if (propChangedTag) {
            this.updatedInfo.setVisible(this.newInfo.isVisible());
        }
    }

    private String changeLongNumber(String olderLongNum, String newNum) {
        String newLongNum = null;
        String[] numberArray = olderLongNum.split("!");
        int len = numberArray.length;
        if (len == 1) {
            newLongNum = newNum;
        } else {
            numberArray[numberArray.length - 1] = newNum;
            StringBuffer longNumBuff = new StringBuffer();
            int j = numberArray.length;
            for (int i = 0; i < j; ++i) {
                if (i != 0) {
                    longNumBuff.append("!");
                }
                longNumBuff.append(numberArray[i]);
            }
            newLongNum = longNumBuff.toString();
        }
        return newLongNum;
    }

    private boolean isSameString(String theString, String toString) {
        boolean sameTag = true;
        if (this.isStringEmpty(theString) && !this.isStringEmpty(toString) || !this.isStringEmpty(theString) && this.isStringEmpty(toString)) {
            sameTag = false;
        } else if (this.isStringEmpty(theString) && this.isStringEmpty(toString)) {
            sameTag = theString.trim().equals(toString.trim());
        }
        return sameTag;
    }

    private boolean isStringEmpty(String theString) {
        boolean emptyTag = false;
        if (null != theString && theString.trim().length() > 0) {
            emptyTag = true;
        }
        return emptyTag;
    }
}

