/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor;

import com.kingdee.bos.AbstractBOSObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.IBOSObject;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.bos.orm.impl.server.ORMRPConfig;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.message.MessageCenterFactory;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.IUserMonitorAgent;
import com.kingdee.eas.base.usermonitor.KickOutMsgInfo;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorAgentFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorException;
import com.kingdee.eas.base.usermonitor.UserMonitorSettingInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserMonitor
extends AbstractBOSObject
implements IUserMonitor,
IBOSObject {
    private static final Logger logger = Logger.getLogger(UserMonitor.class);
    private IUserMonitorAgent userMonitorAgent = null;

    public UserMonitor() {
        this(ContextUtils.getContextFromSessionNoException());
    }

    public UserMonitor(Context ctx) {
        super(ctx);
        this.registerInterface(IUserMonitor.class, this);
        this.userMonitorAgent = UserMonitorAgentFactory.getInstance(ctx);
    }

    public Context getContext() {
        Context ctx = super.getContext();
        if (ctx == null) {
            ctx = ConfigMDUtil.getContext();
        }
        return ctx;
    }

    @Override
    public void addnew(UMRegistryInfo info) throws EASBizException {
        String url = ORMRPConfig.getRPCListeningURL((boolean)false);
        if (url == null) {
            url = "";
        }
        info.setLoginServerURL(url);
        String ipAddress = ORMRPConfig.getRpcClientIP();
        logger.error((Object)("UserMonitor getClientIPAddress: " + ipAddress));
        if (ipAddress != null && !"".equals(ipAddress) && !"/127.0.0.1".equals(ipAddress)) {
            info.setClientIPAddress(ipAddress.substring(1));
        }
        if (info.getGUIUserId() != null) {
            info.setId(info.getGUIUserId());
        }
        this.userMonitorAgent.addnew(this.getContext(), info);
        try {
            this.setMessageStatusReaded(this.getContext(), info.getUserId());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void setMessageStatusReaded(Context ctx, String receiverId) throws BOSException {
        if (ctx != null) {
            MessageCenterFactory.getLocalInstance((Context)ctx).clearIdleTimeOutMsg(receiverId);
        } else {
            logger.info((Object)"ctx is null. setMessageStatusReaded fail");
        }
    }

    @Override
    public IObjectCollection getCollection() throws EASBizException {
        return this.userMonitorAgent.getCollection();
    }

    @Override
    public IObjectCollection getCollectionByDataCenter(String dataCenterName) throws EASBizException {
        return this.userMonitorAgent.getCollectionByDataCenter(dataCenterName);
    }

    @Override
    public IObjectCollection getCollectionByOrgRange(String dataCenterName, List orgList) throws EASBizException {
        return this.userMonitorAgent.getCollectionByOrgRange(dataCenterName, orgList);
    }

    @Override
    public void deleteByIPs(String[] ips) throws EASBizException, BOSException {
        this.userMonitorAgent.deleteByIPs(ips);
    }

    @Override
    public void deleteSessionAndUserMonitorInfo(String sessionId, Boolean isForce) throws EASBizException, BOSException {
        this.userMonitorAgent.deleteSessionAndUserMonitorInfo(sessionId, isForce);
    }

    @Override
    public void update(UMRegistryInfo info) throws EASBizException {
        this.userMonitorAgent.update(info);
    }

    @Override
    public void updateLastOperateTime(String id) throws EASBizException {
        this.userMonitorAgent.updateLastOperateTime(id);
    }

    @Override
    public IObjectValue getValue(String id) throws EASBizException {
        return this.userMonitorAgent.getValue(id);
    }

    @Override
    public Date getCurrentTime() throws EASBizException {
        return this.userMonitorAgent.getCurrentTime();
    }

    @Override
    public boolean isUserOnline(String dcName, String userName) throws EASBizException {
        return this.userMonitorAgent.isUserOnline(dcName, userName);
    }

    @Override
    public UMRegistryInfo findUser(String dcName, String userName) throws EASBizException {
        return this.userMonitorAgent.findUser(dcName, userName);
    }

    @Override
    public List findUsers(String dcName, String userName) throws EASBizException {
        return this.userMonitorAgent.findUsers(dcName, userName);
    }

    @Override
    public void updateUserMonitorSetting(UserMonitorSettingInfo setInfo) throws EASBizException, UserMonitorException {
        this.userMonitorAgent.updateUserMonitorSetting(setInfo);
    }

    @Override
    public UserMonitorSettingInfo getUserMonitorSetting() throws EASBizException {
        return this.userMonitorAgent.getUserMonitorSetting();
    }

    @Override
    public void sendMessageToUser(String sessionId, Map senderMap, Map msgTopicMap, Map msgContentMap) throws EASBizException {
        this.userMonitorAgent.sendMessageToUser(this.getContext(), sessionId, senderMap, msgTopicMap, msgContentMap);
    }

    @Override
    public void sendMessageToUser(String sessionId, String sender, Map msgTopicMap, Map msgContentMap) throws EASBizException {
        this.userMonitorAgent.sendMessageToUser(this.getContext(), sessionId, sender, msgTopicMap, msgContentMap);
    }

    @Override
    public void updateLastOperate(UMRegistryInfo info) throws EASBizException {
        this.userMonitorAgent.updateLastOperate(info);
    }

    public BOSObjectType getType() {
        return null;
    }

    @Override
    public boolean isPortalUserExists(String sessionId) throws EASBizException {
        return this.userMonitorAgent.isPortalUserExists(sessionId);
    }

    @Override
    public void setMsgPriorityHighToMid(String sessionId) {
        this.userMonitorAgent.setMsgPriorityHighToMid(sessionId);
    }

    @Override
    public boolean isMonitorPortal() throws EASBizException {
        return this.userMonitorAgent.isMonitorPortal();
    }

    @Override
    public void updateIsMonitorPortal(boolean isMonitorPortal) throws EASBizException {
        this.userMonitorAgent.updateIsMonitorPortal(isMonitorPortal);
    }

    @Override
    public boolean isSendTickoutMessage() throws EASBizException, BOSException {
        return this.userMonitorAgent.needSendTickoutMessage(this.getContext());
    }

    @Override
    public void updateTimerLastOperateTime(String id) throws EASBizException {
        this.userMonitorAgent.updateTimerLastOperateTime(id);
    }

    @Override
    public IObjectCollection getCollectionUsingOrgRange(String dataCenterName) throws BOSException, EASBizException {
        return this.userMonitorAgent.getCollectionUsingOrgRange(this.getContext(), dataCenterName);
    }

    @Override
    public boolean isSameNamePortalUserExists(String dataCenter, String userName, String sessionId) throws BOSException, EASBizException {
        return this.userMonitorAgent.isSameNamePortalUserExists(dataCenter, userName, sessionId);
    }

    @Override
    public void sendMsgAndKickOut(List<KickOutMsgInfo> msgs) throws BOSException, EASBizException {
        Context ctx = this.getContext();
        this.userMonitorAgent.sendMsgAndKickOut(ctx, ctx.getAIS(), ctx.getSolution(), msgs);
    }

    @Override
    public Map<String, Object> getServerAndUserNumberMap() throws BOSException, EASBizException {
        return this.userMonitorAgent.getServerAndUserNumberMap();
    }

    @Override
    public boolean isOverLicenseCount(String userNumber, String dcNumber, String contextId) {
        return this.userMonitorAgent.isOverLicenseCount(this.getContext(), userNumber, dcNumber, contextId);
    }
}

