/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor;

import com.kingdee.eas.base.usermonitor.IUserMonitorAgent;
import com.kingdee.eas.base.usermonitor.UserMonitorAgentFactory;
import com.kingdee.eas.base.usermonitor.app.ClusterUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserMonitorManager {
    private static Logger logger = Logger.getLogger(UserMonitorManager.class);
    public static String USER_NUMBER = "User.Number";
    public static String USER_NUMBER_TOTAL = "User.Number.Total";

    public static Map<String, Object> getAttributes() {
        logger.error((Object)"UserMonitorJMX<<<<<<<<<<<<:into UserMonitorManager.getAttributes");
        HashMap<String, Object> ret = new HashMap<String, Object>();
        IUserMonitorAgent userMonitor = UserMonitorAgentFactory.getInstance(null);
        try {
            Map<String, Object> serverAndUserNumberMap = userMonitor.getServerAndUserNumberMap();
            String serverName = System.getProperty("EAS_INSTANCE_NAME");
            Map nameAndUrlMap = ClusterUtil.getClusterNameAndUrlMap();
            String currentServerUrl = (String)nameAndUrlMap.get(serverName);
            Object number = serverAndUserNumberMap.get(currentServerUrl);
            logger.error((Object)("UserMonitorJMX<<<<<<<<<<<<:currentServerUrl:" + currentServerUrl + " number:" + number));
            Integer total = UserMonitorManager.getTotalNumber(serverAndUserNumberMap);
            ret.put(USER_NUMBER, number == null ? Integer.valueOf(0) : number);
            if (currentServerUrl == null) {
                logger.error((Object)"UserMonitorJMX<<<<<<<<<<<<:currentServerUrl is null: set total ");
                ret.put(USER_NUMBER, total);
            }
            logger.error((Object)("UserMonitorJMX<<<<<<<<<<<<:total:" + total));
            ret.put(USER_NUMBER_TOTAL, total);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return ret;
    }

    public static Object getAttribute(String name) {
        return UserMonitorManager.getAttributes().get(name);
    }

    private static Integer getTotalNumber(Map<String, Object> serverAndUserNumberMap) {
        Iterator<Object> itr = serverAndUserNumberMap.values().iterator();
        Integer ret = new Integer(0);
        while (itr.hasNext()) {
            ret = ret + (Integer)itr.next();
        }
        return ret;
    }
}

