/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.UserPromptBox;
import com.kingdee.eas.base.usermonitor.INotAllowRepeatLoginUser;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserFactory;
import com.kingdee.eas.base.usermonitor.NotAllowRepeatLoginUserInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.client.AbstractNotAllowRepeatLoginSettingUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class NotAllowRepeatLoginSettingUI
extends AbstractNotAllowRepeatLoginSettingUI {
    private static final Logger logger = CoreUIObject.getLogger(NotAllowRepeatLoginSettingUI.class);

    public void onLoad() throws Exception {
        this.initButton();
        super.onLoad();
        this.initCtrl();
        this.initLabel();
    }

    private void initCtrl() {
        String dateFormat = CtrlFormatUtilities.getDateTimeFormatString();
        this.tblMain.getColumn("effectiveDate").getStyleAttributes().setNumberFormat(dateFormat);
        this.tblMain.getColumn("invalidationDate").getStyleAttributes().setNumberFormat(dateFormat);
        this.tblMain.getColumn("PWEffectiveDate").getStyleAttributes().setNumberFormat(dateFormat);
    }

    private void initButton() {
        this.btnAddNew.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnAttachment.setVisible(false);
        this.btnView.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnLocate.setVisible(false);
        this.btnDelUser.setEnabled(true);
    }

    private void initLabel() {
        if (this.isDisallowUserRepeatLoginDefault()) {
            String resource = "com.kingdee.eas.base.usermonitor.client.UserMonitorResource";
            this.kDLabel1.setText(EASResource.getString((String)resource, (String)"userAllowRelogin"));
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select fuseridid from T_UM_NotAllowRepeatLoginUser");
        filter.getFilterItems().add(new FilterItemInfo("User.id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionAddNewUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewUser_actionPerformed(e);
        KDCommonPromptDialog dlg = this.getUserDialog();
        dlg.show();
        if (!dlg.isCanceled()) {
            Object data = dlg.getData();
            Object[] userInfos = (Object[])data;
            UserCollection userCollection = new UserCollection();
            for (int i = 0; i < userInfos.length; ++i) {
                userCollection.add((UserInfo)userInfos[i]);
            }
            NotAllowRepeatLoginUserFactory.getRemoteInstance().saveNotAllowRepeatLoginUser(userCollection);
            this.refresh(e);
        }
    }

    private KDCommonPromptDialog getUserDialog() {
        UserPromptBox dlg = null;
        IUIWindow win = this.getUIWindow();
        if (win instanceof Frame) {
            dlg = new UserPromptBox((Frame)this.getUIWindow());
        } else if (win instanceof Dialog) {
            dlg = new UserPromptBox((Dialog)this.getUIWindow());
        }
        if (dlg != null) {
            dlg.setEnabledMultiSelection(true);
            IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.base.permission.app.UserListQuery");
            dlg.setQueryInfo(queryPK);
            dlg.getUIConetxt().put("mergeUserRangeFilter", false);
        }
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select fuseridid from T_UM_NotAllowRepeatLoginUser");
        filterInfo.getFilterItems().add(new FilterItemInfo("User.id", (Object)sql.toString(), CompareType.NOTINNER));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDelete", (Object)0, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        if (dlg != null) {
            dlg.setEntityViewInfo(entityViewInfo);
            dlg.setHasCUDefaultFilter(false);
        }
        return dlg;
    }

    @Override
    public void actionDelUser_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelUser_actionPerformed(e);
        this.checkSelected();
        this.processDelUserFromNotAllow();
        this.refresh(e);
    }

    private void processDelUserFromNotAllow() throws EASBizException, BOSException {
        ArrayList<String> delUserList = new ArrayList<String>();
        ArrayList<String> delUserNumberList = new ArrayList<String>();
        int size = this.tblMain.getSelectManager().size();
        for (int i = 0; i < size; ++i) {
            IBlock selectBlock = KDTSelectBlock.change((KDTable)this.tblMain, (IBlock)this.tblMain.getSelectManager().get(i));
            int size1 = selectBlock.getBottom();
            for (int j = selectBlock.getTop(); j <= size1; ++j) {
                Object userIdObj = this.tblMain.getRow(j).getCell("id").getValue();
                delUserList.add(userIdObj.toString());
                Object userNumberObj = this.tblMain.getRow(j).getCell("number").getValue();
                delUserNumberList.add(userNumberObj.toString());
            }
        }
        IObjectPK logpk = LogUtil.beginLog(null, (String)"_deleteUserForNotAllow", (BOSObjectType)new NotAllowRepeatLoginUserInfo().getBOSType(), null, (String)Arrays.toString((Object[])delUserNumberList.toArray()), (String)"usermonitor_notallow_repeat_delete");
        String idList = StringUtils.arrayToString((Object[])delUserList.toArray(), (String)",");
        INotAllowRepeatLoginUser iNotAllowRepeatLoginUser = NotAllowRepeatLoginUserFactory.getRemoteInstance();
        iNotAllowRepeatLoginUser.deleteUserForNotAllow(idList);
        LogUtil.afterLog(null, (IObjectPK)logpk);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return null;
    }

    private IUserMonitor getUserMonitor() throws EASBizException {
        IUserMonitor userMonitor = UserMonitorFactory.getRemoteInstance();
        return userMonitor;
    }

    private boolean isDisallowUserRepeatLoginDefault() {
        try {
            INotAllowRepeatLoginUser iNotAllowRepeatLoginUser = NotAllowRepeatLoginUserFactory.getRemoteInstance();
            boolean disallowByDefault = iNotAllowRepeatLoginUser.isDisallowRepeatLoginByDefault();
            return disallowByDefault;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }
}

