/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.client.IdleListenerHelper;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.common.EASBizException;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class UserMonitorClientThread
extends Thread {
    private static Logger logger = Logger.getLogger((String)UserMonitorClientThread.class.getName());
    private boolean stop = true;
    private static final long sleepTimeInMinutes = 1L;
    private static final long idleTimeInMinutes = 5L;

    public void stopThread() {
        this.stop = true;
    }

    public boolean isStopped() {
        return this.stop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        UserMonitorClientThread.initListener();
        this.stop = false;
        UMRegistryInfo reg = null;
        Date updateDate = null;
        Date currentDate = null;
        IUserMonitor iUserMonitor = null;
        try {
            iUserMonitor = UserMonitorFactory.getRemoteInstance();
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return;
        }
        while (!this.stop) {
            try {
                Thread.sleep(60000L);
                Class<UserMonitorClientThread> e = UserMonitorClientThread.class;
                // MONITORENTER : com.kingdee.eas.base.usermonitor.client.UserMonitorClientThread.class
                reg = UserMonitorClientTool.getRegistryInfo();
                updateDate = (Date)reg.get("updateDate");
                currentDate = new Date();
                if (!(updateDate == null || reg.isFinished() && currentDate.getTime() - updateDate.getTime() >= 60000L)) {
                    iUserMonitor.updateLastOperate(reg);
                }
                if (updateDate != null && reg.isFinished() && currentDate.getTime() - updateDate.getTime() > 300000L) {
                    try {
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                IdleListenerHelper.doIdleThing();
                            }
                        }).start();
                    }
                    catch (Throwable e2) {
                        logger.error((Object)"", e2);
                    }
                }
                // MONITOREXIT : e
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void initListener() {
        Listener listener = new Listener();
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 16L);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 4L);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener, 8L);
    }

    static class Listener
    implements AWTEventListener {
        Listener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 501 || event.getID() == 401) {
                IUIObject uiObject;
                Container container = SwingUtilities.getAncestorOfClass(CoreUIObject.class, (Component)event.getSource());
                if (container != null && container instanceof CoreUIObject) {
                    UserMonitorClientTool.monitor((CoreUIObject)container);
                } else if (SystemEntry.instance.getMainUIObject() != null && (uiObject = SystemEntry.instance.getMainUIObject().getSelectedUIObject()) instanceof CoreUIObject) {
                    UserMonitorClientTool.monitor((CoreUIObject)uiObject);
                }
            }
        }
    }
}

