/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.eas.base.netctrl.IntegerCompareEnum;
import com.kingdee.eas.base.netctrl.StringCompareEnum;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.usermonitor.UserMonitorAssistInfo;
import com.kingdee.eas.base.usermonitor.client.AbstractUserMonitorFilterUI;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class UserMonitorFilterUI
extends AbstractUserMonitorFilterUI {
    private List filterItems = null;

    public UserMonitorFilterUI() throws Exception {
        this.initComboBoxContent();
    }

    private void initComboBoxContent() {
        this.userNameCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").toArray());
        this.userRealNameCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").toArray());
        this.userTypeCB.addItem(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").get(0));
        this.userCUNameCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").toArray());
        this.clientIPAddressCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").toArray());
        this.loginTimeCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.IntegerCompareEnum").toArray());
        this.dullTimeCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.IntegerCompareEnum").toArray());
        this.currentMainBizUnitCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").toArray());
        this.openWindowTitleCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").toArray());
        this.urlCB.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.netctrl.StringCompareEnum").toArray());
        this.userType.addItem((Object)"");
        this.userType.addItems(EnumUtils.getEnumList((String)"com.kingdee.eas.base.permission.UserType").toArray());
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.filterItems = (List)this.getUIContext().get("filterItems");
        this.loginTimeDatePicker.setValue(null);
        GregorianCalendar initDate = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        this.dullTimePicker.setValue((Object)initDate.getTime());
        this.initComponentValue();
    }

    private void initComponentValue() {
        if (this.filterItems == null || this.filterItems.size() == 0) {
            return;
        }
        for (UserMonitorAssistInfo item : this.filterItems) {
            switch (item.getAttrType()) {
                case 0: {
                    this.txtUserName.setText(item.getAttrValue());
                    this.userNameCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                    break;
                }
                case 1: {
                    this.txtUserRealName.setText(item.getAttrValue());
                    this.userRealNameCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                    break;
                }
                case 2: {
                    this.userType.setSelectedItem((Object)UserType.getEnum((int)Integer.parseInt(item.getAttrValue())));
                    this.userTypeCB.setSelectedItem(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : "");
                    break;
                }
                case 3: {
                    this.txtUserCUName.setText(item.getAttrValue());
                    this.userCUNameCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                    break;
                }
                case 4: {
                    this.txtClientIPAddress.setText(item.getAttrValue());
                    this.clientIPAddressCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                    break;
                }
                case 5: {
                    this.loginTimeDatePicker.setValue((Object)new Timestamp(Long.parseLong(item.getAttrValue())));
                    this.loginTimeCB.setSelectedItem((Object)this.getIntCompareType(item.getCompareType()));
                    break;
                }
                case 6: {
                    long timestamp = Long.parseLong(item.getAttrValue());
                    int hour = (int)timestamp / 3600000;
                    int minute = (int)(timestamp - (long)(hour * 3600 * 1000)) / 60000;
                    int second = (int)(timestamp - (long)(hour * 3600 * 1000) - (long)(minute * 60 * 1000)) / 1000;
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(11, hour);
                    calendar.set(12, minute);
                    calendar.set(13, second);
                    this.dullTimePicker.setValue((Object)calendar.getTime());
                    this.dullTimeCB.setSelectedItem((Object)this.getIntCompareType(item.getCompareType()));
                    break;
                }
                case 7: {
                    this.txtCurrentMainBizUnit.setText(item.getAttrValue());
                    this.currentMainBizUnitCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                    break;
                }
                case 8: {
                    this.txtOpenWindowTitle.setText(item.getAttrValue());
                    this.openWindowTitleCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                    break;
                }
                case 9: {
                    this.txtURL.setText(item.getAttrValue());
                    this.urlCB.setSelectedItem((Object)(item.getCompareType() == 0 ? StringCompareEnum.EQUAL : StringCompareEnum.LIKE));
                }
            }
        }
    }

    private IntegerCompareEnum getIntCompareType(int compareType) {
        switch (compareType) {
            case 0: {
                return IntegerCompareEnum.EQUAL;
            }
            case 1: {
                return IntegerCompareEnum.GREATER;
            }
            case -1: {
                return IntegerCompareEnum.LESS;
            }
        }
        return IntegerCompareEnum.EQUAL;
    }

    private void addFilterItem(int attrType, KDComboBox cb, String strValue) {
        int compareType = -999;
        Object objCp = cb.getSelectedItem();
        if (objCp instanceof StringCompareEnum) {
            compareType = ((StringCompareEnum)objCp).equals((Object)StringCompareEnum.EQUAL) ? 0 : 5;
        } else if (objCp instanceof IntegerCompareEnum) {
            IntegerCompareEnum comparator = (IntegerCompareEnum)objCp;
            if (comparator.equals((Object)IntegerCompareEnum.EQUAL)) {
                compareType = 0;
            } else if (comparator.equals((Object)IntegerCompareEnum.GREATER)) {
                compareType = 1;
            } else if (comparator.equals((Object)IntegerCompareEnum.LESS)) {
                compareType = -1;
            }
        }
        if (attrType == -1 || compareType == -999) {
            return;
        }
        UserMonitorAssistInfo item = new UserMonitorAssistInfo(attrType, compareType, strValue);
        this.filterItems.add(item);
    }

    @Override
    protected void okButton_actionPerformed(ActionEvent e) throws Exception {
        this.filterItems.clear();
        if (!StringUtils.isEmpty((String)this.txtUserName.getText())) {
            this.addFilterItem(0, this.userNameCB, this.txtUserName.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.txtUserRealName.getText())) {
            this.addFilterItem(1, this.userRealNameCB, this.txtUserRealName.getText().trim());
        }
        if (this.userType.getSelectedItem() != null && !this.userType.getSelectedItem().toString().equals("")) {
            this.addFilterItem(2, this.userTypeCB, ((UserType)this.userType.getSelectedItem()).getValue() + "");
        }
        if (!StringUtils.isEmpty((String)this.txtUserCUName.getText())) {
            this.addFilterItem(3, this.userCUNameCB, this.txtUserCUName.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.txtClientIPAddress.getText())) {
            this.addFilterItem(4, this.clientIPAddressCB, this.txtClientIPAddress.getText().trim());
        }
        if (this.loginTimeDatePicker.getValue() != null) {
            this.addFilterItem(5, this.loginTimeCB, this.loginTimeDatePicker.getTimestamp().getTime() + "");
        }
        if (!((Date)this.dullTimePicker.getValue()).equals(new GregorianCalendar(0, 0, 0, 0, 0, 0).getTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)this.dullTimePicker.getValue());
            long time = calendar.get(11) * 3600 + calendar.get(12) * 60 + calendar.get(13);
            this.addFilterItem(6, this.dullTimeCB, time * 1000L + "");
        }
        if (!StringUtils.isEmpty((String)this.txtCurrentMainBizUnit.getText())) {
            this.addFilterItem(7, this.currentMainBizUnitCB, this.txtCurrentMainBizUnit.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.txtOpenWindowTitle.getText())) {
            this.addFilterItem(8, this.openWindowTitleCB, this.txtOpenWindowTitle.getText().trim());
        }
        if (!StringUtils.isEmpty((String)this.txtURL.getText())) {
            this.addFilterItem(9, this.urlCB, this.txtURL.getText().trim());
        }
        this.destroyWindow();
    }

    @Override
    protected void cancelButton_actionPerformed(ActionEvent e) throws Exception {
        this.destroyWindow();
    }
}

