/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.AppLogInfo;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorException;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorSettingInfo;
import com.kingdee.eas.base.usermonitor.client.AbstractUserMonitorSettingUI;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;

public class UserMonitorSettingUI
extends AbstractUserMonitorSettingUI {
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.base.usermonitor.client.UserMonitorResource";

    public void onLoad() throws Exception {
        super.onLoad();
        UserMonitorSettingInfo info = this.getUserMonitorInfo();
        this.spinIdleTime.setValue((Object)new Long(info.getIdleTime()));
        this.radioEnable.setSelected(info.isMonitorUserAction());
        this.radioDisable.setSelected(!info.isMonitorUserAction());
    }

    private UserMonitorSettingInfo getUserMonitorInfo() throws EASBizException {
        IUserMonitor userMonitor = UserMonitorFactory.getRemoteInstance();
        return userMonitor.getUserMonitorSetting();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        UserMonitorSettingInfo info = new UserMonitorSettingInfo();
        info.setIdleTime(Long.valueOf(this.spinIdleTime.getValue().toString()));
        info.setMonitorUserAction(this.radioEnable.isSelected());
        if (this.checkData(info)) {
            try {
                IObjectPK pk = LogUtil.beginLog(null, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"userMonitorSetting"), (BOSObjectType)new AppLogInfo().getBOSType(), null, (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"userMonitorSetting"));
                IUserMonitor userMonitor = UserMonitorFactory.getRemoteInstance();
                userMonitor.updateUserMonitorSetting(info);
                UserMonitorClientTool.setMonitorUserAction(this.radioEnable.isSelected());
                LogUtil.afterLog(null, (IObjectPK)pk);
                MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"setupSuccess"));
            }
            catch (UserMonitorException ex) {
                this.handUIException((Throwable)((Object)ex));
            }
            this.disposeUIWindow();
        }
    }

    private boolean checkData(UserMonitorSettingInfo info) {
        if (info.getIdleTime() < 10L || info.getIdleTime() > 6000L) {
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"idleTimeInfo"));
            this.spinIdleTime.requestFocusInWindow();
            return false;
        }
        return true;
    }
}

