/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.usermonitor.client;

import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.message.client.TempMsgManager;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.base.uiframe.EASLoginException;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.KickOutMsgInfo;
import com.kingdee.eas.base.usermonitor.KickoutFacadeFactory;
import com.kingdee.eas.base.usermonitor.UMRegistryCollection;
import com.kingdee.eas.base.usermonitor.UMRegistryInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorAssistInfo;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.client.AbstractUserMonitorUI;
import com.kingdee.eas.base.usermonitor.client.IsMonitorPortalUI;
import com.kingdee.eas.base.usermonitor.client.MessageUI;
import com.kingdee.eas.base.usermonitor.client.NotAllowRepeatLoginSettingUI;
import com.kingdee.eas.base.usermonitor.client.UMregistryComparator;
import com.kingdee.eas.base.usermonitor.client.UserMonitorClientTool;
import com.kingdee.eas.base.usermonitor.client.UserMonitorSettingUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class UserMonitorUI
extends AbstractUserMonitorUI {
    private static final long serialVersionUID = -2822709220108756530L;
    private static Logger logger = Logger.getLogger((String)UserMonitorUI.class.getName());
    private static final String RESOURCE_FULLNAME = "com.kingdee.eas.base.usermonitor.client.UserMonitorResource";
    private static final String RESOURCE_COMMON = "com.kingdee.eas.base.usermonitor.UserMonitorCommonResource";
    private static final String ZERO_TIME_STRING = "00:00:00";
    private static Hashtable comparators = new Hashtable();
    private static String propertyName = "userName";
    private UMRegistryCollection regs = null;
    private static final String SESSIONID = "sessionID";
    private static final String DATACENTERNAME = "dataCenterName";
    private static final String USERNAME = "userName";
    private static final String USER_REAL_NAME = "userRealName";
    private static final String USER_TYPE = "userType";
    private static final String USER_CU_NAME = "userCUName";
    private static final String CLIENT_IPADDRESS = "clientIPAddress";
    private static final String LOGIN_TIME = "loginTime";
    private static final String ONLINE_TIME = "onlineTime";
    private static final String DULL_TIME = "dullTime";
    private static final String CURRENT_MAINBIZUNIT = "currentMainBizUnit";
    private static final String OPENWINDOW_TITLE = "openWindowTitle";
    private static final String ACTIONNAME = "actionName";
    private static final String ACTION_DESCRIPTION = "actionDescription";
    private static final String URL = "url";
    private static final String GUI_USERID = "GUIUserId";
    private static final String LOGIN_TYPE = "loginType";
    private List filterItems = new ArrayList();
    private static final String strResource = "com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnQuery.setEnabled(true);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setupKDTable();
        this.initMyWorkButton();
        try {
            this.doRefresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"loadRegistriesFailed"), (Throwable)e);
        }
        if (this.tblMain.getRow(0) != null) {
            this.tblMain.getSelectManager().select(0, 0, 0, 0);
        }
    }

    private void setupKDTable() {
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(SESSIONID).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(DATACENTERNAME).getStyleAttributes().setHided(true);
        KDTDefaultCellEditor dateEditor = new KDTDefaultCellEditor(new KDDatePicker());
        this.tblMain.getColumn(LOGIN_TIME).setEditor((ICellEditor)dateEditor);
        this.tblMain.getColumn(LOGIN_TIME).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getViewManager().setFreezeView(0, 4);
    }

    private void initMyWorkButton() {
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.setButtonDefaultStyl(this.btnRefresh);
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnKickOut.setIcon(EASResource.getIcon((String)"imgTbtn_cutlink"));
        this.menuItemKickOut.setIcon(EASResource.getIcon((String)"imgTbtn_cutlink"));
        this.btnSendMsg.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.menuItemSendMsg.setIcon(EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnBroadcastTempMsg.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.menuItemBroadcastTempMsg.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
        this.btnUserMonitorSetting.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
        this.menuItemUserMonitorSetting.setIcon(EASResource.getIcon((String)"imgTbtn_advancedsetting"));
    }

    public String getUITitle() {
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)"userMonitor");
    }

    private void doRefresh() throws Exception {
        this.loadUMRegistry();
        this.filterUMRegistry();
        this.fillUMRegistryTable(this.sortUMRegistries(propertyName, true));
        this.displayTotalInBar();
    }

    private void filterUMRegistry() throws EASBizException {
        if (this.filterItems == null || this.filterItems.size() == 0 || this.regs == null || this.regs.size() == 0) {
            return;
        }
        UMRegistryInfo info = null;
        UserMonitorAssistInfo assistInfo = null;
        block18: for (int i = 0; i < this.regs.size(); ++i) {
            info = this.regs.get(i);
            boolean isFound = true;
            String strParam = "";
            long timeParam = 0L;
            int k = this.filterItems.size();
            for (int j = 0; j < k; ++j) {
                assistInfo = (UserMonitorAssistInfo)this.filterItems.get(j);
                switch (assistInfo.getAttrType()) {
                    case 0: {
                        strParam = info.getUserName();
                        break;
                    }
                    case 1: {
                        strParam = info.getUserRealName();
                        break;
                    }
                    case 2: {
                        strParam = info.getUserType() + "";
                        break;
                    }
                    case 3: {
                        strParam = info.getUserCUName();
                        break;
                    }
                    case 4: {
                        strParam = info.getClientIPAddress();
                        break;
                    }
                    case 5: {
                        timeParam = info.getLoginTime().getTime();
                        break;
                    }
                    case 6: {
                        timeParam = this.getBizInterface().getCurrentTime().getTime() - info.getLastOperateTime().getTime();
                        break;
                    }
                    case 7: {
                        strParam = info.getCurrentMainBizUnitName();
                        break;
                    }
                    case 8: {
                        strParam = info.getOpenWindowTitle();
                        break;
                    }
                    case 9: {
                        strParam = info.getLoginServerURL();
                        break;
                    }
                    case 10: {
                        strParam = info.getLoginType() + "";
                    }
                }
                if (strParam != null) {
                    isFound = assistInfo.getCompareType() == 0 ? strParam.equals(assistInfo.getAttrValue()) : strParam.indexOf(assistInfo.getAttrValue()) != -1;
                    strParam = "";
                }
                if (timeParam > 0L) {
                    switch (assistInfo.getCompareType()) {
                        case 0: {
                            isFound = timeParam == Long.parseLong(assistInfo.getAttrValue());
                            break;
                        }
                        case 1: {
                            isFound = timeParam > Long.parseLong(assistInfo.getAttrValue());
                            break;
                        }
                        case -1: {
                            isFound = timeParam < Long.parseLong(assistInfo.getAttrValue());
                        }
                    }
                    timeParam = 0L;
                }
                if (isFound && strParam != null) continue;
                this.regs.remove(info);
                --i;
                continue block18;
            }
        }
    }

    private void displayTotalInBar() {
        int total = this.regs.size();
        int guiNum = 0;
        int portalNum = 0;
        int webserviceNum = 0;
        int openapiNum = 0;
        int mobileNum = 0;
        int unkownNum = 0;
        int size = this.regs.size();
        block7: for (int i = 0; i < size; ++i) {
            UMRegistryInfo reg = this.regs.get(i);
            int loginType = reg.getLoginType();
            switch (loginType) {
                case 0: {
                    ++guiNum;
                    continue block7;
                }
                case 1: {
                    ++portalNum;
                    continue block7;
                }
                case 2: {
                    ++webserviceNum;
                    continue block7;
                }
                case 3: {
                    ++mobileNum;
                    continue block7;
                }
                case 4: {
                    ++openapiNum;
                    continue block7;
                }
                default: {
                    ++unkownNum;
                }
            }
        }
        String totalMsgPattern = EASResource.getString((String)RESOURCE_COMMON, (String)"totalMsg");
        String totalMsg = MessageFormat.format(totalMsgPattern, total, guiNum, portalNum, webserviceNum, mobileNum, openapiNum, unkownNum);
        this.getMainStatusBar().setMessage(totalMsg);
    }

    private void loadUMRegistry() throws Exception {
        String dataCenterName = SysContext.getSysContext().getDcName();
        this.regs = (UMRegistryCollection)this.getBizInterface().getCollectionUsingOrgRange(dataCenterName);
    }

    private void fillUMRegistryTable(Object[] objs) throws Exception {
        this.tblMain.removeRows();
        if (objs == null || objs.length == 0) {
            return;
        }
        Date currentTime = this.getBizInterface().getCurrentTime();
        for (int i = 0; i < objs.length; ++i) {
            UMRegistryInfo reg = (UMRegistryInfo)objs[i];
            IRow row = this.tblMain.addRow();
            row.getCell(SESSIONID).setValue((Object)reg.getId());
            row.getCell(DATACENTERNAME).setValue((Object)reg.getDataCenterName());
            row.getCell(USERNAME).setValue((Object)reg.getUserName());
            row.getCell(USER_REAL_NAME).setValue((Object)reg.getUserRealName());
            row.getCell(USER_TYPE).setValue((Object)UserType.getEnum((int)reg.getUserType()));
            row.getCell(USER_CU_NAME).setValue((Object)reg.getUserCUName());
            row.getCell(CLIENT_IPADDRESS).setValue((Object)reg.getClientIPAddress());
            row.getCell(LOGIN_TIME).getKDTCell().setFormattedValue((Object)this.getFormattedDate(reg.getLoginTime()));
            row.getCell(ONLINE_TIME).setValue((Object)this.getDurationTimeString(reg.getLoginTime(), currentTime));
            row.getCell(DULL_TIME).setValue((Object)this.getDurationTimeString(reg.getLastOperateTime(), currentTime));
            row.getCell(CURRENT_MAINBIZUNIT).setValue((Object)reg.getCurrentMainBizUnitName());
            if (UserMonitorClientTool.isMonitorUserAction()) {
                this.tblMain.getColumn(OPENWINDOW_TITLE).getStyleAttributes().setHided(false);
                this.tblMain.getColumn(ACTIONNAME).getStyleAttributes().setHided(false);
                this.tblMain.getColumn(ACTION_DESCRIPTION).getStyleAttributes().setHided(false);
                row.getCell(OPENWINDOW_TITLE).setValue((Object)reg.getOpenWindowTitle());
                row.getCell(ACTIONNAME).setValue((Object)reg.getActionName());
                row.getCell(ACTION_DESCRIPTION).setValue((Object)reg.getActionDescription());
            } else {
                this.tblMain.getColumn(OPENWINDOW_TITLE).getStyleAttributes().setHided(true);
                this.tblMain.getColumn(ACTIONNAME).getStyleAttributes().setHided(true);
                this.tblMain.getColumn(ACTION_DESCRIPTION).getStyleAttributes().setHided(true);
            }
            row.getCell(URL).setValue((Object)reg.getLoginServerURL());
            row.getCell(GUI_USERID).setValue((Object)reg.getGUIUserId());
            String loginType = this.getUserLoginType(reg.getLoginType());
            row.getCell(LOGIN_TYPE).setValue((Object)loginType);
            this.tblMain.getColumn(URL).getStyleAttributes().setHided(false);
            this.tblMain.getColumn(GUI_USERID).getStyleAttributes().setHided(true);
        }
    }

    public String getFormattedDate(Date date) {
        DateFormat formater = BOSLocaleUtil.getDateTimeFormat();
        return formater.format(date);
    }

    private String getDurationTimeString(Date start, Date end) {
        long diff = end.getTime() - start.getTime();
        if (diff <= 0L) {
            return ZERO_TIME_STRING;
        }
        StringBuffer buffer = new StringBuffer();
        long h = diff / 3600000L;
        long m = diff % 3600000L / 60000L;
        long s = diff % 60000L / 1000L;
        buffer = h < 10L ? buffer.append("0" + h) : buffer.append(h);
        buffer.append(":");
        buffer = m < 10L ? buffer.append("0" + m) : buffer.append(m);
        buffer.append(":");
        buffer = s < 10L ? buffer.append("0" + s) : buffer.append(s);
        return buffer.toString();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.doRefresh();
    }

    @Override
    public void actionKickOut_actionPerformed(ActionEvent e) throws Exception {
        super.actionKickOut_actionPerformed(e);
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectedRows.length <= 0) {
            MsgBox.showError((Component)((Object)this), (String)this.getResourceItemByName("selectRowFirst"));
            return;
        }
        if (this.isSuicide(selectedRows)) {
            MsgBox.showWarning((Component)((Object)this), (String)this.getResourceItemByName("notSuicide"));
            return;
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)this.getResourceItemByName("kickOutConfirm")))) {
            boolean isSuccessed = true;
            try {
                String kickIP = InetAddress.getLocalHost().getHostAddress();
                String kickUserName = SysContext.getSysContext().getUserName();
                ArrayList<KickOutMsgInfo> msgs = new ArrayList<KickOutMsgInfo>();
                int j = selectedRows.length;
                for (int i = 0; i < j; ++i) {
                    msgs.add(this.createKickOutMsgInfo(kickIP, kickUserName, selectedRows[i]));
                }
                IUserMonitor iUserMonitor = this.getBizInterface();
                iUserMonitor.sendMsgAndKickOut(msgs);
                KickoutFacadeFactory.getRemoteInstance().kickoutUser(null);
            }
            catch (UnknownHostException e1) {
                logger.info((Object)"in UserMonitorUI actionKickOut_actionPerformed UnknownHostException! ", (Throwable)e1);
                throw new EASLoginException(EASLoginException.LOCAL_IP_FAILURE, (Throwable)e1);
            }
            catch (Exception e1) {
                isSuccessed = false;
                logger.info((Object)"in UserMonitorUI actionKickOut_actionPerformed Exception er! ", (Throwable)e1);
                ExceptionHandler.handle((Component)((Object)this), (String)this.getResourceItemByName("kickOutFailed"), (Throwable)e1);
            }
            if (isSuccessed) {
                this.doRefresh();
                MsgBox.showInfo((Component)((Object)this), (String)this.getResourceItemByName("kickOutSuccessed"));
            }
        }
    }

    private KickOutMsgInfo createKickOutMsgInfo(String kickIP, String kickUserName, int rowIndex) {
        assert (!StringUtils.isEmpty((String)kickIP) && !StringUtils.isEmpty((String)kickUserName));
        KickOutMsgInfo info = new KickOutMsgInfo();
        IRow row = this.tblMain.getRow(rowIndex);
        String beKickUserName = (String)row.getCell(USERNAME).getValue();
        String beKickIp = (String)row.getCell(CLIENT_IPADDRESS).getValue();
        String bosCtxID = (String)row.getCell(SESSIONID).getValue();
        String guiUserID = (String)row.getCell(GUI_USERID).getValue();
        info.setBeKickUserName(beKickUserName);
        info.setBeKickIP(beKickIp);
        info.setBeKickUserCtxID(bosCtxID);
        info.setKickIP(kickIP);
        info.setKickUserName(kickUserName);
        info.setGUIUserId(guiUserID);
        return info;
    }

    private boolean isSuicide(int[] selectedRows) {
        String contextId = SysContext.getSysContext().getSessionID();
        int j = selectedRows.length;
        for (int i = 0; i < j; ++i) {
            IRow row = this.tblMain.getRow(selectedRows[i]);
            String sessionID = (String)row.getCell(SESSIONID).getValue();
            String guiUserID = (String)row.getCell(GUI_USERID).getValue();
            if (!contextId.equals(sessionID) && !contextId.equals(guiUserID)) continue;
            return true;
        }
        return false;
    }

    private Object[] sortUMRegistries(String propertyName, boolean isRefresh) {
        Object[] objs = null;
        if (this.regs != null) {
            objs = this.regs.toArray();
            Arrays.sort(objs, this.getUMregistryComparatorFromCache(propertyName, isRefresh));
        }
        return objs;
    }

    @Override
    public void actionBroadcastTempMsg_actionPerformed(ActionEvent e) throws Exception {
        super.actionBroadcastTempMsg_actionPerformed(e);
        TempMsgManager.getInstance().showTempMsgSendUI((Component)((Object)this));
    }

    @Override
    public void actionSendMsg_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMsg_actionPerformed(e);
        KDTSelectManager selectManager = this.tblMain.getSelectManager();
        int index = selectManager.getActiveRowIndex();
        if (index < 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RESOURCE_FULLNAME, (String)"selectRowFirst"));
        } else {
            IUIFactory uiFactory = null;
            try {
                UIContext ctx = new UIContext((Object)this);
                uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
                IUIWindow messageDialog = uiFactory.create(MessageUI.class.getName(), (Map)ctx);
                messageDialog.show();
                Map messageTopicMap = ((MessageUI)messageDialog.getUIObject()).getMessageTopicMap();
                Map messageContentMap = ((MessageUI)messageDialog.getUIObject()).getMessageContentMap();
                if (messageTopicMap != null && !messageTopicMap.isEmpty()) {
                    int size = selectManager.size();
                    for (int i = 0; i < size; ++i) {
                        KDTSelectBlock block = selectManager.get(i);
                        for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                            String sessionID = (String)this.tblMain.getCell(j, SESSIONID).getValue();
                            this.getBizInterface().sendMessageToUser(sessionID, SysContext.getSysContext().getUserName(), messageTopicMap, messageContentMap);
                        }
                    }
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handle((Throwable)ex);
            }
        }
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 1 && e.getType() == 0) {
            int sortColIndex = e.getColIndex();
            Object[] objs = null;
            String sortColKey = this.tblMain.getColumnKey(sortColIndex);
            objs = this.sortUMRegistries(sortColKey, false);
            propertyName = sortColKey;
            this.fillUMRegistryTable(objs);
        }
    }

    private UMregistryComparator getUMregistryComparatorFromCache(String key, boolean isRefresh) {
        UMregistryComparator comp = (UMregistryComparator)comparators.get(key);
        if (comp == null) {
            comp = new UMregistryComparator(key, true);
            comparators.put(key, comp);
        } else if (!isRefresh) {
            comp.setAscend(!comp.isAscend());
        }
        return comp;
    }

    protected IUserMonitor getBizInterface() throws EASBizException {
        return UserMonitorFactory.getRemoteInstance();
    }

    @Override
    public void actionUserMonitorSetting_actionPerformed(ActionEvent e) throws Exception {
        super.actionUserMonitorSetting_actionPerformed(e);
        IUIFactory uiFactory = null;
        try {
            UIContext ctx = new UIContext((Object)this);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow settingDialog = uiFactory.create(UserMonitorSettingUI.class.getName(), (Map)ctx);
            settingDialog.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    @Override
    public void actionPortalSetting_actionPerformed(ActionEvent e) throws Exception {
        super.actionPortalSetting_actionPerformed(e);
        IUIFactory uiFactory = null;
        try {
            UIContext ctx = new UIContext((Object)this);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow settingDialog = uiFactory.create(IsMonitorPortalUI.class.getName(), (Map)ctx);
            settingDialog.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    @Override
    public void actionRepeatLoginSetting_actionPerformed(ActionEvent e) throws Exception {
        super.actionRepeatLoginSetting_actionPerformed(e);
        IUIFactory uiFactory = null;
        try {
            UIContext ctx = new UIContext((Object)this);
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow settingDialog = uiFactory.create(NotAllowRepeatLoginSettingUI.class.getName(), (Map)ctx);
            settingDialog.show();
        }
        catch (UIException ex) {
            ExceptionHandler.handle((Throwable)ex);
        }
    }

    private String getResourceItemByName(String name) {
        if (StringUtils.isEmpty((String)name)) {
            return "";
        }
        return EASResource.getString((String)RESOURCE_FULLNAME, (String)name);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"filterItems", (Object)this.filterItems);
        uiContext.put((Object)"modifyFlag", (Object)new Boolean(false));
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.base.usermonitor.client.UserMonitorFilterUI", (Map)uiContext, null, null);
        uiWindow.show();
        this.doRefresh();
    }

    private String getUserLoginType(int item) {
        String loginType = "";
        switch (item) {
            case -2: {
                loginType = EASResource.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.loginType_Session_Cleared");
                break;
            }
            case 0: {
                loginType = EASResource.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.loginType_GUI");
                break;
            }
            case 1: {
                loginType = EASResource.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.loginType_Portal");
                break;
            }
            case 2: {
                loginType = EASResource.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.loginType_WebService");
                break;
            }
            case 3: {
                loginType = EASResource.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.loginType_Mobile");
                break;
            }
            case 4: {
                loginType = EASResource.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.loginType_OpenAPI");
                break;
            }
            default: {
                loginType = EASResource.getString((String)"com.kingdee.eas.base.usermonitor.UserMonitorCommonResource.loginType_Unknow");
            }
        }
        return loginType;
    }
}

