/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mcloud.admin.action.xt.api;

import com.kingdee.mcloud.admin.action.xt.base.XTMessage;
import com.kingdee.mcloud.admin.action.xt.base.secruity.SecurityEngine;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;

public class XTClient {
    private String endPoint;
    private int alg;
    private String appID;
    private HttpClient httpClient = new HttpClient();

    public XTClient() {
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(60000);
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(60000);
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setAlg(int alg) {
        this.alg = alg;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    private void prepare(XTMessage req, String serviceId) {
        XTMessage.Header header = new XTMessage.Header();
        header.setAlg(this.alg);
        header.setAppID(this.appID);
        header.setServiceID(serviceId);
        header.setTime(System.currentTimeMillis());
        SecurityEngine securityEngine = SecurityEngine.getEngine(this.appID, serviceId, this.alg);
        req.setSecurityEngine(securityEngine);
        req.setHeader(header);
    }

    public void doHttpRemoter(XTMessage req, XTMessage resp) throws Exception {
        this.prepare(req, req.getServiceId());
        if (!req.validate()) {
            throw new Exception("\u8bf7\u6c42\u5bf9\u8c61\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6cd5\u53d1\u8d77\u8bf7\u6c42");
        }
        String reqData = req.encode();
        PostMethod httpPost = new PostMethod(this.endPoint);
        httpPost.setRequestEntity((RequestEntity)new StringRequestEntity(reqData));
        httpPost.getParams().setParameter("http.protocol.content-charset", (Object)"UTF-8");
        httpPost.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        int httpStatus = this.httpClient.executeMethod((HttpMethod)httpPost);
        if (httpStatus != 200) {
            httpPost.abort();
            throw new Exception("http \u72b6\u6001\u7801 :" + httpStatus + " \u4e1a\u52a1\u8bf7\u6c42\u5931\u8d25");
        }
        InputStream in = httpPost.getResponseBodyAsStream();
        String result = XTClient.inputStream2String(in, "UTF-8");
        XTMessage.Header responseHeader = XTMessage.parseHeader(result);
        resp.setHeader(responseHeader);
        resp.setSecurityEngine(req.getSecurityEngine());
        resp.decode();
    }

    public static String inputStream2String(InputStream is, String charSet) throws Exception {
        try {
            InputStreamReader reader = new InputStreamReader(is, charSet);
            BufferedReader in = new BufferedReader(reader);
            StringBuffer buffer = new StringBuffer();
            String line = "";
            while (line != null) {
                if ((line = line.trim()).length() != 0) {
                    buffer.append(line);
                }
                line = in.readLine();
            }
            return buffer.toString();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

