/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.mcloud.admin.action.xt.base.secruity;

import java.io.File;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.FileUtils;

public class RSAUtils {
    public static KeyPair genKeyPair() throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
        kpg.initialize(1024);
        return kpg.genKeyPair();
    }

    public static PrivateKey restorePrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static PublicKey restorePublicKey(byte[] bytes) throws Exception {
        X509EncodedKeySpec pkcs = new X509EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePublic(pkcs);
    }

    public static byte[] encrypt(byte[] src, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, key);
        return cipher.doFinal(src);
    }

    public static byte[] deEncrypt(byte[] dest, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, key);
        return cipher.doFinal(dest);
    }

    public static byte[] encryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = Cipher.getInstance("RSA");
        rsa.init(1, key);
        SecureRandom random = new SecureRandom();
        byte[] secretKey = new byte[16];
        random.nextBytes(secretKey);
        Cipher aes = Cipher.getInstance("AES");
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(1, k);
        byte[] ciphedKey = rsa.doFinal(secretKey);
        byte[] ciphedData = aes.doFinal(data);
        byte[] result = new byte[128 + ciphedData.length];
        System.arraycopy(ciphedKey, 0, result, 0, 128);
        System.arraycopy(ciphedData, 0, result, 128, ciphedData.length);
        return result;
    }

    public static byte[] deEncryptLarger(byte[] data, Key key) throws Exception {
        Cipher rsa = Cipher.getInstance("RSA");
        rsa.init(2, key);
        byte[] secretKeyData = new byte[128];
        System.arraycopy(data, 0, secretKeyData, 0, secretKeyData.length);
        byte[] cipherData = new byte[data.length - secretKeyData.length];
        System.arraycopy(data, secretKeyData.length, cipherData, 0, cipherData.length);
        byte[] secretKey = rsa.doFinal(secretKeyData);
        Cipher aes = Cipher.getInstance("AES");
        SecretKeySpec k = new SecretKeySpec(secretKey, "AES");
        aes.init(2, k);
        byte[] deciphedData = aes.doFinal(cipherData);
        return deciphedData;
    }

    public static byte[] sign(byte[] src, PrivateKey prvKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initSign(prvKey);
        sig.update(src);
        return sig.sign();
    }

    public static boolean verifySign(byte[] src, byte[] dest, PublicKey pubKey) throws Exception {
        Signature sig = Signature.getInstance("MD5withRSA");
        sig.initVerify(pubKey);
        sig.update(src);
        return sig.verify(dest);
    }

    public static void main(String[] args) {
        try {
            KeyPair kp = RSAUtils.genKeyPair();
            PublicKey pub1 = kp.getPublic();
            PrivateKey prv1 = kp.getPrivate();
            byte[] pubbts1 = pub1.getEncoded();
            byte[] prvbts1 = prv1.getEncoded();
            System.out.println("pubkey format=" + pub1.getFormat());
            System.out.println("prvkey format=" + prv1.getFormat());
            PublicKey pub2 = RSAUtils.restorePublicKey(pubbts1);
            PrivateKey prv2 = RSAUtils.restorePrivateKey(prvbts1);
            String src = "this is a test";
            byte[] signed = RSAUtils.sign(src.getBytes(), prv1);
            boolean v = RSAUtils.verifySign(src.getBytes(), signed, pub2);
            System.out.println("v=" + v);
            byte[] encrypt = RSAUtils.encrypt(src.getBytes(), pub1);
            String src2 = new String(RSAUtils.deEncrypt(encrypt, prv2));
            System.out.println("src2=" + src2);
            System.out.println(RSAUtils.encryptLarger(FileUtils.readFileToByteArray((File)new File("d://a.wsdl")), pub1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

