/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.base.wf.IMyProcess;
import com.kingdee.eas.base.wf.MyProcessCollection;
import com.kingdee.eas.base.wf.MyProcessFactory;
import com.kingdee.eas.base.wf.MyProcessInfo;
import com.kingdee.eas.base.wf.client.AbstractCustomizeUI;
import com.kingdee.eas.base.wf.client.WFClientUtil;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.Map;

public class CustomizeUI
extends AbstractCustomizeUI {
    public boolean returnValue = false;
    ProcessDefInfo[] procDefArray = null;
    EASWfServiceClient client = null;
    IMyProcess iMyProcess = null;
    public MyProcessCollection myProCollection = null;
    UserInfo userInfo = null;
    Locale locale = SysContext.getSysContext().getLocale();

    private void myInit() {
        this.returnValue = false;
        this.initTable();
        this.fillTable();
    }

    private void initTable() {
        this.tabProcess.checkParsed();
        this.tabProcess.getSelectManager().setSelectMode(2);
        this.tabProcess.getColumn("processName").getStyleAttributes().setLocked(true);
        this.tabProcess.getColumn("processName").setWidth(200);
        this.tabProcess.getColumn("processDetail").getStyleAttributes().setLocked(true);
        this.tabProcess.getColumn("processDetail").setWidth(150);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.toolBar.setEnabled(false);
        Map map = this.getUIContext();
        this.userInfo = (UserInfo)this.getUIContext().get("userInfo");
        this.procDefArray = (ProcessDefInfo[])map.get("procDefArray");
        this.client = (EASWfServiceClient)map.get("client");
        this.iMyProcess = (IMyProcess)map.get("iMyProcess");
        this.myProCollection = (MyProcessCollection)((Object)map.get("myProCollection"));
        this.myInit();
        if (this.procDefArray == null || this.procDefArray.length == 0) {
            this.btnOK.setEnabled(false);
            this.kDBtnViewProcess.setEnabled(false);
        }
    }

    private void initProcessOrientData() {
        String url = UIConfig.getUrl();
        try {
            this.client = new EASWfServiceClient();
            this.client.init(url, (String)SysContext.getSysContext().getProperty((Object)"SessionId"));
            this.procDefArray = this.client.getProcDefArrayDistinctByUserID(this.userInfo.getId().toString());
        }
        catch (WfException e1) {
            ExceptionHandler.handle((Component)((Object)this), (String)"\u5de5\u4f5c\u6d41WfException\u5f02\u5e38", (Throwable)e1);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)((Object)this), (String)"\u5de5\u4f5c\u6d41BOSException\u5f02\u5e38", (Throwable)e);
        }
    }

    private void initMyProcessConllection() {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("userID", (Object)this.userInfo.getId().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        try {
            this.iMyProcess = MyProcessFactory.getRemoteInstance();
            this.myProCollection = this.iMyProcess.getMyProcessCollection(viewInfo);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void fillTable() {
        this.tabProcess.removeRows();
        if (this.procDefArray == null) {
            return;
        }
        for (int i = 0; i < this.procDefArray.length; ++i) {
            int j;
            String proDefID = this.procDefArray[i].getProcDefId().trim();
            for (j = 0; j < this.myProCollection.size() && !proDefID.equals(this.myProCollection.get(j).getProcessID().toString().trim()); ++j) {
            }
            IRow rowData = this.tabProcess.addRow(i);
            rowData.getCell("processID").setValue((Object)this.procDefArray[i]);
            rowData.getCell("processName").setValue((Object)this.procDefArray[i].getProcDefName(this.locale));
            rowData.getCell("processDetail").setValue((Object)this.procDefArray[i].getProcDefDesc(this.locale));
            rowData.getCell("userID").setValue((Object)this.userInfo);
            if (j == this.myProCollection.size()) {
                rowData.getCell("processIsLauch").setValue((Object)new Boolean(false));
                continue;
            }
            rowData.getCell("processIsLauch").setValue((Object)new Boolean(true));
        }
        this.tabProcess.getSelectManager().select(0, 0);
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        this.myUpdateData();
        this.returnValue = true;
        this.destroyWindow();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.returnValue = false;
        this.destroyWindow();
    }

    protected void kDBtnViewProcess_actionPerformed(ActionEvent e) throws Exception {
        if (this.tabProcess.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)WFClientUtil.resName, (String)"SelectOneRow"));
            return;
        }
        int selectRow = this.tabProcess.getSelectManager().get().getBottom();
        IRow row = this.tabProcess.getRow(selectRow);
        ProcessDefInfo procDefInfo = (ProcessDefInfo)row.getCell("processID").getValue();
        WFClientUtil cu = new WFClientUtil();
        cu.transferWfDefinePanel((Component)((Object)this), procDefInfo);
    }

    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tabProcess.getRowCount(); ++i) {
            this.tabProcess.getRow(i).getCell("processIsLauch").setValue((Object)new Boolean(true));
        }
    }

    protected void btnReset_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.tabProcess.getRowCount(); ++i) {
            this.tabProcess.getRow(i).getCell("processIsLauch").setValue((Object)new Boolean(false));
        }
    }

    private void myUpdateData() {
        String proID = null;
        for (int i = 0; i < this.tabProcess.getRowCount(); ++i) {
            int j;
            proID = ((ProcessDefInfo)this.tabProcess.getRow(i).getCell("processID").getValue()).getProcDefId();
            for (j = 0; j < this.myProCollection.size() && !proID.equals(this.myProCollection.get(j).getProcessID().toString().trim()); ++j) {
            }
            if (j == this.myProCollection.size()) {
                if (!((Boolean)this.tabProcess.getRow(i).getCell("processIsLauch").getValue()).booleanValue()) continue;
                MyProcessInfo model = new MyProcessInfo();
                BOSUuid myProId = BOSUuid.create((BOSObjectType)model.getBOSType());
                BOSUuid proId = BOSUuid.read((String)proID);
                model.setId(myProId);
                model.setUserID(this.userInfo.getId());
                model.setProcessID(proId);
                try {
                    this.iMyProcess.addnew((CoreBaseInfo)model);
                    this.myProCollection.add(model);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)WFClientUtil.resName, (String)"ProcessSaveFailure"), (Throwable)e);
                }
                continue;
            }
            if (((Boolean)this.tabProcess.getRow(i).getCell("processIsLauch").getValue()).booleanValue()) continue;
            try {
                ObjectUuidPK pk = new ObjectUuidPK(this.myProCollection.get(j).getId());
                this.iMyProcess.delete((IObjectPK)pk);
                this.myProCollection.remove(this.myProCollection.get(j));
                continue;
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)WFClientUtil.resName, (String)"ProcessSaveFailure"), (Throwable)e);
            }
        }
    }
}

