/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.client;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.wssc.PiaoFacadeFactory;
import com.kingdee.eas.base.wssc.piao.pojo.HelperParam;
import com.kingdee.eas.base.wssc.piao.pojo.PiaoBillInfo;
import com.kingdee.eas.base.wssc.piao.pwy.PwyConnectUtil;
import com.kingdee.eas.base.wssc.piao.pwy.PwyHandle;
import com.kingdee.eas.base.wssc.util.MD5;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public class InvoiceBillHelper {
    private static Logger logger = Logger.getLogger(InvoiceBillHelper.class);
    private static String openWithBrowser = "false";
    private boolean isDoPolling;

    public static void openFpzsInvoicesUI(UIContext uiContext) throws Exception {
        openWithBrowser = PiaoFacadeFactory.getRemoteInstance().getPiaoConfigInfo("openWithBrowser");
        if ("true".equals(openWithBrowser) && "selectCloudInvoice".equals((String)uiContext.get((Object)"action"))) {
            HelperParam helperParam = InvoiceBillHelper.getHelperParam(InvoiceBillHelper.getPiaoBillInfo(uiContext), (String)uiContext.get((Object)"action"));
            String url = InvoiceBillHelper.getUrl(helperParam);
            Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            new InvoiceBillHelper().createPollingThread(helperParam);
        } else {
            IUIWindow iuiWindow = null;
            try {
                iuiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.base.wssc.client.InvoiceBillViewUI", (Map)uiContext, (Map)null, OprtState.VIEW);
                if (iuiWindow != null) {
                    iuiWindow.show();
                }
            }
            catch (Exception var4) {
                logger.error((Object)var4.getMessage());
                SysUtil.abort((Throwable)var4);
            }
        }
    }

    private void createPollingThread(final HelperParam helperParam) throws Exception {
        this.isDoPolling = true;
        Runnable polling = new Runnable(){

            @Override
            public void run() {
                long beignTime = System.currentTimeMillis();
                while (InvoiceBillHelper.this.isDoPolling && !InvoiceBillHelper.this.doPollingRequest(helperParam).booleanValue()) {
                    if (System.currentTimeMillis() - beignTime > 900000L) {
                        InvoiceBillHelper.this.closeCurrentThread();
                        break;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException var4) {
                        logger.error((Object)var4.getMessage(), (Throwable)var4);
                    }
                }
            }
        };
        Thread pollingThread = new Thread(polling, "fpzsPooling");
        pollingThread.start();
    }

    private Boolean doPollingRequest(HelperParam helperParam) {
        String msgId;
        String receiveUrl = helperParam.getApiPiaoZone() + "/polling/fpzs/invoice/data/v2?access_token=" + helperParam.getAccessToken() + "&key=" + MD5.md5crypt(helperParam.getLinkKey());
        logger.info((Object)("\u957f\u8fde\u63a5\u83b7\u53d6\u6d88\u606f\uff1aurl  " + receiveUrl));
        JSONObject receiveResult = new JSONObject();
        try {
            msgId = PwyConnectUtil.httpsRequestGet(receiveUrl);
            logger.info((Object)("\u957f\u8fde\u63a5\u63a5\u6536\u7684\u6d88\u606f\uff1a" + msgId));
            if (PwyHandle.isNotEmpty(msgId)) {
                receiveResult = JSONObject.parseObject((String)msgId);
            }
        }
        catch (Exception var9) {
            logger.error((Object)var9.getMessage(), (Throwable)var9);
            this.closeCurrentThread();
            MsgBox.showInfo((String)"\u83b7\u53d6\u4e0a\u4f20\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\uff01");
            return true;
        }
        if (receiveResult.getString("data") != null && "0000".equals(receiveResult.getString("errcode"))) {
            msgId = receiveResult.getJSONObject("data").getString("msgId");
            String receiptUrl = helperParam.getApiPiaoZone() + "/polling/fpzs/portal/receipt?access_token=" + helperParam.getAccessToken() + "&key=" + MD5.md5crypt(helperParam.getLinkKey()) + "&msgId=" + msgId;
            logger.info((Object)("\u957f\u8fde\u63a5\u786e\u8ba4\u56de\u6267 \uff1a " + receiptUrl));
            try {
                for (int i = 0; i < 3; ++i) {
                    String receiptResult = PwyConnectUtil.httpsRequestGet(receiptUrl);
                    logger.info((Object)("\u957f\u8fde\u63a5\u786e\u8ba4\u56de\u6267\u8fde\u63a5 \u786e\u8ba4\u7ed3\u679c\uff1a" + receiptResult));
                    JSONObject receiptData = JSONObject.parseObject((String)receiptResult);
                    if (receiptData != null && "0000".equals(receiptData.getString("errcode"))) {
                        this.invoiceHandle(helperParam.getInfo());
                        return true;
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception var10) {
                logger.error((Object)var10.getMessage(), (Throwable)var10);
                this.closeCurrentThread();
                MsgBox.showInfo((String)"\u786e\u8ba4\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7");
                return true;
            }
            return false;
        }
        if ("1300".equals(receiveResult.getString("error"))) {
            this.closeCurrentThread();
            MsgBox.showInfo((String)"\u83b7\u53d6\u4e0a\u4f20\u4fe1\u606f\u5931\u8d25\uff0c\u53d1\u7968\u52a9\u624b\u8fd4\u56de\u9519\u8bef\u7801\uff1a1300");
            return true;
        }
        return false;
    }

    public static PiaoBillInfo getPiaoBillInfo(UIContext uiContext) {
        Object bill = uiContext.get((Object)"bill");
        PiaoBillInfo baseInfo = new PiaoBillInfo();
        if (bill instanceof CoreBillBaseInfo) {
            baseInfo = new PiaoBillInfo().setCoreBillBaseInfo((CoreBillBaseInfo)bill);
        } else if (bill instanceof PiaoBillInfo) {
            baseInfo = (PiaoBillInfo)uiContext.get((Object)"bill");
        } else if (bill instanceof Map) {
            Map billMap = (Map)bill;
            baseInfo = new PiaoBillInfo().setId(billMap.get("id") + "").setNumber(billMap.get("number") + "").setCreatorId(billMap.get("creatorId") + "").setCompanyId(billMap.get("companyId") + "");
        } else {
            logger.error((Object)"\u53c2\u6570 bill \u9519\u8bef");
            MsgBox.showError((String)"\u53c2\u6570 bill \u9519\u8bef");
            SysUtil.abort();
        }
        return baseInfo;
    }

    public static String getUrl(HelperParam param) {
        return "selectCloudInvoice".equals(param.getOperation()) ? param.getInvoiceUrl() + "/m4-web/fpzs/index?userKey=" + param.getUserKey() + "&linkKey=" + param.getLinkKey() + "&optMode=1&gridParam=1100" : null;
    }

    public static HelperParam getHelperParam(PiaoBillInfo piaoBillInfo, String actionType) throws BOSException, EASBizException {
        Map res = PiaoFacadeFactory.getRemoteInstance().getUserKey(piaoBillInfo, new HashMap());
        String userKeyJson = (String)res.get("userKeyJson");
        String userKey = JSONObject.parseObject((String)userKeyJson).getJSONObject("data").get((Object)"userKey").toString();
        String linkKey = UUID.randomUUID().toString().replace("-", "");
        Map baseInvoiceUrl = PiaoFacadeFactory.getRemoteInstance().getBaseInvoiceUrl(new HashMap(10));
        String invoiceUrl = (String)baseInvoiceUrl.get("invoiceUrl");
        String apiPiaoZone = (String)baseInvoiceUrl.get("apiPiaoZone");
        Map returnObject = PiaoFacadeFactory.getRemoteInstance().getAccessToken(piaoBillInfo, new HashMap());
        String token = (String)returnObject.get("token");
        return new HelperParam().setUserKey(userKey).setLinkKey(linkKey).setInvoiceUrl(invoiceUrl).setApiPiaoZone(apiPiaoZone).setAccessToken(token).setOperation(actionType).setInfo(piaoBillInfo);
    }

    public void closeCurrentThread() {
        this.isDoPolling = false;
    }

    public void invoiceHandle(PiaoBillInfo info) {
        try {
            PiaoFacadeFactory.getRemoteInstance().saveTicketBill(info, null);
        }
        catch (Exception var3) {
            logger.error((Object)var3.getMessage(), (Throwable)var3);
        }
    }
}

