/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.wssc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class GeninsertUtil {
    private static Logger logger = Logger.getLogger(GeninsertUtil.class);

    public static List<String> exportInsertSql(Context ctx, String sql) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        IRowSetMetaData rsmd = rs.getRowSetMetaData();
        int colCount = rsmd.getColumnCount();
        String tableName = rsmd.getTableName(1);
        HashMap<String, String> colMap = new HashMap<String, String>();
        for (int i = 1; i <= colCount; ++i) {
            colMap.put(rsmd.getColumnLabel(i), rsmd.getColumnTypeName(i));
        }
        ArrayList<String> sqlList = new ArrayList<String>();
        while (rs.next()) {
            StringBuffer bufferKey = new StringBuffer();
            StringBuffer bufferValue = new StringBuffer();
            Set set = colMap.keySet();
            for (String colKey : set) {
                String colType = (String)colMap.get(colKey);
                Object objValue = rs.getObject(colKey);
                if ("char".equalsIgnoreCase(colType) || "varchar".equalsIgnoreCase(colType) || "nvarchar".equalsIgnoreCase(colType) || "nchar".equalsIgnoreCase(colType)) {
                    bufferKey.append(colKey + ",");
                    if (null == objValue) {
                        bufferValue.append("null,");
                        continue;
                    }
                    bufferValue.append("'" + objValue + "',");
                    continue;
                }
                if ("datetime".equalsIgnoreCase(colType)) {
                    bufferKey.append(colKey + ",");
                    if (null == objValue) {
                        bufferValue.append("null,");
                        continue;
                    }
                    bufferValue.append("{ts'" + objValue + "'},");
                    continue;
                }
                if ("int".equalsIgnoreCase(colType) || "numeric".equalsIgnoreCase(colType) || "decimal".equalsIgnoreCase(colType)) {
                    bufferKey.append(colKey + ",");
                    bufferValue.append(objValue + ",");
                    continue;
                }
                bufferKey.append(colKey + ",");
                bufferValue.append("null,");
            }
            String insertSql = "insert into " + tableName + "(" + bufferKey.toString().substring(0, bufferKey.toString().length() - 1) + ") values (" + bufferValue.toString().substring(0, bufferValue.toString().length() - 1) + ")";
            sqlList.add(insertSql);
        }
        return sqlList;
    }

    public static EntityObjectInfo getEntityObjectInfo(Context ctx, String bostype) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo eo = loader.getEntity(BOSObjectType.create((String)bostype));
        if (null != eo) {
            return eo;
        }
        return null;
    }

    public static ICoreBase getLocalInstance(Context ctx, EntityObjectInfo eo) {
        ICoreBase iCoreBase = null;
        try {
            Class<?> cls = Class.forName(eo.getBusinessImplFactory());
            Method mtd = cls.getMethod("getLocalInstance", Context.class);
            iCoreBase = (ICoreBase)mtd.invoke(cls, ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iCoreBase;
    }
}

