/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.basesync.util;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.EasSyncConfigItemEnum;
import com.kingdee.eas.base.xtsync.trdsync.SyncHighItemType;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.AdminOrgTreeInfo;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.ExportExcelTools;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.IBaseSyncHelper;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncConfigUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.PageResult;
import com.kingdee.eas.base.xtsync.xtutil.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public abstract class AbstactBaseSyncHelper
implements IBaseSyncHelper {
    @Override
    public abstract Map getConfig();

    @Override
    public String getSyncLogs(SyncContext syncCtx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String syncType = param.getString("syncType");
        String syncTimeId = param.getString("syncTimeId");
        int success = param.getBoolean("success") == true ? 0 : 1;
        int page = param.getIntValue("page");
        int rowCount = param.getIntValue("rowCount");
        String filter = param.getString("filter");
        Context ctx = syncCtx.getCtx();
        Map syncLogMap = this.getSyncLogColBase(syncType);
        String[] baseCol = (String[])syncLogMap.get("syncLogCol");
        String sql = this.getBaseSql(syncCtx.getHighItemType());
        StringBuilder baseSql = new StringBuilder(sql);
        baseSql.append(" WHERE log.FSYNCTIMEID = '" + syncTimeId + "' AND ").append(" log.FSUCCESS = " + success + " AND ").append(" log.FTYPE = '" + syncLogMap.get("syncTypeValue") + "' ");
        if (!StringUtils.isEmpty((String)filter)) {
            SyncHighItemType highItemType = syncCtx.getHighItemType();
            String[] filterColName = this.getFilterColName(highItemType, true);
            baseSql.append(this.buildFilterSql(filterColName, filter, highItemType));
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList<Map<Object, Object>> rows = new ArrayList<Map<Object, Object>>();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + baseSql.toString() + ") tmp"));
            baseSql.append(" order by log.fcreatetime desc");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)baseSql.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                Map<Object, Object> map = new HashMap();
                map = this.buildTableData(syncCtx.getCtx(), syncCtx.getHighItemType(), baseCol, rs);
                map.put("index", index);
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    @Override
    public String getAllSyncLogs(SyncContext syncCtx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String syncType = param.getString("syncType");
        String subAction = param.getString("subAction");
        String successReqStr = param.getString("successReqStr");
        int page = param.getIntValue("page");
        int rowCount = param.getIntValue("rowCount");
        String filter = param.getString("filter");
        String createTimeStart = param.getString("createTimeStart");
        String createTimeEnd = param.getString("createTimeEnd");
        Context ctx = syncCtx.getCtx();
        Map syncLogMap = this.getAllSyncLogColBase(syncType, subAction);
        String[] baseCol = (String[])syncLogMap.get("syncLogCol");
        String sql = this.getBaseSql(syncCtx.getHighItemType());
        StringBuilder baseSql = new StringBuilder(sql);
        baseSql.append(" WHERE 1=1 ");
        if (!"ALL".equalsIgnoreCase(syncType)) {
            baseSql.append(" and log.FTYPE = '" + syncLogMap.get("syncTypeValue") + "'");
        }
        if (!"ALL".equalsIgnoreCase(successReqStr)) {
            int success = "true".equalsIgnoreCase(successReqStr) ? 0 : 1;
            baseSql.append(" and log.FSUCCESS = " + success);
        }
        if (!StringUtils.isEmpty((String)createTimeStart)) {
            baseSql.append(" and log.fcreatetime >={" + Timestamp.valueOf(createTimeStart) + "} ");
        }
        if (!StringUtils.isEmpty((String)createTimeEnd)) {
            baseSql.append(" and log.fcreatetime <{" + Timestamp.valueOf(createTimeEnd) + "} ");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            SyncHighItemType highItemType = SyncHighItemType.getEnum(param.get((Object)"highItemType").toString());
            String[] filterColName = this.getFilterColName(highItemType, true);
            baseSql.append(this.buildFilterSql(filterColName, filter, highItemType));
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList<Map<Object, Object>> rows = new ArrayList<Map<Object, Object>>();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)ctx, (String)("select count(*) from (" + baseSql.toString() + ") tmp"));
            baseSql.append(" order by log.fcreatetime desc");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)baseSql.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                Map<Object, Object> map = new HashMap();
                map = this.buildTableData(syncCtx.getCtx(), syncCtx.getHighItemType(), baseCol, rs);
                map.put("index", index);
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    protected String buildFilterSql(String[] filterColName, String filter, SyncHighItemType highItemType) {
        StringBuilder sql = new StringBuilder();
        if (SyncHighItemType.PartJob.equals((Object)highItemType) || SyncHighItemType.DeptLeader.equals((Object)highItemType) || SyncHighItemType.Relations.equals((Object)highItemType)) {
            sql.append(" AND log." + filterColName[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterColName.length; ++i) {
                if ("FPERSONNAME".equalsIgnoreCase(filterColName[i]) || "FCELL".equalsIgnoreCase(filterColName[i]) || "FORGLONGNAME".equalsIgnoreCase(filterColName[i])) {
                    sql.append(" AND umap." + filterColName[i] + " like '%" + filter + "%'");
                    continue;
                }
                sql.append(" AND log." + filterColName[i] + " like '%" + filter + "%'");
            }
        } else {
            sql.append(" AND (log." + filterColName[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterColName.length; ++i) {
                sql.append(" OR log." + filterColName[i] + " like '%" + filter + "%'");
            }
            sql.append(")");
        }
        return sql.toString();
    }

    public abstract String[] getFilterColName(SyncHighItemType var1, boolean var2);

    @Override
    public String getAllXtOrg(SyncContext syncCtx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = param.getString("filter");
        String sql = SyncConfigUtil.getInstance().getValue("getAllSyncOrg");
        int page = param.getIntValue("page");
        int rowCount = param.getIntValue("rowCount");
        sql = SyncBaseUtil.fillTemplateSql(sql, 1, syncCtx.getSyncTableName());
        sql = SyncBaseUtil.fillTemplateSql(sql, 2, syncCtx.getMappingOrgIdColnum());
        StringBuilder sqlB = new StringBuilder(sql);
        sqlB.append(" WHERE 1=1 ");
        String[] filterCol = this.getAllSyncFilterCol("ORG");
        if (!StringUtils.isEmpty((String)filter)) {
            sqlB.append(" AND " + filterCol[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterCol.length; ++i) {
                sqlB.append(" OR " + filterCol[i] + " LIKE '%" + filter + "%'");
            }
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)("select count(*) from (" + sqlB.toString() + ") tmp"));
            sqlB.append(" ORDER BY FWEIGHT");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sqlB.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(syncCtx.getMappingOrgIdColnum(), rs.getString(syncCtx.getMappingOrgIdColnum()));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fname", rs.getString("fname"));
                map.put("fweight", rs.getString("fweight"));
                map.put("fparentid", rs.getString("fparentid"));
                map.put("fid", rs.getString("fid"));
                map.put("index", index);
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    @Override
    public String getAllXtUser(SyncContext syncCtx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject param = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String filter = param.getString("filter");
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        String sql = SyncConfigUtil.getInstance().getValue("getAllSyncPerson");
        int page = param.getIntValue("page");
        int rowCount = param.getIntValue("rowCount");
        sql = SyncBaseUtil.fillTemplateSql(sql, 1, syncCtx.getSyncTableName());
        sql = SyncBaseUtil.fillTemplateSql(sql, 2, syncCtx.getMappingOrgIdColnum());
        StringBuilder sqlB = new StringBuilder(sql);
        sqlB.append(" WHERE 1=1 ");
        String[] filterCol = this.getAllSyncFilterCol("PERSON");
        if (!StringUtils.isEmpty((String)filter)) {
            sqlB.append(" AND " + filterCol[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterCol.length; ++i) {
                sqlB.append(" OR " + filterCol[i] + " LIKE '%" + filter + "%'");
            }
        }
        IRowSet rsCount = null;
        IRowSet rs = null;
        ArrayList rows = new ArrayList();
        int total = 0;
        int index = 1;
        try {
            rsCount = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)("select count(*) from (" + sqlB.toString() + ") tmp"));
            sqlB.append(" ORDER BY FORGLONGNAME");
            if (rsCount.next()) {
                total = rsCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sqlB.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("fuserid", rs.getString("fuserid"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("fposition", rs.getString("fposition"));
                map.put("faddress", rs.getString("faddress"));
                map.put("ftelephone", rs.getString("ftelephone"));
                map.put("fgender", rs.getInt("fgender") == 1 ? "\u7537" : (rs.getInt("fgender") == 2 ? "\u5973" : "\u672a\u8bbe\u7f6e"));
                map.put("fweight", rs.getString("fweight"));
                map.put("fstatus", rs.getString("fstatus"));
                map.put("index", index);
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rsCount != null) {
                try {
                    rsCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, rows);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    @Override
    public String getAllEasDatas(SyncContext syncCtx, com.alibaba.fastjson.JSONObject condition) throws BOSException {
        SyncHighItemType highItemType = SyncHighItemType.getEnum(condition.get((Object)"highItemType").toString());
        String subAction = condition.getString("subAction");
        if (SyncHighItemType.Dept.equals((Object)highItemType)) {
            if ("orgTree".equalsIgnoreCase(subAction)) {
                return this.getEasOrgTree(syncCtx, condition);
            }
            return this.getOrgLeaderByOrgName(syncCtx, condition);
        }
        if (SyncHighItemType.Person.equals((Object)highItemType)) {
            if ("userDetail".equalsIgnoreCase(subAction)) {
                return this.getEasXtUserDetail(syncCtx, condition);
            }
            if (condition.getInteger("dataType") == 0) {
                return this.getEasPersonDatas(syncCtx, condition);
            }
            return this.getEasPersonByPosition(syncCtx, condition);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOrgLeaderByOrgName(SyncContext syncCtx, com.alibaba.fastjson.JSONObject condition) throws BOSException {
        String isSyncStr;
        String orgId = condition.getString("orgId");
        Context ctx = syncCtx.getCtx();
        AdminOrgUnitInfo adminInfo = null;
        try {
            adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (adminInfo == null) {
            return "";
        }
        String orgLongName = adminInfo.getDisplayName();
        String getEasOrgLeader = SyncConfigUtil.getInstance().getValue("getEasOrgLeader");
        String getXtOrgLeader = this.getXtOrgLeaderSql(ctx, orgLongName);
        if (orgLongName.indexOf("_") < 0) {
            getEasOrgLeader = getEasOrgLeader + " and (case when CHARINDEX('_',org.fdisplayname_l2) > 0 then to_char(REPLACE (SUBSTRING(org.fdisplayname_l2,CHARINDEX('_',org.fdisplayname_l2)+1,length(org.fdisplayname_l2)), '_', '\\')) else to_char('\\') end) = to_char('\\')";
        } else if (orgLongName.indexOf("_") > 0) {
            orgLongName = orgLongName.substring(orgLongName.indexOf("_") + 1);
            orgLongName = orgLongName.replaceAll("_", "\\\\");
            getEasOrgLeader = getEasOrgLeader + " and (case when CHARINDEX('_',org.fdisplayname_l2) > 0 then to_char(REPLACE (SUBSTRING(org.fdisplayname_l2,CHARINDEX('_',org.fdisplayname_l2)+1,length(org.fdisplayname_l2)), '_', '\\')) else to_char('\\') end) = to_char('" + orgLongName + "')";
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getEasOrgLeader);
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)getXtOrgLeader);
        HashMap<String, String> tmpMap = new HashMap<String, String>();
        StringBuilder easLeaderName = new StringBuilder();
        StringBuilder xtLeaderName = new StringBuilder();
        try {
            while (rs.next()) {
                if (StringUtils.isEmpty((String)rs.getString("leaderName"))) continue;
                easLeaderName.append(rs.getString("leaderName")).append(",");
            }
            while (rs1.next()) {
                if (StringUtils.isEmpty((String)rs1.getString("leaderName"))) continue;
                xtLeaderName.append(rs1.getString("leaderName")).append(",");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        if (StringUtils.isEmpty((String)easLeaderName.toString())) {
            tmpMap.put("easLeaderName", "\u6682\u65e0\u8d1f\u8d23\u4eba");
        } else {
            tmpMap.put("easLeaderName", easLeaderName.toString().substring(0, easLeaderName.lastIndexOf(",")));
        }
        if (StringUtils.isEmpty((String)xtLeaderName.toString())) {
            tmpMap.put("xtLeaderName", "\u6682\u65e0\u8d1f\u8d23\u4eba");
        } else {
            tmpMap.put("xtLeaderName", xtLeaderName.toString().substring(0, xtLeaderName.lastIndexOf(",")));
        }
        com.alibaba.fastjson.JSONObject cond = new com.alibaba.fastjson.JSONObject();
        cond.put("easorgid", (Object)orgId);
        cond.put("orglongname", (Object)orgLongName);
        String xtOrgNameMapStr = this.getXtOrg(syncCtx, cond.toString());
        com.alibaba.fastjson.JSONObject jo = com.alibaba.fastjson.JSONObject.parseObject((String)xtOrgNameMapStr);
        StringBuilder noBindReason = new StringBuilder();
        String easOrgName = adminInfo.getName();
        boolean isSync = this.getOrgSyncStatus(syncCtx, orgId);
        String string = isSyncStr = !isSync ? "" : "<span style='color:red;'>(\u4e0d\u4e0a\u4f20)</spam>";
        if (adminInfo.get("isSealup").equals("1")) {
            noBindReason.append("EAS\u7ec4\u7ec7\u5df2\u5c01\u5b58\uff1b");
        }
        if (easOrgName.contains(" ")) {
            noBindReason.append("EAS\u90e8\u95e8\u5b58\u5728\u7a7a\u683c\u6216\u7a7a\u5b57\u7b26\u4e32\uff0c\u540c\u6b65\u540e\u53ef\u80fd\u65e0\u6cd5\u7ed1\u5b9a\uff1b");
        }
        if (easOrgName.contains("\\")) {
            noBindReason.append("EAS\u90e8\u95e8\u5b58\u5728\"\\\"\uff0c\u540c\u6b65\u540e\u4f1a\u5bfc\u81f4\u540c\u6b65\u4f01\u4e1a\u7ec4\u7ec7\u5c42\u6b21\u9519\u4e71\uff1b");
        }
        if (easOrgName.contains("_")) {
            noBindReason.append("EAS\u90e8\u95e8\u5b58\u5728\"_\"\uff0c\u540c\u6b65\u540e\u4f1a\u5bfc\u81f4\u540c\u6b65\u4f01\u4e1a\u7ec4\u7ec7\u5c42\u6b21\u9519\u4e71\uff1b");
        }
        if (jo == null) {
            tmpMap.put("xtOrgName", "<span style='color:red;'>\u672a\u67e5\u8be2\u5230\u6570\u636e</span>");
            tmpMap.put("isbind", "<span style='color:red;'>\u672a\u7ed1\u5b9a</span>");
            noBindReason.append("\u540c\u6b65\u4f01\u4e1a\u4e0d\u5b58\u5728\u8be5\u90e8\u95e8\uff1b");
        } else {
            String xtOrgName = jo.get((Object)"forgname").toString();
            String isBind = jo.getString("fisbind");
            if (StringUtils.isEmpty((String)xtOrgName)) {
                tmpMap.put("isbind", "<span style='color:red;'>\u672a\u7ed1\u5b9a</span>");
                tmpMap.put("xtOrgName", "<span style='color:red;'>\u672a\u67e5\u8be2\u5230\u6570\u636e</span>");
                noBindReason.append("\u540c\u6b65\u4f01\u4e1a\u4e0d\u5b58\u5728\u8be5\u90e8\u95e8\uff1b");
            } else {
                tmpMap.put("xtOrgName", xtOrgName);
                if ("1".equals(isBind)) {
                    tmpMap.put("isbind", "\u5df2\u7ed1\u5b9a");
                } else {
                    tmpMap.put("isbind", "<span style='color:red;'>\u672a\u7ed1\u5b9a</span>");
                    noBindReason.append("\u5176\u4ed6\u539f\u56e0\u672a\u7ed1\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5206\u6790\u3002");
                }
            }
        }
        tmpMap.put("easOrgName", easOrgName + isSyncStr);
        tmpMap.put("noBindReason", noBindReason.toString());
        return JSONObject.fromObject(tmpMap).toString();
    }

    protected String getXtOrgLeaderSql(Context ctx, String orgLongName) throws BOSException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getOrgSyncStatus(SyncContext sctx, String orgId) {
        String sql = "select nso.forgid from " + sctx.getNoSyncTableName() + " nso where nso.forgid = ?";
        Context ctx = sctx.getCtx();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{orgId});
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getXtOrg(SyncContext syncCtx, String condition) throws BOSException {
        com.alibaba.fastjson.JSONObject o = com.alibaba.fastjson.JSONObject.parseObject((String)condition);
        String easorgid = o.getString("easorgid");
        String orglongname = o.getString("orglongname");
        Context ctx = syncCtx.getCtx();
        String getXtOrgFromOrgMap = this.getXtOrgFormOrgMap();
        String getXtOrg = SyncConfigUtil.getInstance().getValue("getXtOrg");
        getXtOrg = SyncBaseUtil.fillTemplateSql(getXtOrg, 1, syncCtx.getSyncTableName());
        String getXtOrgById = getXtOrgFromOrgMap + " and omap.feasorgid = ? ";
        String getXtOrgByLongName = getXtOrg + " and xt.forglongname = ? ";
        IRowSet rs = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)getXtOrgById, (Object[])new Object[]{easorgid});
            if (rs.next()) {
                map.put("fisbind", StringUtils.isEmpty((String)rs.getString("forgname")) ? "0" : "1");
                map.put("forgname", rs.getString("forgname"));
            }
            if (map.get("forgname") == null || StringUtils.isEmpty((String)map.get("forgname").toString())) {
                rs = DbUtil.executeQuery((Context)ctx, (String)getXtOrgByLongName, (Object[])new Object[]{orglongname});
                if (rs.next()) {
                    map = new HashMap();
                    map.put("fisbind", "0");
                    map.put("forgname", rs.getString("forgname"));
                } else {
                    map.put("fisbind", "none");
                    map.put("forgname", "");
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.fromObject(map).toString();
    }

    protected String getXtOrgFormOrgMap() throws BOSException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEasPersonByPosition(SyncContext syncCtx, com.alibaba.fastjson.JSONObject condition) throws BOSException {
        String filter = condition.getString("filter");
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        Boolean includeNotInMiddle = condition.getBoolean("includeNotInMiddle");
        int page = condition.getIntValue("page");
        int rowCount = condition.getIntValue("rowCount");
        String positionId = condition.getString("orgId");
        boolean showSub = "true".equals(condition.getString("showSub"));
        int dataType = condition.getInteger("dataType");
        Context ctx = syncCtx.getCtx();
        StringBuilder sql = new StringBuilder(this.getEasAllPersonSql(syncCtx));
        if (!includeNotInMiddle.booleanValue()) {
            sql.append(" and t1.mapstatus is not null ");
        }
        if (dataType == 1) {
            BOSUuid.read((String)positionId);
            sql.append(" and t1.positionId = '" + positionId + "' and t1.FISPRIMARY = 1");
        }
        String fuserid = syncCtx.getMappingUserIdColnum();
        if (!StringUtils.isEmpty((String)filter)) {
            sql.append(" and (t1.forglongname like '%").append(filter).append("%'").append(" or t1.ucell like '%").append(filter).append("%'").append(" or t1.pcell like '%").append(filter).append("%'").append(" or t1.umail like '%").append(filter).append("%'").append(" or t1.pmail like '%").append(filter).append("%'").append(" or t1.fusernumber like '%").append(filter).append("%'").append(" or t1.personnumber like '%").append(filter).append("%'").append(" or t1.fpersonname like '%").append(filter).append("%'").append(" or t1.fposition like '%").append(filter).append("%'");
            if ("\u4e0d\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is not null ");
            } else if ("\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is null ");
            }
            if ("\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is not null ");
            } else if ("\u4e0d\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is null ");
            }
            if ("\u5df2\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1." + fuserid + " is not null ");
            } else if ("\u672a\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1." + fuserid + " is null ");
            }
            sql.append(" or t1.femail like '%").append(filter).append("%') ");
        }
        IRowSet rowSetCount = DbUtil.executeQuery((Context)ctx, (String)("select count(0) from (" + sql.toString() + ") countt"));
        sql.append(" order by Flongnumber");
        HashMap<String, String> map = null;
        ArrayList list = new ArrayList();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rowSet1.next()) {
                map = new HashMap<String, String>();
                String longName = rowSet1.getString("FOrgLongName");
                String xtid = rowSet1.getString(fuserid);
                map.put("fxtid", xtid);
                map.put("fuserid", rowSet1.getString("fuserId"));
                map.put("fpersonid", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("faddress", rowSet1.getString("faddress"));
                map.put("ftelephone", rowSet1.getString("ftelephone"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", longName);
                int inService = rowSet1.getInt("FinService");
                String status = "";
                switch (inService) {
                    case 1: {
                        status = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        status = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        status = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        status = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        status = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        status = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                map.put("finservice", status);
                map.put("fisbindsucc", StringUtils.isEmpty((String)xtid) ? "0" : "1");
                map.put("fnosync", StringUtils.isEmpty((String)rowSet1.getString("noSyncPersonId")) ? "0" : "1");
                map.put("fnotinmiddle", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "0" : "1");
                map.put("fmapstatus", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "none" : rowSet1.getString("mapstatus"));
                map.put("fdescription", rowSet1.getString("fdescription"));
                map.put("fusernumber", StringUtils.isEmpty((String)rowSet1.getString("usernumber")) ? "" : rowSet1.getString("usernumber"));
                map.put("personnumber", StringUtils.isEmpty((String)rowSet1.getString("personnumber")) ? "" : rowSet1.getString("personnumber"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEasPersonDatas(SyncContext syncCtx, com.alibaba.fastjson.JSONObject condition) throws BOSException {
        String filter = condition.getString("filter");
        if (StringUtil.sql_inj(filter)) {
            PageResult pageResult = new PageResult(1, 20, 0, new ArrayList());
            return JSONObject.fromObject((Object)pageResult).toString();
        }
        Boolean includeNotInMiddle = condition.getBoolean("includeNotInMiddle");
        int page = condition.getIntValue("page");
        int rowCount = condition.getIntValue("rowCount");
        String orgId = condition.getString("orgId");
        boolean showSub = "true".equals(condition.getString("showSub"));
        orgId = orgId == null ? "" : orgId.replaceAll(" ", "+");
        Context ctx = syncCtx.getCtx();
        AdminOrgUnitInfo adminInfo = null;
        try {
            adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (adminInfo == null) {
            return "";
        }
        String orgLongName = adminInfo.getDisplayName();
        StringBuilder sql = new StringBuilder(this.getEasAllPersonSql(syncCtx));
        if (!includeNotInMiddle.booleanValue()) {
            sql.append(" and t1.mapstatus is not null ");
        }
        String fuserid = syncCtx.getMappingUserIdColnum();
        if (!StringUtils.isEmpty((String)filter)) {
            sql.append(" and (t1.forglongname like '%").append(filter).append("%'").append(" or t1.ucell like '%").append(filter).append("%'").append(" or t1.pcell like '%").append(filter).append("%'").append(" or t1.umail like '%").append(filter).append("%'").append(" or t1.pmail like '%").append(filter).append("%'").append(" or t1.fusernumber like '%").append(filter).append("%'").append(" or t1.personnumber like '%").append(filter).append("%'").append(" or t1.fpersonname like '%").append(filter).append("%'").append(" or t1.fposition like '%").append(filter).append("%'");
            if ("\u4e0d\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is not null ");
            } else if ("\u4e0a\u4f20".equals(filter)) {
                sql.append(" or t1.noSyncPersonId is null ");
            }
            if ("\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is not null ");
            } else if ("\u4e0d\u5b58\u5728".equals(filter)) {
                sql.append(" or t1.mapstatus is null ");
            }
            if ("\u5df2\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1." + fuserid + " is not null ");
            } else if ("\u672a\u7ed1\u5b9a".equals(filter)) {
                sql.append(" or t1." + fuserid + " is null ");
            }
            sql.append(" or t1.femail like '%").append(filter).append("%') ");
        } else if (orgLongName.indexOf("_") < 0) {
            if (!showSub) {
                sql.append(" and (t1.orgparentid = '' or t1.orgparentid is null)");
            }
        } else if (orgLongName.indexOf("_") > 0) {
            if (showSub) {
                String dbType = (String)ctx.get((Object)"dbType");
                String tmpOrgLongName = orgLongName;
                sql.append(" and t1.forglongname like '").append(tmpOrgLongName).append("%'");
            } else {
                sql.append(" and t1.forglongname = '").append(orgLongName).append("'");
            }
        }
        IRowSet rowSetCount = DbUtil.executeQuery((Context)ctx, (String)("select count(0) from (" + sql.toString() + ") countt"));
        sql.append(" order by Flongnumber");
        HashMap<String, String> map = null;
        ArrayList list = new ArrayList();
        int total = 0;
        IRowSet rowSet1 = null;
        try {
            if (rowSetCount.next()) {
                total = rowSetCount.getInt(1);
            }
            if (!StringUtils.isEmpty((String)filter) && total < (page - 1) * rowCount) {
                page = 1;
            }
            rowSet1 = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (int)((page - 1) * rowCount), (int)rowCount);
            while (rowSet1.next()) {
                map = new HashMap<String, String>();
                String longName = rowSet1.getString("FOrgLongName");
                longName = "\\".equals(longName) ? adminInfo.getName() : longName;
                String xtid = rowSet1.getString(fuserid);
                map.put("fxtid", xtid);
                map.put("fuserid", rowSet1.getString("fuserId"));
                map.put("fpersonid", rowSet1.getString("fpersonId"));
                map.put("fname", rowSet1.getString("fpersonname"));
                map.put("fcell", rowSet1.getString("fcell"));
                map.put("femail", rowSet1.getString("femail"));
                map.put("faddress", rowSet1.getString("faddress"));
                map.put("ftelephone", rowSet1.getString("ftelephone"));
                map.put("fposition", rowSet1.getString("FPosition"));
                map.put("forglongname", longName);
                int inService = rowSet1.getInt("FinService");
                String status = "";
                switch (inService) {
                    case 1: {
                        status = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        status = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        status = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        status = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        status = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        status = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                map.put("finservice", status);
                map.put("fisbindsucc", StringUtils.isEmpty((String)xtid) ? "0" : "1");
                map.put("fnosync", StringUtils.isEmpty((String)rowSet1.getString("noSyncPersonId")) ? "0" : "1");
                map.put("fnotinmiddle", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "0" : "1");
                map.put("fmapstatus", StringUtils.isEmpty((String)rowSet1.getString("mapstatus")) ? "none" : rowSet1.getString("mapstatus"));
                map.put("fdescription", rowSet1.getString("fdescription"));
                map.put("fusernumber", StringUtils.isEmpty((String)rowSet1.getString("usernumber")) ? "" : rowSet1.getString("usernumber"));
                map.put("personnumber", StringUtils.isEmpty((String)rowSet1.getString("personnumber")) ? "" : rowSet1.getString("personnumber"));
                list.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSetCount != null) {
                try {
                    rowSetCount.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        PageResult pageResult = new PageResult(page, rowCount, total, list);
        return JSONObject.fromObject((Object)pageResult).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEasXtUserDetail(SyncContext syncCtx, com.alibaba.fastjson.JSONObject condition) throws BOSException {
        String xtid = null;
        String userid = condition.getString("userid") == null ? null : condition.getString("userid").trim();
        String personid = condition.getString("personid") == null ? null : condition.getString("personid").trim();
        Context ctx = syncCtx.getCtx();
        ArrayList<String> param = new ArrayList<String>();
        SyncConfigUtil instance = SyncConfigUtil.getInstance();
        String getEasPersonDetail = instance.getValue("getEasPersonDetail");
        String getXtPersonDetail = instance.getValue("getXtPersonDetail");
        getXtPersonDetail = this.fillTemplateSqlByName(getXtPersonDetail, "USER_SYNC_TABLE");
        getXtPersonDetail = this.fillTemplateSqlByName(getXtPersonDetail, "ORG_SYNC_TABLE");
        String getXtIdFromUMap = "select " + syncCtx.getMappingUserIdColnum() + " from " + syncCtx.getMappingTableName() + " umap where 1 = 1 ";
        if (!StringUtils.isEmpty((String)userid) && !"null".equalsIgnoreCase(userid)) {
            getEasPersonDetail = getEasPersonDetail + " and u.fid = ?";
            getXtIdFromUMap = getXtIdFromUMap + " and umap.fuserid = ?";
            param.add(userid);
        } else {
            getEasPersonDetail = getEasPersonDetail + " and p.fid = ?";
            getXtIdFromUMap = getXtIdFromUMap + " and umap.fpersonid = ?";
            param.add(personid);
        }
        IRowSet rs0 = DbUtil.executeQuery((Context)ctx, (String)getXtIdFromUMap, (Object[])param.toArray());
        try {
            if (rs0.next()) {
                xtid = rs0.getString(syncCtx.getMappingUserIdColnum());
                getXtPersonDetail = getXtPersonDetail + " and u.fuserid = '" + xtid + "'";
            } else {
                getXtPersonDetail = getXtPersonDetail + " and 1=2";
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs0 != null) {
                try {
                    rs0.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getEasPersonDetail, (Object[])param.toArray());
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)getXtPersonDetail);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, HashMap<String, String>> tmpMap = null;
        try {
            tmpMap = new HashMap<String, HashMap<String, String>>();
            if (rs.next()) {
                String orgLongName;
                map = new HashMap();
                map.put("fname", rs.getString("fpersonname"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("fposition", rs.getString("FPosition"));
                String string = orgLongName = rs.getString("FOrgLongName") == null ? "" : rs.getString("FOrgLongName");
                if (orgLongName.indexOf("_") > 0) {
                    orgLongName = orgLongName.substring(orgLongName.indexOf("_") + 1).replaceAll("_", "\\\\");
                    map.put("orgtop", "false");
                } else {
                    map.put("orgtop", "true");
                }
                map.put("forglongname", orgLongName);
                String userDelete = rs.getString("FIsDelete");
                int personInService = rs.getInt("FinService");
                String deletedStatus = rs.getString("fdeletedStatus");
                String status = "";
                switch (personInService) {
                    case 1: {
                        status = "\u5728\u804c";
                        break;
                    }
                    case 0: {
                        status = "\u4e0d\u5728\u804c";
                        break;
                    }
                    case 2: {
                        status = "\u79bb\u804c";
                        break;
                    }
                    case 3: {
                        status = "\u79bb\u9000\u4f11";
                        break;
                    }
                    case 4: {
                        status = "\u8fd4\u8058";
                        break;
                    }
                    default: {
                        status = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                    }
                }
                if (!"1".equals(userDelete) && !"2".equals(deletedStatus)) {
                    map.put("fstatus", status);
                } else {
                    map.put("fstatus", "\u7528\u6237\u5df2\u5220\u9664");
                }
                map.put("fgender", Genders.getEnum((int)rs.getInt("FGender")) == null ? "\u672a\u8bbe\u7f6e" : Genders.getEnum((int)rs.getInt("FGender")).getAlias());
                map.put("faddress", rs.getString("faddress"));
                map.put("ftelephone", rs.getString("ftelephone"));
                map.put("fcontact", "");
                Map easLeaderAndJob = this.getLeaderAndJob(ctx, "EAS", rs.getString("fcell"));
                map.put("leaderName", (String)easLeaderAndJob.get("leaderName"));
                map.put("leaderPosition", (String)easLeaderAndJob.get("leaderPosition"));
                map.put("partJob", (String)easLeaderAndJob.get("partJob"));
                tmpMap.put("easPerson", map);
            } else {
                map = new HashMap();
                map.put("fname", "");
                map.put("fcell", "");
                map.put("femail", "");
                map.put("fposition", "");
                map.put("forglongname", "");
                map.put("orgtop", "true");
                map.put("fstatus", "");
                map.put("fgender", "");
                map.put("faddress", "");
                map.put("ftelephone", "");
                map.put("fcontact", "");
                map.put("leaderName", "");
                map.put("leaderPosition", "");
                map.put("partJob", "");
                tmpMap.put("easPerson", map);
            }
            if (rs1.next()) {
                map = new HashMap();
                map.put("fname", rs1.getString("fpersonname"));
                map.put("fcell", "20220620".equals(rs1.getString("fcell")) ? "\u4eba\u5458\u654f\u611f\u4fe1\u606f" : rs1.getString("fcell"));
                map.put("femail", "20220620".equals(rs1.getString("femail")) ? "\u4eba\u5458\u654f\u611f\u4fe1\u606f" : rs1.getString("femail"));
                map.put("fposition", rs1.getString("FPosition"));
                map.put("forglongname", rs1.getString("FOrgLongName"));
                map.put("orgtop", StringUtils.isEmpty((String)rs1.getString("FParentId")) ? "true" : "false");
                String status = rs1.getString("FStatus");
                map.put("fstatus", this.getXTPersonStatus(status));
                String fgenderStr = "";
                int fgender = rs1.getInt("FGender");
                fgenderStr = fgender == 8 ? "\u4eba\u5458\u654f\u611f\u4fe1\u606f" : (Genders.getEnum((int)fgender) == null ? "\u672a\u8bbe\u7f6e" : Genders.getEnum((int)fgender).getAlias());
                map.put("fgender", fgenderStr);
                map.put("faddress", "20220620".equals(rs1.getString("faddress")) ? "\u4eba\u5458\u654f\u611f\u4fe1\u606f" : rs1.getString("faddress"));
                map.put("ftelephone", rs1.getString("ftelephone"));
                map.put("fcontact", "");
                Map easLeaderAndJob = this.getLeaderAndJob(ctx, "XT", rs1.getString("fuserid"));
                map.put("leaderName", (String)easLeaderAndJob.get("leaderName"));
                map.put("leaderPosition", (String)easLeaderAndJob.get("leaderPosition"));
                map.put("partJob", (String)easLeaderAndJob.get("partJob"));
                tmpMap.put("xtPerson", map);
            } else {
                map = new HashMap();
                map.put("fname", "");
                map.put("fcell", "");
                map.put("femail", "");
                map.put("fposition", "");
                map.put("forglongname", "");
                map.put("orgtop", "true");
                map.put("fstatus", "");
                map.put("fgender", "");
                map.put("faddress", "");
                map.put("ftelephone", "");
                map.put("fcontact", "");
                map.put("leaderName", "");
                map.put("leaderPosition", "");
                map.put("partJob", "");
                map.put("fpersonnumber", "");
                tmpMap.put("xtPerson", map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rs1 != null) {
                try {
                    rs1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONObject.fromObject(tmpMap).toString();
    }

    protected String getXTPersonStatus(String status) {
        status = "0".equals(status) ? "\u7981\u7528" : ("4".equals(status) ? "\u5728\u804c" : "\u79bb\u804c");
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getLeaderAndJob(Context ctx, String type, String xtIdOrCell) {
        String partJobSql = "";
        String leaderSql = "";
        SyncConfigUtil exsu = SyncConfigUtil.getInstance();
        try {
            if ("EAS".equals(type)) {
                partJobSql = exsu.getValue("getEASJianzhiWithAdmin") + " and (case when(u.FID is null or u.FID = '') then p.FCELL else u.FCELL end) = '" + xtIdOrCell + "'";
                leaderSql = exsu.getValue("getEASShangjiWithAdmin") + " and (case when(u.FID is null or u.FID = '') then p.FCELL else u.FCELL end) = '" + xtIdOrCell + "' ";
            } else if ("XT".equals(type)) {
                partJobSql = this.getPersonPartJobTiltle(xtIdOrCell);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        IRowSet rowSet = null;
        Object rowSet1 = null;
        HashMap<String, String> leaderAndJob = null;
        try {
            leaderAndJob = new HashMap<String, String>();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)partJobSql.toString());
            StringBuilder jobStr = new StringBuilder();
            while (rowSet.next()) {
                String orgLongName = "\\".equals(rowSet.getString("orgLongName")) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rowSet.getString("orgLongName");
                orgLongName = "\u3010" + orgLongName + "\u3011";
                if ("XT".equals(type)) {
                    jobStr.append(orgLongName);
                    continue;
                }
                jobStr.append(rowSet.getString("jobTitle") + orgLongName + "\uff1b");
            }
            leaderAndJob.put("partJob", jobStr.toString());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (rowSet != null) {
                try {
                    rowSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return leaderAndJob;
    }

    protected String getPersonPartJobTiltle(String xtIdOrCell) throws BOSException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEasOrgTree(SyncContext syncCtx, com.alibaba.fastjson.JSONObject condition) throws BOSException {
        String sql = "select fid,fparentid,fname_l2 from t_org_admin where fisSealup = 0 order by flongnumber asc, fsortcode asc";
        IRowSet rowSet1 = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sql);
        String sql2 = "SELECT p.FID,p.FNAME_l2,p.FADMINORGUNITID FROM T_ORG_POSITION  p inner join T_ORG_ADMIN  a on p.FADMINORGUNITID = a.FID and a.fisSealup = 0 and (p.FDELETEDSTATUS = 1 or p.FDELETEDSTATUS is null)";
        IRowSet rowSet2 = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sql2);
        String noSyncPersonTable = this.getTableName("USER_NOSYNC_TABLE");
        String sql3 = "SELECT DISTINCT(FPOSITIONID) FROM " + noSyncPersonTable + " WHERE FPOSITIONID IS NOT NULL";
        IRowSet rowSet3 = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sql3);
        ArrayList<String> noSyncPositionIds = new ArrayList<String>();
        AdminOrgTreeInfo org = null;
        ArrayList<AdminOrgTreeInfo> list = new ArrayList<AdminOrgTreeInfo>();
        try {
            while (rowSet3.next()) {
                noSyncPositionIds.add(rowSet3.getString("fpositionid"));
            }
            while (rowSet2.next()) {
                org = new AdminOrgTreeInfo();
                org.setId(rowSet2.getString("fid"));
                org.setName(rowSet2.getString("fname_l2"));
                org.setPid(rowSet2.getString("FADMINORGUNITID"));
                org.setType(1);
                if (noSyncPositionIds.size() > 0 && noSyncPositionIds.contains(org.getId())) {
                    org.setSync(true);
                }
                list.add(org);
            }
            while (rowSet1.next()) {
                org = new AdminOrgTreeInfo();
                org.setId(rowSet1.getString("fid"));
                org.setName(rowSet1.getString("fname_l2"));
                org.setType(0);
                if (!StringUtils.isEmpty((String)rowSet1.getString("fparentid"))) {
                    org.setPid(rowSet1.getString("fparentid"));
                } else {
                    org.setOpen(true);
                }
                list.add(org);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (rowSet1 != null) {
                try {
                    rowSet1.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return JSONArray.toJSONString(list);
    }

    protected String getEasAllPersonSql(SyncContext syncCtx) throws BOSException {
        String pSql = SyncConfigUtil.getInstance().getValue("getEasAllPersons");
        pSql = SyncBaseUtil.fillTemplateSql(pSql, 0, syncCtx.getMappingTableName());
        pSql = SyncBaseUtil.fillTemplateSql(pSql, 2, syncCtx.getMappingUserIdColnum());
        pSql = SyncBaseUtil.fillTemplateSql(pSql, 4, syncCtx.getNoSyncTableName());
        return pSql;
    }

    @Override
    public HSSFWorkbook exportFilterDataWrokbook(SyncContext syncCtx, com.alibaba.fastjson.JSONObject param, int type) throws BOSException {
        String syncType = param.getString("syncType");
        String subAction = param.getString("subAction");
        String successReqStr = param.getString("successReqStr");
        String filter = param.getString("filter");
        String createTimeStart = param.getString("createTimeStart");
        String createTimeEnd = param.getString("createTimeEnd");
        Map exportParam = this.getExportColName(syncCtx, syncType, subAction);
        String[] baseCol = (String[])exportParam.get("syncLogCol");
        String sql = this.getBaseSql(syncCtx.getHighItemType());
        StringBuilder baseSql = new StringBuilder(sql);
        baseSql.append(" WHERE 1=1 ");
        if (!StringUtils.isEmpty((String)syncType) && !"ALL".equalsIgnoreCase(syncType)) {
            baseSql.append(" and log.FTYPE = '" + exportParam.get("syncTypeValue") + "'");
        }
        if (!StringUtils.isEmpty((String)successReqStr) && !"ALL".equalsIgnoreCase(successReqStr)) {
            int success = "true".equalsIgnoreCase(successReqStr) ? 0 : 1;
            baseSql.append(" and log.FSUCCESS = " + success);
        }
        if (!StringUtils.isEmpty((String)createTimeStart)) {
            baseSql.append(" and log.fcreatetime >={" + Timestamp.valueOf(createTimeStart) + "} ");
        }
        if (!StringUtils.isEmpty((String)createTimeEnd)) {
            baseSql.append(" and log.fcreatetime <{" + Timestamp.valueOf(createTimeEnd) + "} ");
        }
        if (!StringUtils.isEmpty((String)filter)) {
            SyncHighItemType highItemType = SyncHighItemType.getEnum(param.get((Object)"highItemType").toString());
            String[] filterColName = this.getFilterColName(highItemType, true);
            baseSql.append(this.buildFilterSql(filterColName, filter, highItemType));
        }
        IRowSet rs = null;
        ArrayList<Map> rows = new ArrayList<Map>();
        int index = 1;
        try {
            baseSql.append(" order by log.fcreatetime desc");
            rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)baseSql.toString());
            while (rs.next()) {
                Map<Object, Object> map = new HashMap();
                map = this.buildExportTableData(syncCtx.getCtx(), syncCtx.getHighItemType(), baseCol, rs);
                ++index;
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        ExportExcelTools et = new ExportExcelTools();
        String[] exportTiltle = this.getExportTiltle(subAction);
        String fileName = this.getExportFileName(subAction);
        return et.writeWorkBook(rows, fileName, exportTiltle, baseCol);
    }

    @Override
    public HSSFWorkbook exportAllXtOrg(SyncContext syncCtx, com.alibaba.fastjson.JSONObject param) throws BOSException {
        String filter = param.getString("filter");
        String subAction = param.getString("subAction");
        String sql = SyncConfigUtil.getInstance().getValue("getAllSyncOrg");
        sql = SyncBaseUtil.fillTemplateSql(sql, 1, syncCtx.getSyncTableName());
        sql = SyncBaseUtil.fillTemplateSql(sql, 2, syncCtx.getMappingOrgIdColnum());
        StringBuilder sqlB = new StringBuilder(sql);
        sqlB.append(" WHERE 1=1 ");
        String[] filterCol = this.getAllSyncFilterCol("ORG");
        if (!StringUtils.isEmpty((String)filter)) {
            sqlB.append(" AND " + filterCol[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterCol.length; ++i) {
                sqlB.append(" OR " + filterCol[i] + " LIKE '%" + filter + "%'");
            }
        }
        IRowSet rs = null;
        ArrayList<Map> rows = new ArrayList<Map>();
        try {
            sqlB.append(" ORDER BY FWEIGHT");
            rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sqlB.toString());
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put(syncCtx.getMappingOrgIdColnum(), rs.getString(syncCtx.getMappingOrgIdColnum()));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fname", rs.getString("fname"));
                map.put("fweight", rs.getString("fweight"));
                map.put("fparentid", rs.getString("fparentid"));
                map.put(syncCtx.getMappingOrgIdColnum(), rs.getString(syncCtx.getMappingOrgIdColnum()));
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        ExportExcelTools et = new ExportExcelTools();
        String[] exportTiltle = this.getExportTiltle(subAction);
        String fileName = this.getExportFileName(subAction);
        String[] baseCol = new String[]{syncCtx.getMappingOrgIdColnum(), "forglongname", "fname", "fparentid", "fweight"};
        return et.writeWorkBook(rows, fileName, exportTiltle, baseCol);
    }

    @Override
    public HSSFWorkbook exportAllXtUser(SyncContext syncCtx, com.alibaba.fastjson.JSONObject param) throws BOSException {
        String filter = param.getString("filter");
        String subAction = param.getString("subAction");
        String sql = SyncConfigUtil.getInstance().getValue("getAllSyncPerson");
        sql = SyncBaseUtil.fillTemplateSql(sql, 1, syncCtx.getSyncTableName());
        sql = SyncBaseUtil.fillTemplateSql(sql, 2, syncCtx.getMappingOrgIdColnum());
        StringBuilder sqlB = new StringBuilder(sql);
        sqlB.append(" WHERE 1=1 ");
        String[] filterCol = this.getAllSyncFilterCol("PERSON");
        if (!StringUtils.isEmpty((String)filter)) {
            sqlB.append(" AND " + filterCol[0] + " like '%" + filter + "%'");
            for (int i = 1; i < filterCol.length; ++i) {
                sqlB.append(" OR " + filterCol[i] + " LIKE '%" + filter + "%'");
            }
        }
        IRowSet rs = null;
        ArrayList<Map> rows = new ArrayList<Map>();
        try {
            sqlB.append(" ORDER BY FORGLONGNAME");
            rs = DbUtil.executeQuery((Context)syncCtx.getCtx(), (String)sqlB.toString());
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("fuserid", rs.getString("fuserid"));
                map.put("fpersonname", rs.getString("fpersonname"));
                map.put("forglongname", rs.getString("forglongname"));
                map.put("fcell", rs.getString("fcell"));
                map.put("femail", rs.getString("femail"));
                map.put("fposition", rs.getString("fposition"));
                map.put("faddress", rs.getString("faddress"));
                map.put("ftelephone", rs.getString("ftelephone"));
                map.put("fgender", rs.getInt("fgender") == 1 ? "\u7537" : (rs.getInt("fgender") == 2 ? "\u5973" : "\u672a\u8bbe\u7f6e"));
                map.put("fweight", rs.getString("fweight"));
                String status = null;
                switch (rs.getInt("fstatus")) {
                    case 1: {
                        status = "\u5df2\u6fc0\u6d3b";
                        break;
                    }
                    case 2: {
                        status = "\u5df2\u7981\u7528";
                        break;
                    }
                    case 4: {
                        status = "\u672a\u6fc0\u6d3b";
                        break;
                    }
                    case 5: {
                        status = "\u9000\u51fa\u4f01\u4e1a";
                        break;
                    }
                    default: {
                        status = "\u672a\u77e5";
                    }
                }
                map.put("fstatus", status);
                rows.add(map);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        ExportExcelTools et = new ExportExcelTools();
        String[] exportTiltle = this.getExportTiltle(subAction);
        String fileName = this.getExportFileName(subAction);
        String[] baseCol = new String[]{"fuserid", "fname", "fcell", "fcmail", "forglongname", "fgender", "fposition", "faddress", "ftelephone", "fweight", "fstatus"};
        return et.writeWorkBook(rows, fileName, exportTiltle, baseCol);
    }

    protected String getExportFileName(String subAction) {
        if ("viewOrgLog".equalsIgnoreCase(subAction)) {
            return "\u7ec4\u7ec7\u65e5\u5fd7";
        }
        if ("viewPersonLog".equalsIgnoreCase(subAction)) {
            return "\u4eba\u5458\u65e5\u5fd7";
        }
        if ("viewDeptLeaderLog".equalsIgnoreCase(subAction)) {
            return "\u90e8\u95e8\u8d1f\u8d23\u4eba\u65e5\u5fd7";
        }
        if ("viewPartJobLog".equalsIgnoreCase(subAction)) {
            return "\u517c\u804c\u65e5\u5fd7";
        }
        if ("viewXtOrg".equalsIgnoreCase(subAction)) {
            return "\u540c\u6b65\u4f01\u4e1a\u7ec4\u7ec7";
        }
        if ("viewXtUser".equalsIgnoreCase(subAction)) {
            return "\u540c\u6b65\u4f01\u4e1a\u4eba\u5458";
        }
        if ("viewRelationsLog".equalsIgnoreCase(subAction)) {
            return "\u540c\u6b65\u4e0a\u7ea7\u65e5\u5fd7";
        }
        return null;
    }

    protected String[] getExportTiltle(String subAction) {
        if ("viewOrgLog".equalsIgnoreCase(subAction)) {
            return new String[]{"FID", "\u540c\u6b65\u7c7b\u578b", "\u540c\u6b65\u65f6\u95f4", "\u65e7\u7ec4\u7ec7\u957f\u540d\u79f0", "\u7ec4\u7ec7\u957f\u540d\u79f0", "\u7ec4\u7ec7\u6392\u5e8f\u7801", "\u7ed1\u5b9a\u72b6\u6001", "\u6d88\u606f\u7801", "\u65e5\u5fd7\u8be6\u60c5", "\u662f\u5426\u6210\u529f", "\u540c\u6b65\u6279\u6b21\u53f7"};
        }
        if ("viewPersonLog".equalsIgnoreCase(subAction)) {
            return new String[]{"FID", "\u540c\u6b65\u7c7b\u578b", "\u540c\u6b65\u65f6\u95f4", "\u59d3\u540d", "\u624b\u673a", "\u90ae\u7bb1", "\u539f\u7ec4\u7ec7\u957f\u540d\u79f0", "\u73b0\u7ec4\u7ec7\u957f\u540d\u79f0", "\u804c\u4f4d", "\u6027\u522b", "\u5730\u5740", "\u529e\u516c\u7535\u8bdd", "\u6392\u5e8f\u7801", "\u5728\u804c\u72b6\u6001", "\u7ed1\u5b9a\u72b6\u6001", "\u6d88\u606f\u7801", "\u65e5\u5fd7\u8be6\u60c5", "\u662f\u5426\u6210\u529f", "\u540c\u6b65\u6279\u6b21\u53f7"};
        }
        if ("viewDeptLeaderLog".equalsIgnoreCase(subAction)) {
            return new String[]{"FID", "\u540c\u6b65\u65f6\u95f4", "\u8d1f\u8d23\u4eba\u59d3\u540d", "\u7ec4\u7ec7\u957f\u540d\u79f0", "\u624b\u673a", "\u8d1f\u8d23\u7684\u90e8\u95e8\u957f\u540d\u79f0", "\u6d88\u606f\u7801", "\u5177\u4f53\u9519\u8bef\u4fe1\u606f", "\u662f\u5426\u6210\u529f", "\u540c\u6b65\u6279\u6b21"};
        }
        if ("viewPartJobLog".equalsIgnoreCase(subAction)) {
            return new String[]{"FID", "\u7c7b\u578b", "\u540c\u6b65\u65f6\u95f4", "\u4eba\u5458\u59d3\u540d", "\u624b\u673a", "\u7ec4\u7ec7\u957f\u540d\u79f0", "\u517c\u804c\u804c\u4f4d", "\u6d88\u606f\u7801", "\u5177\u4f53\u9519\u8bef\u4fe1\u606f", "\u662f\u5426\u6210\u529f", "\u540c\u6b65\u6279\u6b21"};
        }
        if ("viewXtOrg".equalsIgnoreCase(subAction)) {
            return new String[]{"\u7ec4\u7ec7ID", "\u7ec4\u7ec7\u957f\u540d\u79f0", "\u7ec4\u7ec7\u540d\u79f0", "\u4e0a\u7ea7ID", "\u6392\u5e8f"};
        }
        if ("viewXtUser".equalsIgnoreCase(subAction)) {
            return new String[]{"\u4eba\u5458UserId", "\u59d3\u540d", "\u624b\u673a", "\u90ae\u7bb1", "\u7ec4\u7ec7\u957f\u540d\u79f0", "\u6027\u522b", "\u804c\u4f4d", "\u5730\u5740", "\u529e\u516c\u7535\u8bdd", "\u6392\u5e8f", "\u72b6\u6001"};
        }
        if ("viewRelationsLog".equalsIgnoreCase(subAction)) {
            return new String[]{"FID", "\u7c7b\u578b", "\u540c\u6b65\u65f6\u95f4", "\u4eba\u5458\u59d3\u540d", "\u624b\u673a", "\u7ec4\u7ec7\u957f\u540d\u79f0", "\u4e0a\u7ea7\u540d\u79f0", "\u6d88\u606f\u7801", "\u5177\u4f53\u9519\u8bef\u4fe1\u606f", "\u662f\u5426\u6210\u529f", "\u540c\u6b65\u6279\u6b21"};
        }
        return null;
    }

    protected Map getExportColName(SyncContext syncCtx, String syncType, String subAction) {
        return null;
    }

    protected String[] getAllSyncFilterCol(String type) {
        if ("ORG".equals(type)) {
            return new String[]{"FORGLONGNAME", "FNAME"};
        }
        return new String[]{"FCELL", "FEMAIL", "FPERSONNAME", "FPOSITION", "FORGLONGNAME", "FSTATUS"};
    }

    protected Map getAllSyncLogColBase(String syncType, String subAction) {
        HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
        String[] baseCol = null;
        String syncTypeValue = null;
        if ("ALL".equalsIgnoreCase(syncType)) {
            baseCol = "viewOrgLog".equalsIgnoreCase(subAction) ? new String[]{"fid", "ftype", "fcreatetime", "foldorglongname", "forglongname", "fweight", "fisbindsucc", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"} : new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "foldorglongname", "forglongname", "fposition", "fgender", "faddress", "ftelephone", "fweight", "finservice", "fisbindsucc", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
        } else {
            SyncItemType baseType = SyncBaseUtil.getBaseEnum(syncType);
            syncTypeValue = baseType.getValue();
            switch (Integer.parseInt(syncTypeValue)) {
                case 1: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "forglongname", "fisbindsucc", "fweight", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 2: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 3: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "foldorglongname", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 4: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "foldorglongname", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 5: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "forglongname", "fweight", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 6: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fposition", "fgender", "faddress", "ftelephone", "fweight", "finservice", "fisbindsucc", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 7: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "finservice", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 8: 
                case 9: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "foldorglongname", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 10: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fposition", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 11: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 12: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "faddress", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 13: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 14: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "ftelephone", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 15: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 16: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fgender", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 17: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fpersonnumber", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
                case 19: {
                    baseCol = new String[]{"fid", "ftype", "fcreatetime", "fpersonname", "fcell", "femail", "forglongname", "fweight", "fmsgcode", "ferrormsg", "fsuccess", "fsynctimeid"};
                    break;
                }
            }
        }
        syncLogMap.put("syncLogCol", baseCol);
        syncLogMap.put("syncTypeValue", syncTypeValue);
        return syncLogMap;
    }

    protected Map getSyncLogColBase(String syncType) {
        HashMap<String, Object> syncLogMap = new HashMap<String, Object>();
        String[] baseCol = null;
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(syncType);
        String syncTypeValue = baseType.getValue();
        switch (Integer.parseInt(syncTypeValue)) {
            case 1: {
                baseCol = new String[]{"fid", "forglongname", "ferrormsg", "fisbindsucc"};
                break;
            }
            case 2: {
                baseCol = new String[]{"fid", "forglongname", "ferrormsg"};
                break;
            }
            case 3: {
                baseCol = new String[]{"fid", "foldorglongname", "forglongname", "ferrormsg"};
                break;
            }
            case 4: {
                baseCol = new String[]{"fid", "foldorglongname", "forglongname", "ferrormsg"};
                break;
            }
            case 5: {
                baseCol = new String[]{"fid", "forglongname", "fweight", "ferrormsg"};
                break;
            }
            case 6: {
                baseCol = new String[]{"fid", "fpersonname", "fcell", "femail", "forglongname", "fposition", "fgender", "faddress", "finservice", "ferrormsg", "fisbindsucc"};
                break;
            }
            case 7: {
                baseCol = new String[]{"fid", "fpersonname", "fcell", "ferrormsg"};
                break;
            }
            case 8: 
            case 9: {
                baseCol = new String[]{"fid", "fpersonname", "foldorglongname", "forglongname", "ferrormsg"};
                break;
            }
            case 10: {
                baseCol = new String[]{"fid", "fpersonname", "fposition", "ferrormsg"};
                break;
            }
            case 11: {
                baseCol = new String[]{"fid", "fpersonname", "ferrormsg"};
                break;
            }
            case 12: {
                baseCol = new String[]{"fid", "fpersonname", "faddress", "ferrormsg"};
                break;
            }
            case 13: {
                baseCol = new String[]{"fid", "fpersonname", "femail", "ferrormsg"};
                break;
            }
            case 14: {
                baseCol = new String[]{"fid", "fpersonname", "ftelephone", "ferrormsg"};
                break;
            }
            case 15: {
                baseCol = new String[]{"fid", "fpersonname", "fcell", "ferrormsg"};
                break;
            }
            case 16: {
                baseCol = new String[]{"fid", "fpersonname", "fgender", "ferrormsg"};
                break;
            }
            case 17: {
                baseCol = new String[]{"fid", "fpersonname", "fpersonnumber", "ferrormsg"};
                break;
            }
            case 18: 
            case 19: {
                baseCol = new String[]{"fid", "fpersonname", "fweight", "ferrormsg"};
                break;
            }
        }
        syncLogMap.put("syncLogCol", baseCol);
        syncLogMap.put("syncTypeValue", syncTypeValue);
        return syncLogMap;
    }

    protected Map<String, Object> buildTableData(Context ctx, SyncHighItemType highItemType, String[] baseCol, IRowSet rs) throws BOSException {
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        try {
            if (SyncHighItemType.Dept.equals((Object)highItemType)) {
                for (int i = 0; i < baseCol.length; ++i) {
                    String key = baseCol[i];
                    if ("forglongname".equalsIgnoreCase(key)) {
                        tableMap.put(key, "\\".equals(rs.getString(key)) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString(key));
                        continue;
                    }
                    if ("ftype".equalsIgnoreCase(key)) {
                        tableMap.put(key, this.getSyncTypeAlias(rs.getString(key)));
                        continue;
                    }
                    tableMap.put(key, rs.getString(key));
                }
            } else if (SyncHighItemType.Person.equals((Object)highItemType)) {
                for (int i = 0; i < baseCol.length; ++i) {
                    String key = baseCol[i];
                    if ("FinService".equalsIgnoreCase(key)) {
                        int inService = rs.getInt(key);
                        String finservice = "";
                        switch (inService) {
                            case 1: {
                                finservice = "\u5728\u804c";
                                break;
                            }
                            case 0: {
                                finservice = "\u4e0d\u5728\u804c";
                                break;
                            }
                            case 2: {
                                finservice = "\u79bb\u804c";
                                break;
                            }
                            case 3: {
                                finservice = "\u79bb\u9000\u4f11";
                                break;
                            }
                            case 4: {
                                finservice = "\u8fd4\u8058";
                                break;
                            }
                            default: {
                                finservice = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                            }
                        }
                        tableMap.put(key, finservice);
                        continue;
                    }
                    if ("ftype".equalsIgnoreCase(key)) {
                        tableMap.put(key, this.getSyncTypeAlias(rs.getString(key)));
                        continue;
                    }
                    if ("forglongname".equalsIgnoreCase(key) || "foldorglongname".equalsIgnoreCase(key)) {
                        tableMap.put(key, "\\".equals(rs.getString(key)) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString(key));
                        continue;
                    }
                    if ("fgender".equalsIgnoreCase(key)) {
                        int type = rs.getInt(key);
                        String gender = type == 1 ? "\u7537" : (type == 2 ? "\u5973" : "\u672a\u8bbe\u7f6e");
                        tableMap.put(key, gender);
                        continue;
                    }
                    tableMap.put(key, rs.getString(key));
                }
            } else if (SyncHighItemType.PartJob.equals((Object)highItemType)) {
                for (int i = 0; i < baseCol.length; ++i) {
                    String key = baseCol[i];
                    if ("forglongname".equalsIgnoreCase(key)) {
                        tableMap.put(key, "\\".equals(rs.getString(key)) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString(key));
                        continue;
                    }
                    if ("ftype".equalsIgnoreCase(key)) {
                        tableMap.put(key, this.getSyncTypeAlias(rs.getString(key)));
                        continue;
                    }
                    tableMap.put(key, rs.getString(key));
                }
            } else if (SyncHighItemType.DeptLeader.equals((Object)highItemType)) {
                for (int i = 0; i < baseCol.length; ++i) {
                    String key = baseCol[i];
                    if ("forglongname".equalsIgnoreCase(key)) {
                        tableMap.put(key, "\\".equals(rs.getString(key)) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString(key));
                        continue;
                    }
                    if ("ftype".equalsIgnoreCase(key)) {
                        tableMap.put(key, this.getSyncTypeAlias(rs.getString(key)));
                        continue;
                    }
                    tableMap.put(key, rs.getString(key));
                }
            } else if (SyncHighItemType.Relations.equals((Object)highItemType)) {
                for (int i = 0; i < baseCol.length; ++i) {
                    String key = baseCol[i];
                    if ("forglongname".equalsIgnoreCase(key)) {
                        tableMap.put(key, "\\".equals(rs.getString(key)) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString(key));
                        continue;
                    }
                    if ("ftype".equalsIgnoreCase(key)) {
                        tableMap.put(key, this.getSyncTypeAlias(rs.getString(key)));
                        continue;
                    }
                    tableMap.put(key, rs.getString(key));
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tableMap;
    }

    protected Map<String, Object> buildExportTableData(Context ctx, SyncHighItemType highItemType, String[] baseCol, IRowSet rs) throws BOSException {
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        try {
            for (int i = 0; i < baseCol.length; ++i) {
                String key = baseCol[i];
                if ("forglongname".equalsIgnoreCase(key) || "foldorglongname".equalsIgnoreCase(key)) {
                    tableMap.put(key, "\\".equals(rs.getString(key)) ? EasXtCommonUtils.getEasTopUnitName(ctx) : rs.getString(key));
                    continue;
                }
                if ("ftype".equalsIgnoreCase(key)) {
                    tableMap.put(key, this.getSyncTypeAlias(rs.getString(key)));
                    continue;
                }
                if ("FinService".equalsIgnoreCase(key)) {
                    int inService = rs.getInt(key);
                    String finservice = "";
                    switch (inService) {
                        case 1: {
                            finservice = "\u5728\u804c";
                            break;
                        }
                        case 0: {
                            finservice = "\u4e0d\u5728\u804c";
                            break;
                        }
                        case 2: {
                            finservice = "\u79bb\u804c";
                            break;
                        }
                        case 3: {
                            finservice = "\u79bb\u9000\u4f11";
                            break;
                        }
                        case 4: {
                            finservice = "\u8fd4\u8058";
                            break;
                        }
                        default: {
                            finservice = "\u804c\u5458\u72b6\u6001\u5f02\u5e38";
                        }
                    }
                    tableMap.put(key, finservice);
                    continue;
                }
                if ("fgender".equalsIgnoreCase(key)) {
                    int type = rs.getInt(key);
                    String gender = type == 1 ? "\u7537" : (type == 2 ? "\u5973" : "\u672a\u8bbe\u7f6e");
                    tableMap.put(key, gender);
                    continue;
                }
                if ("fsuccess".equalsIgnoreCase(key)) {
                    tableMap.put(key, rs.getInt(key) == 0 ? "\u6210\u529f" : "\u5931\u8d25");
                    continue;
                }
                if ("fisBindSucc".equalsIgnoreCase(key)) {
                    tableMap.put(key, rs.getInt(key) == 1 ? "\u5df2\u7ed1\u5b9a" : "\u672a\u7ed1\u5b9a");
                    continue;
                }
                tableMap.put(key, rs.getString(key));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return tableMap;
    }

    protected String getSyncTypeAlias(String type) throws BOSException {
        SyncItemType baseType = SyncItemType.getEnum(type);
        if (baseType != null) {
            return baseType.getAlias();
        }
        return null;
    }

    protected abstract String getBaseSql(SyncHighItemType var1) throws BOSException;

    private String fillTemplateSqlByName(String sqlTemplate, String type) {
        Pattern p = Pattern.compile("\\{" + type + "\\}");
        Matcher m = p.matcher(sqlTemplate);
        return m.replaceAll(this.getTableName(type));
    }

    public String getDetailLogMsg(Map newConfig, Map config) {
        StringBuilder detailLogMsg = new StringBuilder();
        String beforeValue = "";
        String afterValue = "";
        try {
            MapDifference difference = Maps.difference((Map)config, (Map)newConfig);
            Map entriesDiffering = difference.entriesDiffering();
            for (Map.Entry entry : entriesDiffering.entrySet()) {
                EasSyncConfigItemEnum syncEnum = EasSyncConfigItemEnum.getEnum((String)entry.getKey());
                if (syncEnum == null || (beforeValue = ((MapDifference.ValueDifference)entry.getValue()).leftValue() == null ? "null" : ((MapDifference.ValueDifference)entry.getValue()).leftValue().toString()).equals(afterValue = ((MapDifference.ValueDifference)entry.getValue()).rightValue() == null ? "null" : ((MapDifference.ValueDifference)entry.getValue()).rightValue().toString())) continue;
                if (EasSyncConfigItemEnum.secret.equals((Object)syncEnum) || EasSyncConfigItemEnum.selfBuildSecret.equals((Object)syncEnum)) {
                    if (StringUtils.isEmpty((String)beforeValue) || StringUtils.isEmpty((String)afterValue)) continue;
                    detailLogMsg.append("\u66f4\u65b0\u540c\u6b65\u5bc6\u94a5\uff1a").append((Object)syncEnum).append("; ");
                    continue;
                }
                if (EasSyncConfigItemEnum.customSql.equals((Object)syncEnum) && "0".equals(beforeValue) && StringUtils.isEmpty((String)afterValue)) continue;
                detailLogMsg.append("\u66f4\u65b0\u540c\u6b65\u53c2\u6570\uff1a").append((Object)syncEnum).append("(").append((String)entry.getKey()).append(")").append(" \u539f\u503c: ").append(beforeValue).append(" \u73b0\u503c: ").append(afterValue).append("; ");
            }
            Map entriesOnlyOnLeft = difference.entriesOnlyOnLeft();
            for (Map.Entry entry : entriesOnlyOnLeft.entrySet()) {
                EasSyncConfigItemEnum syncEnum = EasSyncConfigItemEnum.getEnum((String)entry.getKey());
                detailLogMsg.append("\u65b0\u589e\u540c\u6b65\u9879\uff1a").append((Object)syncEnum).append("=").append((String)entry.getValue());
            }
            if (StringUtils.isEmpty((String)detailLogMsg.toString())) {
                detailLogMsg.append("\u65e0\u4fee\u6539");
            }
        }
        catch (Exception e) {
            detailLogMsg.append("\u8bb0\u5f55\u5931\u8d25,\u8bf7\u67e5\u770bapusic\u65e5\u5fd7");
            e.printStackTrace();
        }
        return detailLogMsg.toString();
    }
}

