/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.ddsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncPartBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncCommunitcateUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.DDSyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.ddsync.util.DDSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class DDSyncPartService
extends SyncPartBaseService {
    public DDSyncPartService(SyncContext syncCtx) {
        super(syncCtx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        this.updatePartJobInfo();
        this.deleteMapPartJob();
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String sync(String itemType) throws BOSException, EASBizException, EASBizException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        if (baseType != null) {
            return super.sync(itemType);
        }
        DDSyncItemType ddType = DDSyncUtil.getDDSyncEnum(itemType);
        if (DDSyncItemType.BatchUpdatePersonPartJob.equals((Object)ddType)) {
            String sql = DDSyncConfigUtil.getInstance().getValue("selectPartJobChanged");
            IRowSet rowSet = EasXtSyncUtil.executeQuery(this.ctx, sql);
            String[] syncJsonKey = this.getSyncJsonKey(itemType);
            String[] syncJsonValue = this.getSyncJsonValue(itemType);
            String[] syncLogColName = this.getSyncLogColName(itemType);
            String[] syncLogColValue = this.getSyncLogColValue(itemType);
            JSONArray dataArray = new JSONArray();
            HashMap<String, Object> logMap = new HashMap<String, Object>();
            logMap.put("logColName", syncLogColName);
            ArrayList logArrays = new ArrayList();
            Object result = null;
            try {
                ArrayList<String> logValue = null;
                while (rowSet.next()) {
                    int i;
                    JSONObject dataJSON = new JSONObject();
                    for (i = 0; i < syncJsonKey.length; ++i) {
                        if ("department".equals(syncJsonKey[i])) {
                            ArrayList<String> orgids = JSONArray.parseArray((String)rowSet.getString("FDDORGIDS"), String.class);
                            if (orgids == null) {
                                orgids = new ArrayList<String>();
                            }
                            orgids.add(0, rowSet.getString("fmaindepartment"));
                            dataJSON.put(syncJsonKey[i], (Object)orgids.toArray());
                            continue;
                        }
                        Object value = rowSet.getObject(syncJsonValue[i]);
                        dataJSON.put(syncJsonKey[i], (Object)(value == null ? "" : value.toString()));
                    }
                    logValue = new ArrayList<String>();
                    for (i = 0; i < syncLogColName.length; ++i) {
                        Object value2 = rowSet.getObject(syncLogColValue[i]);
                        logValue.add(value2 == null ? "" : value2.toString());
                    }
                    logArrays.add(logValue);
                    dataArray.add((Object)dataJSON);
                }
                logMap.put("logColValue", logArrays);
                logger.error((Object)(" updatePartJob2DingDing detail is " + dataArray));
                String string = this.syncPart(this.syncCtx, dataArray, itemType, logMap);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e instanceof BOSException) {
                    throw (BOSException)((Object)e);
                }
            }
            finally {
                if (rowSet != null) {
                    try {
                        rowSet.close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    @Override
    protected String syncPart(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException {
        DDSyncItemType type = DDSyncUtil.getDDSyncEnum(itemType);
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            String url = DDSyncURLUtil.getSyncUrl(this.ctx, "/user/update");
            for (int i = 0; i < dataArray.size(); ++i) {
                JSONObject dataJSON = dataArray.getJSONObject(i);
                result = SyncCommunitcateUtil.getSyncResponse(dataJSON, url);
                logger.error((Object)("xjw syncPart:" + result.toJSONString()));
                logArray.add((Object)result);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, type.getValue());
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, type.getValue()));
    }

    @Override
    public String afterSync() throws BOSException, EASBizException {
        return this.insertPartInfo();
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        DDSyncItemType DDType = DDSyncUtil.getDDSyncEnum(itemType);
        if (DDSyncItemType.BatchUpdatePersonPartJob.equals((Object)DDType)) {
            head = new String[]{"userid", "department"};
        }
        return head;
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        DDSyncItemType DDType = DDSyncUtil.getDDSyncEnum(itemType);
        if (DDSyncItemType.BatchUpdatePersonPartJob.equals((Object)DDType)) {
            head = new String[]{"FDDId", "fDDorgids"};
        }
        return head;
    }

    @Override
    protected String[] getSyncLogColName(String itemType) {
        String[] head = null;
        DDSyncItemType DDType = DDSyncUtil.getDDSyncEnum(itemType);
        if (DDSyncItemType.BatchUpdatePersonPartJob.equals((Object)DDType)) {
            head = new String[]{"FDDId", "FJobtitles", "FOldDDOrgIds", "FDDOrgIds"};
        }
        return head;
    }

    @Override
    protected String[] getSyncLogColValue(String itemType) {
        String[] head = null;
        DDSyncItemType DDType = DDSyncUtil.getDDSyncEnum(itemType);
        if (DDSyncItemType.BatchUpdatePersonPartJob.equals((Object)DDType)) {
            head = new String[]{"FDDId", "FJobtitles", "FOldDDOrgIds", "FDDOrgIds"};
        }
        return head;
    }

    private String insertPartInfo() throws BOSException {
        String syncTimeId = SyncLogUtils.getLastSyncTime(this.syncCtx);
        String sql = "SELECT FDDID FROM T_DD_SYNCPARTLOG WHERE FSyncTimeID = '" + syncTimeId + "' and FSUCCESS = 0";
        IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
        ArrayList<String> userIds = new ArrayList<String>();
        String sqlForOrgID = DDSyncConfigUtil.getInstance().getValue("getOrgIdByDDID");
        try {
            while (rs.next()) {
                String userid = rs.getString("FDDID");
                if (StringUtils.isEmpty((String)userid)) continue;
                userIds.add(userid);
            }
            if (userIds.size() < 50000000) {
                HashMap paramMap = new HashMap();
                String syncUrl = DDSyncURLUtil.getSyncUrl(this.ctx, "/user/get");
                String syncUrlReal = "";
                for (int i = 0; i < userIds.size(); ++i) {
                    String userID = (String)userIds.get(i);
                    syncUrlReal = syncUrl + "&userid=" + userID;
                    try {
                        JSONObject result = SyncCommunitcateUtil.getSyncResponse(syncUrlReal);
                        logger.error((Object)("syncUrlReal:" + syncUrlReal));
                        logger.error((Object)("- insertPartInfo \u5c1d\u8bd5\u901a\u8fc7\u901a\u8baf\u5f55\u53bb\u8c03\u7528\u63a5\u53e3-result:" + result.toString()));
                        if (!"0".equals(result.getString("errcode"))) {
                            throw new BOSException(result.getString("errmsg"));
                        }
                        JSONArray departs = result.getJSONArray("department");
                        if (departs.size() <= 1) continue;
                        String ddid = result.getString("userid");
                        String sql1 = sqlForOrgID + " where xt.FUserID = '" + ddid + "'";
                        logger.error((Object)("sql1:" + sql1));
                        IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sql1);
                        if (rs1.next()) {
                            String mainDepart = rs1.getString("fddorgid");
                            for (int j = 0; j < departs.size(); ++j) {
                                if (!mainDepart.equals(departs.get(j).toString())) continue;
                                departs.remove(j);
                                break;
                            }
                        }
                        ArrayList<String> param = new ArrayList<String>();
                        param.add(departs.toString());
                        param.add(userID);
                        paramMap.put(userID, param);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                Set allUserId = paramMap.keySet();
                if (allUserId.size() < 1) {
                    return null;
                }
                StringBuilder sb = new StringBuilder("select FUserId FROM T_DD_PART WHERE FUserId in (");
                for (String uId : allUserId) {
                    sb.append("'" + uId + "',");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(") ");
                IRowSet rs1 = EasXtSyncUtil.executeQuery(this.ctx, sb.toString());
                ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
                String updateSql = "UPDATE T_DD_PART SET FOrgIds = ? WHERE FUserId = ?";
                while (rs1.next()) {
                    String FUserId = rs1.getString("FUserId");
                    updateParams.add(((List)paramMap.get(FUserId)).toArray());
                    paramMap.remove(FUserId);
                }
                EasXtSyncUtil.executeBatch(this.ctx, updateSql, updateParams);
                String insertSql = "INSERT INTO T_DD_PART (FID,FOrgIds,FUserId,FJobTitle) VALUES (?,?,?,?)";
                Set insertUserIdSet = paramMap.keySet();
                ArrayList<Object[]> updateParams1 = new ArrayList<Object[]>();
                for (String uId : insertUserIdSet) {
                    ArrayList<String> updateParam = new ArrayList<String>();
                    updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                    updateParam.addAll((Collection)paramMap.get(uId));
                    updateParam.add(null);
                    updateParams1.add(updateParam.toArray());
                }
                EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams1);
                logger.error((Object)(" updatePartJob2DingDing detail is " + ArrayUtils.toString(updateParams1)));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void deleteMapPartJob() throws BOSException {
        String sql = DDSyncConfigUtil.getInstance().getValue("deleteNotExistPartJob");
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    private void updatePartJobInfo() throws BOSException {
        HashMap<String, PartInfo> partMap = new HashMap<String, PartInfo>();
        String sql = DDSyncConfigUtil.getInstance().getValue("selectPersonPartJob");
        try {
            IRowSet rs = EasXtSyncUtil.executeQuery(this.ctx, sql);
            while (rs.next()) {
                String personId = rs.getString("FPersonId");
                String DDId = rs.getString("FXTId");
                PartInfo info = (PartInfo)partMap.get(personId);
                if (info == null) {
                    info = new PartInfo(personId, DDId);
                    partMap.put(personId, info);
                }
                info.addEasOrgId(rs.getString("FEasOrgId"));
                info.addDDOrgId(rs.getString("FDDOrgId"));
                info.addJobTitle(rs.getString("FJobTitle"));
            }
            Set personIdSet = partMap.keySet();
            if (personIdSet.size() < 1) {
                return;
            }
            String truncateSql = "truncate table T_PM_EASDDPARTMAP";
            EasXtSyncUtil.execute(this.ctx, truncateSql);
            String insertSql = "INSERT INTO T_PM_EASDDPARTMAP (FID,FPERSONID,FEASORGIDS,FDDORGIDS,FDDID,FJOBTITLES ) VALUES (?,?,?,?,?,?)";
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            for (String pid : personIdSet) {
                ArrayList<String> updateParam = new ArrayList<String>();
                PartInfo pi = (PartInfo)partMap.get(pid);
                updateParam.add(BOSUuid.create((String)"F4AF4F04").toString());
                updateParam.add(pi.personId);
                updateParam.add(pi.easOrgIds.toString());
                updateParam.add(pi.DDOrgIds.toString().replace(" ", ""));
                updateParam.add(pi.DDId);
                updateParam.add(pi.jobTitle.toString());
                updateParams.add(updateParam.toArray());
            }
            EasXtSyncUtil.executeBatch(this.ctx, insertSql, updateParams);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    class PartInfo {
        String personId;
        String DDId;
        List<String> easOrgIds;
        List<String> DDOrgIds;
        List<String> jobTitle;

        PartInfo(String personId, String DDId) {
            this.personId = personId;
            this.DDId = DDId;
            this.easOrgIds = new ArrayList<String>();
            this.DDOrgIds = new ArrayList<String>();
            this.jobTitle = new ArrayList<String>();
        }

        public void addEasOrgId(String easOrgId) {
            if (!this.easOrgIds.contains(easOrgId)) {
                this.easOrgIds.add(easOrgId);
            }
        }

        public void addDDOrgId(String DDOrgId) {
            if (!this.DDOrgIds.contains(DDOrgId)) {
                this.DDOrgIds.add(DDOrgId);
            }
        }

        public void addJobTitle(String jobTitle) {
            this.jobTitle.add(jobTitle);
        }
    }
}

