/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.trdsync.wlsync.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.xtsync.trdsync.SyncItemType;
import com.kingdee.eas.base.xtsync.trdsync.basesync.SyncContext;
import com.kingdee.eas.base.xtsync.trdsync.basesync.imp.SyncDeptBaseService;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncBaseUtil;
import com.kingdee.eas.base.xtsync.trdsync.basesync.util.SyncLogUtils;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLHttpSendUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncConfigUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncHelper;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncURLUtil;
import com.kingdee.eas.base.xtsync.trdsync.wlsync.util.WLSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WLSyncDeptService
extends SyncDeptBaseService {
    private static Logger logger = Logger.getLogger(WLSyncDeptService.class);

    public WLSyncDeptService(SyncContext ctx) {
        super(ctx);
    }

    @Override
    public String beforeSync() throws BOSException, EASBizException {
        super.beforeSync();
        String sql = WLSyncConfigUtil.getInstance().getValue("updateOrgNameEn");
        EasXtSyncUtil.execute(this.ctx, sql);
        Map<String, String> orgInfo = WLSyncUtil.getRootOrgInfo(this.ctx);
        if (orgInfo != null) {
            EasXtSyncUtil.execute(this.ctx, "UPDATE T_PM_EASWLORGMAP SET FORGLONGNAME = '\\' WHERE FEASORGID = '" + orgInfo.get("orgId") + "'");
        }
        return "true";
    }

    @Override
    protected void bindOrgByOrgLongName() throws BOSException {
        Map<String, String> orgInfo = WLSyncUtil.getRootOrgInfo(this.ctx);
        if (orgInfo != null) {
            String sql = WLSyncConfigUtil.getInstance().getValue("bindOrgByOrgLongName");
            if ("Kingbase".equals((String)this.ctx.get((Object)"dbType"))) {
                sql = "/*dialect*/" + sql;
            }
            Pattern p = Pattern.compile("\\{0\\}");
            Matcher m = p.matcher(sql);
            sql = m.replaceAll(orgInfo.get("orgName").length() + 1 + "");
            EasXtSyncUtil.execute(this.ctx, sql);
        } else {
            super.bindOrgByOrgLongName();
        }
    }

    @Override
    protected void insertNewOrgToMap() throws BOSException {
        String sql = WLSyncConfigUtil.getInstance().getValue("insertNewOrgToMap");
        Map<String, String> orgInfo = WLSyncUtil.getRootOrgInfo(this.ctx);
        if (orgInfo != null) {
            String orgLongNumber = orgInfo.get("orgLongNumber");
            sql = sql + " AND org.FLONGNUMBER LIKE '" + orgLongNumber + "%'";
        }
        EasXtSyncUtil.execute(this.ctx, sql);
    }

    @Override
    protected void getAllOrg() throws BOSException {
        int pageNo = 1;
        JSONArray allDeptArray = new JSONArray();
        JSONObject getDeptDetailUrl = JSONObject.parseObject((String)WLSyncURLUtil.getSyncUrl(this.ctx, "/api/tenant/v1/tenants"));
        try {
            JSONObject response = WLHttpSendUtil.startGet(getDeptDetailUrl.getString("url") + "?deptCode=0", null, getDeptDetailUrl.getString("token"), WLSyncHelper.getHWConfig(this.ctx));
            if (!"0".equals(response.getString("code"))) {
                logger.error((Object)response.toString());
                throw new BOSException(response.getString("message"));
            }
            JSONObject rootDeptData = response.getJSONObject("data");
            JSONObject rootDept = new JSONObject();
            rootDept.put("deptCode", (Object)0);
            rootDept.put("deptNameCn", (Object)rootDeptData.getString("companyNameEn"));
            rootDept.put("deptNameEn", (Object)rootDeptData.getString("companyNameCn"));
            allDeptArray.add((Object)rootDept);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        try {
            JSONObject response;
            do {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("deptCode", "0");
                paramMap.put("recursiveflag", "0");
                paramMap.put("pageNo", pageNo++ + "");
                paramMap.put("pageSize", "50");
                String url = this.getSyncURL(SyncItemType.GetAllOrg.getName());
                JSONObject url0 = JSONObject.parseObject((String)url);
                response = WLHttpSendUtil.startGet(url0.getString("url"), paramMap, url0.getString("token"), url0.getJSONObject("hwConfig"));
                if (!"0".equals(response.getString("code"))) {
                    logger.error((Object)response.toString());
                    throw new BOSException(response.getString("message"));
                }
                JSONArray deptArray = response.getJSONArray("data");
                if (deptArray.size() <= 0) continue;
                for (int i = 0; i < deptArray.size(); ++i) {
                    JSONObject parentDept = deptArray.getJSONObject(i);
                    allDeptArray.add((Object)parentDept);
                    this.getAllChildDept(parentDept, allDeptArray);
                }
            } while (!"1".equals(response.getString("hasMore")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        String sql = "truncate table " + this.syncCtx.getSyncTableName();
        EasXtSyncUtil.execute(this.ctx, sql);
        this.insertIntoSyncOrgTable(allDeptArray);
        Map config = new WLSyncHelper(this.ctx).getConfig();
        if ("1".equals(config.get("UpdateDepartmentPerson").toString())) {
            this.initWLDeptLeader(allDeptArray);
        }
    }

    private void getAllChildDept(JSONObject parentDept, JSONArray allDeptArray) throws BOSException, IOException {
        JSONObject response;
        int pageNo = 1;
        do {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("deptCode", parentDept.getString("deptCode"));
            paramMap.put("recursiveflag", "1");
            paramMap.put("pageNo", pageNo++ + "");
            paramMap.put("pageSize", "50");
            String url = this.getSyncURL(SyncItemType.GetAllOrg.getName());
            JSONObject url0 = JSONObject.parseObject((String)url);
            response = WLHttpSendUtil.startGet(url0.getString("url"), paramMap, url0.getString("token"), url0.getJSONObject("hwConfig"));
            if (!"0".equals(response.getString("code"))) {
                logger.error((Object)response.toString());
                throw new BOSException(response.getString("message"));
            }
            JSONArray deptArray = response.getJSONArray("data");
            if (deptArray.size() <= 0) continue;
            allDeptArray.addAll((Collection)deptArray);
        } while (!"1".equals(response.getString("hasMore")));
    }

    @Override
    protected void insertIntoSyncOrgTable(JSONArray totalArray) throws BOSException {
        ArrayList<String> ids = new ArrayList<String>();
        JSONArray totalArray0 = (JSONArray)totalArray.clone();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        HashMap<String, String> orgLongNameMap = new HashMap<String, String>();
        ArrayList<String> parentIds = new ArrayList<String>();
        parentIds.add(((JSONObject)totalArray0.get(0)).getString("deptCode"));
        JSONArray orderOrgArray = new JSONArray();
        orderOrgArray.add(totalArray0.get(0));
        totalArray0.remove(0);
        this.orderOrg(parentIds, orderOrgArray, totalArray0, 0);
        for (int i = 0; i < orderOrgArray.size(); ++i) {
            JSONObject json = orderOrgArray.getJSONObject(i);
            logger.debug((Object)("WeLink\u90e8\u95e8\u4fe1\u606f\u4e3a:" + json.toJSONString()));
            String id = json.getString("deptCode");
            if (ids.contains(id)) continue;
            ids.add(id);
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(id);
            param.add(json.getString("corpDeptCode"));
            String orgName = json.getString("deptNameCn");
            String parentId = json.getString("parentCode");
            if ("0".equals(parentId)) {
                param.add(orgName);
                orgLongNameMap.put(id, orgName);
            } else if (StringUtils.isEmpty((String)parentId)) {
                param.add("\\");
                orgLongNameMap.put(id, orgName);
            } else {
                String parentLongName;
                String string = parentLongName = orgLongNameMap.get(parentId) == null ? null : ((String)orgLongNameMap.get(parentId)).toString();
                if (StringUtils.isEmpty(parentLongName)) {
                    throw new BOSException(json.getString("deptNameCn") + "\u7684\u4e0a\u7ea7\u4e3a\u7a7a");
                }
                String longName = parentLongName + "\\" + orgName;
                param.add(longName);
                orgLongNameMap.put(id, longName);
            }
            param.add(orgName);
            param.add(json.getString("deptNameEn"));
            param.add(parentId);
            param.add(json.getString("corpParentCode"));
            String weights = json.getString("orderNo");
            if (weights == null || "".equals(weights.trim()) || "null".equalsIgnoreCase(weights)) {
                param.add("0");
            } else {
                param.add(weights);
            }
            params.add(param.toArray());
        }
        String sql = WLSyncConfigUtil.getInstance().getValue("insertIntoSyncOrgTable");
        EasXtSyncUtil.executeBatch(this.ctx, sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String syncDept(SyncContext syncCtx, JSONArray dataArray, String itemType, Map logList) throws BOSException, IOException {
        SyncItemType baseType = SyncBaseUtil.getBaseEnum(itemType);
        String syncType = baseType.getValue();
        JSONArray logArray = new JSONArray();
        JSONObject result = null;
        try {
            JSONObject url0 = JSONObject.parseObject((String)this.getSyncURL(itemType));
            if (baseType != null) {
                if (SyncItemType.DeleteOrg.equals((Object)baseType)) {
                    ArrayList<String> reomveOrgIds = new ArrayList<String>();
                    for (int i = 0; i < dataArray.size(); ++i) {
                        JSONObject dataJSON = dataArray.getJSONObject(i);
                        result = WLHttpSendUtil.startPost(url0.getString("url"), dataJSON, url0.getString("token"), null, url0.getJSONObject("hwConfig"));
                        if (result.getInteger("code") == 0) {
                            reomveOrgIds.add(dataJSON.getString("deptCode"));
                        }
                        result.put("errcode", result.get((Object)"code"));
                        result.put("errmsg", result.get((Object)"message"));
                        logArray.add((Object)result);
                    }
                    this.removeMapOrg(this.ctx, reomveOrgIds);
                } else {
                    for (int i = 0; i < dataArray.size(); ++i) {
                        JSONObject dataJSON = dataArray.getJSONObject(i);
                        if (SyncItemType.AddNewOrg.equals((Object)baseType)) {
                            String sql;
                            IRowSet rs;
                            String parentId = dataJSON.getString("parentCode");
                            String orgLongName = dataJSON.getString("FOrgLongName");
                            if (!"0".equals(parentId) && (rs = EasXtSyncUtil.executeQuery(this.ctx, sql = "SELECT top 1 FWLORGID FROM T_PM_EASWLORGMAP WHERE FEASORGID = '" + parentId + "'")).next()) {
                                dataJSON.put("parentCode", (Object)rs.getString("fwlorgid"));
                            }
                            dataJSON.remove((Object)"FOrgLongName");
                            result = WLHttpSendUtil.startPost(url0.getString("url"), dataJSON, url0.getString("token"), null, url0.getJSONObject("hwConfig"));
                            result.put("errcode", result.get((Object)"code"));
                            result.put("errmsg", result.get((Object)"message"));
                            if ("0".equals(result.get((Object)"code"))) {
                                String wlOrgId = result.getString("deptCode");
                                String insert = "UPDATE T_PM_EASWLORGMAP SET FWLORGID = ?,FWLPARENTID = ? WHERE FORGLONGNAME = ? ";
                                EasXtSyncUtil.execute(this.ctx, insert, new String[]{wlOrgId, dataJSON.getString("parentCode"), orgLongName});
                            }
                            if ("47008".equals(result.get((Object)"code")) && (rs = EasXtSyncUtil.executeQuery(this.ctx, sql = "SELECT FWLORGID,FID FROM T_WL_ORG WHERE FPARENTID = ? AND FNAME = ?", new String[]{parentId, dataJSON.getString("deptNameCn")})).next()) {
                                String wlOrgId = rs.getString("FWLORGID");
                                String insert = "UPDATE T_PM_EASWLORGMAP SET FWLORGID = ?,FWLPARENTID = ? WHERE FORGLONGNAME = ? ";
                                EasXtSyncUtil.execute(this.ctx, insert, new String[]{wlOrgId, dataJSON.getString("parentCode"), orgLongName});
                            }
                        } else {
                            result = WLHttpSendUtil.startPost(url0.getString("url"), dataJSON, url0.getString("token"), null, url0.getJSONObject("hwConfig"));
                            result.put("errcode", result.get((Object)"code"));
                            result.put("errmsg", result.get((Object)"message"));
                        }
                        logArray.add((Object)result);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            SyncLogUtils.syncLog(syncCtx, logList, logArray, syncType);
        }
        return JSONObject.toJSONString((Object)this.getSyncResultCount(syncCtx, syncType));
    }

    private void removeMapOrg(Context ctx, List<String> reomveOrgIds) throws BOSException {
        if (reomveOrgIds.size() < 1) {
            return;
        }
        StringBuilder sql = new StringBuilder("DELETE FROM T_PM_EASWLORGMAP WHERE FWLORGID IN (");
        for (String id : reomveOrgIds) {
            sql.append("'" + id + "',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        EasXtSyncUtil.executeQuery(ctx, sql.toString());
    }

    @Override
    protected String[] getSyncJsonKey(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (baseEnum != null) {
            if (SyncItemType.AddNewOrg.equals((Object)baseEnum)) {
                head = new String[]{"corpDeptCode", "corpParentCode", "parentCode", "deptNameCn", "FOrgLongName"};
                return head;
            }
            if (SyncItemType.DeleteOrg.equals((Object)baseEnum)) {
                head = new String[]{"deptCode"};
                return head;
            }
            if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
                head = new String[]{"deptCode", "deptNameCn"};
                return head;
            }
            if (SyncItemType.MoveOrg.equals((Object)baseEnum)) {
                head = new String[]{"deptCode", "parentCode"};
                return head;
            }
            if (SyncItemType.SetOrgWeights.equals((Object)baseEnum)) {
                head = new String[]{"deptCode", "order"};
                return head;
            }
            return super.getSyncJsonKey(itemType);
        }
        return null;
    }

    @Override
    protected String[] getSyncJsonValue(String itemType) {
        String[] head = null;
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.AddNewOrg.equals((Object)baseEnum)) {
            head = new String[]{"FNumber", "FParentNumber", "FParentCode", "FName", "FORGLONGNAME"};
            return head;
        }
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            head = new String[]{this.syncCtx.getMappingOrgIdColnum(), "FName"};
            return head;
        }
        return super.getSyncJsonValue(itemType);
    }

    @Override
    protected String getAddNewOrgSql() throws BOSException {
        return WLSyncConfigUtil.getInstance().getValue("selectAddNewOrgInfo");
    }

    @Override
    protected String getUpdateOrgSql(String itemType) throws BOSException {
        SyncItemType baseEnum = SyncBaseUtil.getBaseEnum(itemType);
        if (SyncItemType.UpdateOrgName.equals((Object)baseEnum)) {
            return WLSyncConfigUtil.getInstance().getValue("selectUpdateOrgName");
        }
        return super.getUpdateOrgSql(itemType);
    }

    @Override
    protected String getSyncURL(String itemType) throws BOSException {
        SyncItemType type = SyncBaseUtil.getBaseEnum(itemType);
        String url = null;
        if (type != null) {
            if (SyncItemType.AddNewOrg.equals((Object)type)) {
                url = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/department/create");
                return url;
            }
            if (SyncItemType.GetAllOrg.equals((Object)type)) {
                url = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/department/list");
                return url;
            }
            if (SyncItemType.DeleteOrg.equals((Object)type)) {
                url = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/department/delete");
            }
            if (SyncItemType.MoveOrg.equals((Object)type) || SyncItemType.UpdateOrgName.equals((Object)type) || SyncItemType.SetOrgWeights.equals((Object)type)) {
                url = WLSyncURLUtil.getSyncUrl(this.ctx, "/api/contact/v1/department/update");
                return url;
            }
        }
        return url;
    }

    private void orderOrg(List<String> parentIds, JSONArray orderOrgArray, JSONArray totalArray, int count) throws BOSException {
        if (totalArray.size() == 0) {
            return;
        }
        if (count > 10) {
            logger.error((Object)("\u5269\u4f59\u7ec4\u7ec7\u6570\u636e\u4e3a:" + totalArray.toJSONString()));
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject o = totalArray.getJSONObject(i);
            String parentId = o.getString("parentCode");
            if (!parentIds.contains(parentId)) continue;
            list.add(o.getString("deptCode"));
            orderOrgArray.add((Object)o);
            totalArray.remove(i);
            --i;
        }
        this.orderOrg(list, orderOrgArray, totalArray, ++count);
    }

    private void initWLDeptLeader(JSONArray allDeptArray) throws BOSException {
        if (allDeptArray.size() < 1) {
            return;
        }
        ArrayList<Object[]> insertParams = new ArrayList<Object[]>();
        for (int i = 0; i < allDeptArray.size(); ++i) {
            JSONObject deptInfo = allDeptArray.getJSONObject(i);
            JSONArray managers = deptInfo.getJSONArray("managerId");
            if (managers == null || managers.size() < 1) continue;
            ArrayList<String> param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(deptInfo.getString("deptCode"));
            Collections.sort((List)managers);
            param.add(managers.toString());
            JSONArray easPersonNumbers = deptInfo.getJSONArray("corpManagerId");
            param.add(easPersonNumbers.toString());
            insertParams.add(param.toArray());
        }
        String sql = "truncate table T_WL_ORGLEADER";
        EasXtSyncUtil.execute(this.ctx, sql);
        String insertSql = "INSERT INTO T_WL_ORGLEADER (FID,FWLOrgId,FUserIds,FEasPersonNumbers) VALUES (?,?,?,?)";
        EasXtSyncUtil.executeBatch(this.ctx, insertSql, insertParams);
    }

    private void initAccessSleepTime(Context ctx) {
        String sql = "SELECT TOP 1 FSLEEPTIME FROM T_WL_ACCESSSLEEPTIME";
        try {
            IRowSet rs = EasXtSyncUtil.executeQuery(ctx, sql);
            if (rs.next()) {
                int time = rs.getInt("FSleepTime");
                WLHttpSendUtil.setSleep(time);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

