/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.base.xtsync.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.xtsync.EasXtException;
import com.kingdee.eas.base.xtsync.EasXtSyncItemType;
import com.kingdee.eas.base.xtsync.EasXtSyncType;
import com.kingdee.eas.base.xtsync.web.ExceptionLogInfo;
import com.kingdee.eas.base.xtsync.web.ExceptionLogService;
import com.kingdee.eas.base.xtsync.web.IEasXtSync;
import com.kingdee.eas.base.xtsync.xtutil.EasXtCommonUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncLogUtils;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.EasXtViewDataUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AbstractEasXtSyncService
implements IEasXtSync {
    protected static Logger logger = Logger.getLogger((String)"com.kingdee.eas.base.xtsync.web.AbstractEasXtSyncService");

    @Override
    public String beforeSync(EasXtSyncType syncType) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String sync(EasXtSyncItemType itemType) throws BOSException, EASBizException, EASBizException {
        return null;
    }

    @Override
    public String afterSync(EasXtSyncType syncType) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String checkForUpdate(Context ctx, EasXtSyncType syncType) throws BOSException, EASBizException {
        logger.error((Object)"*******1 \tAbstractEasXtSyncService checkForUpdate \u5728\u68c0\u67e5\u4e4b\u524d\u6e05\u9664\u5f02\u5e38\u5197\u4f59\u6570\u636e\uff0c\u662feas\u548c\u4e91\u4e4b\u5bb6\u5747\u6ca1\u6709\u7684\u6570\u636e ******** ");
        long time1 = System.currentTimeMillis();
        this.updateUserStatus(ctx);
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 \tAbstractEasXtSyncService \u66f4\u65b0\u7528\u6237\u72b6\u6001 ,updateUserStatus(ctx) \u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        this.updateUserMapByPersonNotInServ(ctx);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******3 \tAbstractEasXtSyncService \u66f4\u65b0\u79bb\u804c\u4eba\u5458 ,updateUserMapByPersonNotInServ(ctx) \u8017\u65f6\uff1a" + (time3 - time2) + "\u6beb\u79d2"));
        this.fillUserId(ctx);
        long time4 = System.currentTimeMillis();
        logger.error((Object)("*******4 \tAbstractEasXtSyncService \u8865\u5145\u7528\u6237\u4fe1\u606f ,fillUserId(ctx) \u8017\u65f6\uff1a" + (time4 - time3) + "\u6beb\u79d2"));
        this.updateUserInfo(ctx);
        long time5 = System.currentTimeMillis();
        logger.error((Object)("*******5\tAbstractEasXtSyncService\u66f4\u65b0\u804c\u5458\u57fa\u672c\u4fe1\u606f,updateUserInfo(ctx) \u8017\u65f6\uff1a" + (time5 - time4) + "\u6beb\u79d2"));
        this.insertNewPersonToMap(ctx);
        long time6 = System.currentTimeMillis();
        logger.error((Object)("*******6 \tAbstractEasXtSyncService \u65b0\u589e\u804c\u5458\u540c\u6b65T_PM_EASXTUSERMAP ,insertNewPersonToMap(ctx) \u8017\u65f6\uff1a" + (time6 - time5) + "\u6beb\u79d2"));
        this.setDefaultNull(ctx);
        long time7 = System.currentTimeMillis();
        logger.error((Object)("*******7 \tAbstractEasXtSyncService \u68c0\u67e5\u5b8c\u6210\u540e,\u8bbe\u7f6et_pm_easxtusermap\u4e2d''\u7684\u5b57\u6bb5\u4e3anull ,setDefaultNull(ctx) \u8017\u65f6\uff1a" + (time7 - time6) + "\u6beb\u79d2"));
        this.updateSynchStatus(ctx);
        long time8 = System.currentTimeMillis();
        logger.error((Object)("*******8 \tAbstractEasXtSyncService \u66f4\u65b0\u662f\u5426\u53ef\u540c\u6b65\u5b57\u6bb5,updateSynchStatus(ctx) \u8017\u65f6\uff1a" + (time8 - time7) + "\u6beb\u79d2"));
        this.updateXtUser(ctx, syncType);
        long time9 = System.currentTimeMillis();
        logger.error((Object)("*******9\tAbstractEasXtSyncService \u4ece\u8baf\u901a\u62c9\u6570\u636e\u5230T_XT_USER,updateXtUser(ctx, syncType) \u8017\u65f6\uff1a" + (time9 - time8) + "\u6beb\u79d2"));
        this.updateOrgLongName(ctx);
        long time10 = System.currentTimeMillis();
        logger.error((Object)("*******10\tAbstractEasXtSyncService \u66f4\u65b0\u7ec4\u7ec7\u957f\u540d\u79f0,updateOrgLongName(ctx) \u8017\u65f6\uff1a" + (time10 - time9) + "\u6beb\u79d2"));
        this.updateOrgName(ctx);
        long time11 = System.currentTimeMillis();
        logger.error((Object)("*******11\tAbstractEasXtSyncService \u66f4\u65b0\u7ec4\u7ec7\u540d\u79f0,updateOrgName(ctx) \u8017\u65f6\uff1a" + (time11 - time10) + "\u6beb\u79d2"));
        this.updateOrgStatus(ctx);
        long time12 = System.currentTimeMillis();
        logger.error((Object)("*******12\tAbstractEasXtSyncService \u66f4\u65b0\u7ec4\u7ec7\u5c01\u5b58\u72b6\u6001\uff0c\u540c\u6b65\u65f6\u5220\u9664,updateOrgStatus(ctx) \u8017\u65f6\uff1a" + (time12 - time11) + "\u6beb\u79d2"));
        this.updateOrgParentId(ctx);
        long time13 = System.currentTimeMillis();
        logger.error((Object)("*******13\tAbstractEasXtSyncService \u66f4\u65b0\u7ec4\u7ec7\u4e0a\u7ea7id\u7528\u4e0e\u7ec4\u7ec7\u632a\u52a8,updateOrgParentId(ctx) \u8017\u65f6\uff1a" + (time13 - time12) + "\u6beb\u79d2"));
        this.insertNewOrgToMap(ctx);
        long time14 = System.currentTimeMillis();
        logger.error((Object)("*******14\tAbstractEasXtSyncService \u65b0\u589e\u7ec4\u7ec7\u5230orgmap\u8868,insertNewOrgToMap(ctx) \u8017\u65f6\uff1a" + (time14 - time13) + "\u6beb\u79d2"));
        this.updateXtOrgNew(ctx);
        long time15 = System.currentTimeMillis();
        logger.error((Object)("*******15\tAbstractEasXtSyncService \u4ece\u8baf\u901a\u62c9\u6570\u636e\u5230T_XT_ORG,updateXtOrg(ctx) \u8017\u65f6\uff1a" + (time15 - time14) + "\u6beb\u79d2"));
        this.bindByNameAndCell(ctx);
        long time16 = System.currentTimeMillis();
        logger.error((Object)("*******16\tAbstractEasXtSyncService \u6309\u59d3\u540d\u7535\u8bdd\u7ed1\u5b9a,bindByNameAndCell(ctx) \u8017\u65f6\uff1a" + (time16 - time15) + "\u6beb\u79d2"));
        this.bindByNameAndMail(ctx);
        long time17 = System.currentTimeMillis();
        logger.error((Object)("*******17\tAbstractEasXtSyncService \u6309\u59d3\u540d\u90ae\u7bb1\u7ed1\u5b9a,bindByNameAndMail(ctx) \u8017\u65f6\uff1a" + (time17 - time16) + "\u6beb\u79d2"));
        this.bindOrgByOrgLongName(ctx);
        long time18 = System.currentTimeMillis();
        logger.error((Object)("*******18\tAbstractEasXtSyncService \u6309\u7ec4\u7ec7\u957f\u540d\u79f0\u7ed1\u5b9a\u7ec4\u7ec7,bindOrgByOrgLongName(ctx) \u8017\u65f6\uff1a" + (time18 - time17) + "\u6beb\u79d2"));
        Map xtConfig = null;
        try {
            xtConfig = this._getXtConfig(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (null != xtConfig) {
            if ("1".equals(xtConfig.get("isUpdateDepartmentPerson"))) {
                this.updateOrgLeaderToMap(ctx);
                this.updateXtOrgLeader(ctx);
            }
            if ("1".equals(xtConfig.get("isUpdatePluralityMsg"))) {
                this.updatePartJobInfo(ctx);
                this.updateXtPartJob(ctx);
            }
            if ("1".equals(xtConfig.get("isUpdateSuperiorsMsg"))) {
                this.updateRelationsInfo(ctx);
                this.updateXtRelations(ctx);
            }
            if ("1".equals(xtConfig.get("isAutoUpdateCell"))) {
                EasXtViewDataUtil.bindUpdateCellToMap(ctx, null, null);
            }
        }
        long time19 = System.currentTimeMillis();
        logger.error((Object)("*******19\tAbstractEasXtSyncService checkForUpdate \u603b\u8017\u65f6\uff1a" + (time19 - time1) + "\u6beb\u79d2"));
        return null;
    }

    @Override
    public boolean init(Context ctx) throws BOSException, EASBizException {
        long time1 = System.currentTimeMillis();
        logger.error((Object)"*******1\tAbstractEasXtSyncService init *****");
        this.insertNewPersonToMap(ctx);
        this.updateUserStatus(ctx);
        this.updateUserMapByPersonNotInServ(ctx);
        this.updateUserInfo(ctx);
        this.fillUserId(ctx);
        this.setDefaultNull(ctx);
        this.updateSynchStatus(ctx);
        this.insertNewOrgToMap(ctx);
        this.updateOrgLongName(ctx);
        this.updateOrgName(ctx);
        this.updateOrgStatus(ctx);
        this.updateOrgParentId(ctx);
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******19\tAbstractEasXtSyncService init \u603b\u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        return true;
    }

    protected void bindByNameAndMail(Context ctx) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("bindByNameAndMail");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void bindByNameAndCell(Context ctx) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("bindByNameAndCell");
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void bindOrgByOrgLongName(Context ctx) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("bindOrgByOrgLongName");
        if ("Kingbase".equals((String)ctx.get((Object)"dbType"))) {
            sql = "/*dialect*/" + sql;
        }
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected Map _getXtConfig(Context ctx) throws BOSException, EASBizException {
        return EasXtSyncUtil.getInstance(ctx).getXtConfig(ctx);
    }

    protected boolean isItemUpdate(Context ctx, String updateItem) throws BOSException {
        if (StringUtils.isEmpty((String)updateItem)) {
            return false;
        }
        Map xtConfig = null;
        try {
            xtConfig = this._getXtConfig(ctx);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        if (null != xtConfig) {
            return "1".equals(xtConfig.get(updateItem));
        }
        return false;
    }

    protected JSONObject getSyncResultCount(Context ctx, EasXtSyncItemType itemType) throws BOSException {
        String syncTimeId = EasXtSyncLogUtils.getLastSyncTimeId(ctx);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("succCount", (Object)EasXtSyncLogUtils.getSyncLogCount(ctx, itemType, null, syncTimeId, true));
        jsonObject.put("failCount", (Object)EasXtSyncLogUtils.getSyncLogCount(ctx, itemType, null, syncTimeId, false));
        jsonObject.put("syncTimeId", (Object)syncTimeId);
        return jsonObject;
    }

    protected void updateUserStatus(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = easXtSyncUtil.getValue("updateUserStatus");
        logger.error((Object)("*****updateUserStatus***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserStatus cost***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserStatus2");
        logger.error((Object)("*****updateUserStatus2**" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserStatus2 cost***" + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateReNomalUserMap");
        logger.error((Object)("*****updateReNomalUserMap**" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateReNomalUserMap cost***" + (System.currentTimeMillis() - t3)));
    }

    protected void updateUserMapByPersonNotInServ(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("updateDeletedUserMap");
        logger.error((Object)("*****updateDeletedUserMap***" + sql));
        logger.error((Object)("sql: " + sql));
        if (!StringUtils.isEmpty((String)sql)) {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        logger.error((Object)("*****updateDeletedUserMap cost***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance(ctx).getValue("updateDeletedPUMap");
        logger.error((Object)("*****updateDeletedPUMap***" + sql));
        logger.error((Object)("sql: " + sql));
        if (!StringUtils.isEmpty((String)sql)) {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        logger.error((Object)("*****updateDeletedPUMap cost***" + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance(ctx).getValue("updateDeletedPerson");
        logger.error((Object)("*****updateDeletedPerson***" + sql));
        logger.error((Object)(" updateDeletedPerson sql: " + sql));
        if (!StringUtils.isEmpty((String)sql)) {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        logger.error((Object)("*****updateDeletedPerson cost***" + (System.currentTimeMillis() - t3)));
    }

    protected void updateUserInfo(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        Map xtConfig = easXtSyncUtil.getXtConfig(ctx);
        String sql = easXtSyncUtil.getValue("insertWhenNewUser");
        logger.error((Object)("*****insertWhenNewUser***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertWhenNewUser cost ***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateWhenNewUser");
        logger.error((Object)("*****updateWhenNewUser***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateWhenNewUser cost ***" + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserCell");
        logger.error((Object)("*****updateUserCell***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserCell cost ***" + (System.currentTimeMillis() - t3)));
        long t4 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateNoUserCell");
        logger.error((Object)("*****updateNoUserCell***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateNoUserCell cost ***" + (System.currentTimeMillis() - t4)));
        long t5 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserEmail");
        logger.error((Object)("*****updateUserEmail***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserEmail cost ***" + (System.currentTimeMillis() - t5)));
        long t6 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateNoUserEmail");
        logger.error((Object)("*****updateNoUserEmail***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateNoUserEmail cost ***" + (System.currentTimeMillis() - t6)));
        long t7 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserPosition");
        logger.error((Object)("*****updateUserPosition***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserPosition cost ***" + (System.currentTimeMillis() - t7)));
        long t8 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserOrg");
        logger.error((Object)("*****updateUserOrg***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserOrg cost ***" + (System.currentTimeMillis() - t8)));
        long t9 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateNoUserName");
        logger.error((Object)("*****updateNoUserName***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateNoUserName cost ***" + (System.currentTimeMillis() - t9)));
        long t10 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserName");
        logger.error((Object)("*****updateUserName***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserName cost ***" + (System.currentTimeMillis() - t10)));
        long t11 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updatePCellWhenUCellNull");
        logger.error((Object)("*****updatePCellWhenUCellNull***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updatePCellWhenUCellNull cost ***" + (System.currentTimeMillis() - t11)));
        long t12 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updatePersonNumber");
        logger.error((Object)("*****updatePersonNumber***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updatePersonNumber cost ***" + (System.currentTimeMillis() - t12)));
        long t13 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserPersonNumber");
        logger.error((Object)("*****updateUserPersonNumber***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserPersonNumber cost ***" + (System.currentTimeMillis() - t13)));
        long t14 = System.currentTimeMillis();
        String dbType = (String)ctx.get((Object)"dbType");
        String valueKey = "";
        if ("1".equals(xtConfig.get("isUpdatePersonWeights"))) {
            if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
                valueKey = "updatePersonWeights_Oracle";
            } else if ("MS SQL Server".equals(dbType)) {
                valueKey = "updatePersonWeights_sqlServer";
            } else if ("DB2 UDB".equals(dbType)) {
                valueKey = "updatePersonWeights_DB2";
            } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
                valueKey = "updatePersonWeights_PG";
            }
            if (!StringUtils.isEmpty((String)valueKey)) {
                logger.error((Object)("*****updatePersonWeights***dbType=" + dbType + ";valueKey=" + valueKey));
                sql = EasXtSyncUtil.getInstance(ctx).getValue(valueKey);
                sql = "/*dialect*/" + sql;
                logger.error((Object)("*****updatePersonWeights***" + sql));
                this.updatePersonWeights(ctx, sql);
                logger.error((Object)("*****updatePersonWeights cost ***" + (System.currentTimeMillis() - t14)));
            }
        }
        long t15 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance(ctx).getValue("updatePEmailWhenUEmailNull");
        logger.error((Object)("*****updatePEmailWhenUEmailNull***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updatePEmailWhenUEmailNull cost ***" + (System.currentTimeMillis() - t15)));
        long t16 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updateUserNumber");
        logger.error((Object)("*****updateUserNumber***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateUserNumber cost ***" + (System.currentTimeMillis() - t16)));
        long t17 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("updatePersonHireDate");
        logger.error((Object)("*****updatePersonHireDate***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updatePersonHireDate cost ***" + (System.currentTimeMillis() - t17)));
    }

    private void updatePersonWeights(Context ctx, String sql) throws BOSException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = new ArrayList<String>();
        String updateSql = "update t_pm_easxtusermap set fweights = ? where fpersonid = ?";
        try {
            while (rs.next()) {
                param = new ArrayList();
                param.add(rs.getString("sortCode"));
                param.add(rs.getString("pid"));
                params.add(param.toArray());
                if (params.size() <= 999) continue;
                DbUtil.executeBatch((Context)ctx, (String)updateSql, params);
                params = new ArrayList();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)"****updatePersonWeights****error SQLException");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"****updatePersonWeights****error OtherException");
        }
        if (params.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSql, params);
            params = null;
        }
    }

    protected void fillUserId(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("fillUserId");
        logger.error((Object)("*****fillUserId***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****fillUserId cost***" + (System.currentTimeMillis() - t1)));
    }

    protected void insertNewPersonToMap(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertNewPersonToMap");
        logger.error((Object)("*****insertNewPersonToMap******" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertNewPersonToMap cost ******" + (System.currentTimeMillis() - t1)));
    }

    protected void insertNoSyncPerson(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertNoSyncPerson");
        logger.error((Object)("*****insertNoSyncPerson******" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertNoSyncPerson cost ******" + (System.currentTimeMillis() - t1)));
    }

    protected void insertNoSyncPersonByPosition(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertNoSyncPersonByPosition");
        logger.error((Object)("*****insertNoSyncPerson******" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertNoSyncPerson cost ******" + (System.currentTimeMillis() - t1)));
    }

    protected void syncIsExistsUser(Context ctx) throws BOSException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        Map xtConfig = easXtSyncUtil.getXtConfig(ctx);
        if ("1".equals(xtConfig.get("isExistsUser"))) {
            long t1 = System.currentTimeMillis();
            String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertNoUserPerson");
            logger.error((Object)("*****insertNoSyncPerson******" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            logger.error((Object)("*****insertNoSyncPerson cost ******" + (System.currentTimeMillis() - t1)));
            long t2 = System.currentTimeMillis();
            String sql2 = EasXtSyncUtil.getInstance(ctx).getValue("deleteExistsUserPerson");
            logger.error((Object)("*****deleteExistsUserPerson******" + sql2));
            DbUtil.execute((Context)ctx, (String)sql2);
            logger.error((Object)("*****deleteExistsUserPerson cost ******" + (System.currentTimeMillis() - t2)));
        } else {
            long t1 = System.currentTimeMillis();
            String sql = EasXtSyncUtil.getInstance(ctx).getValue("deleteAllExistsUserPerson");
            logger.error((Object)("*****deleteAllExistsUserPerson******" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    protected void updateSynchStatus(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = easXtSyncUtil.getValue("canSyncWithCellNotNull");
        logger.error((Object)("**canSyncWithCellNotNull***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**canSyncWithCellNotNull cost***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("canSyncWithCellNotRepeat");
        logger.error((Object)("**canSyncWithCellNotRepeat***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**canSyncWithCellNotRepeat cost***" + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("cantSyncWithCellNull");
        logger.error((Object)("**cantSyncWithCellNull***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**cantSyncWithCellNull cost***" + (System.currentTimeMillis() - t3)));
        long t4 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("cantSyncWithCellRepeat");
        logger.error((Object)("**cantSyncWithCellRepeat***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**cantSyncWithCellRepeat cost***" + (System.currentTimeMillis() - t4)));
        long t5 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("cantSyncWithNoInservice");
        logger.error((Object)("**cantSyncWithNoInservice***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("**cantSyncWithNoInservice cost***" + (System.currentTimeMillis() - t5)));
        long t6 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("cantSyncWithCellRepeat4User");
        logger.error((Object)("*****cantSyncWithCellRepeat4User***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****cantSyncWithCellRepeat4User cost ***" + (System.currentTimeMillis() - t6)));
        long t7 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("cantSyncWithEmailRepeat");
        logger.error((Object)("*****cantSyncWithEmailRepeat***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****cantSyncWithEmailRepeat cost ***" + (System.currentTimeMillis() - t7)));
        long t8 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("cantSyncWithEmailRepeat4User");
        logger.error((Object)("*****cantSyncWithEmailRepeat4User***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****cantSyncWithEmailRepeat4User cost ***" + (System.currentTimeMillis() - t8)));
        long t11 = System.currentTimeMillis();
        sql = easXtSyncUtil.getValue("cantSyncSameCellButDiffName");
        logger.error((Object)("*****cantSyncSameCellButDiffName***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****cantSyncSameCellButDiffName cost ***" + (System.currentTimeMillis() - t11)));
    }

    protected void updateXtUser(Context ctx, EasXtSyncType syncType) throws BOSException {
        long time1 = System.currentTimeMillis();
        logger.error((Object)"*******1 AbstractEasXtSyncService updateXtUser*******");
        String lastCheckTime = "1900-01-01 01:01:01";
        if (EasXtSyncType.Incre.equals((Object)syncType)) {
            lastCheckTime = EasXtCommonUtils.getLastCheckTime(ctx);
        }
        int start = 0;
        int length = 1000;
        JSONArray array = new JSONArray();
        JSONArray totalArray = new JSONArray();
        String checkTime = null;
        int count = 1;
        try {
            while (true) {
                long while_time1 = System.currentTimeMillis();
                JSONObject response = XtCommunicateUtil.getInstance(ctx).getDataAfterCheckTime(lastCheckTime, start, length);
                long while_time2 = System.currentTimeMillis();
                logger.error((Object)("******* XtCommunicateUtil.getInstance(ctx).getDataAfterCheckTime(" + lastCheckTime + "," + start + "," + length + ") \u7b2c" + count + "\u6b21\uff1a\u8017\u65f6\uff1a" + (while_time2 - while_time1) + "\u6beb\u79d2"));
                if (!response.getBooleanValue("success")) {
                    System.out.println("***** response.getIntValue(\"errorCode\") ***** :" + response.getIntValue("errorCode"));
                    if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                        throw new EasXtException(EasXtException.OPENCLOUD);
                    }
                    throw new BOSException(response.getString("error"));
                }
                array = response.getJSONArray("data");
                checkTime = (String)response.get((Object)"curTime");
                if (array != null && array.size() >= 1) {
                    logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a" + array.size()));
                    totalArray.addAll((Collection)array);
                    start += length;
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("updateXtUser", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 AbstractEasXtSyncService \u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6\u4e0a\u6b21check\u4e4b\u540e\u6240\u6709\u66f4\u65b0\u6216\u8005\u65b0\u589e\u7684\u7528\u6237: \u8017\u65f6: " + (time2 - time1) + "\u6beb\u79d2"));
        if (EasXtSyncUtil.getInstance(ctx).isFirstCheck(lastCheckTime)) {
            this.clearXtUserDatas(ctx);
            this.insertIntoXtUserTable(ctx, totalArray);
        } else {
            this.clearXtUserDatas(ctx, totalArray);
            this.insertIntoXtUserTable(ctx, totalArray);
        }
        this.insertCheckTime(ctx, checkTime);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******3 AbstractEasXtSyncService updateXtUser \u603b\u8017\u65f6: " + (time3 - time2) + "\u6beb\u79d2"));
    }

    protected void insertIntoXtUserTable(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertIntoXtTable");
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = null;
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Timestamp tmin = new Timestamp(simpleDateFormat.parse("1753-01-01").getTime());
            Timestamp tmax = new Timestamp(simpleDateFormat.parse("9999-12-31").getTime());
            for (int i = 0; i < totalArray.size(); ++i) {
                JSONObject json = totalArray.getJSONObject(i);
                if (StringUtils.isEmpty((String)json.getString("openId")) || StringUtils.isEmpty((String)json.getString("name")) || ids.contains(json.getString("openId"))) continue;
                ids.add(json.getString("openId"));
                param = new ArrayList<Object>();
                param.add(json.getString("openId"));
                param.add(json.getString("name"));
                String phone = json.getString("phone");
                if (phone == null || "".equals(phone.trim()) || "null".equalsIgnoreCase(phone)) {
                    param.add(null);
                } else {
                    param.add(phone);
                }
                String department = json.getString("department");
                if (department == null || "".equals(department.trim()) || "null".equalsIgnoreCase(department)) {
                    param.add(null);
                } else {
                    param.add(department);
                }
                String jobTitle = json.getString("jobTitle");
                if (jobTitle == null || "".equals(jobTitle.trim()) || "null".equalsIgnoreCase(jobTitle)) {
                    param.add(null);
                } else {
                    param.add(jobTitle);
                }
                String email = json.getString("email");
                if (email == null || "".equals(email.trim()) || "null".equalsIgnoreCase(email)) {
                    param.add(null);
                } else {
                    param.add(email);
                }
                param.add(json.getInteger("status"));
                String photoUrl = json.getString("photoUrl");
                if (StringUtils.isEmpty((String)photoUrl)) {
                    param.add(null);
                } else {
                    param.add(photoUrl);
                }
                String phones = json.getString("phones");
                if (StringUtils.isEmpty((String)phones)) {
                    param.add(null);
                } else {
                    param.add(phones);
                }
                String isHidePhone = json.getString("isHidePhone");
                if (StringUtils.isEmpty((String)isHidePhone)) {
                    param.add(null);
                } else {
                    param.add(isHidePhone);
                }
                Integer gender = json.getInteger("gender");
                param.add(gender);
                Integer weights = json.getInteger("weights");
                param.add(weights);
                String jobNo = json.getString("jobNo");
                if (StringUtils.isEmpty((String)jobNo)) {
                    param.add(null);
                } else {
                    param.add(jobNo);
                }
                String birthday = json.getString("birthday");
                if (StringUtils.isEmpty((String)birthday)) {
                    param.add(null);
                } else {
                    try {
                        Timestamp ts1 = new Timestamp(new SimpleDateFormat("yyyy-MM-dd").parse(birthday).getTime());
                        if (ts1.before(tmin) || ts1.after(tmax)) {
                            param.add(null);
                        } else {
                            param.add(ts1);
                        }
                    }
                    catch (ParseException e) {
                        param.add(null);
                        e.printStackTrace();
                    }
                }
                String hireDate = json.getString("hireDate");
                if (StringUtils.isEmpty((String)hireDate)) {
                    param.add(null);
                } else {
                    try {
                        Timestamp ts = new Timestamp(simpleDateFormat.parse(hireDate).getTime());
                        if (ts.before(tmin) || ts.after(tmax)) {
                            param.add(null);
                        } else {
                            param.add(ts);
                        }
                    }
                    catch (ParseException e) {
                        param.add(null);
                        e.printStackTrace();
                    }
                }
                params.add(param.toArray());
            }
        }
        catch (ParseException e1) {
            logger.error((Object)"---------\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u63d2\u5165\u8baf\u901a\u8868\u5931\u8d25----------");
            e1.printStackTrace();
        }
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u8868----------");
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u8868\u6210\u529f----------");
    }

    protected void clearXtUserDatas(Context ctx) throws BOSException {
        String sql = "truncate table t_xt_user";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void clearXtUserDatas(Context ctx, JSONArray totalArray) throws BOSException {
        if (totalArray == null || totalArray.size() == 0) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("openId"))) continue;
            String openId = json.getString("openId");
            ids.add(openId);
            if (ids.size() <= 444) continue;
            this.deleteXtUser(ctx, ids);
            ids = new ArrayList();
        }
        if (ids.size() > 0) {
            this.deleteXtUser(ctx, ids);
            ids = null;
        }
    }

    protected void deleteXtUser(Context ctx, List ids) throws BOSException {
        String sql = "delete from t_xt_user where fid in ";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append("'").append(ids.get(i)).append("',");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        DbUtil.execute((Context)ctx, (String)new StringBuffer(sql).append("(").append(sb).append(")").toString());
    }

    protected void initCheckTime(Context ctx) throws BOSException {
        String sql = "truncate table t_xt_checktime";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void insertCheckTime(Context ctx, String curTime) throws BOSException {
        if (StringUtils.isEmpty((String)curTime)) {
            long time = new Date().getTime();
            Timestamp checktime = new Timestamp(time);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            curTime = formatter.format(checktime);
        }
        String sql = "insert into T_XT_CHECKTIME (fid,fchecktime) select newbosid('F4AF4F04'),{ts'" + curTime + "'}";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void updateOrgStatus(Context ctx) throws BOSException {
        long t2 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("updateOrgStatus");
        logger.error((Object)("*****updateOrgStatus***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateOrgStatus cost ***" + (System.currentTimeMillis() - t2)));
        long t3 = System.currentTimeMillis();
        String dbType = (String)ctx.get((Object)"dbType");
        String valueKey = "";
        if ("Oracle".equals(dbType) || "DM".equals(dbType)) {
            valueKey = "updateOrgWeights_Oracle";
        } else if ("MS SQL Server".equals(dbType)) {
            valueKey = "updateOrgWeights_sqlServer";
        } else if ("DB2 UDB".equals(dbType)) {
            valueKey = "updateOrgWeights_DB2";
        } else if ("PostgresSQL".equals(dbType) || "Kingbase".equals(dbType)) {
            valueKey = "updateOrgWeights_PG";
        }
        if (!StringUtils.isEmpty((String)valueKey)) {
            sql = EasXtSyncUtil.getInstance(ctx).getValue(valueKey);
            sql = "/*dialect*/" + sql;
            logger.error((Object)("*****updateOrgWeights***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            logger.error((Object)("*****updateOrgWeights cost ***" + (System.currentTimeMillis() - t3)));
        }
    }

    protected void updateOrgParentId(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("updateOrgEasParentId");
        logger.error((Object)("*****updateOrgEasParentId***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateOrgEasParentId cost ***" + (System.currentTimeMillis() - t1)));
        long t2 = System.currentTimeMillis();
        sql = EasXtSyncUtil.getInstance(ctx).getValue("updateOrgXtParentId");
        logger.error((Object)("*****updateOrgXtParentId***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateOrgXtParentId cost ***" + (System.currentTimeMillis() - t2)));
    }

    protected void updateOrgLongName(Context ctx) throws BOSException {
        long t2 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("updateOrgLongName");
        logger.error((Object)("*****updateOrgLongName***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateOrgLongName cost ***" + (System.currentTimeMillis() - t2)));
    }

    protected void updateOrgName(Context ctx) throws BOSException {
        long t2 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("updateOrgName");
        logger.error((Object)("*****updateOrgName***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****updateOrgName cost ***" + (System.currentTimeMillis() - t2)));
    }

    protected void insertNewOrgToMap(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertNewOrgToMap");
        logger.error((Object)("*****insertNewOrgToMap***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertNewOrgToMap cost ***" + (System.currentTimeMillis() - t1)));
    }

    protected void insertNoSyncOrg(Context ctx) throws BOSException {
        long t1 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertNoSyncOrg");
        logger.error((Object)("*****insertNoSyncOrg***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertNoSyncOrg cost ***" + (System.currentTimeMillis() - t1)));
    }

    protected void updatePartJobInfo(Context ctx) throws BOSException {
        long t2 = System.currentTimeMillis();
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertPartMap");
        logger.error((Object)("*****insertPartMap***" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
        logger.error((Object)("*****insertPartMap cost ***" + (System.currentTimeMillis() - t2)));
    }

    protected void updateRelationsInfo(Context ctx) throws BOSException {
    }

    protected void updateXtOrg(Context ctx) throws BOSException {
        long time1 = System.currentTimeMillis();
        logger.error((Object)"*******1 AbstractEasXtSyncService updateXtOrg ********");
        JSONArray array = new JSONArray();
        try {
            JSONObject response = XtCommunicateUtil.getInstance(ctx).getAllOrg();
            long try_time1 = System.currentTimeMillis();
            logger.error((Object)("*******1 AbstractEasXtSyncService updateXtOrg XtCommunicateUtil.getInstance(ctx).getAllOrg() \u8017\u65f6:" + (try_time1 - time1) + "\u6beb\u79d2"));
            if (!response.getBooleanValue("success")) {
                if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                    throw new EasXtException(EasXtException.OPENCLOUD);
                }
                throw new BOSException(response.getString("error"));
            }
            array = response.getJSONArray("data");
            if (array != null) {
                logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a " + array.size()));
            }
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("updateXtOrgLeader", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 AbstractEasXtSyncService updateXtOrg ********" + (time2 - time1) + "\u6beb\u79d2"));
        this.clearXtOrgDatas(ctx);
        this.insertIntoXtOrgTable(ctx, array);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******3 AbstractEasXtSyncService updateXtOrg ********" + (time3 - time2) + "\u6beb\u79d2"));
        logger.error((Object)("*******4 AbstractEasXtSyncService updateXtOrg ********" + (time3 - time1) + "\u6beb\u79d2"));
    }

    protected void updateXtOrgNew(Context ctx) throws BOSException {
        long time1 = System.currentTimeMillis();
        logger.error((Object)"*******1 AbstractEasXtSyncService updateXtOrg*******");
        int start = 0;
        int length = 1000;
        JSONArray array = new JSONArray();
        JSONArray totalArray = new JSONArray();
        int count = 1;
        try {
            while (true) {
                long while_time1 = System.currentTimeMillis();
                JSONObject response = XtCommunicateUtil.getInstance(ctx).getAllOrgNew(start, length);
                long while_time2 = System.currentTimeMillis();
                logger.error((Object)("******* XtCommunicateUtil.getInstance(ctx).getAllOrgNew(" + start + "," + length + ") \u7b2c" + count + "\u6b21\uff1a\u8017\u65f6\uff1a" + (while_time2 - while_time1) + "\u6beb\u79d2"));
                if (!response.getBooleanValue("success")) {
                    System.out.println("***** response.getIntValue(\"errorCode\") ***** :" + response.getIntValue("errorCode"));
                    if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                        throw new EasXtException(EasXtException.OPENCLOUD);
                    }
                    throw new BOSException(response.getString("error"));
                }
                array = response.getJSONArray("data");
                if (array != null && array.size() >= 1) {
                    logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a" + array.size()));
                    totalArray.addAll((Collection)array);
                    start += length;
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("updateXtOrg", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("*******2 AbstractEasXtSyncService \u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6\u4e0a\u6b21check\u4e4b\u540e\u6240\u6709\u66f4\u65b0\u6216\u8005\u65b0\u589e\u7684\u7528\u6237: \u8017\u65f6: " + (time2 - time1) + "\u6beb\u79d2"));
        this.clearXtOrgDatas(ctx);
        logger.error((Object)("\u4f20\u53c2\u603b\u91cf\u4e3a" + totalArray.size()));
        this.insertIntoXtOrgTable(ctx, totalArray);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******3 AbstractEasXtSyncService updateXtOrg \u603b\u8017\u65f6: " + (time3 - time2) + "\u6beb\u79d2"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONArray getOrgBySyncTime(Context ctx) {
        String sql = "SELECT TOP 1 FID FROM T_XT_SYNCHTIME ORDER BY FSYNCHTIME DESC";
        IRowSet rs = null;
        IRowSet rs_add = null;
        String syncTime = null;
        JSONObject response = null;
        JSONArray addOrg = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && StringUtils.isEmpty((String)(syncTime = rs.getString("fid")))) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            String sql_add = "SELECT FOLDORGLONGNAME FROM T_XT_SYNCDEPTLOG WHERE  FTYPE = 1 AND FSUCCESS = 1 AND FSYNCTIMEID = '" + syncTime + "'";
            rs_add = DbUtil.executeQuery((Context)ctx, (String)sql_add);
            JSONArray orgLongNumber = new JSONArray();
            while (rs_add.next()) {
                String orgLongname = rs_add.getString("FOLDORGLONGNAME");
                if (StringUtils.isEmpty((String)orgLongname)) continue;
                orgLongNumber.add((Object)orgLongname);
            }
            if (!orgLongNumber.isEmpty()) {
                response = XtCommunicateUtil.getInstance(ctx).getOrgByLongNumber(orgLongNumber);
                if (response.getBoolean("success").booleanValue()) {
                    addOrg = response.getJSONArray("data");
                } else {
                    logger.error((Object)("\u6839\u636e\u957f\u7f16\u7801\u83b7\u53d6\u4e91\u4e4b\u5bb6\u7ec4\u7ec7\u6570\u636e\u5931\u8d25:" + response.toJSONString()));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return addOrg;
    }

    protected void clearXtOrgDatas(Context ctx) throws BOSException {
        String sql = "truncate table t_xt_org";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void insertIntoXtOrgTable(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertIntoXtOrgTable");
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<Object> param = null;
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("id")) || StringUtils.isEmpty((String)json.getString("department")) || ids.contains(json.getString("id"))) continue;
            ids.add(json.getString("id"));
            param = new ArrayList<Object>();
            param.add(json.getString("id"));
            String department = json.getString("department");
            if (department == null || "".equals(department.trim()) || "null".equalsIgnoreCase(department)) {
                param.add(null);
            } else if (StringUtils.isEmpty((String)json.getString("parentId"))) {
                param.add("\\");
            } else {
                param.add(department);
            }
            param.add(json.getString("name"));
            param.add(json.getString("parentId"));
            String weights = json.getString("weights");
            if (weights == null || "".equals(weights.trim()) || "null".equalsIgnoreCase(weights)) {
                param.add(Integer.valueOf("-1"));
            } else {
                param.add(Integer.valueOf(weights));
            }
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u7ec4\u7ec7\u8868----------");
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u7ec4\u7ec7\u8868\u6210\u529f----------");
    }

    protected void updateXtOrgLeader(Context ctx) throws BOSException {
        long time1 = System.currentTimeMillis();
        logger.error((Object)"*******1 AbstractEasXtSyncService updateXtOrgLeader ******");
        int start = 0;
        int length = 1000;
        int count = 1;
        JSONArray array = new JSONArray();
        JSONArray totalArray = new JSONArray();
        String checkTime = null;
        try {
            while (true) {
                long while_time1 = System.currentTimeMillis();
                JSONObject response = XtCommunicateUtil.getInstance(ctx).getAllOrgLeader(start, length);
                long while_time2 = System.currentTimeMillis();
                logger.error((Object)("*******XtCommunicateUtil.getInstance(ctx).getAllOrgLeader(" + start + "," + length + ") \u7b2c" + count + "\u6b21 \u8017\u65f6\uff1a" + (while_time2 - while_time1) + "\u6beb\u79d2"));
                if (!response.getBooleanValue("success")) {
                    if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                        throw new EasXtException(EasXtException.OPENCLOUD);
                    }
                    throw new BOSException(response.getString("error"));
                }
                array = response.getJSONArray("data");
                checkTime = (String)response.get((Object)"curTime");
                if (array != null && array.size() >= 1) {
                    logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a" + array.size()));
                    totalArray.addAll((Collection)array);
                    start += length;
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("updateXtOrgLeader", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("******* \u4ece\u4e91\u4e4b\u5bb6\u83b7\u53d6\u4e0a\u6b21check\u4e4b\u540e\u6240\u6709\u66f4\u65b0\u6216\u8005\u65b0\u589e\u90e8\u95e8\u8d1f\u8d23\u4eba,updateXtOrgLeader  \u8017\u65f6\uff1a" + (time2 - time1) + "\u6beb\u79d2"));
        this.clearXtOrgLeaderDatas(ctx, totalArray);
        this.insertIntoXtOrgLeaderTable(ctx, totalArray);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("*******2 AbstractEasXtSyncService ******  \u8017\u65f6\uff1a" + (time3 - time2) + "\u6beb\u79d2"));
        logger.error((Object)("*******3 AbstractEasXtSyncService updateXtOrgLeade  \u8017\u65f6\uff1a" + (time3 - time1) + "\u6beb\u79d2"));
    }

    protected void clearXtOrgLeaderDatas(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = "truncate table T_XT_ORGLEADER";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void insertIntoXtOrgLeaderTable(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertIntoXtOrgLeaderTable");
        ArrayList ids = new ArrayList();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("openId")) || StringUtils.isEmpty((String)json.getString("department"))) continue;
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(json.getString("department"));
            param.add(json.getString("openId"));
            param.add(json.getString("departmentId"));
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u8868----------");
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u8868\u6210\u529f----------");
    }

    protected void updateOrgLeaderToMap(Context ctx) throws BOSException {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String insertMiddleOrgLeader = easXtSyncUtil.getValue("insertMiddleOrgLeader");
        DbUtil.execute((Context)ctx, (String)insertMiddleOrgLeader);
        logger.error((Object)"\u65b0\u589e\u8d1f\u8d23\u4eba\u4fe1\u606f\u5230\u8d1f\u8d23\u4eba\u4e2d\u95f4\u8868");
    }

    protected void updateXtPartJob(Context ctx) throws BOSException {
        long time1 = System.currentTimeMillis();
        logger.error((Object)"**************1\tAbstractEasXtSyncService updateXtPartJob***************");
        int start = 0;
        int length = 1000;
        JSONArray array = new JSONArray();
        JSONArray totalArray = new JSONArray();
        boolean size = false;
        int count = 1;
        try {
            while (true) {
                long while_time1 = System.currentTimeMillis();
                JSONObject response = XtCommunicateUtil.getInstance(ctx).getAllPartJob(start, length);
                long while_time2 = System.currentTimeMillis();
                logger.error((Object)("*** AbstractEasXtSyncService XtCommunicateUtil.getInstance(ctx).getAllPartJob(start,length) \u7b2c" + count + "\u6b21\uff0c\u8017\u65f6:" + (while_time2 - while_time1) + "\u6beb\u79d2"));
                if (!response.getBooleanValue("success")) {
                    if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                        throw new EasXtException(EasXtException.OPENCLOUD);
                    }
                    throw new BOSException(response.getString("error"));
                }
                array = response.getJSONArray("data");
                if (array != null && array.size() >= 1) {
                    logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a" + array.size()));
                    totalArray.addAll((Collection)array);
                    start += length;
                    ++count;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("updateXtPartJob", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("**************2\tAbstractEasXtSyncService updateXtPartJob \u62c9\u53d6\u4e91\u4e4b\u5bb6\u517c\u804c\u6570\u636e \uff0c\u8017\u65f6:" + (time2 - time1) + "\u6beb\u79d2"));
        this.clearXtPartJobDatas(ctx, totalArray);
        this.insertIntoXtPartJobTable(ctx, totalArray);
        long time3 = System.currentTimeMillis();
        logger.error((Object)("**************3\tAbstractEasXtSyncService updateXtPartJob \u8017\u65f6:" + (time3 - time2) + "\u6beb\u79d2"));
    }

    protected void clearXtPartJobDatas(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = "truncate table T_XT_PART";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void insertIntoXtPartJobTable(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertIntoXtPartTable");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("openId")) || StringUtils.isEmpty((String)json.getString("orgId"))) continue;
            String jobTitle = json.getString("jobTitle");
            if (!StringUtils.isEmpty((String)jobTitle) && jobTitle.contains(",")) {
                String[] jobTitles = jobTitle.split(",");
                for (int j = 0; j < jobTitles.length; ++j) {
                    param = new ArrayList();
                    param.add(BOSUuid.create((String)"F4AF4F04").toString());
                    param.add(json.getString("orgId"));
                    param.add(json.getString("openId"));
                    param.add(jobTitles[j]);
                    params.add(param.toArray());
                }
                continue;
            }
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(json.getString("orgId"));
            param.add(json.getString("openId"));
            param.add(jobTitle);
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u517c\u804c\u8868----------");
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u517c\u804c\u8868\u6210\u529f----------");
    }

    protected void updateXtRelations(Context ctx) throws BOSException {
        int start = 0;
        int length = 1000;
        JSONArray array = new JSONArray();
        JSONArray totalArray = new JSONArray();
        try {
            while (true) {
                JSONObject response;
                if (!(response = XtCommunicateUtil.getInstance(ctx).getAllRelations(start, length)).getBooleanValue("success")) {
                    if (300 == response.getIntValue("errorCode") || 301 == response.getIntValue("errorCode")) {
                        throw new EasXtException(EasXtException.OPENCLOUD);
                    }
                    throw new BOSException(response.getString("error"));
                }
                array = response.getJSONArray("data");
                if (array != null && array.size() >= 1) {
                    logger.error((Object)("*******\u83b7\u53d6\u4e91\u4e4b\u5bb6\u6570\u636e\u96c6\u5408\u5927\u5c0f\uff1a" + array.size()));
                    totalArray.addAll((Collection)array);
                    start += length;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ExceptionLogInfo excepInfo = new ExceptionLogInfo("updateXtRelations", e, null, null);
            ExceptionLogService.getInstance(ctx).addException(excepInfo);
            e.printStackTrace();
            throw new BOSException(e.getMessage());
        }
        this.clearXtRelationsDatas(ctx, totalArray);
        this.insertIntoXtRelationsTable(ctx, totalArray);
    }

    protected void clearXtRelationsDatas(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = "truncate table T_XT_PERSONRELATIONS";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    protected void insertIntoXtRelationsTable(Context ctx, JSONArray totalArray) throws BOSException {
        String sql = EasXtSyncUtil.getInstance(ctx).getValue("insertIntoXtRelationsTable");
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        ArrayList<String> param = null;
        for (int i = 0; i < totalArray.size(); ++i) {
            JSONObject json = totalArray.getJSONObject(i);
            if (StringUtils.isEmpty((String)json.getString("openId")) || StringUtils.isEmpty((String)json.getString("leaderOpenId"))) continue;
            param = new ArrayList<String>();
            param.add(BOSUuid.create((String)"F4AF4F04").toString());
            param.add(json.getString("leaderOpenId"));
            param.add(json.getString("openId"));
            param.add(json.getString("relationType"));
            params.add(param.toArray());
        }
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u4e0a\u7ea7\u4fe1\u606f\u8868----------");
        DbUtil.executeBatch((Context)ctx, (String)sql, params);
        logger.error((Object)sql);
        logger.error((Object)"---------\u5168\u90e8\u63d2\u5165\u8baf\u901a\u4e0a\u7ea7\u4fe1\u606f\u8868\u6210\u529f----------");
    }

    protected void setDefaultNull(Context ctx) {
        EasXtSyncUtil easXtSyncUtil = EasXtSyncUtil.getInstance(ctx);
        String sql = null;
        try {
            sql = easXtSyncUtil.getValue("setXtIdNULL");
            logger.error((Object)("*****setXtIdNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setCellNULL");
            logger.error((Object)("*****setCellNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setEmailNULL");
            logger.error((Object)("*****setEmailNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setPositionNULL");
            logger.error((Object)("*****setPositionNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setOrgLongNameNULL");
            logger.error((Object)("*****setOrgLongNameNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setDescriptionNULL");
            logger.error((Object)("*****setDescriptionNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setUserNameNULL");
            logger.error((Object)("*****setUserNameNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setUserNumberNULL");
            logger.error((Object)("*****setUserNumberNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setPersonNameNULL");
            logger.error((Object)("*****setPersonNameNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
            sql = easXtSyncUtil.getValue("setUserIdNULL");
            logger.error((Object)("*****setUserIdNULL***" + sql));
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            logger.error((Object)"\u8bbe\u7f6e''\u4e3anull\u51fa\u9519");
            e.printStackTrace();
        }
    }

    protected void rebuildAdminOrgDisplayName(Context ctx) {
    }
}

