/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import com.kingdee.eas.cp.autoupdater.util.FileUtil;
import com.kingdee.eas.cp.autoupdater.util.IPMapUtil;
import com.kingdee.eas.cp.autoupdater.util.JNLPCacheUtil;
import com.kingdee.eas.cp.autoupdater.util.MD5Util;
import com.kingdee.eas.cp.autoupdater.util.ResGeneratorUtil;
import com.kingdee.eas.cp.common.web.config.PortalXmlConfiguration;
import com.kingdee.eas.util.PropertiesUtil;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class JnlpResxWriter {
    private static final String ON_DEMAND_RESOURCE = "resource.lst";
    private static final String RESOURCE_CONFIG = "resourceSet.properties";
    private static final String FIRSTDOWNRES_FILENAME = "FirstDownRes.properties";
    private static final String ODDS_CONFIG = "oddsConfig.properties";
    private static Vector FirstDownResVect = new Vector();

    public static synchronized String createOnDemandJnlpResx(HttpServletRequest request) {
        String jnlpResources = "";
        Hashtable jnlpResourcesCache = JNLPCacheUtil.getJnlpCache();
        String onDemandJnlpResx = "onDemandJnlpResx";
        String refreshCache = request.getParameter("refreshCache");
        if (refreshCache == null) {
            refreshCache = "false";
        }
        if (refreshCache.equalsIgnoreCase("true")) {
            jnlpResourcesCache.put(onDemandJnlpResx, null);
        }
        String localDir = PropertiesUtil.getDefaultProFullName((String)"");
        String _easJnlpPath = JnlpResxWriter.resetJnlpPathByRequest(request);
        String _autoUpdate = PortalXmlConfiguration.getInstance().getEasWebClientConfigItem().getAutoUpdate();
        if (_autoUpdate == null || "".equals(_autoUpdate)) {
            _autoUpdate = "true";
        }
        String easJnlpFileName = "resource.lst?autoUpdate=" + _autoUpdate;
        easJnlpFileName = JnlpResxWriter.resetJnlpHref(easJnlpFileName, false);
        if (jnlpResourcesCache == null || jnlpResourcesCache.get(onDemandJnlpResx) == null) {
            jnlpResources = FileUtil.fileToString(localDir + "/" + ON_DEMAND_RESOURCE);
            jnlpResourcesCache.put(onDemandJnlpResx, jnlpResources);
        } else {
            jnlpResources = (String)jnlpResourcesCache.get(onDemandJnlpResx);
            System.out.println("[easupdater] get jnlp resx from Hashtable,key=" + onDemandJnlpResx);
        }
        if (jnlpResources == null) {
            jnlpResources = "";
        } else {
            StringBuffer sb = new StringBuffer("");
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
            sb.append("\t\t<jnlp spec=\"1.0+\" codebase=\"" + _easJnlpPath + "\" href=\"" + easJnlpFileName + "\" ");
            jnlpResources = sb.toString() + jnlpResources;
        }
        return jnlpResources;
    }

    public static synchronized String createBaseJnlpResx(HttpServletRequest request) {
        boolean disableCache;
        Hashtable jnlpResourcesCache = JNLPCacheUtil.getJnlpCache();
        Hashtable jnlpOldResourcesCache = JNLPCacheUtil.getOldJnlpCache();
        String refreshCache = request.getParameter("refreshCache");
        if (refreshCache == null) {
            refreshCache = "false";
        }
        String autoDownload = JnlpResxWriter.resetAutoDowolad(request);
        String jnlpResources = null;
        String jnlpResxKey = "jnlpResx";
        String localDir = System.getProperty("EAS_HOME") + "/server/properties/";
        if (refreshCache.equalsIgnoreCase("true")) {
            IPMapUtil.refreshIPMap();
            MD5Util.loadMD5(localDir);
        }
        String _easJnlpPath = JnlpResxWriter.resetJnlpPathByRequest(request);
        System.out.println("[easupdater] get jnlp resx from Hashtable,key=" + jnlpResxKey);
        String enableCacheStr = request.getParameter("enableCache");
        boolean bl = disableCache = new Boolean(enableCacheStr) == false;
        if (autoDownload.equalsIgnoreCase("true") && (jnlpResourcesCache == null || jnlpResourcesCache.get(jnlpResxKey) == null) || autoDownload.equalsIgnoreCase("false") && (jnlpOldResourcesCache == null || jnlpOldResourcesCache.get(jnlpResxKey) == null) || disableCache || refreshCache.equalsIgnoreCase("true")) {
            String silentJnlp;
            if (refreshCache.equalsIgnoreCase("true")) {
                jnlpResourcesCache.clear();
                jnlpOldResourcesCache.clear();
            }
            if (!((silentJnlp = request.getParameter("silentJnlp")) != null && "true".equals(silentJnlp) || (jnlpResourcesCache != null && jnlpResourcesCache.size() != 0 || jnlpOldResourcesCache != null && jnlpOldResourcesCache.size() != 0) && !refreshCache.equalsIgnoreCase("true"))) {
                ResGeneratorUtil resUtil = ResGeneratorUtil.getInstance();
                String localPortalDir = request.getParameter("localDir");
                resUtil.generatorResourceList(jnlpResourcesCache, jnlpOldResourcesCache, localPortalDir, refreshCache);
            }
            jnlpResources = autoDownload.equalsIgnoreCase("true") ? FileUtil.fileToString(localDir + "/ondemand_eas.jnlp") : FileUtil.fileToString(localDir + "/full_eas.jnlp");
            if (!disableCache) {
                if (autoDownload.equalsIgnoreCase("true")) {
                    jnlpResourcesCache.put(jnlpResxKey, jnlpResources);
                } else {
                    jnlpOldResourcesCache.put(jnlpResxKey, jnlpResources);
                }
            }
        } else {
            jnlpResources = autoDownload.equalsIgnoreCase("true") ? (String)jnlpResourcesCache.get(jnlpResxKey) : (String)jnlpOldResourcesCache.get(jnlpResxKey);
        }
        if (jnlpResources == null) {
            jnlpResources = "";
        } else {
            String jnlpFileName;
            String strAutoUpdate = request.getParameter("autoUpdate");
            boolean _autoUpdate = true;
            _autoUpdate = strAutoUpdate == null || "".equals(strAutoUpdate) ? true : new Boolean(strAutoUpdate);
            boolean _enableVerSwitch = new Boolean(request.getParameter("enableVerSwitch"));
            int _maxVerCopyCount = 2;
            try {
                _maxVerCopyCount = Integer.parseInt(request.getParameter("maxVerCopyCount"));
            }
            catch (NumberFormatException e) {
                _maxVerCopyCount = 2;
            }
            String _jnlpVersion = request.getParameter("jnlpVersion");
            if (_jnlpVersion == null || "".equals(_jnlpVersion)) {
                _jnlpVersion = "5.1.0.0";
            }
            if ((jnlpFileName = request.getParameter("jnlpFileName")) == null || "".equals(jnlpFileName)) {
                jnlpFileName = "eas.jnlp";
            }
            String easJnlpFileName = jnlpFileName + "?autoUpdate=" + _autoUpdate + "&amp;enableVerSwitch=" + _enableVerSwitch + "&amp;maxVerCopyCount=" + _maxVerCopyCount + "&amp;jnlpVersion=" + _jnlpVersion;
            easJnlpFileName = JnlpResxWriter.resetJnlpHref(easJnlpFileName, true);
            StringBuffer sb = new StringBuffer("");
            sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
            sb.append("\t\t<jnlp spec=\"1.0+\" codebase=\"" + _easJnlpPath + "\" href=\"" + easJnlpFileName + "\" ");
            jnlpResources = sb.toString() + jnlpResources;
        }
        return jnlpResources;
    }

    private static String addToArray(Vector vect, String str) {
        StringBuffer buf = new StringBuffer(str);
        if (vect.size() > 0) {
            Iterator it = vect.iterator();
            String tempStr = null;
            while (it.hasNext()) {
                tempStr = (String)it.next();
                buf.append(",");
                buf.append(tempStr);
            }
        }
        return buf.toString();
    }

    private static String resetJnlpHref(String easJnlpFileName, boolean isBaseResx) {
        Properties oddsConfigProperties;
        String useOddsJarFunction;
        String cdn_force_enable;
        String cdn_ok_code;
        String cdn_test_method;
        Properties prop = PropertiesUtil.getProperties((String)PropertiesUtil.getDefaultFullName((String)RESOURCE_CONFIG));
        String seperator = prop.getProperty("seperator", ",");
        String full_resItemsExcluded = prop.getProperty("full_resItemsExcluded", "eas_help.jar,set-client-env.bat,set-client-env.sh");
        String baseResPaths = prop.getProperty("baseResPaths", "deploy/,bin/,classloader/,metas/");
        String ondemand_resPaths = prop.getProperty("ondemand_resPaths", "lib/sp/,lib/common/,lib/client/");
        String ondemand_resItemsExcluded = prop.getProperty("ondemand_resItemsExcluded", "set-client-env.bat,set-client-env.sh");
        String resPaths = "";
        String resItemsExcluded = "";
        if (isBaseResx) {
            resPaths = JnlpResxWriter.addToArray(FirstDownResVect, baseResPaths);
            resItemsExcluded = full_resItemsExcluded;
        } else {
            resPaths = ondemand_resPaths;
            resItemsExcluded = JnlpResxWriter.addToArray(FirstDownResVect, ondemand_resItemsExcluded);
        }
        String jnlpParamStr = "resPaths=" + resPaths + "&amp;resItemsExcluded=" + resItemsExcluded + "&amp;seperator=" + seperator;
        String result = easJnlpFileName;
        result = result.indexOf("?") > 0 ? result + "&amp;" + jnlpParamStr : result + "?" + jnlpParamStr;
        String cdnURL = prop.getProperty("CDN_URL");
        if (cdnURL != null && cdnURL.trim().length() > 0) {
            result = result + "&amp;CDN_URL=" + cdnURL.trim();
        }
        if ((cdn_test_method = prop.getProperty("CDN_TEST_METHOD")) != null && cdn_test_method.trim().length() > 0) {
            result = result + "&amp;CDN_TEST_METHOD=" + cdn_test_method.trim();
        }
        if ((cdn_ok_code = prop.getProperty("CDN_OK_CODE")) != null && cdn_ok_code.trim().length() > 0) {
            result = result + "&amp;CDN_OK_CODE=" + cdn_ok_code.trim();
        }
        if ((cdn_force_enable = prop.getProperty("CDN_FORCE_ENABLE")) != null && cdn_force_enable.trim().length() > 0) {
            result = result + "&amp;CDN_FORCE_ENABLE=" + cdn_force_enable.trim();
        }
        result = (useOddsJarFunction = (oddsConfigProperties = PropertiesUtil.getProperties((String)PropertiesUtil.getDefaultFullName((String)ODDS_CONFIG))).getProperty("useOddsJarFunction")) != null && useOddsJarFunction.trim().length() > 0 ? result + "&amp;useOddsJarFunction=" + useOddsJarFunction.trim() : result + "&amp;useOddsJarFunction=false";
        return result;
    }

    public static String resetJnlpPathByRequest(HttpServletRequest request) {
        String _serverPort;
        String codebase = request.getParameter("codebase");
        if (codebase != null) {
            return codebase;
        }
        String _serverName = request.getServerName();
        if (_serverName == null || "".equals(_serverName)) {
            _serverName = "localhost";
        }
        if ((_serverPort = Integer.toString(request.getServerPort())) == null || "".equals(_serverPort)) {
            _serverPort = "80";
        }
        String protocol = request.isSecure() ? "https://" : "http://";
        String _easJnlpPath = protocol + _serverName + ":" + _serverPort + "/easWebClient/";
        String _remoteAddress = request.getRemoteAddr();
        String fileServerUrl = IPMapUtil.getIPMapValue(_remoteAddress);
        if (fileServerUrl != null) {
            _easJnlpPath = fileServerUrl;
        }
        System.out.println("[easupdater] request jnlp from " + _remoteAddress);
        return _easJnlpPath;
    }

    private static String resetAutoDowolad(HttpServletRequest request) {
        String autoDownload = request.getParameter("autoDownload");
        if (autoDownload == null) {
            autoDownload = "false";
        }
        return autoDownload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        File FirstDownResFile = new File(PropertiesUtil.getDefaultFullName((String)FIRSTDOWNRES_FILENAME));
        if (!FirstDownResFile.exists()) return;
        BufferedReader in = null;
        in = new BufferedReader(new InputStreamReader(new FileInputStream(FirstDownResFile)));
        String line = null;
        while (true) {
            try {
                line = in.readLine();
            }
            catch (IOException e) {
                System.out.println("file FirstDownRes.properties has a bad line!");
            }
            if (line == null) break;
            line = StringUtils.trim((String)line);
            FirstDownResVect.add(line);
        }
        Object var5_5 = null;
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException e2) {
            System.out.println("IOException when closing!");
        }
        return;
        {
            catch (FileNotFoundException e) {
                System.out.println("file FirstDownRes.properties not found!");
                Object var5_6 = null;
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (IOException e2) {
                    System.out.println("IOException when closing!");
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e2) {
                System.out.println("IOException when closing!");
            }
            throw throwable;
        }
    }
}

