/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.autoupdater.util;

import com.kingdee.eas.cp.autoupdater.util.MD5Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class PackageMapGenerator {
    public static String PKMAP_RESOURCE_FILENAME = "pkCache.lst";
    private static boolean modified = false;
    private static Map oldMap = null;
    private static Map newMap = null;
    private static Vector packageNames = null;
    private static String cachePath = null;

    public static void main(String[] args) {
        long startTime = System.currentTimeMillis();
        String home = "W:/eas/Server/server/deploy/fileserver.ear/easWebClient";
        String libPath = "lib";
        PackageMapGenerator.generatePKMap(home, libPath, "W:/", "pkmap.lst", "W:/eas/Server/server/properties/");
        System.out.println("Generate package map list: " + (System.currentTimeMillis() - startTime));
    }

    public static void generatePKMap(String home, String libPath, String outputpath) {
        System.out.println("--generatePKMap--path" + home);
    }

    private static Map getOldPKMap() {
        if (oldMap == null) {
            oldMap = PackageMapGenerator.loadPKMap();
        }
        return oldMap;
    }

    private static Map getNewPKMap() {
        if (newMap == null) {
            newMap = new HashMap();
        }
        return newMap;
    }

    private static Vector getPackageNames() {
        if (packageNames == null) {
            packageNames = new Vector();
        }
        return packageNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Map loadPKMap() {
        block13: {
            startTime = System.currentTimeMillis();
            map /* !! */  = null;
            objectinputstream = null;
            file = new File(PackageMapGenerator.cachePath, PackageMapGenerator.PKMAP_RESOURCE_FILENAME);
            if (file.exists()) {
                try {
                    objectinputstream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
                    map /* !! */  = (Map)objectinputstream.readObject();
                    var7_4 = null;
                    ** if (objectinputstream == null) goto lbl-1000
                }
                catch (Throwable var6_11) {
                    var7_6 = null;
                    if (objectinputstream != null) {
                        try {
                            objectinputstream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    throw var6_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        objectinputstream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block13;
                    catch (Exception e) {
                        file.delete();
                        map /* !! */  = new HashMap<K, V>();
                        e.printStackTrace();
                        var7_5 = null;
                        if (objectinputstream != null) {
                            try {
                                objectinputstream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        }
        if (map /* !! */  == null) {
            map /* !! */  = new HashMap<K, V>();
        }
        System.out.println("[easupdater] load pkCache resource. used time:" + (System.currentTimeMillis() - startTime) + "ms");
        return map /* !! */ ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void storePKMap() {
        block16: {
            if (PackageMapGenerator.newMap == null) {
                return;
            }
            startTime = System.currentTimeMillis();
            objectoutputstream = null;
            file = new File(PackageMapGenerator.cachePath, PackageMapGenerator.PKMAP_RESOURCE_FILENAME);
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                file.delete();
            }
            try {
                objectoutputstream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                objectoutputstream.writeObject(PackageMapGenerator.newMap);
                var6_5 = null;
                ** if (objectoutputstream == null) goto lbl-1000
            }
            catch (Throwable var5_11) {
                var6_7 = null;
                if (objectoutputstream != null) {
                    try {
                        objectoutputstream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw var5_11;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    objectoutputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block16;
                catch (Exception e) {
                    file.delete();
                    e.printStackTrace();
                    var6_6 = null;
                    if (objectoutputstream != null) {
                        try {
                            objectoutputstream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        System.out.println("[easupdater] store pkCache resource. used time:" + (System.currentTimeMillis() - startTime) + "ms");
    }

    private static void storeMap(File file, Map map) {
        try {
            FileWriter pkMapWriter = new FileWriter(file);
            BufferedWriter bufPKMapWriter = new BufferedWriter(pkMapWriter);
            Object[] keys = map.keySet().toArray(new String[0]);
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                bufPKMapWriter.write((String)keys[i]);
                bufPKMapWriter.write("=");
                bufPKMapWriter.write(map.get(keys[i]).toString());
                bufPKMapWriter.write("\r\n");
            }
            bufPKMapWriter.flush();
            pkMapWriter.close();
        }
        catch (Throwable ex) {
            System.err.println("[easupdater] store pkMap failed, cause by " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static boolean generatePKMap(String home, String libPath, String outputpath, String fileName, String configPath) {
        cachePath = configPath;
        oldMap = null;
        newMap = null;
        packageNames = null;
        Properties md5 = MD5Util.getMD5(configPath);
        modified = false;
        File resHome = new File(home);
        File file = null;
        Properties resList = new Properties();
        try {
            String homePath = resHome.getCanonicalPath();
            String[] libList = libPath.split(",");
            for (int i = 0; i < libList.length; ++i) {
                System.out.println("----liblist" + i + "=" + libList[i]);
                file = new File(resHome, libList[i]);
                if (!file.exists()) continue;
                if (file.isDirectory()) {
                    PackageMapGenerator.scanDir(homePath.length(), resHome, libList[i], md5);
                    continue;
                }
                PackageMapGenerator.scanFile(file, homePath.length(), md5);
            }
            if (PackageMapGenerator.getOldPKMap().size() != PackageMapGenerator.getNewPKMap().size()) {
                modified = true;
            }
            if (modified) {
                String key = null;
                Object object = null;
                Vector vector = null;
                int num = 0;
                int size = PackageMapGenerator.getPackageNames().size();
                for (int k = 0; k < size; ++k) {
                    key = PackageMapGenerator.getPackageNames().get(k).toString();
                    object = PackageMapGenerator.getNewPKMap().get(key);
                    if (object == null || !(object instanceof Vector)) continue;
                    vector = object;
                    num = vector.size();
                    for (int j = 0; j < num; ++j) {
                        PackageMapGenerator.addPackageToList((String)vector.get(j), "/" + key, resList);
                    }
                }
                PackageMapGenerator.storeMap(new File(outputpath + "/" + fileName), resList);
                PackageMapGenerator.storePKMap();
            } else {
                System.out.println("[easupdater] pkmap resource no modified.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modified;
    }

    private static void scanDir(int homeLength, File parent, String sub, Properties md5) {
        File path = new File(parent, sub);
        if (!path.exists()) {
            return;
        }
        File[] files = path.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            if (file.isDirectory()) {
                PackageMapGenerator.scanDir(homeLength, path, file.getName(), md5);
                continue;
            }
            PackageMapGenerator.scanFile(file, homeLength, md5);
        }
    }

    private static void scanFile(File file, int homeLength, Properties md5) {
        try {
            String jarPath = null;
            String key = null;
            Vector vector = null;
            Object object = null;
            String filename = file.getCanonicalPath();
            if (filename.toLowerCase().endsWith(".jar") || filename.toLowerCase().endsWith(".zip") || filename.toLowerCase().endsWith(".rar")) {
                jarPath = (filename = filename.replace('\\', '/')).substring(homeLength);
                String string = key = jarPath.indexOf("/") == 0 ? jarPath.substring(1) : jarPath;
                if (file.lastModified() != MD5Util.getLastModified(md5, key)) {
                    vector = PackageMapGenerator.scanPackage(file, jarPath);
                    PackageMapGenerator.getNewPKMap().put(key, vector);
                    PackageMapGenerator.getPackageNames().add(key);
                    modified = true;
                } else {
                    object = PackageMapGenerator.getOldPKMap().get(key);
                    if (object != null && object instanceof Vector) {
                        PackageMapGenerator.getNewPKMap().put(key, object);
                        PackageMapGenerator.getPackageNames().add(key);
                    } else {
                        vector = PackageMapGenerator.scanPackage(file, jarPath);
                        PackageMapGenerator.getNewPKMap().put(key, vector);
                        PackageMapGenerator.getPackageNames().add(key);
                        modified = true;
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static Vector scanPackage(File file, String jarPath) {
        Vector<String> vector = new Vector<String>();
        String packageName = "";
        try {
            ZipFile lib = new ZipFile(file);
            Enumeration<? extends ZipEntry> en = lib.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                if (entry.isDirectory()) continue;
                packageName = entry.getName();
                if (packageName.lastIndexOf("/") >= 0) {
                    packageName = packageName.substring(0, packageName.lastIndexOf(47));
                }
                if (vector.contains(packageName)) continue;
                vector.add(packageName);
            }
            lib.close();
        }
        catch (Exception e) {
            if (file.getName().endsWith("metasindex.jar")) {
                vector.add("index.lst");
            }
            file.delete();
            modified = true;
            e.printStackTrace();
        }
        return vector;
    }

    private static void addPackageToList(String packageName, String jarPath, Properties resList) {
        String jarList = resList.getProperty(packageName, "");
        if (jarList.length() > 0) {
            String[] packageList = jarList.split(";");
            List<String> pkList = Arrays.asList(packageList);
            if (!pkList.contains(jarPath)) {
                resList.setProperty(packageName, jarList + ";" + jarPath);
            }
        } else {
            resList.setProperty(packageName, jarPath);
        }
    }
}

