/*
 * Decompiled with CFR 0.152.
 */
package net.buffalo.protocal.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.buffalo.protocal.AccessFieldException;
import net.buffalo.protocal.InitializeObjectFailedException;
import net.buffalo.protocal.TypeNotFoundException;
import net.buffalo.protocal.util.ClassFieldNamePair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassUtil {
    private static final Log LOGGER = LogFactory.getLog(ClassUtil.class);
    private static Map fieldCache = new HashMap();

    public static Object newInstanceOfType(String className) {
        Object result = null;
        try {
            result = ClassUtil.getClassFor(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new InitializeObjectFailedException("fail to initialize type: " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new InitializeObjectFailedException("fail to initialize type: " + className, e);
        }
        return result;
    }

    public static Class getClassFor(String className) {
        try {
            return ClassUtil.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotFoundException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setFieldValue(Object obj, String property, Object value) {
        Class<?> type = obj.getClass();
        Field field = null;
        ClassFieldNamePair pair = new ClassFieldNamePair(type, property);
        if (fieldCache.get(pair) == null) {
            field = (Field)ClassUtil.getFieldMap(type).get(property);
            if (field == null) throw new AccessFieldException("Cannot find field [" + property + "] for " + type);
            fieldCache.put(pair, field);
        } else {
            field = (Field)fieldCache.get(pair);
        }
        try {
            try {
                field.set(obj, value);
                return;
            }
            catch (IllegalArgumentException ex) {
                field.set(obj, ClassUtil.convertValue(value, field.getType()));
            }
            return;
        }
        catch (SecurityException e) {
            throw new AccessFieldException(e);
        }
        catch (IllegalAccessException e) {
            throw new AccessFieldException(e);
        }
    }

    private static HashMap getFieldMap(Class cl) {
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        while (cl != null) {
            Field[] fields = cl.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                fieldMap.put(field.getName(), field);
            }
            cl = cl.getSuperclass();
        }
        return fieldMap;
    }

    public static Object convertValue(Object value, Class targetType) {
        if (value.getClass().equals(targetType)) {
            return value;
        }
        if (targetType.isPrimitive()) {
            targetType = ClassUtil.getWrapperClass(targetType);
        }
        if (targetType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if ((value instanceof String || value instanceof Number) && Number.class.isAssignableFrom(targetType)) {
            try {
                Constructor ctor = targetType.getConstructor(String.class);
                return ctor.newInstance(value.toString());
            }
            catch (Exception e) {
                LOGGER.error((Object)"convert type error", (Throwable)e);
                throw new RuntimeException("Cannot convert from " + value.getClass().getName() + " to " + targetType, e);
            }
        }
        if (targetType.isArray() && Collection.class.isAssignableFrom(value.getClass())) {
            Collection collection = (Collection)value;
            Object array = Array.newInstance(targetType.getComponentType(), collection.size());
            int i = 0;
            for (Object val : collection) {
                Array.set(array, i++, val);
            }
            return array;
        }
        if (Collection.class.isAssignableFrom(targetType) && value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        throw new IllegalArgumentException("Cannot convert from " + value.getClass().getName() + " to " + targetType);
    }

    public static Class getWrapperClass(Class primitiveClass) {
        return primitiveClass == Integer.TYPE ? Integer.class : (primitiveClass == Long.TYPE ? Long.class : (primitiveClass == Short.TYPE ? Short.class : (primitiveClass == Byte.TYPE ? Byte.class : (primitiveClass == Float.TYPE ? Float.class : (primitiveClass == Double.TYPE ? Double.class : (primitiveClass == Boolean.TYPE ? Boolean.class : primitiveClass))))));
    }

    public static Object invokeMethod(Object instance, Method method, Object[] arguments) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].isAssignableFrom(arguments[i].getClass())) continue;
            arguments[i] = ClassUtil.convertValue(arguments[i], parameterTypes[i]);
        }
        return method.invoke(instance, arguments);
    }
}

