/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.permission.MachineRegisterFactory;
import com.kingdee.eas.base.permission.MachineRegisterInfo;
import com.kingdee.eas.base.permission.PermissionCommonUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.app.util.UserInfoUtils;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class MachineCodeAuthentication
extends AbstractAction {
    private static Logger logger = Logger.getLogger(MachineCodeAuthentication.class);

    protected Event doExecute(RequestContext context) throws Exception {
        String tgt;
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String cell = request.getParameter("cell");
        String createTimeStart = request.getParameter("createTimeStart");
        String createTimeEnd = request.getParameter("createTimeEnd");
        String string = tgt = context.getConversationScope().get("tgt") == null ? "" : context.getConversationScope().get("tgt").toString();
        if (!StringUtils.isEmpty((String)tgt)) {
            WebUtils.putTicketGrantingTicketInRequestScope((RequestContext)context, (String)tgt);
        }
        EASCredentials credentials = (EASCredentials)request.getSession().getAttribute("secondAuthContext");
        Context ctx = EASLoginHandler.getContextBySessionID(credentials.getEasSessionId());
        UserInfo userInfo = UserInfoUtils.getUserInfo4LoinModule((Context)ctx, (String)credentials.getUsername());
        MachineRegisterInfo machineInfo = new MachineRegisterInfo();
        machineInfo.setIp(credentials.getClientHostIP());
        machineInfo.setMachineName(credentials.getClientHostIP());
        machineInfo.setIsRegistered("00000000-0000-0000-0000-00000000000013B7DE7F".equals(ctx.getCaller().toString()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        machineInfo.setValidDate(dateFormat.parse(createTimeStart));
        machineInfo.setInValidDate(dateFormat.parse(createTimeEnd));
        machineInfo.setCU(userInfo.getCU());
        machineInfo.setPhoneNumber(cell);
        String policy = PermissionCommonUtil.getMachineCodeGeneratorPolicy((Context)ctx);
        String machineCode = "";
        if ("2".equals(policy)) {
            machineCode = credentials.getClientHostIP().replace(".", "");
        } else if ("4".equals(policy)) {
            machineCode = credentials.getMcCodeToken();
        } else if ("6".equals(policy)) {
            machineCode = credentials.getMcCodeToken() + credentials.getClientHostIP().replace(".", "");
        } else {
            request.setAttribute("errMsg", (Object)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5f53\u524d\u673a\u5668\u7801\u7c7b\u578b\u4e0d\u652f\u6301portal!");
            request.setAttribute("checkError", (Object)"true");
            return this.error();
        }
        try {
            machineCode = CryptoTean.encrypt((String)"", (String)machineCode);
        }
        catch (CryptException e) {
            logger.error((Object)"", (Throwable)e);
            machineCode = "Crypt Fail";
        }
        machineInfo.setMachineCode(machineCode);
        try {
            MachineRegisterFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)machineInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("errMsg", (Object)"\u63d0\u4ea4\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
            request.setAttribute("checkError", (Object)"true");
            return this.error();
        }
        request.setAttribute("checkError", (Object)"false");
        return this.success();
    }
}

