/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.web.server;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomFactory;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomInfo;
import com.kingdee.eas.base.myeas.PrivacyStatementFactory;
import com.kingdee.eas.base.permission.PrivacyStatementParam;
import com.kingdee.eas.base.permission.util.cloud.Constants;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.cp.eip.sso.qrcode.helper.QrCodeTokenHelper;
import com.kingdee.eas.cp.eip.sso.web.EASCredentials;
import com.kingdee.eas.cp.eip.sso.web.server.EASLoginHandler;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SignPrivacyStatement
extends AbstractAction {
    private static Logger logger = Logger.getLogger(SignPrivacyStatement.class);

    protected Event doExecute(RequestContext context) throws Exception {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        try {
            String tgt;
            PrivacyStatementParam privacyStatementParam;
            EASCredentials credentials = (EASCredentials)request.getSession().getAttribute("secondAuthContext");
            Context ctx = EASLoginHandler.getContextBySessionID(credentials.getEasSessionId());
            String agree = context.getRequestParameters().get("_agree");
            if (!"true".equalsIgnoreCase(agree)) {
                HttpServletResponse httpServletResponse = WebUtils.getHttpServletResponse((RequestContext)context);
                String service = context.getRequestParameters().get("service");
                if (StringUtils.isEmpty((String)service)) {
                    service = "/portal";
                }
                UserMonitorFactory.getLocalInstance((Context)ctx).deleteSessionAndUserMonitorInfo(ctx.getContextID(), Boolean.valueOf(false));
                httpServletResponse.sendRedirect(service);
                return this.error();
            }
            String userId = ctx.getCaller().toString();
            Timestamp sighTime = new Timestamp(System.currentTimeMillis());
            int privacyStatement = QrCodeTokenHelper.getPrivacyStatement();
            if (privacyStatement == 1) {
                privacyStatementParam = new PrivacyStatementParam(userId, sighTime, Constants.PRIVACY_STATE_VERSION, "N31DMHgERAqJg4mE3TLXGjmwZ2f=");
            } else {
                EntityViewInfo entityViewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)"ENABLE", CompareType.EQUALS));
                entityViewInfo.setFilter(filterInfo);
                PrivacyStatementCustomInfo privacyStatementCustomInfo = PrivacyStatementCustomFactory.getLocalInstance((Context)ctx).getPrivacyStatementCustomInfo("select id where status = 'ENABLE'");
                if (privacyStatementCustomInfo == null) {
                    request.setAttribute("errMsg", (Object)"\u7b7e\u7f72\u5931\u8d25\uff0cxxx\u6b63\u5728\u7b7e\u7f72\u6216\u9605\u8bfb\uff0c\u6682\u65f6\u65e0\u6cd5\u4fee\u6539");
                    request.setAttribute("success", (Object)"false");
                    return this.error();
                }
                String privacyCusId = privacyStatementCustomInfo.getId().toString();
                privacyStatementParam = new PrivacyStatementParam(userId, sighTime, null, privacyCusId);
            }
            boolean success = PrivacyStatementFactory.getLocalInstance((Context)ctx).signPrivacyStatement(privacyStatementParam);
            if (!success) {
                request.setAttribute("errMsg", (Object)"\u7b7e\u7f72\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
                request.setAttribute("success", (Object)"false");
                return this.error();
            }
            String string = tgt = context.getConversationScope().get("tgt") == null ? "" : context.getConversationScope().get("tgt").toString();
            if (!StringUtils.isEmpty((String)tgt)) {
                WebUtils.putTicketGrantingTicketInRequestScope((RequestContext)context, (String)tgt);
            }
            return this.success();
        }
        catch (Exception e) {
            request.setAttribute("errMsg", (Object)"\u7b7e\u7f72\u5931\u8d25\uff0c\u8bf7\u53ca\u65f6\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            request.setAttribute("success", (Object)"false");
            logger.error((Object)e);
            return this.error();
        }
    }
}

