/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.bicomponent;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.bicomponent.BIComponentResource;
import com.kingdee.bos.ctrl.analysis.bicomponent.CalculateMemberBuilder;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.MemberTree;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_QueryManager;
import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import com.kingdee.bos.olap.mdx.Formula;
import com.kingdee.bos.olap.mdx.MdxQuery;
import com.kingdee.bos.olap.mem.impl.CalculatedMemberImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DimensionNavigator
extends KDDialog {
    ComponentConfig config;
    OlapModel olapModel;
    private KDTree tree = new KDTree();
    private KDContainer lcTree = new KDContainer();
    private KDTable tblList = new KDTable();
    private KDContainer lcList = new KDContainer();
    private KDPanel rootPanel = new KDPanel();
    private KDPopupMenu popMenu = new KDPopupMenu();
    private MyAction actionSelectSelf = new MyAction("Select");
    private MyAction actionSelectChild = new MyAction("SelectChild");
    private MyAction actionSelectDescendant = new MyAction("SelectDescendant");
    private MyAction actionSelectSameLevel = new MyAction("SelectSameLevelMember");
    private MyAction actionSelectDetail = new MyAction("SelectDetailMember");
    private MyAction actionDelete = new MyAction("Deselect");
    private MyAction actionCreateCalculate = new MyAction("CreateCalMember");
    private MyAction actionEditCalculate = new MyAction("EditCalMember");
    private MyAction actionDeleteCalculate = new MyAction("DeleteCalMember");
    private MyAction actionOk = new MyAction("OK");
    private MyAction actionCancel = new MyAction("Cancel");
    private CalculateMemberBuilder calculateMemberBuilder = null;
    boolean hierInSlicer = false;
    Hierarchy hierarchy;
    private boolean isOk = false;
    DefaultKingdeeTreeNode calculateFolderNode;
    private static final String ACTION_SELECT_SELF = "Select";
    private static final String ACTION_SELECT_CHILD = "SelectChild";
    private static final String ACTION_SELECT_DESCENDANT = "SelectDescendant";
    private static final String ACTION_SELECT_SAMELEVEL = "SelectSameLevelMember";
    private static final String ACTION_SELECT_DETAIL = "SelectDetailMember";
    private static final String ACTION_DELETE = "Deselect";
    private static final String ACTION_CREATE_CALCULATE = "CreateCalMember";
    private static final String ACTION_EDIT_CALCULATE = "EditCalMember";
    private static final String ACTION_DELETE_CALCULATE = "DeleteCalMember";
    private static final String ACTION_OK = "OK";
    private static final String ACTION_CANCEL = "Cancel";
    private static final String CALCULATE_MEMBER_FOLDER_NAME = "CalMember";

    public DimensionNavigator(ComponentConfig config) {
        this.config = config;
        this.initUI();
        this.initListener();
    }

    public DimensionNavigator(JDialog dialog, ComponentConfig config) {
        super((Dialog)dialog);
        this.config = config;
        this.initUI();
        this.initListener();
    }

    public DimensionNavigator(JFrame frame, ComponentConfig config) {
        super((Frame)frame);
        this.config = config;
        this.initUI();
        this.initListener();
    }

    public void setOlapModel(OlapModel olapModel) {
        this.olapModel = olapModel;
    }

    private KDWorkButton createBarButton(String tip, Icon icon) {
        KDWorkButton btn = new KDWorkButton();
        btn.setText(null);
        btn.setIcon(icon);
        btn.setToolTipText(tip);
        return btn;
    }

    private void selectSameLevel() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            this.selectSameLevel(paths);
        }
    }

    private void selectSameLevel(TreePath[] paths) {
        List listMember = this.collectSelectedMembers();
        MemberTree memberTree = this.getMemberTree();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (!(node.getUserObject() instanceof Member)) continue;
            Member[] memberRoot = memberTree.getRootMembers(this.hierarchy);
            ArrayList<Member> memberList = new ArrayList<Member>();
            memberList.addAll(Arrays.asList(memberRoot));
            int memberLevel = ((Member)node.getUserObject()).getLevel().getDepth();
            while (memberLevel > 0) {
                --memberLevel;
                ArrayList<Member> tempList = new ArrayList<Member>();
                tempList.addAll(memberList);
                memberList.clear();
                for (int j = 0; j < tempList.size(); ++j) {
                    Member memberTemp = (Member)tempList.get(j);
                    if (!memberTree.hasChildren(memberTemp)) continue;
                    Member[] memberChild = memberTree.getChildren(memberTemp);
                    memberList.addAll(Arrays.asList(memberChild));
                }
            }
            for (int j = 0; j < memberList.size(); ++j) {
                if (listMember.contains(memberList.get(j))) continue;
                listMember.add(memberList.get(j));
            }
        }
        this.addToKDList(listMember);
    }

    private void selectDetail() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            this.selectDetail(paths);
        }
    }

    private void selectDetail(TreePath[] paths) {
        List listMember = this.collectSelectedMembers();
        MemberTree memberTree = this.getMemberTree();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            Member[] descendant = null;
            descendant = node.getUserObject() instanceof Member ? memberTree.getDescendant((Member)node.getUserObject()) : memberTree.getDescendant(this.hierarchy);
            if (descendant == null) continue;
            for (int j = 0; j < descendant.length; ++j) {
                if (!descendant[j].isLeaf() || listMember.contains(descendant[j])) continue;
                listMember.add(descendant[j]);
            }
        }
        this.addToKDList(listMember);
    }

    private DefaultKingdeeTreeNode getSelectTreeNode() {
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null) {
            return (DefaultKingdeeTreeNode)tp.getLastPathComponent();
        }
        return null;
    }

    private void updateUIStatus() {
        boolean isSelectNothing = true;
        boolean isSelectMember = false;
        boolean isSelectCalFolder = false;
        boolean isSelectLeaf = false;
        DefaultKingdeeTreeNode node = this.getSelectTreeNode();
        if (node != null) {
            isSelectNothing = false;
            Object obj = node.getUserObject();
            isSelectCalFolder = obj.equals(BIComponentResource.getString(BIComponentResource.class, (String)CALCULATE_MEMBER_FOLDER_NAME));
            if (obj instanceof Member) {
                isSelectMember = true;
                isSelectLeaf = ((Member)obj).isLeaf();
            }
        }
        if (isSelectNothing) {
            this.actionSelectSelf.setEnabled(false);
            this.actionSelectChild.setEnabled(false);
            this.actionSelectDescendant.setEnabled(false);
            this.actionSelectSameLevel.setEnabled(false);
            this.actionSelectDetail.setEnabled(false);
            return;
        }
        if (this.hierInSlicer) {
            this.actionSelectSelf.setEnabled(isSelectMember);
            this.actionSelectChild.setEnabled(false);
            this.actionSelectDescendant.setEnabled(false);
            this.actionSelectSameLevel.setEnabled(false);
            this.actionSelectDetail.setEnabled(false);
        } else if (isSelectMember) {
            this.actionSelectSelf.setEnabled(true);
            this.actionSelectSameLevel.setEnabled(true);
            this.actionSelectChild.setEnabled(!isSelectLeaf);
            this.actionSelectDescendant.setEnabled(!isSelectLeaf);
            this.actionSelectDetail.setEnabled(!isSelectLeaf);
        } else {
            this.actionSelectSelf.setEnabled(false);
            this.actionSelectSameLevel.setEnabled(false);
            this.actionSelectChild.setEnabled(!isSelectCalFolder);
            this.actionSelectDescendant.setEnabled(!isSelectCalFolder);
            this.actionSelectDetail.setEnabled(!isSelectCalFolder);
        }
    }

    private void initUI() {
        this.setModal(true);
        this.setSize(640, 480);
        WindowUtil.makeCneterBounds((Window)((Object)this));
        this.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"DimNavigator"));
        this.popMenu.add(new JMenuItem(this.actionSelectSelf));
        this.popMenu.add(new JMenuItem(this.actionSelectChild));
        this.popMenu.add(new JMenuItem(this.actionSelectDescendant));
        this.popMenu.add(new JMenuItem(this.actionSelectSameLevel));
        this.popMenu.add(new JMenuItem(this.actionSelectDetail));
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DimensionNavigator.this.updateUIStatus();
            }
        });
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e) && DimensionNavigator.this.getSelectTreeNode() != null) {
                    DimensionNavigator.this.popMenu.show((Component)DimensionNavigator.this.tree, e.getX(), e.getY());
                }
            }
        });
        this.lcTree.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"DimenionStruct"));
        this.lcTree.setTitleStyle(2);
        this.lcTree.setEnableActive(false);
        this.lcTree.getContentPane().setLayout(new BorderLayout(0, 0));
        this.lcTree.getContentPane().add((Component)new JScrollPane((Component)this.tree), "Center");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.rootPanel, "Center");
        this.rootPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.tblList.setMinimumSize(new Dimension(10, 10));
        this.tree.setMinimumSize(new Dimension(10, 10));
        this.tree.setShowCheckBox(false);
        this.tblList.getSelectManager().setSelectMode(10);
        this.tblList.getStyleAttributes().setLocked(true);
        this.tblList.addColumn();
        this.tblList.addColumn().setWidth(100);
        IRow r = this.tblList.addHeadRow();
        r.getCell(0).setValue((Object)"\u6807\u9898");
        r.getCell(1).setValue((Object)"\u5168\u540d");
        this.tblList.getSelectManager().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                KDTSelectBlock b = DimensionNavigator.this.tblList.getSelectManager().get();
                if (b != null) {
                    DimensionNavigator.this.onSelectTblRow(b.getTop());
                }
            }
        });
        KDWorkButton btnUp = this.createBarButton("\u5411\u4e0a\u79fb\u52a8", Resources.getIcon("icon/tbtn_movetop.gif"));
        KDWorkButton btnDown = this.createBarButton("\u5411\u4e0b\u79fb\u52a8", Resources.getIcon("icon/tbtn_movedown.gif"));
        this.lcList.setTitle(BIComponentResource.getString(BIComponentResource.class, (String)"SelectedMember"));
        this.lcList.setTitleStyle(2);
        this.lcList.setEnableActive(false);
        this.lcList.getContentPane().setLayout(new BorderLayout(0, 0));
        this.lcList.getContentPane().add((Component)this.tblList, "Center");
        this.lcList.addButton((JButton)btnUp);
        this.lcList.addButton((JButton)btnDown);
        btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimensionNavigator.this.moveRow(true);
            }
        });
        btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DimensionNavigator.this.moveRow(false);
            }
        });
        TableLayout layout = TableLayout.split((int)3, (int)1);
        this.rootPanel.setLayout((LayoutManager)layout);
        layout.rowStyle(0).setPriY(1);
        layout.rowStyle(1).setHeight(2);
        layout.rowStyle(2).setHeight(21);
        layout.rowStyle(0).setMargin(10);
        layout.rowStyle(2).setMargin(10);
        this.rootPanel.add((Component)new KDSeparator(), (Object)layout.cell(1));
        Table centerLayout = layout.cell(0).split(1, 3);
        Table bottomLayout = layout.cell(2).split(1, 5);
        bottomLayout.colStyle(0).setPriX(1);
        this.rootPanel.add((Component)new KDButton((Action)this.actionOk), (Object)bottomLayout.cell(1));
        this.rootPanel.add((Component)new KDButton((Action)this.actionCancel), (Object)bottomLayout.cell(3));
        bottomLayout.colStyle(1).setWidth(80);
        bottomLayout.colStyle(3).setWidth(80);
        bottomLayout.colStyle(3).setMarginLeft(10);
        centerLayout.colStyle(0).setWidth(200);
        centerLayout.colStyle(1).setWidth(100);
        centerLayout.colStyle(2).setWidth(200);
        centerLayout.colStyle(0).setPriX(1);
        centerLayout.colStyle(2).setPriX(1);
        centerLayout.colStyle(1).setMarginLeft(10);
        centerLayout.colStyle(1).setMarginRight(10);
        this.rootPanel.add((Component)this.lcTree, (Object)centerLayout.cell(0));
        this.rootPanel.add((Component)this.lcList, (Object)centerLayout.cell(2));
        Table btnLayout = centerLayout.cell(1).splitRow(12);
        btnLayout.rowStyle(0).setPriY(1);
        btnLayout.rowStyle(11).setPriY(1);
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionSelectSelf), (Object)btnLayout.cell(1));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionSelectChild), (Object)btnLayout.cell(2));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionSelectDescendant), (Object)btnLayout.cell(3));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionSelectSameLevel), (Object)btnLayout.cell(4));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionSelectDetail), (Object)btnLayout.cell(5));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionDelete), (Object)btnLayout.cell(6));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionCreateCalculate), (Object)btnLayout.cell(7));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionEditCalculate), (Object)btnLayout.cell(8));
        this.rootPanel.add((Component)new KDWorkButton((Action)this.actionDeleteCalculate), (Object)btnLayout.cell(9));
        btnLayout.rowStyle(1).setMarginBottom(10);
        btnLayout.rowStyle(2).setMarginBottom(10);
        btnLayout.rowStyle(3).setMarginBottom(10);
        btnLayout.rowStyle(4).setMarginBottom(10);
        btnLayout.rowStyle(5).setMarginBottom(10);
        btnLayout.rowStyle(6).setMarginBottom(10);
        btnLayout.rowStyle(7).setMarginBottom(10);
        btnLayout.rowStyle(8).setMarginBottom(10);
        btnLayout.rowStyle(9).setMarginBottom(10);
    }

    private void moveRow(boolean isUp) {
        int to;
        int from;
        int i;
        ArrayList<Integer> selectedList = new ArrayList<Integer>();
        KDTRange r = this.tblList.getSelectManager().toRange();
        for (int i2 = 0; i2 < this.tblList.getRowCount(); ++i2) {
            if (!r.contains(0, i2)) continue;
            selectedList.add(new Integer(i2));
        }
        int n = selectedList.size();
        if (n == 0) {
            return;
        }
        int lastTo = -1;
        ArrayList<Integer> newSelectedList = new ArrayList<Integer>();
        if (isUp) {
            for (i = 0; i < n; ++i) {
                from = (Integer)selectedList.get(i);
                to = from - 1;
                if (to < 0) {
                    lastTo = 0;
                } else if (to == lastTo) {
                    lastTo = from;
                } else {
                    lastTo = to;
                    this.tblList.moveRow(from, to);
                }
                newSelectedList.add(new Integer(lastTo));
            }
        } else {
            for (i = n - 1; i >= 0; --i) {
                from = (Integer)selectedList.get(i);
                to = from + 1;
                if (to >= this.tblList.getRowCount()) {
                    lastTo = this.tblList.getRowCount() - 1;
                } else if (to == lastTo) {
                    lastTo = from;
                } else {
                    lastTo = to;
                    this.tblList.moveRow(to, from);
                }
                newSelectedList.add(new Integer(lastTo));
            }
        }
        this.tblList.getSelectManager().getBlocks().clear();
        for (int i3 = newSelectedList.size() - 1; i3 >= 0; --i3) {
            int rIndex = (Integer)newSelectedList.get(i3);
            this.tblList.getSelectManager().add(rIndex, 0, rIndex, 1);
        }
    }

    private void onSelectTblRow(int rowIndex) {
        if (this.tblList == null || this.tblList.getRowCount() == 0 || rowIndex < 0) {
            return;
        }
        IRow row = this.tblList.getRow(rowIndex);
        if (row == null) {
            return;
        }
        ListMemberItem item = (ListMemberItem)row.getUserObject();
        if (item == null) {
            return;
        }
        Enumeration em = ((DefaultKingdeeTreeNode)this.tree.getModel().getRoot()).depthFirstEnumeration();
        while (em.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)em.nextElement();
            if (!(node.getUserObject() instanceof Member) || !item.member.getUniqueName().equals(((Member)node.getUserObject()).getUniqueName())) continue;
            this.tree.setSelectionNode(node);
            this.tree.scrollPathToVisible(new TreePath(node.getPath()));
            break;
        }
    }

    private void initListener() {
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (treeNode.getChildCount() == 0) {
                    DimensionNavigator.this.expandNode(treeNode);
                }
            }
        });
    }

    private void setHierarchy(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.hierInSlicer = false;
        if (OlapModelUtil.getSliceHierarchy(this.olapModel).contains(hierarchy)) {
            this.hierInSlicer = true;
        }
        this.tree.setModel((TreeModel)new HierarchyTreeModel(hierarchy));
        ArrayList<Member> list = OlapModelUtil.findVisibleMembers(this.olapModel, hierarchy);
        if (list.size() == 0) {
            list = new ArrayList<Member>();
            Member[] members = OlapModelUtil.getSliceMembers(this.olapModel);
            for (int i = 0; i < members.length; ++i) {
                if (!members[i].getHierarchy().equals(hierarchy)) continue;
                list.add(members[i]);
                break;
            }
        }
        this.updateUIStatus();
        this.setTreeSelectionModal();
        this.addToKDList(list);
    }

    public CalculateMemberBuilder getCalculateMemberBuilder() {
        if (this.calculateMemberBuilder == null) {
            this.calculateMemberBuilder = new CalculateMemberBuilder((Dialog)((Object)this));
        }
        this.calculateMemberBuilder.setOlapModel(this.olapModel);
        return this.calculateMemberBuilder;
    }

    public boolean showForHierarchy(Hierarchy hierarchy) {
        this.setHierarchy(hierarchy);
        this.setVisible(true);
        return this.isOk;
    }

    private void setTreeSelectionModal() {
        TreeSelectionModel treeSelectionModal = this.tree.getSelectionModel();
        if (this.hierInSlicer) {
            treeSelectionModal.setSelectionMode(1);
        } else {
            treeSelectionModal.setSelectionMode(4);
        }
    }

    private MemberTree getMemberTree() {
        return OlapModelUtil.getMemberTree(this.olapModel);
    }

    private void expandNode(DefaultKingdeeTreeNode node) {
        Member member;
        if (node.getUserObject() instanceof Member && (member = (Member)node.getUserObject()) != null && OlapModelUtil.getMemberTree(this.olapModel).hasChildren(member)) {
            this.makeTree(node, OlapModelUtil.getMemberTree(this.olapModel).getChildren(member));
        }
    }

    private void makeTree(DefaultKingdeeTreeNode node, Member[] ms) {
        for (int i = 0; i < ms.length; ++i) {
            this.tree.addNodeInto((MutableTreeNode)this.createMemberNode(ms[i]), (MutableTreeNode)node);
        }
    }

    private DefaultKingdeeTreeNode createMemberNode(Member member) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)member);
        node.setText(member.getLabel());
        node.setAllowsChildren(OlapModelUtil.getMemberTree(this.olapModel).hasChildren(member));
        node.setCustomIcon((Icon)NonIcon.getInstance());
        return node;
    }

    public JComponent getJComponent() {
        return this.rootPanel;
    }

    public void render() throws AnalysisException {
    }

    public boolean isOk() {
        return this.isOk;
    }

    private void cancel() {
        this.isOk = false;
        this.setVisible(false);
    }

    private void confirm() {
        List members = this.getSelectedMembers();
        if (members == null || members.size() == 0) {
            WindowUtil.alert((Component)((Object)this), (String)BIComponentResource.getString(BIComponentResource.class, (String)"MustSelectMember"));
            return;
        }
        this.isOk = true;
        this.setVisible(false);
    }

    private void deSelect() {
        KDTRange r = this.tblList.getSelectManager().toRange();
        for (int i = this.tblList.getRowCount() - 1; i >= 0; --i) {
            if (!r.contains(0, i)) continue;
            this.tblList.removeRow(i);
        }
    }

    private void selectDescendant() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            this.selectDescendant(paths);
        }
    }

    private void selectChildren() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            this.selectChildren(paths);
        }
    }

    private void selectSelf() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths != null) {
            this.selectSelf(paths);
        }
    }

    private List collectSelectedMembers() {
        ArrayList<Member> list = new ArrayList<Member>();
        int count = this.tblList.getRowCount();
        for (int i = 0; i < count; ++i) {
            ListMemberItem item = (ListMemberItem)this.tblList.getRow(i).getUserObject();
            list.add(item.member);
        }
        return list;
    }

    public List getSelectedMembers() {
        return this.collectSelectedMembers();
    }

    private void addToKDList(List listMember) {
        this.tblList.removeRows();
        OlapModelUtil.hierarchize(this.olapModel, listMember);
        Iterator iter = listMember.iterator();
        while (iter.hasNext()) {
            IRow r = this.tblList.addRow();
            ListMemberItem item = new ListMemberItem((Member)iter.next());
            r.setUserObject((Object)item);
            r.getCell(0).setValue((Object)item.member.getCaption());
            r.getCell(1).setValue((Object)item.member.getUniqueName());
        }
    }

    private void selectSelf(TreePath[] paths) {
        ArrayList<Member> listMember = null;
        if (this.hierInSlicer) {
            Member member;
            listMember = new ArrayList<Member>();
            TreePath path = paths[0];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof Member && !listMember.contains(member = (Member)node.getUserObject())) {
                listMember.add(member);
            }
        } else {
            listMember = this.collectSelectedMembers();
            for (int i = 0; i < paths.length; ++i) {
                Member member;
                TreePath path = paths[i];
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                if (!(node.getUserObject() instanceof Member) || listMember.contains(member = (Member)node.getUserObject())) continue;
                listMember.add(member);
            }
        }
        this.addToKDList(listMember);
    }

    private void selectChildren(TreePath[] paths) {
        List listMember = this.collectSelectedMembers();
        MemberTree memberTree = this.getMemberTree();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            Member[] children = null;
            children = node.getUserObject() instanceof Member ? memberTree.getChildren((Member)node.getUserObject()) : memberTree.getRootMembers(this.hierarchy);
            if (children == null) continue;
            for (int j = 0; j < children.length; ++j) {
                if (listMember.contains(children[j])) continue;
                listMember.add(children[j]);
            }
        }
        this.addToKDList(listMember);
    }

    private void selectDescendant(TreePath[] paths) {
        List listMember = this.collectSelectedMembers();
        MemberTree memberTree = this.getMemberTree();
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            Member[] descendant = null;
            descendant = node.getUserObject() instanceof Member ? memberTree.getDescendant((Member)node.getUserObject()) : memberTree.getDescendant(this.hierarchy);
            if (descendant == null) continue;
            for (int j = 0; j < descendant.length; ++j) {
                if (listMember.contains(descendant[j])) continue;
                listMember.add(descendant[j]);
            }
        }
        this.addToKDList(listMember);
    }

    private void createCalculate() {
        CalculateMemberBuilder builder = this.getCalculateMemberBuilder();
        builder.clear();
        builder.setCurrentHierarchy(this.hierarchy);
        if (builder.showDialog()) {
            Member member = builder.getResult();
            this.tree.addNodeInto((MutableTreeNode)this.createMemberNode(member), (MutableTreeNode)this.calculateFolderNode);
        }
    }

    private void editCalculate() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null || node.getParent() != this.calculateFolderNode) {
            return;
        }
        CalculateMemberBuilder builder = this.getCalculateMemberBuilder();
        builder.clear();
        builder.setCurrentHierarchy(this.hierarchy);
        Member member = (Member)node.getUserObject();
        builder.editMember(member);
        if (builder.showDialog()) {
            builder.commitEdit();
        }
    }

    private void deleteCalculate() {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null || node.getParent() != this.calculateFolderNode) {
            return;
        }
        Member member = (Member)node.getUserObject();
        if (member instanceof KDOLAP_Member) {
            com.kingdee.bos.olap.Member kdMember = ((KDOLAP_Member)member).getKDMember();
            Formula formula = ((CalculatedMemberImpl)kdMember).getFormula();
            MdxQuery kdMdxQuery = null;
            kdMdxQuery = ((KDOLAP_QueryManager)this.olapModel.getQueryManager()).getKDQuery();
            kdMdxQuery.removeFormula(formula.getUniqeName());
        }
        this.tree.removeNodeFromParent((MutableTreeNode)node);
        ListMemberItem item = new ListMemberItem(member);
        for (int i = this.tblList.getRowCount() - 1; i >= 0; --i) {
            if (!item.equals(this.tblList.getRow(i).getUserObject())) continue;
            this.tblList.removeRow(i);
            break;
        }
    }

    private static class ListMemberItem {
        Member member;

        ListMemberItem(Member member) {
            this.member = member;
        }

        public String toString() {
            return this.member.getUniqueName();
        }

        public boolean equals(Object o) {
            return this.member.equals(((ListMemberItem)o).member);
        }
    }

    class HierarchyTreeModel
    extends DefaultTreeModel
    implements TreeModel {
        private static final long serialVersionUID = 1L;
        Hierarchy hierarchy;

        HierarchyTreeModel(Hierarchy hierarchy) {
            super(null, true);
            this.setRoot(this.createRoot(hierarchy));
            this.hierarchy = hierarchy;
            this.expandRoot();
        }

        private TreeNode createRoot(Hierarchy hierarchy) {
            this.root = new DefaultKingdeeTreeNode((Object)hierarchy);
            ((DefaultKingdeeTreeNode)this.root).setText(hierarchy.getLabel());
            return this.root;
        }

        private void expandRoot() {
            int i;
            Member[] members = DimensionNavigator.this.getMemberTree().getRootMembers(this.hierarchy);
            ArrayList<Member> calMemberList = new ArrayList<Member>();
            for (i = 0; i < members.length; ++i) {
                if (members[i].isCalculated()) {
                    calMemberList.add(members[i]);
                    continue;
                }
                ((DefaultKingdeeTreeNode)this.root).add((MutableTreeNode)DimensionNavigator.this.createMemberNode(members[i]));
            }
            ((DefaultKingdeeTreeNode)this.root).add((MutableTreeNode)this.createCalculateFolder());
            for (i = 0; i < calMemberList.size(); ++i) {
                DimensionNavigator.this.calculateFolderNode.add((MutableTreeNode)DimensionNavigator.this.createMemberNode((Member)calMemberList.get(i)));
            }
        }

        private DefaultKingdeeTreeNode createCalculateFolder() {
            DimensionNavigator.this.calculateFolderNode = new DefaultKingdeeTreeNode((Object)BIComponentResource.getString(BIComponentResource.class, (String)DimensionNavigator.CALCULATE_MEMBER_FOLDER_NAME));
            return DimensionNavigator.this.calculateFolderNode;
        }
    }

    class MyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public MyAction(String name) {
            this.putValue("Name", BIComponentResource.getString(BIComponentResource.class, (String)name));
            this.putValue("key", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = (String)this.getValue("key");
            if (key.equalsIgnoreCase(DimensionNavigator.ACTION_SELECT_SELF)) {
                DimensionNavigator.this.selectSelf();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_SELECT_CHILD)) {
                DimensionNavigator.this.selectChildren();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_SELECT_DESCENDANT)) {
                DimensionNavigator.this.selectDescendant();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_SELECT_SAMELEVEL)) {
                DimensionNavigator.this.selectSameLevel();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_SELECT_DETAIL)) {
                DimensionNavigator.this.selectDetail();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_DELETE)) {
                DimensionNavigator.this.deSelect();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_DELETE_CALCULATE)) {
                DimensionNavigator.this.deleteCalculate();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_CREATE_CALCULATE)) {
                DimensionNavigator.this.createCalculate();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_EDIT_CALCULATE)) {
                DimensionNavigator.this.editCalculate();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_OK)) {
                DimensionNavigator.this.confirm();
            } else if (key.equalsIgnoreCase(DimensionNavigator.ACTION_CANCEL)) {
                DimensionNavigator.this.cancel();
            }
        }
    }
}

