/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.common.dbcenter.pool;

import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.center.DBCenterModel;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.pool.AbstractDBPool;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.pool.DB2DBPool;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.pool.IDBPool;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.pool.OracleDBPool;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.pool.SqlServerDBPool;

public class DBPoolFactory {
    public static IDBPool createPoolInstance(DBCenterModel model) throws DBCenterException {
        AbstractDBPool pool = null;
        String type = model.getDbType();
        if ("oracle".equalsIgnoreCase(type)) {
            pool = new OracleDBPool(model);
        } else if ("sqlserver".equalsIgnoreCase(type)) {
            pool = new SqlServerDBPool(model);
        } else if ("db2".equalsIgnoreCase(type)) {
            pool = new DB2DBPool(model);
        }
        if (pool == null) {
            return null;
        }
        pool.prepare();
        pool.startPool();
        return pool;
    }
}

