/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui;

import com.kingdee.bos.ctrl.analysis.AnalysisException;
import com.kingdee.bos.ctrl.analysis.cubemodel.CubeModelResource;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.CubeModelDataProvider;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Column;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.data.model.Table;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.WizardContext;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.AbstractWizardStep;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.Cube_DefineMeasure;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.ui.stepwizard.IWizardStep;
import com.kingdee.bos.ctrl.common.ui.stepwizard.WizardDialog;
import java.awt.Dimension;
import javax.swing.JComponent;

public class Cube_SelectFactTable
extends AbstractWizardStep {
    private String oldTableName;
    CubeModelDataProvider dataProvider;

    public Cube_SelectFactTable(WizardContext context) {
        super(context);
        this.dataProvider = (CubeModelDataProvider)context.get("DataProvider");
    }

    @Override
    public void intoThisStep(IWizardStep prevStep, boolean isOppose) {
        super.intoThisStep(prevStep, isOppose);
        if (isOppose) {
            this.oldTableName = ((Table)this.context.get("FactTable")).getName();
        }
        this.manager.setPreviousStepEnabled(false);
    }

    public IWizardStep outThisStep(boolean isOppose) {
        if (!isOppose) {
            Table table = this.getSelectedTable();
            if (table == null) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"PleaseSelectFact"));
                return this;
            }
            int count = table.getColumnCount();
            boolean found = false;
            for (int i = 0; i < count; ++i) {
                Column column = table.getColumn(i);
                if (column.getDataType() != DataType.INTEGER && column.getDataType() != DataType.DECIMAL) continue;
                found = true;
                break;
            }
            if (!found) {
                this.alert(CubeModelResource.getString(CubeModelResource.class, (String)"TableNoDigitalColumn"));
                return this;
            }
            this.context.put("FactTable", table);
            if (this.oldNextStep != null && table.getName().equals(this.oldTableName)) {
                return null;
            }
            return new Cube_DefineMeasure(this.context);
        }
        return null;
    }

    private Table getSelectedTable() {
        String id = this.dataProvider.getSelectedNodeID();
        if (id == null) {
            return null;
        }
        try {
            return this.dataProvider.queryTableModel(id);
        }
        catch (AnalysisException e) {
            return null;
        }
    }

    @Override
    public void initStep(WizardDialog.StepsManager manager) {
        super.initStep(manager);
        JComponent component = this.dataProvider.getDataSelectComponent();
        component.setMinimumSize(new Dimension(80, 60));
        this.add(component, this.layout(CubeModelResource.getString(CubeModelResource.class, (String)"SelectFactTitle"), CubeModelResource.getString(CubeModelResource.class, (String)"PleaseSelectFactTable") + CubeModelResource.getString(CubeModelResource.class, (String)"FactTableNeedDigitalColumn") + CubeModelResource.getString(CubeModelResource.class, (String)"Example1") + "(" + CubeModelResource.getString(CubeModelResource.class, (String)"Product") + "Id," + CubeModelResource.getString(CubeModelResource.class, (String)"Time") + "Id," + CubeModelResource.getString(CubeModelResource.class, (String)"Store") + "Id," + CubeModelResource.getString(CubeModelResource.class, (String)"AmountAndQuantity") + ")" + CubeModelResource.getString(CubeModelResource.class, (String)"Comma") + CubeModelResource.getString(CubeModelResource.class, (String)"Example2")));
    }
}

