/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.format;

import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.format.FormatModel;
import com.kingdee.bos.ctrl.analysis.cubemodel.designer.wizard.ui.format.IFormatDataSource;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class FormatEditDialog
extends TypicalDialog
implements KDPromptSelector {
    private IFormatDataSource ds;
    private KDRadioButton rbNumber = new KDRadioButton("\u6570\u503c");
    private KDRadioButton rbPercent = new KDRadioButton("\u767e\u5206\u6570");
    private KDRadioButton rbCurrency = new KDRadioButton("\u8d27\u5e01");
    private KDLabelContainer lab1 = new KDLabelContainer("\u7cbe\u5ea6");
    private KDLabelContainer lab2 = new KDLabelContainer("\u7cbe\u5ea6");
    private KDLabelContainer lab3 = new KDLabelContainer("\u7cbe\u5ea6");
    private KDSpinner spn1 = new KDSpinner();
    private KDSpinner spn2 = new KDSpinner();
    private KDSpinner spn3 = new KDSpinner();
    private KDCheckBox cbNumberSplit = new KDCheckBox("\u5343\u5206\u4f4d");
    private KDCheckBox cbCurrencySplit = new KDCheckBox("\u5343\u5206\u4f4d");

    public FormatEditDialog(Dialog parent, IFormatDataSource ds) {
        super(parent);
        this.ds = ds;
        this.setTitle("\u5ea6\u91cf\u683c\u5f0f");
    }

    protected void todoInit() {
        int w = 325;
        int h = 184;
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((d.width - w) / 2, (d.height - h) / 2, w, h);
        this.setResizable(false);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.rbNumber);
        bg.add((AbstractButton)this.rbPercent);
        bg.add((AbstractButton)this.rbCurrency);
        this.spn1.setPreferredSize(new Dimension(80, 21));
        this.spn2.setPreferredSize(new Dimension(80, 21));
        this.spn3.setPreferredSize(new Dimension(80, 21));
        this.lab1.setBoundEditor((JComponent)this.spn1);
        this.lab2.setBoundEditor((JComponent)this.spn2);
        this.lab3.setBoundEditor((JComponent)this.spn3);
        this.lab1.setBoundLabelLength(30);
        this.lab2.setBoundLabelLength(30);
        this.lab3.setBoundLabelLength(30);
        this.lab1.setBoundLabelUnderline(true);
        this.lab2.setBoundLabelUnderline(true);
        this.lab3.setBoundLabelUnderline(true);
        this.spn1.setModel((SpinnerModel)new SpinnerNumberModel(3, 0, 15, 1));
        this.spn2.setModel((SpinnerModel)new SpinnerNumberModel(3, 0, 15, 1));
        this.spn3.setModel((SpinnerModel)new SpinnerNumberModel(3, 0, 15, 1));
        KDPanel p1 = new KDPanel();
        p1.setLayout((LayoutManager)new FlowLayout(0, 0, 0));
        p1.setOpaque(false);
        p1.add((Component)this.lab1);
        p1.add((Component)this.cbNumberSplit);
        KDPanel p2 = new KDPanel();
        p2.setLayout((LayoutManager)new FlowLayout(0, 0, 0));
        p2.setOpaque(false);
        p2.add((Component)this.lab2);
        KDPanel p3 = new KDPanel();
        p3.setLayout((LayoutManager)new FlowLayout(0, 0, 0));
        p3.setOpaque(false);
        p3.add((Component)this.lab3);
        p3.add((Component)this.cbCurrencySplit);
        Table tab = thisCell.split(9, 2);
        parent.add((Component)this.rbNumber, tab.cell(0, 0));
        parent.add((Component)p1, tab.cell(0, 1));
        tab.cell(2, 0).style().setPriY(1);
        parent.add((Component)this.rbPercent, tab.cell(3, 0));
        parent.add((Component)p2, tab.cell(3, 1));
        tab.cell(5, 0).style().setPriY(1);
        parent.add((Component)this.rbCurrency, tab.cell(6, 0));
        parent.add((Component)p3, tab.cell(6, 1));
        tab.cell(8, 0).style().setPriY(1);
    }

    public boolean isCanceled() {
        return !this.isOk;
    }

    public Object getData() {
        if (this.isOk) {
            return this.getFormatString();
        }
        return null;
    }

    public void show() {
        this.onInit(this.ds.getFormatString());
        this.showDialog();
    }

    private String getFormatString() {
        int type = -1;
        type = this.rbNumber.isSelected() ? 0 : (this.rbPercent.isSelected() ? 1 : 2);
        switch (type) {
            case 0: {
                return FormatModel.getNumberFormatString((Integer)this.spn1.getValue(), this.cbNumberSplit.isSelected());
            }
            case 1: {
                return FormatModel.getPercentFormatString((Integer)this.spn2.getValue());
            }
            case 2: {
                return FormatModel.getCurrencyFormatString((Integer)this.spn3.getValue(), this.cbCurrencySplit.isSelected());
            }
        }
        return null;
    }

    private void onInit(String formatString) {
        FormatModel model = new FormatModel(formatString);
        int type = model.getFormatType();
        switch (type) {
            case 0: {
                this.spn1.setValue((Object)new Integer(model.getPrecision()));
                this.cbNumberSplit.setSelected(model.isSplit());
                this.rbNumber.setSelected(true);
                break;
            }
            case 1: {
                this.spn2.setValue((Object)new Integer(model.getPrecision()));
                this.cbNumberSplit.setSelected(model.isSplit());
                this.rbPercent.setSelected(true);
                break;
            }
            case 2: {
                this.spn3.setValue((Object)new Integer(model.getPrecision()));
                this.cbCurrencySplit.setSelected(model.isSplit());
                this.rbCurrency.setSelected(true);
            }
        }
    }
}

