/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Axis;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olap.Position;
import com.kingdee.bos.ctrl.analysis.olap.SortRank;
import com.kingdee.bos.ctrl.analysis.report.ReportResource;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class SortRankDialog
extends TypicalDialog {
    KDCheckBox cbUse = new KDCheckBox(ReportResource.getString(ReportResource.class, (String)"Enable"));
    KDPanel sortModePanel = new KDPanel();
    KDRadioButton rbAsc = new KDRadioButton(ReportResource.getString(ReportResource.class, (String)"Asc"));
    KDRadioButton rbDesc = new KDRadioButton(ReportResource.getString(ReportResource.class, (String)"Desc"));
    KDCheckBox cbBreak = new KDCheckBox(ReportResource.getString(ReportResource.class, (String)"BreakHierarchy"));
    KDCheckBox cbTopCount = new KDCheckBox("");
    KDLabelContainer lcTopCount = new KDLabelContainer(ReportResource.getString(ReportResource.class, (String)"TopCount"));
    KDFormattedTextField tf = new KDFormattedTextField(0);
    KDLabelContainer lcPosition = new KDLabelContainer(ReportResource.getString(ReportResource.class, (String)"SelectCompareColumnMember"));
    KDPromptBox pb = new KDPromptBox();
    ColumnAxisPositionF7 f7;
    OlapModel olapModel;
    SortRank sortRank;
    boolean asc;
    boolean hiebreak;
    boolean rank;
    int count = -1;
    boolean first = true;

    public SortRankDialog() {
    }

    public SortRankDialog(Dialog owner) {
        super(owner);
    }

    public SortRankDialog(Frame owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setTitle(ReportResource.getString(ReportResource.class, (String)"SortRank"));
        this.setSize(640, 480);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this.sortModePanel.setBorder((Border)BorderFactory.createTitledBorder(ReportResource.getString(ReportResource.class, (String)"OrderOption")));
        this.sortModePanel.setLayout((LayoutManager)new FlowLayout(0));
        this.sortModePanel.add((Component)this.rbAsc);
        this.sortModePanel.add((Component)this.rbDesc);
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.rbAsc);
        bg.add((AbstractButton)this.rbDesc);
        this.lcTopCount.setBoundLabelLength(128);
        this.lcTopCount.setBoundLabelUnderline(true);
        this.lcTopCount.setBoundEditor((JComponent)this.tf);
        this.tf.setNegatived(false);
        this.tf.setGroupingUsed(false);
        this.tf.setDataVerifierType(12);
        KDPanel topCountPanel = new KDPanel();
        topCountPanel.setLayout((LayoutManager)new FlowLayout(0, 0, 5));
        topCountPanel.add((Component)this.cbTopCount);
        topCountPanel.add((Component)this.lcTopCount);
        this.lcPosition.setBoundLabelLength(150);
        this.lcPosition.setBoundLabelUnderline(true);
        this.lcPosition.setBoundEditor((JComponent)this.pb);
        this.f7 = new ColumnAxisPositionF7(new ColumnAxisPositionDialog((Dialog)((Object)this)));
        this.pb.setSelector((KDPromptSelector)this.f7);
        this.pb.setEditable(false);
        Table table = thisCell.splitRow(6);
        int index = 0;
        parent.add((Component)this.cbUse, table.cell(index++));
        parent.add((Component)this.sortModePanel, table.cell(index++));
        parent.add((Component)this.lcPosition, table.cell(index++));
        parent.add((Component)topCountPanel, table.cell(index++));
        parent.add((Component)this.cbBreak, table.cell(index++));
        table.rowStyle(index).setPriY(1);
        this.initStatus();
        this.initListener();
        this.initModel();
    }

    public void initStatus() {
        this.cbUse.setSelected(false);
        this.tf.setEnabled(false);
        this.tf.setText("10");
        this.rbDesc.setSelected(true);
        this.pb.setValue(null);
        this.setUseState();
    }

    public void initListener() {
        this.cbUse.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SortRankDialog.this.setUseState();
            }
        });
        this.cbTopCount.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SortRankDialog.this.tf.setEnabled(SortRankDialog.this.cbTopCount.isSelected());
                SortRankDialog.this.cbBreak.setEnabled(!SortRankDialog.this.cbTopCount.isSelected());
                if (SortRankDialog.this.cbTopCount.isSelected()) {
                    SortRankDialog.this.cbBreak.setSelected(true);
                }
            }
        });
    }

    private void setUseState() {
        this.rbAsc.setEnabled(this.cbUse.isSelected());
        this.rbDesc.setEnabled(this.cbUse.isSelected());
        this.pb.setEnabled(this.cbUse.isSelected());
        this.cbTopCount.setEnabled(this.cbUse.isSelected());
        if (this.cbUse.isSelected()) {
            this.tf.setEnabled(this.cbTopCount.isSelected());
            this.cbBreak.setEnabled(!this.cbTopCount.isSelected());
            if (this.cbTopCount.isSelected()) {
                this.cbBreak.setSelected(true);
            }
        } else {
            this.tf.setEnabled(false);
            this.cbBreak.setEnabled(false);
        }
    }

    public void setOlapModel(OlapModel olapModel) {
        if (this.olapModel != olapModel) {
            this.pb.setValue(null);
        }
        this.olapModel = olapModel;
        if (!this.first) {
            this.initModel();
        }
        this.first = false;
    }

    void initModel() {
        this.sortRank = (SortRank)this.olapModel.getExtension("sortRank");
        if (this.sortRank.isSorting()) {
            int sortMode = this.sortRank.getSortMode();
            switch (sortMode) {
                case 1: {
                    this.asc = true;
                    this.hiebreak = false;
                    this.rank = false;
                    break;
                }
                case 2: {
                    this.asc = false;
                    this.hiebreak = false;
                    this.rank = false;
                    break;
                }
                case 3: {
                    this.asc = true;
                    this.hiebreak = true;
                    this.rank = false;
                    break;
                }
                case 4: {
                    this.asc = false;
                    this.hiebreak = true;
                    this.rank = false;
                    break;
                }
                case 5: {
                    this.asc = false;
                    this.hiebreak = false;
                    this.rank = true;
                    break;
                }
                case 6: {
                    this.asc = true;
                    this.hiebreak = false;
                    this.rank = true;
                }
            }
            this.count = this.sortRank.getTopBottomCount();
            this.cbUse.setSelected(true);
            if (this.asc) {
                this.rbAsc.setSelected(true);
            } else {
                this.rbDesc.setSelected(true);
            }
            this.cbBreak.setSelected(this.hiebreak);
            if (this.rank) {
                this.cbTopCount.setSelected(true);
                this.tf.setText("" + this.count);
                this.cbBreak.setSelected(true);
            } else {
                this.cbTopCount.setSelected(false);
            }
            Position position = this.sortRank.getSortPosition();
            position = this.topAxisContains(this.olapModel, position);
            if (position != null) {
                this.pb.setValue((Object)position);
            } else {
                this.pb.setValue(null);
            }
            this.f7.setModel(this.olapModel, position);
        } else {
            this.cbUse.setSelected(false);
            this.f7.setModel(this.olapModel, null);
        }
        try {
            Axis leftAxis = OlapModelUtil.getLeftAxis(this.olapModel);
            this.sortRank.setAxisToSort(leftAxis.getOrdinal());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected boolean verify() {
        if (!this.cbUse.isSelected()) {
            this.sortRank.setSorting(false);
            return true;
        }
        if (this.cbTopCount.isSelected() && this.tf.getText().trim().length() == 0) {
            WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"TopCountEmpty"));
            this.tf.requestFocus();
            return false;
        }
        if (this.pb.getValue() == null) {
            WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"SelectOrderColumnMembers"));
            this.pb.requestFocus();
            return false;
        }
        this.sortRank.setSorting(true);
        this.asc = this.rbAsc.isSelected();
        this.hiebreak = this.cbBreak.isSelected();
        this.rank = this.cbTopCount.isSelected();
        Position position = (Position)this.pb.getValue();
        if (this.asc && !this.hiebreak && !this.rank) {
            this.sortRank.setSortMode(1);
        } else if (!(this.asc || this.hiebreak || this.rank)) {
            this.sortRank.setSortMode(2);
        } else if (this.asc && this.hiebreak && !this.rank) {
            this.sortRank.setSortMode(3);
        } else if (!this.asc && this.hiebreak && !this.rank) {
            this.sortRank.setSortMode(4);
        } else if (this.rank) {
            if (this.asc) {
                this.sortRank.setSortMode(6);
            } else {
                this.sortRank.setSortMode(5);
            }
            try {
                this.count = Integer.parseInt(this.tf.getText());
            }
            catch (NumberFormatException e) {
                this.count = 10;
            }
            this.sortRank.setTopBottomCount(this.count);
        }
        this.sortRank.setSortPosition(position);
        return true;
    }

    private Position topAxisContains(OlapModel olapModel, Position position) {
        Axis axis = null;
        try {
            axis = OlapModelUtil.getTopAxis(olapModel);
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        if (null == axis) {
            return null;
        }
        Hierarchy[] hies = axis.getHierarchies();
        if (hies.length != position.getMembers().length) {
            return null;
        }
        List<Hierarchy> list = Arrays.asList(hies);
        Member[] ms = position.getMembers();
        ArrayList<Hierarchy> list2 = new ArrayList<Hierarchy>();
        for (int i = 0; i < ms.length; ++i) {
            list2.add(ms[i].getHierarchy());
        }
        Iterator<Hierarchy> iter = list.iterator();
        while (iter.hasNext()) {
            if (list2.contains(iter.next())) continue;
            return null;
        }
        List poses = axis.getPositions();
        for (Position pos : poses) {
            if (!this.comparePositions(pos, position)) continue;
            return pos;
        }
        return null;
    }

    private boolean comparePositions(Position pos1, Position pos2) {
        List<Member> list1 = Arrays.asList(pos1.getMembers());
        List<Member> list2 = Arrays.asList(pos2.getMembers());
        Iterator<Member> iter = list1.iterator();
        while (iter.hasNext()) {
            if (list2.contains(iter.next())) continue;
            return false;
        }
        return true;
    }

    class ColumnAxisPositionF7
    implements KDPromptSelector {
        ColumnAxisPositionDialog dialog;

        ColumnAxisPositionF7(ColumnAxisPositionDialog dialog) {
            this.dialog = dialog;
        }

        public void setModel(OlapModel olapModel, Position position) {
            this.dialog.setModel(olapModel, position);
        }

        public void show() {
            this.dialog.showDialog();
        }

        public boolean isCanceled() {
            return !this.dialog.isOk();
        }

        public Object getData() {
            return this.dialog.getValue();
        }
    }

    class ColumnAxisPositionDialog
    extends TypicalDialog {
        KDLabel label;
        KDTable table;
        Position selected;

        public ColumnAxisPositionDialog() {
            this.label = new KDLabel(ReportResource.getString(ReportResource.class, (String)"SelectOrderColumnMembers"));
            this.table = new KDTable();
        }

        public ColumnAxisPositionDialog(Dialog owner) {
            super(owner);
            this.label = new KDLabel(ReportResource.getString(ReportResource.class, (String)"SelectOrderColumnMembers"));
            this.table = new KDTable();
        }

        public ColumnAxisPositionDialog(Frame owner) {
            super(owner);
            this.label = new KDLabel(ReportResource.getString(ReportResource.class, (String)"SelectOrderColumnMembers"));
            this.table = new KDTable();
        }

        protected void todoInit() {
            this.setTitle(ReportResource.getString(ReportResource.class, (String)"ColumnMemberSelect"));
            this.setSize(480, 400);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            Table t = thisCell.splitRow(2);
            parent.add((Component)this.label, t.cell(0));
            parent.add((Component)this.table, t.cell(1));
            t.rowStyle(1).setPriY(1);
            this.table.setEditable(false);
            this.table.getSelectManager().setSelectMode(2);
            try {
                this.table.getSelectManager().select(0, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setModel(OlapModel olapModel, Position position) {
            if (olapModel == null) {
                return;
            }
            Axis axis = null;
            try {
                axis = OlapModelUtil.getTopAxis(olapModel);
            }
            catch (OlapException e) {
                e.printStackTrace();
            }
            this.table.removeRows();
            this.table.removeColumns();
            Hierarchy[] hies = null;
            if (null != axis) {
                hies = axis.getHierarchies();
            }
            if (null != hies) {
                for (int i = 0; i < hies.length; ++i) {
                    this.table.addColumn();
                }
            }
            IRow header = this.table.addHeadRow();
            if (null != hies) {
                for (int i = 0; i < hies.length; ++i) {
                    header.getCell(i).setValue((Object)hies[i]);
                }
            }
            int index = -1;
            if (null != axis) {
                List poses = axis.getPositions();
                Iterator iter = poses.iterator();
                while (iter.hasNext()) {
                    IRow row = this.table.addRow();
                    Position pos = (Position)iter.next();
                    if (pos.equals(position)) {
                        index = row.getRowIndex();
                    }
                    Member[] ms = pos.getMembers();
                    for (int i = 0; i < hies.length; ++i) {
                        row.getCell(i).setValue((Object)ms[i]);
                        row.setUserObject((Object)pos);
                    }
                }
            }
            try {
                if (index < 0) {
                    index = 0;
                }
                this.table.getSelectManager().select(index, -1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public boolean isOk() {
            return this.isOk;
        }

        protected boolean verify() {
            if (this.table.getSelectManager().get() == null || this.table.getSelectManager().get().getTop() < 0) {
                WindowUtil.alert((Component)((Object)this), (String)ReportResource.getString(ReportResource.class, (String)"SelectOneRow"));
                return false;
            }
            IRow row = this.table.getRow(this.table.getSelectManager().get().getTop());
            this.selected = (Position)row.getUserObject();
            return true;
        }

        public Object getValue() {
            return this.selected;
        }
    }
}

