/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.report.ui.style;

import com.kingdee.bos.ctrl.analysis.bicomponent.OlapModelUtil;
import com.kingdee.bos.ctrl.analysis.olap.Dimension;
import com.kingdee.bos.ctrl.analysis.olap.Hierarchy;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.report.ui.style.HierarchyTreeModel;
import com.kingdee.bos.ctrl.analysis.util.FaceUtil;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SelectMemberDlg
extends TypicalDialog
implements KDPromptSelector {
    private OlapModel model = null;
    private KDTree tree = null;
    private Object data;

    SelectMemberDlg(Dialog parent) {
        super(parent);
        this.setSize(400, 400);
        this.setTitle("\u9009\u62e9\u6210\u5458");
        this.tree = new KDTree();
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                DefaultKingdeeTreeNode treeNode = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
                if (treeNode.getChildCount() == 0 && treeNode.getAllowsChildren()) {
                    SelectMemberDlg.this.expandNode(treeNode);
                }
            }
        });
    }

    public void setDimension(OlapModel model, Dimension dim) {
        Hierarchy hie = dim.getHierarchies()[0];
        this.model = model;
        HierarchyTreeModel treeModel = new HierarchyTreeModel(model, hie);
        this.tree.setModel((TreeModel)treeModel);
        this.tree.expandAllNodes(true, (TreeNode)treeModel.visibleMembersFolderNode);
    }

    protected void todoInit() {
        FaceUtil.center((Window)((Object)this));
    }

    private void expandNode(DefaultKingdeeTreeNode node) {
        Member member;
        if (node.getUserObject() instanceof Member && (member = (Member)node.getUserObject()) != null && OlapModelUtil.getMemberTree(this.model).hasChildren(member)) {
            this.makeTree(node, OlapModelUtil.getMemberTree(this.model).getChildren(member));
        }
    }

    private void makeTree(DefaultKingdeeTreeNode node, Member[] ms) {
        for (int i = 0; i < ms.length; ++i) {
            this.tree.addNodeInto((MutableTreeNode)this.createMemberNode(ms[i]), (MutableTreeNode)node);
        }
    }

    private DefaultKingdeeTreeNode createMemberNode(Member member) {
        DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)member);
        node.setText(member.getLabel());
        node.setAllowsChildren(OlapModelUtil.getMemberTree(this.model).hasChildren(member));
        node.setCustomIcon((Icon)NonIcon.getInstance());
        return node;
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        parent.add((Component)new KDScrollPane((Component)this.tree, 20, 30), thisCell);
    }

    public boolean isCanceled() {
        return !this.isOk;
    }

    public Object getData() {
        if (this.isOk) {
            return this.data;
        }
        return null;
    }

    public void show() {
        this.showDialog();
    }

    protected boolean verify() {
        DefaultKingdeeTreeNode node;
        Object v;
        TreePath tp = this.tree.getSelectionPath();
        if (tp != null && (v = (node = (DefaultKingdeeTreeNode)tp.getLastPathComponent()).getUserObject()) != null && v instanceof Member) {
            this.data = v;
            return true;
        }
        WindowUtil.alert((Component)((Object)this), (String)"\u8bf7\u9009\u62e9\u6210\u5458.");
        return false;
    }
}

