/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.ajax.ChartUIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.DataSourceManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.FilterUIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.MdxQueryO;
import com.kingdee.bos.ctrl.analysis.web.ajax.MdxQueryOManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.OlapModelManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.PageManager;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.SchemeUI;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.WorksheetUIO;
import com.kingdee.bos.ctrl.analysis.web.link.DimensionLinkManager;
import com.kingdee.bos.ctrl.analysis.web.piece.DynamicPiece;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReport;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.MacroVariant;
import com.kingdee.bos.ctrl.analysis.web.solution.Report;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterValue;
import com.kingdee.bos.ctrl.analysis.web.worklist.WorklistComponentManager;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class BIReportPage
extends ReportPage {
    BISubject subject;
    boolean useRepository;
    MdxQueryOManager mdxQueryOManager;
    DataSourceManager dataSourceManager;
    DimensionLinkManager dimLinkManager;
    WorklistComponentManager worklistComponentManager;
    private boolean loadingPieceFlag = false;
    private boolean isFullScreen = false;
    FilterValue fv = null;
    private Connection olapConnection;

    public BIReportPage(String pageId, BISubject subject, Report report, String type) {
        super(pageId, type, report);
        this.subject = subject;
        this.mdxQueryOManager = new MdxQueryOManager(this);
        this.dataSourceManager = new DataSourceManager(this);
        this.dimLinkManager = new DimensionLinkManager(this);
        this.worklistComponentManager = new WorklistComponentManager(this);
        this.access();
    }

    public BIReportPage(String pageId, Report report) {
        this(pageId, null, report, "olap");
    }

    public BIReportPage(String pageId, BISubject subject, BIReport report, boolean useRepository) {
        super(pageId, "olap", report);
        this.subject = subject;
        this.mdxQueryOManager = new MdxQueryOManager(this);
        this.dataSourceManager = new DataSourceManager(this);
        this.dimLinkManager = new DimensionLinkManager(this);
        this.worklistComponentManager = new WorklistComponentManager(this);
        this.useRepository = useRepository;
        this.access();
    }

    public BIReport getBIReport() {
        return (BIReport)super.getReport();
    }

    @Override
    protected String generateUI(HttpServletRequest request) throws BIReportException {
        return new SchemeUI((BIReport)this.getReport(), this.uioManager).generateUI();
    }

    @Override
    public boolean canUseRepository() {
        return this.useRepository;
    }

    public MdxQueryOManager getMdxQueryOManager() {
        return this.mdxQueryOManager;
    }

    public DataSourceManager getDataSourceManager() {
        return this.dataSourceManager;
    }

    public BISubject getSubject() {
        return this.subject;
    }

    public FilterValue getFilterValue() {
        return this.fv;
    }

    public void setFilterValue(FilterValue fv) {
        this.fv = fv;
    }

    @Override
    public void close() {
        super.close();
        this.mdxQueryOManager.release();
        if (this.olapConnection != null) {
            try {
                this.olapConnection.close();
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void releaseOlapConnection() {
        if (this.olapConnection != null) {
            try {
                this.olapConnection.close();
            }
            catch (OLAPException e) {
                e.printStackTrace();
            }
        }
        this.olapConnection = null;
    }

    public FilterComponent getFilterComponent() {
        FilterUIO filterUIO = this.uioManager.getFilterUIO();
        if (filterUIO != null) {
            return (FilterComponent)filterUIO.getComponent();
        }
        return null;
    }

    public Connection getOlapConnection(HttpServletRequest request, BIReportVarProvider varProvider) throws BIReportException {
        if (this.olapConnection != null) {
            return this.olapConnection;
        }
        return OlapModelManager.getOlapConnection(request, this.getBIReport(), varProvider, this.fv);
    }

    public String transStringByVarAndMacro(String str, BIReportVarProvider varProvider) throws BIReportException {
        String strRet = this.transStringByMacro(str, varProvider);
        strRet = this.transStringByVar(strRet, varProvider);
        return strRet;
    }

    private String transStringByVar(String str, BIReportVarProvider varProvider) throws BIReportException {
        String strRet = str;
        ScriptSQL sc = new ScriptSQL();
        strRet = sc.transSql(strRet, (AbstractVarProvider)varProvider, null, null);
        return strRet;
    }

    private String transStringByMacro(String str, BIReportVarProvider varProvider) throws BIReportException {
        List macroList;
        String strRet = str;
        if (this.getFilterComponent() != null && (macroList = this.getFilterComponent().getMacroList()) != null && macroList.size() > 0) {
            strRet = MacroVariant.handleStatement(macroList, strRet);
            varProvider.putMacroList(macroList);
        }
        return strRet;
    }

    public DimensionLinkManager getDimLinkManager() {
        return this.dimLinkManager;
    }

    public WorklistComponentManager getWorklistComponentManager() {
        return this.worklistComponentManager;
    }

    private void updateUIOSMdxQuery(MdxQueryO newMo, String newMDX, String queryName) {
        UIO[] uios = this.uioManager.getAllUIOs();
        for (int ii = 0; ii < uios.length; ++ii) {
            String mdx;
            MdxQueryO mo;
            UIO uio = uios[ii];
            if (uio instanceof WorksheetUIO) {
                if (queryName != null && !((WorksheetUIO)uio).getMdxQueryO().getName().equals(queryName)) continue;
                mo = newMo;
                if (mo == null) {
                    mdx = newMDX;
                    if (mdx == null) {
                        mdx = ((WorksheetUIO)uio).getBIReportComponent().getMdx();
                    }
                    mo = this.getMdxQueryOManager().createMdxQueryO(((WorksheetUIO)uio).getMdxQueryO().getName(), mdx);
                }
                ((WorksheetUIO)uio).updateMdxQueryO(mo);
                continue;
            }
            if (!(uio instanceof ChartUIO) || queryName != null && !((ChartUIO)uio).getMdxQueryO().getName().equals(queryName)) continue;
            mo = newMo;
            if (mo == null) {
                mdx = newMDX;
                if (mdx == null) {
                    mdx = ((ChartUIO)uio).getBIReportComponent().getMdx();
                }
                mo = this.getMdxQueryOManager().createMdxQueryO(((ChartUIO)uio).getMdxQueryO().getName(), mdx);
            }
            ((ChartUIO)uio).updateMdxQueryO(mo);
        }
    }

    public void setPiece(DynamicPiece dp) {
        this.setLoadingPiece();
        this.updateUIOSMdxQuery(null, dp.getMDX(), null);
    }

    public void restoreMdxQuery() {
        if (this.isLoadingPiece()) {
            if (this.isFullScreen) {
                this.isFullScreen = false;
                return;
            }
            this.loadingPieceFlag = false;
            this.updateUIOSMdxQuery(null, null, null);
        }
    }

    public void setLoadingPiece() {
        this.loadingPieceFlag = true;
    }

    private boolean isLoadingPiece() {
        return this.loadingPieceFlag;
    }

    @Override
    public String init(HttpServletRequest request) throws BIReportException {
        ReportPage oldPage;
        String ret = super.init(request);
        String opener = request.getParameter("opener");
        String fullscreen = request.getParameter("fullscreen");
        String schemeName = request.getParameter("schemeName");
        if (opener != null && fullscreen != null && schemeName != null && (oldPage = (ReportPage)PageManager.getPage(opener)) != null & oldPage instanceof BIReportPage) {
            MdxQueryO mo = ((BIReportPage)oldPage).getMdxQueryOManager().getMdxQueryO(schemeName);
            this.updateUIOSMdxQuery(mo, null, schemeName);
            if (((BIReportPage)oldPage).isLoadingPiece()) {
                this.setLoadingPiece();
            }
            this.isFullScreen = true;
        }
        return ret;
    }
}

