/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ajax;

import com.kingdee.bos.ctrl.analysis.web.BIWebComponent;
import com.kingdee.bos.ctrl.analysis.web.ajax.BIReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.Constants;
import com.kingdee.bos.ctrl.analysis.web.ajax.ReportPage;
import com.kingdee.bos.ctrl.analysis.web.ajax.UIO;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONList;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtFilterHandler;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReport;
import com.kingdee.bos.ctrl.analysis.web.ext.ExtReportPage;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.DataProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.MacroVariant;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilter;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItem;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.BIReportFilterItemSql;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterComponent;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterScheme;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterValue;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.ShareStrategy;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class FilterUIO
extends UIO {
    private static Logger logger = CommonLogger.getLogger(FilterUIO.class);
    FilterComponent component;

    FilterUIO(ReportPage page, BIReportFilter filterInfo, DataProvider dataProvider) {
        super(page, filterInfo.getName(), filterInfo.getCaption(), "filter", null, -1);
        this.init(page, filterInfo, dataProvider);
    }

    public void init(ReportPage page, BIReportFilter filterInfo, DataProvider dataProvider) {
        this.component = new FilterComponent(page, this.id.toString(), filterInfo, dataProvider);
    }

    @Override
    public BIWebComponent getComponent() {
        return this.component;
    }

    private JSONList getSchemeInfoList(HttpServletRequest request) throws BIReportException {
        BIReportVarProvider varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), ((BIReportPage)this.page).getSubject().getRuntimeVarFilename(), ((BIReportPage)this.page).getSubject().getRuntimeVarClassname(), this.component.getDataProvider().getDatacenter());
        ScriptSQL sc = new ScriptSQL();
        ArrayList list = new ArrayList();
        List schemeList = ((BIReportPage)this.page).getBIReport().getSchemeList();
        for (BIReportScheme scheme : schemeList) {
            List macroList;
            String schemeCaption = scheme.getCaption();
            HashMap<String, String> mapSchemeInfo = new HashMap<String, String>();
            mapSchemeInfo.put("caption", schemeCaption);
            String schemeTitle = scheme.getTitle();
            String schemeMemoHead = scheme.getMemoHead();
            String schemeMemoTail = scheme.getMemoTail();
            String schemeChartLayout = scheme.getChartLayout();
            FilterValue fv = ((BIReportPage)this.page).getFilterValue();
            if (fv != null && (macroList = fv.getMacroList()) != null && macroList.size() > 0) {
                schemeTitle = MacroVariant.handleStatement(macroList, schemeTitle);
                schemeMemoHead = MacroVariant.handleStatement(macroList, schemeMemoHead);
                schemeMemoTail = MacroVariant.handleStatement(macroList, schemeMemoTail);
                schemeChartLayout = MacroVariant.handleStatement(macroList, schemeChartLayout);
                varProvider.putMacroList(macroList);
            }
            schemeTitle = sc.transSql(schemeTitle, (AbstractVarProvider)varProvider, null, null);
            schemeMemoHead = sc.transSql(schemeMemoHead, (AbstractVarProvider)varProvider, null, null);
            schemeMemoTail = sc.transSql(schemeMemoTail, (AbstractVarProvider)varProvider, null, null);
            schemeChartLayout = sc.transSql(schemeChartLayout, (AbstractVarProvider)varProvider, null, null);
            logger.debug((Object)("[title] " + schemeTitle));
            mapSchemeInfo.put("title", schemeTitle);
            logger.debug((Object)("[head] " + schemeMemoHead));
            mapSchemeInfo.put("head", schemeMemoHead);
            logger.debug((Object)("[tail] " + schemeMemoTail));
            mapSchemeInfo.put("tail", schemeMemoTail);
            logger.debug((Object)("[chartLayout] " + schemeChartLayout));
            mapSchemeInfo.put("chartLayout", schemeChartLayout);
            list.add(mapSchemeInfo);
        }
        return new JSONList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String service(HttpServletRequest request) throws BIReportException {
        block49: {
            String requestType = request.getParameter("type");
            if (requestType.equalsIgnoreCase("init")) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.transXSL(request, Constants.PATH_XSL_FILTER, this.component));
                return sb.toString();
            }
            if (requestType.equalsIgnoreCase("action")) {
                String actionName = request.getParameter("actionName");
                try (Repository rep = null;){
                    if ("applyFilter".equals(actionName)) {
                        Object varProvider;
                        BIReportFilter filterInfo = this.page.getReport().getFilter(request);
                        int count = filterInfo.getItemCount();
                        Object[] params = new Object[count];
                        for (int i = 0; i < count; ++i) {
                            String[] strValue = request.getParameterValues("F" + (i + 1));
                            if (strValue == null) continue;
                            params[i] = Arrays.asList(strValue);
                        }
                        Object[] captionParams = new Object[count];
                        for (int i = 0; i < count; ++i) {
                            String[] strValue = request.getParameterValues("FC" + (i + 1));
                            if (strValue == null) continue;
                            captionParams[i] = Arrays.asList(strValue);
                        }
                        String ret = "true";
                        if ("olap".equalsIgnoreCase(this.page.type)) {
                            varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), ((BIReportPage)this.page).getSubject().getRuntimeVarFilename(), ((BIReportPage)this.page).getSubject().getRuntimeVarClassname(), this.component.getDataProvider().getDatacenter());
                            ((BIReportVarProvider)varProvider).verify(params);
                            this.page.setFilterParams(params);
                            this.page.setFilterCaptionParams(captionParams);
                            this.component.applyFilter(params);
                            ((BIReportPage)this.page).releaseOlapConnection();
                            ((BIReportPage)this.page).getMdxQueryOManager().release();
                            ((BIReportPage)this.page).uioManager.clearUIStatus();
                            ((BIReportPage)this.page).restoreMdxQuery();
                            ret = ret + this.getSchemeInfoList(request).toString();
                        } else if ("ext".equalsIgnoreCase(this.page.type)) {
                            ((ExtReport)this.page.getReport()).filterVerify(params, request);
                            this.page.setFilterParams(params);
                            this.page.setFilterCaptionParams(captionParams);
                        }
                        varProvider = ret;
                        return varProvider;
                    }
                    if ("delFilter".equals(actionName)) {
                        rep = BISystem.getRepository(request);
                        String caption = request.getParameter("filterName");
                        String repPath = this.page.getReport().getRepositoryPath();
                        try {
                            FilterScheme.delFilterScheme(caption, repPath, rep, request);
                        }
                        catch (BIReportException e) {
                            String captionParams = e.getMessage();
                            if (rep != null) {
                                rep.close();
                            }
                            return captionParams;
                        }
                        String e = "true";
                        return e;
                    }
                    if ("delFilterExt".equals(actionName)) {
                        try {
                            ExtFilterHandler.delFilter(request, (ExtReportPage)this.page);
                        }
                        catch (BIReportException e) {
                            String repPath = e.getMessage();
                            if (rep != null) {
                                rep.close();
                            }
                            return repPath;
                        }
                        String e = "true";
                        return e;
                    }
                    if ("saveFilterExt".equals(actionName)) {
                        String e = ExtFilterHandler.saveFilter(BISystem.getCurrentUser(request), false, this.page, request);
                        return e;
                    }
                    if ("saveFilter".equals(actionName)) {
                        rep = BISystem.getRepository(request);
                        String caption = request.getParameter("filterName");
                        BIReportFilter filter = this.page.getReport().getFilter(request);
                        String repPath = this.page.getReport().getRepositoryPath();
                        int count = filter.getItemCount();
                        Object[] valueParams = new Object[count];
                        Object[] captionParams = new Object[count];
                        for (int i = 0; i < count; ++i) {
                            String[] strValue = request.getParameterValues("V" + (i + 1));
                            if (strValue != null) {
                                valueParams[i] = Arrays.asList(strValue);
                            }
                            if ((strValue = request.getParameterValues("C" + (i + 1))) == null) continue;
                            captionParams[i] = Arrays.asList(strValue);
                        }
                        ShareStrategy ss = new ShareStrategy(request, null);
                        FilterScheme scheme = null;
                        try {
                            scheme = FilterScheme.createFilterScheme(caption, valueParams, captionParams, ss, repPath);
                        }
                        catch (BIReportException e) {
                            String string = e.getMessage();
                            if (rep != null) {
                                rep.close();
                            }
                            return string;
                        }
                        scheme.save(rep, request);
                        String string = caption;
                        return string;
                    }
                    if ("getFilterSchemesExt".equals(actionName)) {
                        String strategy = request.getParameter("shareStrategy");
                        FilterScheme[] fs = null;
                        BIReportFilter filter = this.page.getReport().getFilter(request);
                        fs = "0".equals(strategy) ? ExtFilterHandler.getFilterSchemes(request, "0", (ExtReportPage)this.page, filter) : ("1".equals(strategy) ? ExtFilterHandler.getFilterSchemes(request, "1", (ExtReportPage)this.page, filter) : ExtFilterHandler.getFilterSchemes(request, "2", (ExtReportPage)this.page, filter));
                        ArrayList list = new ArrayList();
                        for (int i = 0; i < fs.length; ++i) {
                            HashMap<String, String> map = new HashMap<String, String>(3, 1.0f);
                            map.put("caption", fs[i].getCaption());
                            map.put("value", fs[i] + "");
                            list.add(map);
                        }
                        String i = new JSONList(list).toString();
                        return i;
                    }
                    if ("getFilterSchemes".equals(actionName)) {
                        rep = BISystem.getRepository(request);
                        String strategy = request.getParameter("shareStrategy");
                        BIReportFilter filter = this.page.getReport().getFilter(request);
                        String repPath = this.page.getReport().getRepositoryPath();
                        FilterScheme[] fs = "0".equals(strategy) ? FilterScheme.getFilterSchemesSharedByUserAndOrgUnit(repPath, filter, rep) : ("1".equals(strategy) ? FilterScheme.getFilterSchemesSharedByUser(repPath, filter, rep, request) : FilterScheme.getFilterSchemesSharedByOrgUnit(repPath, filter, rep, request));
                        ArrayList list = new ArrayList();
                        for (int i = 0; i < fs.length; ++i) {
                            HashMap<String, String> map = new HashMap<String, String>(3, 1.0f);
                            map.put("caption", fs[i].getCaption());
                            map.put("value", fs[i] + "");
                            list.add(map);
                        }
                        String string = new JSONList(list).toString();
                        return string;
                    }
                    break block49;
                }
            }
            if (requestType.equalsIgnoreCase("getSqlValue")) {
                StringBuffer sb = new StringBuffer();
                String strFilterItem = request.getParameter("filterItem");
                if (strFilterItem == null) {
                    throw new BIReportException("\u7f3a\u5c11\u53c2\u6570filterItem");
                }
                int itemIndex = Integer.parseInt(strFilterItem);
                BIReportFilter filterInfo = this.page.getReport().getFilter(request);
                if ("olap".equalsIgnoreCase(this.page.type)) {
                    BIReportFilterItem item = filterInfo.getItem(itemIndex - 1);
                    if (item == null || !(item instanceof BIReportFilterItemSql)) {
                        throw new BIReportException("\u627e\u4e0d\u5230index\u4e3a " + itemIndex + " \u7684\u5bf9\u5e94\u7684BIReportFilterItemSql");
                    }
                    String strParentid = request.getParameter("parentid");
                    try {
                        BIReportVarProvider varProvider = new BIReportVarProvider(BISystem.getContext(request), !BISystem.isEAS(), ((BIReportPage)this.page).getSubject().getRuntimeVarFilename(), ((BIReportPage)this.page).getSubject().getRuntimeVarClassname(), this.component.getDataProvider().getDatacenter());
                        if (strParentid == null) {
                            this.component.getSqlValues(varProvider, sb, (BIReportFilterItemSql)item);
                        } else {
                            this.component.getSqlValues(varProvider, sb, (BIReportFilterItemSql)item, strParentid);
                        }
                    }
                    catch (Exception e) {
                        throw new BIReportException(e);
                    }
                    return sb.toString();
                }
                if ("ext".equalsIgnoreCase(this.page.type)) {
                    return ((ExtReport)this.page.getReport()).getFilterF7(itemIndex - 1, null, request);
                }
            }
        }
        return null;
    }
}

