/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard;

import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardPage;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DataSource;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.ButtonDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.ChartDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.CheckBoxDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.DatePickerDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.EASKPIDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.KPIChartDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.KPIMonitorDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.NavigationDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.PictureDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.PieceDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.ProgressDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.RadioBoxDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.SelectDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.SliderDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.TableDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.TextDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.TextDialStyle;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.TreePickerDial;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.URLDial;
import com.kingdee.bos.ctrl.analysis.web.solution.util.IDGenerator;
import com.kingdee.bos.ctrl.analysis.web.sql.SQLMeta;
import com.kingdee.bos.ctrl.analysis.web.sql.SQLProvider;
import com.kingdee.bos.ctrl.analysis.web.variant.TextVariant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;

public class DashBoard {
    private Document doc;
    private String layoutInfo;
    private static final String SPLIT_KPI_1 = "@/";
    private static final String SPLIT_KPI_2 = "@//";
    private static final String SPLIT_KPI_3 = "@///";
    private static final int TABLE_CELL_SPACING = 10;
    private TextVariant textVvariant = null;

    public DashBoard(String xml) throws DocumentException {
        this.doc = DocumentHelper.parseText((String)xml);
    }

    public List getPieces() {
        return this.getCells("piece");
    }

    public List getResources() {
        return this.getCells("picture");
    }

    private List getCells(String cellType) {
        ArrayList<String> list = new ArrayList<String>();
        List cells = this.doc.selectNodes("/DashBoard/Contents/Cell");
        for (Element cell : cells) {
            String type = cell.attributeValue("type");
            if (!cellType.equalsIgnoreCase(type)) continue;
            list.add(cell.getText());
        }
        return list;
    }

    String lookup(String xpath) {
        return this.doc.valueOf(xpath);
    }

    TextDialStyle getStyle(String id) {
        return new TextDialStyle((Element)this.doc.selectSingleNode("/DashBoard/Styles/Style[@id='" + id + "']"));
    }

    Dial getDial(Element cell, DashBoardPage page, HttpServletRequest request) throws DashBoardException {
        Dial dial = null;
        String id = cell.attributeValue("id");
        String type = cell.attributeValue("type");
        String name = cell.attributeValue("name");
        if (name == null) {
            name = "";
        }
        if ("text".equals(type)) {
            String styleId = cell.attributeValue("style");
            String linkType = cell.attributeValue("linkType");
            String linkTip = cell.attributeValue("linkTip");
            String linkURI = cell.attributeValue("linkURI");
            String linkReportType = cell.attributeValue("linkReportType");
            String isTab = cell.attributeValue("isTab");
            dial = new TextDial(id, cell.getText(), this.getStyle(styleId), this.getTextVariant(), name, page.getVarProvider(), linkType, linkTip, linkURI, linkReportType, isTab);
        } else if ("piece".equalsIgnoreCase(type)) {
            String title = cell.attributeValue("title");
            dial = new PieceDial(id, cell.getText(), title == null ? "" : title, "true".equals(cell.attributeValue("showTitle")), "true".equals(cell.attributeValue("canDrill")), page.getOlapModelManager(), name);
        } else if ("picture".equalsIgnoreCase(type)) {
            String title = cell.attributeValue("title");
            String linkType = cell.attributeValue("linkType");
            String linkTip = cell.attributeValue("linkTip");
            String linkURI = cell.attributeValue("linkURI");
            String linkReportType = cell.attributeValue("linkReportType");
            String isTab = cell.attributeValue("isTab");
            dial = new PictureDial(id, cell.getText(), title == null ? "" : title, "true".equals(cell.attributeValue("showTitle")), cell.attributeValue("scale"), name, linkType, linkTip, linkURI, linkReportType, isTab);
        } else if ("table".equals(type)) {
            String title = cell.attributeValue("title");
            String dsId = cell.attributeValue("ds");
            String sustainPageSize = cell.attributeValue("sustainPageSize");
            String pageSize = cell.attributeValue("pageSize");
            if (dsId == null || "".equals(dsId)) {
                throw new DashBoardException("\u627e\u4e0d\u5230\u5217\u8868\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fd\u5217\u8868\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
            }
            ArrayList<String> outputList = new ArrayList<String>();
            Iterator it = cell.selectNodes("./OutputColumns/OutputColumn").iterator();
            while (it.hasNext()) {
                outputList.add(((Element)it.next()).getText());
            }
            dial = new TableDial(id, title == null ? "" : title, "true".equals(cell.attributeValue("showTitle")), page.getDataSource(dsId), outputList, name, sustainPageSize, pageSize);
        } else if ("chart".equals(type)) {
            String title = cell.attributeValue("title");
            String dsId = cell.attributeValue("ds");
            if (dsId == null || "".equals(dsId)) {
                throw new DashBoardException("\u627e\u4e0d\u5230\u56fe\u8868\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fd\u56fe\u8868\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
            }
            String chartType = cell.selectSingleNode("./Type").getText();
            ArrayList<String> xs = new ArrayList<String>();
            Iterator it = cell.selectNodes("./Xs/X").iterator();
            while (it.hasNext()) {
                xs.add(((Element)it.next()).getText());
            }
            ArrayList<String> ys = new ArrayList<String>();
            Iterator it2 = cell.selectNodes("./Ys/Y").iterator();
            while (it2.hasNext()) {
                ys.add(((Element)it2.next()).getText());
            }
            ArrayList<String> ms = new ArrayList<String>();
            Iterator it3 = cell.selectNodes("./Measures/Measure").iterator();
            while (it3.hasNext()) {
                ms.add(((Element)it3.next()).getText());
            }
            dial = new ChartDial(id, page.getDataSource(dsId), chartType, xs.toArray(new String[0]), ys.toArray(new String[0]), ms.toArray(new String[0]), title == null ? "" : title, "true".equals(cell.attributeValue("showTitle")), name);
        } else if ("kpi".equals(type)) {
            String title = cell.attributeValue("title");
            String dsId = cell.attributeValue("ds");
            if (dsId == null || "".equals(dsId)) {
                throw new DashBoardException("\u627e\u4e0d\u5230KPI\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fdKPI\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
            }
            String intemsInfo = cell.elementText("ITEMSINFO");
            String paremInfo = "";
            HashMap<String, String> mapParams = new HashMap<String, String>();
            if (intemsInfo == null || intemsInfo == "") {
                String maindimensionv = cell.elementText("MainDimension");
                String kpiprojectv = cell.elementText("KPIPV");
                String itemName = cell.elementText("KPIDV");
                String itemLable = cell.elementText("KPILabel");
                String dispalyType = "KPI";
                String chartType = cell.elementText("Type");
                String pointValue = cell.element("PointV").elementText("PointV");
                String minValue = cell.element("MinV").elementText("MinV");
                String warmningValue = cell.element("AlertV").elementText("AlertV");
                String goodValue = cell.element("GoodV").elementText("GoodV");
                String maxValue = cell.element("MaxV").elementText("MaxV");
                paremInfo = paremInfo + itemName + SPLIT_KPI_1 + itemLable + SPLIT_KPI_1 + dispalyType + SPLIT_KPI_1 + chartType + SPLIT_KPI_1 + pointValue + SPLIT_KPI_1 + minValue + SPLIT_KPI_1 + warmningValue + SPLIT_KPI_1 + goodValue + SPLIT_KPI_1 + maxValue;
                mapParams.put("maindimensionv", maindimensionv);
                mapParams.put("kpiprojectv", kpiprojectv);
                mapParams.put("intemsInfov", paremInfo);
            } else {
                String maindimensionv = cell.elementText("MainDimension");
                String kpiprojectv = cell.elementText("KPIPV");
                mapParams.put("maindimensionv", maindimensionv);
                mapParams.put("kpiprojectv", kpiprojectv);
                mapParams.put("intemsInfov", intemsInfo);
            }
            dial = new KPIChartDial(id, title == null ? "" : title, "true".equals(cell.attributeValue("showTitle")), page.getDataSource(dsId), name, mapParams);
        } else {
            if ("input".equals(type)) {
                throw new DashBoardException("\u4ea4\u4e92\u5f0f\u7ec4\u4ef6\u672a\u7ed1\u5b9a\u7c7b\u578b");
            }
            if ("select".equals(type)) {
                String dsId = cell.attributeValue("ds");
                String DSType = cell.attributeValue("DSType");
                if (DSType != null && DSType.equals("0") && (dsId == null || "".equals(dsId))) {
                    throw new DashBoardException("\u627e\u4e0d\u5230\u4ea4\u4e92\u5f0f\u7ec4\u4ef6\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fd\u4ea4\u4e92\u5f0f\u7ec4\u4ef6\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
                }
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", id);
                map.put("ds", page.getDataSource(dsId));
                map.put("hintText", cell.attributeValue("hintText"));
                map.put("width", cell.attributeValue("width"));
                map.put("captionColumn", cell.attributeValue("captionColumn"));
                map.put("valueColumn", cell.attributeValue("valueColumn"));
                map.put("name", name);
                map.put("emptyItem", cell.attributeValue("emptyItem"));
                map.put("emptyItemEnable", cell.attributeValue("emptyItemEnable"));
                map.put("script", script);
                map.put("DSType", DSType);
                map.put("dim_appModel", cell.attributeValue("dim_appModel"));
                map.put("dim_apply", cell.attributeValue("dim_apply"));
                map.put("dim_apply_caption", cell.attributeValue("dim_apply_caption"));
                map.put("dim_captionColumn", cell.attributeValue("dim_captionColumn"));
                map.put("dim_valueColumn", cell.attributeValue("dim_valueColumn"));
                dial = new SelectDial(map);
            } else if ("treePicker".equals(type)) {
                String dsId = cell.attributeValue("ds");
                String DSType = cell.attributeValue("DSType");
                if (DSType != null && DSType.equals("0") && (dsId == null || "".equals(dsId))) {
                    throw new DashBoardException("\u627e\u4e0d\u5230\u4ea4\u4e92\u5f0f\u7ec4\u4ef6\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fd\u4ea4\u4e92\u5f0f\u7ec4\u4ef6\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
                }
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                String node_prikey = cell.attributeValue("node_prikey");
                String node_fkey = cell.attributeValue("node_fkey");
                String node_caption = cell.attributeValue("node_caption");
                String node_rvalue = cell.attributeValue("node_rvalue");
                String muti_check = cell.attributeValue("muti_check");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", id);
                map.put("ds", page.getDataSource(dsId));
                map.put("hintText", cell.attributeValue("hintText"));
                map.put("width", cell.attributeValue("width"));
                map.put("node_prikey", node_prikey);
                map.put("node_fkey", node_fkey);
                map.put("node_caption", node_caption);
                map.put("node_rvalue", node_rvalue);
                map.put("muti_check", muti_check);
                map.put("name", name);
                map.put("script", script);
                map.put("DSType", DSType);
                map.put("dim_appModel", cell.attributeValue("dim_appModel"));
                map.put("dim_apply", cell.attributeValue("dim_apply"));
                map.put("dim_node_prikey", cell.attributeValue("dim_node_prikey"));
                map.put("dim_node_fkey", cell.attributeValue("dim_node_fkey"));
                map.put("dim_apply_caption", cell.attributeValue("dim_apply_caption"));
                map.put("dim_captionColumn", cell.attributeValue("dim_captionColumn"));
                map.put("dim_valueColumn", cell.attributeValue("dim_valueColumn"));
                dial = new TreePickerDial(map);
            } else if ("datePicker".equals(type)) {
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                String hintText = cell.attributeValue("hintText");
                String width = cell.attributeValue("width");
                String defaultDate = cell.attributeValue("defaultDate");
                String useSystemDate = cell.attributeValue("useSystemDate");
                dial = new DatePickerDial(id, hintText, width, name, defaultDate, useSystemDate, script);
            } else if ("button".equals(type)) {
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                dial = new ButtonDial(id, cell.attributeValue("hintText"), cell.attributeValue("width"), name, script);
            } else if ("checkbox".equals(type)) {
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                dial = new CheckBoxDial(id, cell.attributeValue("hintText"), cell.attributeValue("isChecked"), name, script);
            } else if ("radiobox".equals(type)) {
                String dsId = cell.attributeValue("ds");
                String DSType = cell.attributeValue("DSType");
                if (DSType != null && DSType.equals("0") && (dsId == null || "".equals(dsId))) {
                    throw new DashBoardException("\u627e\u4e0d\u5230\u4ea4\u4e92\u5f0f\u7ec4\u4ef6\u7ed1\u5b9a\u7684\u6570\u636e\u6e90\u3002\u53ef\u80fd\u4ea4\u4e92\u5f0f\u7ec4\u4ef6\u5c1a\u672a\u7ed1\u5b9a\u6570\u636e\u6e90\u6216\u8005\u8be5\u6570\u636e\u6e90\u5df2\u7ecf\u88ab\u5220\u9664\u3002");
                }
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", id);
                map.put("ds", page.getDataSource(dsId));
                map.put("hintText", cell.attributeValue("hintText"));
                map.put("captionColumn", cell.attributeValue("captionColumn"));
                map.put("valueColumn", cell.attributeValue("valueColumn"));
                map.put("name", name);
                map.put("emptyItem", cell.attributeValue("emptyItem"));
                map.put("emptyItemEnable", cell.attributeValue("emptyItemEnable"));
                map.put("script", script);
                map.put("DSType", DSType);
                map.put("dim_appModel", cell.attributeValue("dim_appModel"));
                map.put("dim_apply", cell.attributeValue("dim_apply"));
                map.put("dim_apply_caption", cell.attributeValue("dim_apply_caption"));
                map.put("dim_captionColumn", cell.attributeValue("dim_captionColumn"));
                map.put("dim_valueColumn", cell.attributeValue("dim_valueColumn"));
                dial = new RadioBoxDial(map);
            } else if ("slider".equals(type)) {
                String dsId = cell.attributeValue("ds");
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                dial = new SliderDial(id, page.getDataSource(dsId), cell.attributeValue("hintText"), cell.attributeValue("width"), cell.attributeValue("valign"), cell.attributeValue("maxValue_select"), cell.attributeValue("maxValue_input"), cell.attributeValue("minValue_select"), cell.attributeValue("minValue_input"), cell.attributeValue("distance_select"), cell.attributeValue("distance_input"), cell.attributeValue("step_select"), cell.attributeValue("step_input"), cell.attributeValue("dfValue_select"), cell.attributeValue("dfValue_input"), cell.attributeValue("unit_input"), name, script);
            } else if ("progress".equals(type)) {
                String dsId = cell.attributeValue("ds");
                Node scriptNode = cell.selectSingleNode("./Script");
                if (name == null || "".equals(name)) {
                    throw new DashBoardException("\u8fdb\u5ea6\u6761\u672a\u5b9a\u4e49\uff01");
                }
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < cell.elements().size(); ++i) {
                    sb.append(((Element)cell.elements().get(i)).attributeValue("number") + ",").append(((Element)cell.elements().get(i)).attributeValue("name") + ",").append(((Element)cell.elements().get(i)).attributeValue("value") + ",").append(((Element)cell.elements().get(i)).attributeValue("color"));
                    if (i == cell.elements().size() - 1) continue;
                    sb.append("&");
                }
                dial = new ProgressDial(id, page.getDataSource(dsId), cell.attributeValue("width"), cell.attributeValue("valign"), cell.attributeValue("maxValue_select"), cell.attributeValue("maxValue_input"), cell.attributeValue("minValue_select"), cell.attributeValue("minValue_input"), cell.attributeValue("distance_select"), cell.attributeValue("distance_input"), cell.attributeValue("hintText_select"), cell.attributeValue("hintText_input"), cell.attributeValue("progress_select"), cell.attributeValue("progress_input"), cell.attributeValue("scaledistance_select"), cell.attributeValue("scaledistance_input"), cell.attributeValue("line_input"), name, cell.attributeValue("per_checkbox"), cell.attributeValue("color_input"), sb.toString(), script);
            } else if ("navigation".equals(type)) {
                if (name == null || "".equals(name)) {
                    throw new DashBoardException("\u5bfc\u822a\u7ec4\u4ef6\u672a\u5b9a\u4e49\uff01");
                }
                Node scriptNode = cell.selectSingleNode("./Script");
                String script = "";
                if (scriptNode != null) {
                    script = scriptNode.getText();
                }
                ArrayList list = new ArrayList();
                for (int i = 0; i < cell.elements().size(); ++i) {
                    HashMap<String, String> m = new HashMap<String, String>();
                    Element e = (Element)cell.elements().get(i);
                    m.put("xStart", e.attributeValue("xStart"));
                    m.put("yStart", e.attributeValue("yStart"));
                    m.put("xEnd", e.attributeValue("xEnd"));
                    m.put("yEnd", e.attributeValue("yEnd"));
                    m.put("index", e.attributeValue("index"));
                    m.put("name", e.attributeValue("name"));
                    m.put("link", e.attributeValue("link"));
                    m.put("linkPath", e.attributeValue("linkPath"));
                    m.put("linkType", e.attributeValue("linkType"));
                    m.put("tooltip", e.attributeValue("tooltip"));
                    m.put("openType", e.attributeValue("openType"));
                    m.put("shape", e.attributeValue("shape"));
                    m.put("isShade", e.attributeValue("isShade"));
                    m.put("shadeColor", e.attributeValue("shadeColor"));
                    m.put("shadeAlpha", e.attributeValue("shadeAlpha"));
                    list.add(m);
                }
                dial = new NavigationDial(id, cell.attributeValue("width"), cell.attributeValue("height"), cell.attributeValue("titleName"), name, "true".equals(cell.attributeValue("isShowTitle")), cell.attributeValue("picPath"), cell.attributeValue("isZoom"), list, script);
            } else if ("url".equals(type)) {
                String url = cell.selectSingleNode("./URL").getText();
                if ("".equals(url)) {
                    throw new DashBoardException("\u7f51\u9875\u7ec4\u4ef6\u672a\u7ed1\u5b9aURL");
                }
                dial = new URLDial(id, url, name);
            } else if ("easkpi".equals(type)) {
                String kpi = cell.getText();
                dial = new EASKPIDial(id, kpi, name, request);
            } else if ("kpiMonitor".equalsIgnoreCase(type)) {
                HashMap<String, String> baseInfo = new HashMap<String, String>();
                int compWidth = 240;
                int compHeight = 160;
                try {
                    compWidth = Integer.parseInt(cell.attributeValue("metricWidth"));
                    compHeight = Integer.parseInt(cell.attributeValue("metricHeight"));
                }
                catch (NumberFormatException e) {
                    throw new DashBoardException("\u6307\u6807\u76d1\u63a7\u5355\u4e2a\u7ec4\u4ef6\u7684\u9ad8\u5ea6\u6216\u5bbd\u5ea6\u53ea\u80fd\u662f\u5927\u4e8e0\u7684\u6574\u6570\uff01<br>\u5bbd\u5ea6\u3010" + cell.attributeValue("metricWidth") + "\u3011\uff0c\u9ad8\u5ea6\u3010" + cell.attributeValue("metricHeight") + "\u3011");
                }
                baseInfo.put("id", id);
                baseInfo.put("name", name);
                baseInfo.put("title", cell.attributeValue("title"));
                baseInfo.put("showTitle", cell.attributeValue("showTitle"));
                baseInfo.put("uiid", IDGenerator.getID());
                baseInfo.put("kpiMonitorId", cell.attributeValue("kpiMonitor"));
                baseInfo.put("metricWidth", Integer.toString(compWidth));
                baseInfo.put("metricHeight", Integer.toString(compHeight));
                baseInfo.put("metricAutoFlow", cell.attributeValue("metricAutoFlow"));
                baseInfo.put("monitorType", "metric");
                dial = new KPIMonitorDial(id, baseInfo);
            }
        }
        return dial;
    }

    DataSource getDataSource(String id) {
        Element ds = (Element)this.doc.selectSingleNode("/DashBoard/DataSources/DataSource[@name='" + id + "']");
        int maxRowCount = Integer.parseInt(ds.attributeValue("maxRowCount"));
        String sql = ds.selectSingleNode("./Content").getText();
        String datacenter = ds.attributeValue("datacenter");
        TreeMap<DataSource.OutputColumnEntry, String> map = new TreeMap<DataSource.OutputColumnEntry, String>();
        int order = 1;
        for (Element oc : ds.selectNodes("./OutputColumns/OutputColumn")) {
            map.put(new DataSource.OutputColumnEntry(oc.attribute("column").getValue(), order), oc.attribute("alias").getValue());
            ++order;
        }
        return new DataSource(id, datacenter, sql, maxRowCount, map);
    }

    private TextVariant getTextVariant() {
        if (this.textVvariant != null) {
            return this.textVvariant;
        }
        this.textVvariant = new TextVariant(new SQLProvider(this.getSQLMetaList()));
        return this.textVvariant;
    }

    private List getSQLMetaList() {
        ArrayList<SQLMeta> list = new ArrayList<SQLMeta>();
        for (Element ele : this.doc.selectNodes("/DashBoard/Variants/Sql")) {
            String des;
            String sqlname = ele.attributeValue("name");
            Node nodeContent = ele.selectSingleNode("Content");
            String sql = nodeContent == null ? null : nodeContent.getText();
            Node nodeDes = ele.selectSingleNode("Description");
            String string = des = nodeDes == null ? null : nodeDes.getText();
            if (sql == null) continue;
            SQLMeta sqlMeta = new SQLMeta(sqlname, sql, des);
            list.add(sqlMeta);
        }
        return list;
    }

    List getDials(DashBoardPage page, HttpServletRequest request) throws DashBoardException {
        ArrayList<Dial> list = new ArrayList<Dial>();
        for (Element cell : this.doc.selectNodes("/DashBoard/Contents/Cell")) {
            list.add(this.getDial(cell, page, request));
        }
        for (Element cell : this.doc.selectNodes("/DashBoard/ExtContents/Cell")) {
            list.add(this.getDial(cell, page, request));
        }
        return list;
    }

    List getDataSources() {
        ArrayList<DataSource> list = new ArrayList<DataSource>();
        for (Attribute attr : this.doc.selectNodes("/DashBoard/DataSources/DataSource/@name")) {
            list.add(this.getDataSource(attr.getValue()));
        }
        return list;
    }

    Map getBackgroundInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        Element bg = (Element)this.doc.selectSingleNode("/DashBoard/Page/Background");
        map.put("color", bg.attributeValue("color"));
        map.put("url", bg.getText());
        map.put("scale", bg.attributeValue("scale"));
        return map;
    }

    String getPageScript() {
        Node node = this.doc.selectSingleNode("/DashBoard/Page/Script");
        return node != null ? node.getText() : null;
    }

    String getDashBoardHeight() {
        Element layout = (Element)this.doc.selectSingleNode("/DashBoard/Layout");
        String layoutHeight = layout.attributeValue("height");
        return layoutHeight;
    }

    String getLayoutInfo() {
        if (this.layoutInfo != null) {
            return this.layoutInfo;
        }
        Element layout = (Element)this.doc.selectSingleNode("/DashBoard/Layout");
        Document hDoc = DocumentHelper.createDocument();
        Element hTable = new DefaultElement("table").addAttribute("id", "layout_table" + IDGenerator.getID()).addAttribute("cellpadding", "0").addAttribute("cellspacing", "10");
        hDoc.add(hTable);
        int layoutWidth = Integer.parseInt(layout.attributeValue("width"));
        int layoutHeight = Integer.parseInt(layout.attributeValue("height"));
        HashMap<String, String> widthMap = new HashMap<String, String>();
        Node table = this.doc.selectSingleNode("/DashBoard/Layout/Table");
        List colList = table.selectSingleNode("./ColGroup").selectNodes("./Col");
        int counter = 0;
        Iterator it = colList.iterator();
        while (it.hasNext()) {
            String w = ((Element)it.next()).attributeValue("width");
            widthMap.put(counter + "", w);
            ++counter;
        }
        List rowList = table.selectSingleNode("./TBody").selectNodes("./TR");
        Iterator it2 = rowList.iterator();
        while (it2.hasNext()) {
            Element hTR = hTable.addElement("tr");
            Element tr = (Element)it2.next();
            Attribute height = tr.attribute("height");
            if (height != null) {
                hTR.addAttribute("height", height.getValue());
            }
            List tdList = tr.selectNodes("./TD");
            counter = 0;
            Iterator iter = tdList.iterator();
            while (iter.hasNext()) {
                String tdName;
                Element hTD = hTR.addElement("td");
                hTD.addText("");
                hTD.addAttribute("width", (String)widthMap.get(counter + ""));
                Element td = (Element)iter.next();
                Node div = td.selectSingleNode("./Div");
                if (div != null) {
                    hTD.addAttribute("id", "dashboard_element_" + IDGenerator.getID() + "_" + ((Element)div).attributeValue("cell"));
                }
                if ((tdName = td.attributeValue("name")) != null && !"".equals(tdName)) {
                    hTD.addAttribute("cellName", tdName);
                }
                ++counter;
            }
        }
        if (table.selectSingleNode("./MergeBlocks") != null) {
            List mergeList = table.selectSingleNode("./MergeBlocks").selectNodes("./Block");
            int[] merge = this.sortMerge(mergeList);
            for (int y = 0; y < merge.length; ++y) {
                int i;
                String mergers = String.valueOf(merge[y]);
                int left = Integer.parseInt(mergers.substring(1, 2));
                int right = Integer.parseInt(mergers.substring(2, 3));
                int top = Integer.parseInt(mergers.substring(3, 4));
                int bottom = Integer.parseInt(mergers.substring(4, 5));
                int colspan = right - left + 1;
                int rowspan = bottom - top + 1;
                Element hTR = (Element)hTable.selectSingleNode("./tr[" + (top + 1) + "]");
                int begin = left + 1;
                Element hTD = null;
                while ((hTD = (Element)hTR.selectSingleNode("./td[" + begin + "]")) == null && --begin >= 0) {
                }
                if (colspan > 1) {
                    hTD.addAttribute("colspan", "" + colspan);
                    for (i = 1; i < colspan; ++i) {
                        Element removingTD = (Element)hTR.selectSingleNode("./td[" + (left + 2) + "]");
                        if (removingTD == null) continue;
                        String extendedWidth = removingTD.attributeValue("width");
                        String baseWidth = hTD.attributeValue("width");
                        hTD.addAttribute("width", this.calcWidthOrHeight(layoutWidth, baseWidth, extendedWidth));
                        hTR.remove(removingTD);
                    }
                }
                if (rowspan <= 1) continue;
                hTD.addAttribute("rowspan", "" + rowspan);
                for (i = 1; i < rowspan; ++i) {
                    Element hTRi = (Element)hTable.selectSingleNode("./tr[" + (top + 1 + i) + "]");
                    for (int j = 0; j < colspan; ++j) {
                        hTRi.remove(hTRi.selectSingleNode("./td[" + (left + 1) + "]"));
                    }
                }
            }
        }
        return hDoc.asXML().replaceAll("<\\?xml.*?\\?>", "").trim();
    }

    private int[] sortMerge(List mergeList) {
        String strblack = "";
        int size = mergeList.size();
        for (int i = 0; i < size; ++i) {
            Element block = (Element)mergeList.get(i);
            String left = block.attributeValue("left");
            String right = block.attributeValue("right");
            String top = block.attributeValue("top");
            String bottom = block.attributeValue("bottom");
            strblack = strblack + ",1" + left + right + top + bottom;
        }
        String[] blacks = strblack.substring(1, strblack.length()).split(",");
        int[] nums = new int[blacks.length];
        for (int z = 0; z < blacks.length; ++z) {
            nums[z] = Integer.parseInt(blacks[z]);
        }
        for (int a = 0; a < size; ++a) {
            for (int j = 0; j < size - 1; ++j) {
                if (nums[j + 1] <= nums[j]) continue;
                int temp = nums[j];
                nums[j] = nums[j + 1];
                nums[j + 1] = temp;
            }
        }
        return nums;
    }

    private String calcWidthOrHeight(int totalWidthOrHeight, String baseWidthOrHeight, String extendedWidthOrHeight) {
        int extended;
        int n;
        int base;
        if (baseWidthOrHeight.matches("\\d+")) {
            base = Integer.parseInt(baseWidthOrHeight);
        } else if (baseWidthOrHeight.matches("\\d+\\%")) {
            n = Integer.parseInt(baseWidthOrHeight.substring(0, baseWidthOrHeight.length() - 1));
            base = totalWidthOrHeight * n / 100;
        } else {
            throw new IllegalArgumentException("\u57fa\u7840\u6269\u5c55\u5bbd\u5ea6\u6216\u8005\u9ad8\u5ea6\u5c5e\u6027\u9519\u8bef\uff1a\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u6574\u6570\u6216\u8005\u767e\u5206\u6570");
        }
        if (extendedWidthOrHeight.matches("\\d+")) {
            extended = Integer.parseInt(extendedWidthOrHeight);
        } else if (extendedWidthOrHeight.matches("\\d+\\%")) {
            n = Integer.parseInt(extendedWidthOrHeight.substring(0, extendedWidthOrHeight.length() - 1));
            extended = totalWidthOrHeight * n / 100;
        } else {
            throw new IllegalArgumentException("\u6269\u5c55\u5bbd\u5ea6\u6216\u8005\u9ad8\u5ea6\u5c5e\u6027\u9519\u8bef\uff1a\u53ea\u80fd\u8bbe\u7f6e\u4e3a\u6574\u6570\u6216\u8005\u767e\u5206\u6570");
        }
        return base + extended + 10 + "";
    }

    public List getNavigationPicPaths() {
        ArrayList<String> list = new ArrayList<String>();
        for (Element ele : this.doc.selectNodes("/DashBoard/Contents/Cell[@type='navigation']")) {
            list.add(ele.attribute("picPath").getValue());
        }
        return list;
    }
}

