/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.dashboard.dial;

import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSON;
import com.kingdee.bos.ctrl.analysis.web.ajax.json.JSONMap;
import com.kingdee.bos.ctrl.analysis.web.dashboard.DashBoardException;
import com.kingdee.bos.ctrl.analysis.web.dashboard.dial.Dial;
import com.kingdee.bos.ctrl.analysis.web.easkpi.EASKPI;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class EASKPIDial
implements Dial {
    private static Logger logger = CommonLogger.getLogger(EASKPIDial.class);
    private String id = "";
    private String name;
    EASKPI eas_kpi = null;

    public EASKPIDial(String id, String kpi, String name, HttpServletRequest req) {
        this.id = id;
        this.name = name;
        String ou = null;
        String cu = null;
        try {
            ou = BISystem.getCurrentOrgUnitID(req);
            cu = BISystem.getCurrentCU(req);
        }
        catch (BIReportException e) {
            logger.error((Object)e);
        }
        this.eas_kpi = new EASKPI(kpi, ou, cu);
    }

    @Override
    public String getType() {
        return "easkpi";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JSON init(HttpServletRequest request) throws BIReportException {
        this.eas_kpi.init(request);
        return this.toJSON(request);
    }

    @Override
    public JSON toJSON(HttpServletRequest req) throws DashBoardException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", this.id);
        map.put("type", this.getType());
        map.put("unit", this.eas_kpi.unit);
        map.put("showPercent", new Integer(this.eas_kpi.showPercent));
        map.put("displayPrecision", new Integer(this.eas_kpi.displayPrecision));
        map.put("title", this.eas_kpi.title);
        map.put("myurl", this.eas_kpi.myurl);
        map.put("numValue", this.eas_kpi.lstNumValue);
        map.put("numMin", this.eas_kpi.lstNumMin);
        map.put("numMax", this.eas_kpi.lstNumMax);
        map.put("numAlerm", this.eas_kpi.lstNumMax2);
        map.put("numDanger", this.eas_kpi.lstNumMin2);
        map.put("bizDate", this.eas_kpi.lstBizDate);
        map.put("colorI", this.eas_kpi.lstColorI);
        map.put("colorII", this.eas_kpi.lstColorII);
        map.put("colorIII", this.eas_kpi.lstColorIII);
        map.put("errorMsg", this.eas_kpi.errorMsg);
        return new JSONMap(map);
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public boolean isShowTitle() {
        return false;
    }

    @Override
    public String getScript() {
        return "";
    }

    @Override
    public void setScript(String script) {
    }
}

