/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.ext.mp.dao;

import com.kingdee.bos.ctrl.analysis.web.ext.DateUtil;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.dao.ExtReportDAO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.ExtReportVO;
import com.kingdee.bos.ctrl.analysis.web.ext.mp.vo.ReportOfMyFolderVO;
import com.kingdee.bos.ctrl.analysis.web.ext.util.JDBCUtil;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class ReportOfMyFolderDAO {
    private static final Logger logger = CommonLogger.getLogger(ReportOfMyFolderDAO.class);

    public void deleteFromMyFolder(Connection connection, ReportOfMyFolderVO pVO) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = connection;
            String sql = "delete from T_EXT_ReportAndFolderNode where fcreatorid=? and(charindex(flongNumber,?)>0  or charindex(?,flongNumber)>0 )and forgid=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(2, pVO.getId());
            pstmt.setString(3, pVO.getId());
            pstmt.setString(4, pVO.getOrgId());
            pstmt.setString(1, pVO.getCreatorId());
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u5220\u9664\u6211\u7684\u6587\u4ef6\u5939\u6811\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(pstmt);
    }

    public void changeFolder(Connection connection, ReportOfMyFolderVO vo) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = connection;
            String sql = "update t_ext_reportandfoldernode set ffoldernodeid =?,fcreatetime = ? where freportid =? and forgid=? and fcreatorid=?";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(3, vo.getReportId());
            pstmt.setString(1, vo.getFolderNodeId());
            pstmt.setDate(2, new Date(vo.getCreateTime().getTime()));
            pstmt.setString(5, vo.getCreatorId());
            pstmt.setString(4, vo.getOrgId());
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u6539\u53d8\u6211\u7684\u6587\u4ef6\u5939\u8282\u70b9\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(null, pstmt, null);
                throw throwable;
            }
        }
        JDBCUtil.close(null, pstmt, null);
    }

    public void addToMyFolder(Connection connection, ReportOfMyFolderVO vo) throws SQLException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = connection;
            String sql = "insert into t_ext_reportandfoldernode(fid,freportid,ffoldernodeid,ftypeflag,fcreatetime,fcreatorid,forgid,flongnumber)values(?,?,?,?,?,?,?,?)";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, vo.getId());
            pstmt.setString(2, vo.getReportId());
            pstmt.setString(3, vo.getFolderNodeId());
            pstmt.setInt(4, vo.getReportType());
            pstmt.setDate(5, new Date(vo.getCreateTime().getTime()));
            pstmt.setString(6, vo.getCreatorId());
            pstmt.setString(7, vo.getOrgId());
            pstmt.setString(8, vo.getLongNumber());
            pstmt.execute();
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u589e\u52a0\u6211\u7684\u6587\u4ef6\u5939\u8282\u70b9\u64cd\u4f5c", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(null, pstmt, null);
                throw throwable;
            }
        }
        JDBCUtil.close(null, pstmt, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isReportAlreadyIn(Connection connection, ReportOfMyFolderVO vo) throws SQLException {
        boolean bl;
        ResultSet rs;
        PreparedStatement pstmt;
        block6: {
            boolean bl2;
            Connection conn = null;
            pstmt = null;
            rs = null;
            try {
                conn = connection;
                String sql = "select count(*) as exist FROM t_ext_reportandfoldernode r where r.freportid = ? and r.fcreatorid=? and r.forgid=? and r.fFolderNodeId=?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, vo.getReportId());
                pstmt.setString(2, vo.getCreatorId());
                pstmt.setString(3, vo.getOrgId());
                pstmt.setString(4, vo.getFolderNodeId());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int count = rs.getInt("exist");
                    if (count != 0) continue;
                    bl = false;
                    break block6;
                }
                bl2 = true;
            }
            catch (SQLException e) {
                try {
                    logger.warn((Object)"\u67e5\u8be2\u62a5\u8868\u5df2\u7ecf\u88ab\u52a0\u5165\u64cd\u4f5c\u5931\u8d25", (Throwable)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    JDBCUtil.close(rs, pstmt);
                    throw throwable;
                }
            }
            JDBCUtil.close(rs, pstmt);
            return bl2;
        }
        JDBCUtil.close(rs, pstmt);
        return bl;
    }

    public ArrayList queryMyFolderReportName(Connection connection, ReportOfMyFolderVO params, String queryName) throws SQLException {
        ArrayList<String> arrayList;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = connection;
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append("select ");
            sbSQL.append("d.FPortalAliasName as fname ");
            sbSQL.append("from T_BAS_DefineReport d ");
            sbSQL.append("where d.fid in (select r.freportid from  t_ext_reportandfoldernode r where r.fFolderNodeId =? and r.fcreatorid=? and r.forgid=?) and charindex(?,d.FPortalAliasName)=1 ");
            pstmt = conn.prepareStatement(sbSQL.toString());
            pstmt.setString(1, params.getFolderNodeId());
            pstmt.setString(2, params.getCreatorId());
            pstmt.setString(3, params.getOrgId());
            pstmt.setString(4, queryName);
            rs = pstmt.executeQuery();
            ArrayList<String> rsList = new ArrayList<String>();
            while (rs.next()) {
                rsList.add(rs.getString("fname"));
            }
            arrayList = rsList;
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u540d\u79f0\u5217\u8868\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, pstmt);
        return arrayList;
    }

    public ArrayList getMyFolderReportList(Connection connection, ReportOfMyFolderVO params, String local) throws SQLException {
        ArrayList<ExtReportVO> arrayList;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = connection;
            StringBuffer sbSQL = new StringBuffer();
            sbSQL.append("select d.fid, d.FBIPath, d.FIsStdProduct, d.ftemplettype,d.fmenuui as classname,");
            sbSQL.append("o.Fname_").append(local).append(" as orgname, ");
            sbSQL.append("d.FPortalAliasName as fname, ");
            sbSQL.append("u.Fname_").append(local).append(" as user_name, ");
            sbSQL.append("d.flastupdatetime, d.fdeploypath ");
            sbSQL.append("from T_BAS_DefineReport d left outer join t_pm_user u on d.fcreatorid=u.fid left outer join t_org_baseunit o on o.fid=d.forgid ");
            sbSQL.append("where d.fid in (select r.freportid from  t_ext_reportandfoldernode r where r.fFolderNodeId =? and r.fcreatorid=? and r.forgid=?)");
            pstmt = conn.prepareStatement(sbSQL.toString());
            pstmt.setString(1, params.getFolderNodeId());
            pstmt.setString(2, params.getCreatorId());
            pstmt.setString(3, params.getOrgId());
            rs = pstmt.executeQuery();
            ArrayList<ExtReportVO> rsList = new ArrayList<ExtReportVO>();
            while (rs.next()) {
                ExtReportVO vo = new ExtReportVO();
                vo.setId(rs.getString("fid"));
                vo.setReportName(rs.getString("fname"));
                vo.setCreator(rs.getString("user_name"));
                vo.setCreatorOrg(rs.getString("orgname"));
                vo.setModifiedTime(DateUtil.formatDateTimeHHmm(rs.getTimestamp("flastupdatetime").toString()));
                vo.setEasPath(ExtReportDAO.getDeployName(rs.getString("fdeploypath")));
                vo.setPortalPath(rs.getString("FBIPath"));
                vo.setIsStandard(rs.getInt("fisstdproduct") == 1);
                int reportType = rs.getInt("ftemplettype");
                vo.setReportType(reportType == 0 ? "\u4e0a\u62a5\u6a21\u677f" : (reportType == 1 ? "\u6c47\u603b\u6a21\u677f" : ""));
                vo.setClassName(rs.getString("classname"));
                rsList.add(vo);
            }
            arrayList = rsList;
        }
        catch (SQLException e) {
            try {
                logger.warn((Object)"\u83b7\u5f97\u62a5\u8868\u5217\u8868\u5931\u8d25", (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtil.close(rs, pstmt);
                throw throwable;
            }
        }
        JDBCUtil.close(rs, pstmt);
        return arrayList;
    }
}

