/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.link;

import com.kingdee.bos.ctrl.analysis.util.XmlUtil;
import com.kingdee.bos.ctrl.analysis.web.link.Linkage;
import org.w3c.dom.Node;

public class DimensionLink
implements Linkage {
    private String name;
    private String caption;
    private String dimension;
    private String paramColumn;
    private int level = -1;
    private String levelname;
    private String listName;
    private String mdxQuery;

    public DimensionLink(String name, String caption, String dimension, int level, String levelname, String paramColumn, String listName, String mdxQuery) {
        this.name = name;
        this.caption = caption;
        this.dimension = dimension;
        this.level = level;
        this.levelname = levelname;
        this.paramColumn = paramColumn;
        this.listName = listName;
        this.mdxQuery = mdxQuery;
    }

    public String getLevelname() {
        return this.levelname;
    }

    public static DimensionLink from(Node node) {
        String linkType;
        String name = XmlUtil.getNodeAttribute(node, "name");
        String caption = XmlUtil.getNodeAttribute(node, "caption");
        String mdxQuery = XmlUtil.getNodeAttribute(node, "mdxQuery");
        if (mdxQuery != null && !mdxQuery.equals("") && "list".equalsIgnoreCase(linkType = XmlUtil.getNodeAttribute(node, "linkType"))) {
            String dimension = XmlUtil.getNodeAttribute(node, "dimension");
            String paramColumn = XmlUtil.getNodeAttribute(node, "paramColumn");
            String linkTo = XmlUtil.getNodeAttribute(node, "linkTo");
            String query = XmlUtil.getNodeAttribute(node, "mdxQuery");
            String level = XmlUtil.getNodeAttribute(node, "level");
            int nLevel = -1;
            try {
                nLevel = Integer.parseInt(level);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String levelname = XmlUtil.getNodeAttribute(node, "levelname");
            DimensionLink link = new DimensionLink(name, caption, dimension, nLevel, levelname, paramColumn, linkTo, query);
            return link;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getListName() {
        return this.listName;
    }

    @Override
    public String getMdxQuery() {
        return this.mdxQuery;
    }

    public String getParamColumn() {
        return this.paramColumn;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public String getProperty(String propName) {
        return null;
    }

    @Override
    public String getType() {
        return "dimension";
    }
}

