/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.datacenter;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.DBCenterException;
import com.kingdee.bos.ctrl.analysis.common.dbcenter.service.DBCenterManager;
import com.kingdee.bos.ctrl.analysis.web.solution.BISystem;
import com.kingdee.bos.ctrl.common.datacenter.DataCenterInfo;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.DBUtil;
import com.kingdee.eas.util.BASE64Decoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class DataCenterManager {
    public static final Logger logger = CommonLogger.getLogger(DataCenterManager.class);
    private static HashMap map = null;
    public static final String ClassForName = "com.kingdee.bos.sql.shell.KDDriver";

    public static String[] getDataCenters(Context ctx) throws SQLException {
        try {
            return DBCenterManager.getDBCenterNames(ctx);
        }
        catch (DBCenterException e) {
            throw new SQLException("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u5217\u8868\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    public static Connection getConnection(Context ctx, String dbCenterName) throws SQLException {
        try {
            return DBCenterManager.getConnectionByName(ctx, dbCenterName);
        }
        catch (DBCenterException e) {
            throw new SQLException("\u83b7\u53d6\u6570\u636e\u4e2d\u5fc3\u8fde\u63a5\u51fa\u9519\uff1a" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List getDataCenterList(Context ctx) throws BOSException, SQLException {
        ArrayList<DataCenterInfo> arrayList;
        ArrayList<DataCenterInfo> list = new ArrayList<DataCenterInfo>();
        String sql = "select * from T_CTR_ExtReportOutDB";
        Connection con = null;
        ResultSet rs = null;
        try {
            con = BISystem.getJdbcConnection(ctx);
            rs = DBUtil.executeSql((Connection)con, (String)sql);
            while (rs.next()) {
                DataCenterInfo info = new DataCenterInfo();
                info.setDbCenterName(rs.getString("FDbCenterName"));
                info.setDbAddress(rs.getString("FDbAddress"));
                info.setDbName(rs.getString("FDbName"));
                info.setDbPort(rs.getInt("FDbPort"));
                info.setDbType(rs.getInt("FDbType"));
                info.setInstanceName(rs.getString("FInstanceName"));
                info.setUser(rs.getString("FUser"));
                info.setPwd(rs.getString("FPWD"));
                list.add(info);
            }
            arrayList = list;
        }
        catch (Throwable throwable) {
            DBUtil.closeResultSet(rs);
            DBUtil.closeDBConn((Connection)con);
            throw throwable;
        }
        DBUtil.closeResultSet((ResultSet)rs);
        DBUtil.closeDBConn((Connection)con);
        return arrayList;
    }

    private static Connection openConnection(DataCenterInfo vo) throws Exception {
        Connection conn = null;
        String connectUrl = DataCenterManager.getDriverClassName(vo.getDbType()) + ":" + DataCenterManager.getJDBCUrl(vo);
        DataCenterManager.loadDrive();
        logger.info((Object)("Open DB-Connection " + connectUrl));
        conn = DriverManager.getConnection(connectUrl, vo.getUser(), new String(new BASE64Decoder().decodeBuffer(vo.getPwd())));
        logger.info((Object)"Open DB-Connection OK.");
        return conn;
    }

    private static String getSqlServerUrl(String dbaddress, int dbport, String dbName) {
        String[] arr;
        String instanceName = null;
        if (dbaddress.indexOf("\\") != -1 && (arr = dbaddress.split("\\\\")).length == 2) {
            dbaddress = arr[0];
            instanceName = arr[1];
        }
        StringBuffer sb = new StringBuffer();
        if (instanceName != null && !instanceName.equals("")) {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";instance=").append(instanceName).append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        } else {
            sb.append("jdbc:jtds:sqlserver://").append(dbaddress).append(":").append(dbport).append("/").append(dbName);
            sb.append(";prepareSQL=2;sendStringParametersAsUnicode=false;useCursors=true");
        }
        return sb.toString();
    }

    private static String getOracelUrl(String dbaddress, int dbport, String instanceName) {
        return "jdbc:oracle:thin:@" + dbaddress + ":" + dbport + ":" + instanceName;
    }

    private static String getDb2Url(String dbaddress, int dbport, String dbName) {
        return "jdbc:db2://" + dbaddress + ":" + dbport + "/" + dbName + ":retrieveMessagesFromServerOnGetMessage=true;";
    }

    private static String getMysql(String dbaddress, int dbport, String dbName) {
        return "jdbc:mysql://" + dbaddress + ":" + dbport + "/" + dbName + "?useUnicode=true&characterEncoding=utf-8";
    }

    private static String getJDBCUrl(DataCenterInfo vo) {
        int dbType = vo.getDbType();
        if (dbType == 3) {
            return DataCenterManager.getSqlServerUrl(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 2) {
            return DataCenterManager.getOracelUrl(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 1) {
            return DataCenterManager.getDb2Url(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        if (dbType == 6) {
            return DataCenterManager.getMysql(vo.getDbAddress(), vo.getDbPort(), vo.getDbName());
        }
        return null;
    }

    private static String getDriverClassName(int dbType) {
        switch (dbType) {
            case 3: {
                return "jdbc:ksql:net.sourceforge.jtds.jdbc.Driver:dbtype=mssqlserver";
            }
            case 2: {
                return "jdbc:ksql:oracle.jdbc.driver.OracleDriver:dbtype=oracle";
            }
            case 1: {
                return "jdbc:ksql:com.ibm.db2.jcc.DB2Driver:dbtype=db2";
            }
            case 6: {
                return "jdbc:ksql:com.mysql.jdbc.Driver:dbtype=mysql";
            }
        }
        return null;
    }

    private static final boolean loadDrive() {
        logger.info((Object)"Load JDBC driver com.kingdee.bos.sql.shell.KDDriver");
        try {
            Class.forName(ClassForName);
        }
        catch (ClassNotFoundException ex) {
            logger.error((Object)ex, (Throwable)ex);
            return false;
        }
        logger.info((Object)"Load JDBC driver OK.");
        return true;
    }
}

