/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.impl;

import com.kingdee.bos.ctrl.analysis.web.bimreport.BIMFactory;
import com.kingdee.bos.ctrl.analysis.web.bimreport.BIMReportTreeModel;
import com.kingdee.bos.ctrl.analysis.web.repository.Repository;
import com.kingdee.bos.ctrl.analysis.web.solution.BISolution;
import com.kingdee.bos.ctrl.analysis.web.solution.BISubject;
import com.kingdee.bos.ctrl.analysis.web.solution.config.BISubjectConfig;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BIReportTreeModel;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BIReportTreeModel_EAS;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.DashboardModel;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.KPITreeModel;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.RepositoryTreeModel;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.ThemeReportTreeModel;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.swing.tree.TreeModel;

public class BISolutionImpl
implements BISolution {
    private String base_path;
    private BISubjectConfig subjectConfigDef = null;

    public BISolutionImpl(String root_path, String subjects_path) {
        this.base_path = root_path + File.separator + subjects_path + File.separator;
        this.subjectConfigDef = new BISubjectConfig(this.base_path);
        BIReportTreeModel.setBasepath(this.base_path);
    }

    @Override
    public BISubject lookupSubject(String subjectName) throws BIReportException {
        return this.subjectConfigDef.lookupSubject(subjectName);
    }

    @Override
    public String[] getAllSubjectName() throws BIReportException {
        return this.subjectConfigDef.getAllSubjectName();
    }

    @Override
    public String getSubjectsPath() {
        return this.base_path;
    }

    @Override
    public TreeModel getBITree(int type, Repository rep, HttpServletRequest req) throws BIReportException {
        RepositoryTreeModel treeModel = null;
        String wsName = "";
        String rootFolderName = "";
        switch (type) {
            case 0: {
                return new BIReportTreeModel(this.getSubjectsPath());
            }
            case 1: {
                return new BIReportTreeModel_EAS(rep);
            }
            case 2: {
                return new DashboardModel(rep);
            }
            case 3: 
            case 10: {
                wsName = "RPT";
                rootFolderName = "/piece";
                break;
            }
            case 4: {
                wsName = "DBD";
                rootFolderName = "/resource";
                break;
            }
            case 6: {
                wsName = "RPT";
                rootFolderName = "/report_tree";
                break;
            }
            case 5: {
                wsName = "DBD";
                rootFolderName = "/dashboard_tree";
                break;
            }
            case 7: {
                return new ThemeReportTreeModel(rep);
            }
            case 8: {
                return new KPITreeModel(rep, req);
            }
            case 9: {
                return new BIMReportTreeModel(BIMFactory.getBIMReportTreeInstance(req).getRoot());
            }
            default: {
                return null;
            }
        }
        treeModel = new RepositoryTreeModel(rep, wsName, rootFolderName);
        return treeModel;
    }

    @Override
    public TreeModel getReportsTree() {
        TreeModel ret = null;
        try {
            ret = this.getBITree(0, null, null);
        }
        catch (BIReportException bIReportException) {
            // empty catch block
        }
        return ret;
    }
}

