/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.impl;

import com.kingdee.bos.ctrl.analysis.web.solution.AbstractVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.BIReportVarProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.DataProvider;
import com.kingdee.bos.ctrl.analysis.web.solution.MacroVariant;
import com.kingdee.bos.ctrl.analysis.web.solution.ScriptSQL;
import com.kingdee.bos.ctrl.analysis.web.solution.def.DataSourceDef;
import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.filter.FilterValue;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.olap.util.IgnoreCaseString;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataProviderImpl
implements DataProvider {
    private static Logger logger = CommonLogger.getLogger(DataProviderImpl.class);
    private Map defineTableInfo;
    private String datacenter;

    public DataProviderImpl(DataSourceDef dsDef, String datacenter) throws BIReportException {
        this.defineTableInfo = dsDef.getAllTableInfo();
        this.datacenter = datacenter;
    }

    @Override
    public String getSql(AbstractVarProvider varProvider, String tableName) throws BIReportException {
        ScriptSQL sc = new ScriptSQL();
        String sql = (String)this.defineTableInfo.get(new IgnoreCaseString(tableName));
        if (sql == null) {
            throw new BIReportException("\u672a\u77e5\u8868\u540d\uff1a" + tableName.toString());
        }
        return sc.transSql(sql, varProvider, null, null);
    }

    @Override
    public String getSql(String tableName) throws BIReportException {
        String sql = (String)this.defineTableInfo.get(new IgnoreCaseString(tableName));
        if (sql == null) {
            throw new BIReportException("\u672a\u77e5\u8868\u540d\uff1a" + tableName.toString());
        }
        return sql;
    }

    @Override
    public Map getAllDataSource(AbstractVarProvider vp, FilterValue filterComponent) throws BIReportException {
        BIReportVarProvider varProvider = (BIReportVarProvider)vp;
        HashMap<IgnoreCaseString, String> dsMap = new HashMap<IgnoreCaseString, String>();
        ScriptSQL sc = new ScriptSQL();
        Map conditionMap = null;
        List macroList = null;
        if (filterComponent != null) {
            try {
                conditionMap = filterComponent.getFilterConditions();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BIReportException(e);
            }
            macroList = filterComponent.getMacroList();
            varProvider.putMacroList(macroList);
        }
        for (IgnoreCaseString tableName : this.defineTableInfo.keySet()) {
            String sql = (String)this.defineTableInfo.get(tableName);
            if (filterComponent != null) {
                sql = MacroVariant.handleStatement(macroList, sql);
            }
            sql = sc.transSql(sql, (AbstractVarProvider)varProvider, null, null);
            try {
                List conditions;
                if (filterComponent != null && (conditions = (List)conditionMap.get(tableName)) != null) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("select * from ").append("(").append(sql).append(") OSTTEMP where ");
                    for (int i = 0; i < conditions.size(); ++i) {
                        sb.append(conditions.get(i));
                        if (i >= conditions.size() - 1) continue;
                        sb.append(" and ");
                    }
                    sql = sb.toString();
                }
                logger.debug((Object)("[Datasource] " + tableName + ":" + sql));
                dsMap.put(tableName, sql);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BIReportException(e);
            }
        }
        return dsMap;
    }

    @Override
    public void release() {
    }

    @Override
    public String getDatacenter() {
        return this.datacenter;
    }
}

