/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.analysis.web.solution.tree;

import com.kingdee.bos.ctrl.analysis.web.solution.exception.BIReportException;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BIReportTreeModel;
import com.kingdee.bos.ctrl.analysis.web.solution.tree.BITreeNode;
import com.kingdee.bos.ctrl.analysis.web.solution.util.BISolutionCaptionUtil;
import com.kingdee.bos.ctrl.analysis.web.solution.util.FolderUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;

class BIReportTreeNode
extends DefaultKingdeeTreeNode
implements Comparable,
BITreeNode {
    public static final int NODE_TYPE_SUBJECTS = 0;
    public static final int NODE_TYPE_SUBJECT = 1;
    public static final int NODE_TYPE_REPORTDIR = 2;
    public static final int NODE_TYPE_REPORT = 3;
    private int nodeType;
    private String caption;
    private String path;
    private String name;
    private String subjectname;
    private List tmpChildNodeList = null;
    private static final String ID_SEPERATOR = "||";
    private static final String ID_SEPERATOR_REG = "\\|\\|";

    public static BIReportTreeNode fromID(String ID) {
        try {
            ID = URLDecoder.decode(ID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        String[] values = ID.split(ID_SEPERATOR_REG);
        if (values.length < 5) {
            return null;
        }
        return new BIReportTreeNode(Integer.parseInt(values[0]), values[1], values[2], values[3], values[4]);
    }

    @Override
    public String getID() {
        String ID = "";
        ID = String.valueOf(this.nodeType);
        ID = ID + ID_SEPERATOR + this.caption;
        ID = ID + ID_SEPERATOR + this.path;
        ID = ID + ID_SEPERATOR + this.name;
        ID = ID + ID_SEPERATOR + this.subjectname;
        try {
            ID = URLEncoder.encode(ID, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            ID = "";
        }
        return ID;
    }

    public BIReportTreeNode(String path) {
        super((Object)"\u4e3b\u9898\u5206\u6790", null);
        this.nodeType = 0;
        this.path = path;
        this.caption = "\u4e3b\u9898\u5206\u6790";
        this.name = "subjects";
        this.subjectname = "";
    }

    public BIReportTreeNode(int nodeType, String caption, String path, String name, String subjectname) {
        super((Object)caption, null);
        this.nodeType = nodeType;
        this.caption = caption;
        this.path = path;
        this.name = name;
        this.subjectname = subjectname;
    }

    public String toString() {
        return this.caption;
    }

    @Override
    public String getFullPath() {
        if (this.nodeType == 0 || this.nodeType == 1) {
            return "";
        }
        String subject_path = BIReportTreeModel.getBasepath() + this.subjectname + File.separator + "report" + File.separator;
        return this.path.substring(subject_path.length() - 1);
    }

    public String getReportPath() {
        return this.getFullPath();
    }

    public String getSubjectName() {
        return this.subjectname;
    }

    @Override
    public String getPropertyValue(String propertyName) {
        if (propertyName.equalsIgnoreCase("subject")) {
            return this.subjectname;
        }
        return null;
    }

    @Override
    public int getChildCount() {
        int nCount = 0;
        switch (this.nodeType) {
            case 0: {
                nCount = FolderUtil.getChildrenFolderCount(this.path, Arrays.asList("cvs", ".svn"));
                break;
            }
            case 1: {
                nCount = FolderUtil.getChildrenFolderAndFileCount(this.path + File.separator + "report", "olaprpt", Arrays.asList("cvs", ".svn"));
                break;
            }
            case 2: {
                nCount = FolderUtil.getChildrenFolderAndFileCount(this.path, "olaprpt", Arrays.asList("cvs", ".svn"));
                break;
            }
        }
        return nCount;
    }

    @Override
    public TreeNode getChildAt(int index) {
        int childCount = this.getChildCount();
        if (index < 0 || index >= childCount) {
            return null;
        }
        if (this.tmpChildNodeList != null) {
            return (TreeNode)this.tmpChildNodeList.get(index);
        }
        this.tmpChildNodeList = new ArrayList();
        switch (this.nodeType) {
            case 0: {
                String[] childrenPath = FolderUtil.getChildrenFolderPath(this.path, Arrays.asList("cvs", ".svn"));
                String[] childrenName = FolderUtil.parseName(childrenPath);
                String[] childrenCaption = null;
                try {
                    childrenCaption = BISolutionCaptionUtil.getCaptions(childrenPath, childrenName);
                }
                catch (BIReportException e) {
                    e.printStackTrace();
                }
                if (null == childrenCaption) break;
                for (int n = 0; n < childCount; ++n) {
                    this.tmpChildNodeList.add(new BIReportTreeNode(1, childrenCaption[n], childrenPath[n], childrenName[n], childrenName[n]));
                }
                break;
            }
            case 1: {
                String[] childrenPath = FolderUtil.getChildrenFolderAndFilePath(this.path + File.separator + "report", "olaprpt", Arrays.asList("cvs", ".svn"));
                String[] childrenName = FolderUtil.parseName(childrenPath);
                boolean[] childrenType = FolderUtil.parseType(childrenPath);
                String[] childrenCaption = null;
                try {
                    childrenCaption = BISolutionCaptionUtil.getCaptions(childrenPath, childrenName, childrenType);
                }
                catch (BIReportException e) {
                    e.printStackTrace();
                }
                for (int n = 0; n < childCount; ++n) {
                    this.tmpChildNodeList.add(new BIReportTreeNode(childrenType[n] ? 3 : 2, childrenCaption[n], childrenPath[n], childrenName[n], this.name));
                }
                break;
            }
            case 2: {
                String[] childrenPath = FolderUtil.getChildrenFolderAndFilePath(this.path, "olaprpt", Arrays.asList("cvs", ".svn"));
                String[] childrenName = FolderUtil.parseName(childrenPath);
                boolean[] childrenType = FolderUtil.parseType(childrenPath);
                String[] childrenCaption = null;
                try {
                    childrenCaption = BISolutionCaptionUtil.getCaptions(childrenPath, childrenName, childrenType);
                }
                catch (BIReportException e) {
                    e.printStackTrace();
                }
                for (int n = 0; n < childCount; ++n) {
                    this.tmpChildNodeList.add(new BIReportTreeNode(childrenType[n] ? 3 : 2, childrenCaption[n], childrenPath[n], childrenName[n], this.subjectname));
                }
                break;
            }
        }
        Collections.sort(this.tmpChildNodeList);
        return (TreeNode)this.tmpChildNodeList.get(index);
    }

    public int compareTo(Object o) {
        if (!(o instanceof BIReportTreeNode)) {
            return 1;
        }
        BIReportTreeNode objTo = (BIReportTreeNode)o;
        if (this.isLeaf()) {
            if (objTo.isLeaf()) {
                return this.caption.compareTo(objTo.caption);
            }
            return 1;
        }
        if (objTo.isLeaf()) {
            return -1;
        }
        return this.caption.compareTo(objTo.caption);
    }

    @Override
    public boolean isLeaf() {
        return this.nodeType == 3;
    }

    public Calendar getCreated() {
        return null;
    }

    @Override
    public Calendar getLastModified() {
        return null;
    }
}

