/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.onview;

import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IPrintConfigProvider;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.table.KDTPrintManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.print.IVariantParser;
import com.kingdee.bos.ctrl.print.extend.KDTableImagePrinter;
import com.kingdee.bos.ctrl.print.ui.component.PainterInfo;
import com.kingdee.bos.ctrl.swing.KDChart;
import java.awt.Component;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.jdom2.Element;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public class RDPrinter {
    private IPrintConfigProvider configProvider;

    public void setPrintConfigProvider(IPrintConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    public void doPrint(KDTable tbl, KDChart chart, boolean preview, Component parent) throws Exception {
        HeadFootModel header;
        KDTableImagePrinter printer = new KDTableImagePrinter();
        printer.setSpace(20);
        printer.addDataParser(KDTable.class, KDTableImagePrinter.TABLE_PARSER);
        printer.addDataParser(Image.class, KDTableImagePrinter.IMAGE_PARSER);
        printer.setParent(parent);
        ArrayList<Object> pList = new ArrayList<Object>();
        pList.add(tbl);
        if (chart != null) {
            pList.add(new ChartImage(chart).getImage());
        }
        printer.setPrintData(pList.toArray());
        printer.getPrinter().setVariantParser(new IVariantParser(){

            public String parse(String name, PainterInfo info) {
                if (RDPrinter.this.configProvider != null) {
                    return String.valueOf(RDPrinter.this.configProvider.getVar(name));
                }
                return " ";
            }
        });
        String configName = tbl.getPrintManager().getNewPrintManager().getPrinter().getPrintConfig().createXmlTrans().getName();
        Element e = this.getKDFForTable(tbl).getKDTableNewPrintConfig(configName);
        if (e != null) {
            printer.fromXmlElement(e);
        }
        if ((header = HeadFootParser.parseHeadFootPage2Model((Page)tbl.getPrintManager().getHeader())) == null && this.configProvider != null) {
            header = this.configProvider.getHeader();
        }
        if (header != null) {
            printer.setHeader(header);
        }
        if (preview) {
            printer.printPreview();
        } else {
            printer.print();
        }
        tbl.getPrintManager().fromXmlElement(printer.getPrinter().getPrintConfig().toXmlElement());
    }

    protected KDF getKDFForTable(KDTable kdt) {
        KDTPrintManager kdtPrintM = kdt.getPrintManager();
        KDF kdf = new KDF();
        kdtPrintM.saveToKDF(kdf);
        return kdf;
    }

    class ChartImage {
        private KDChart kdchart;
        private int width = 400;
        private int height = 300;
        private int type = 6;
        private byte[] data;
        private String name;

        ChartImage(KDChart cc) {
            this.kdchart = cc;
        }

        public Image getImage() {
            try {
                int h;
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int w = this.kdchart.getWidth();
                if (w < 10) {
                    w = 400;
                }
                if ((h = this.kdchart.getHeight()) < 10) {
                    h = 300;
                }
                ChartUtilities.writeChartAsPNG((OutputStream)os, (JFreeChart)this.kdchart.getDelegate(), (int)w, (int)h);
                this.width = w;
                this.height = h;
                this.data = os.toByteArray();
                this.name = this.kdchart.getChartTitle().getText();
                return new ImageIcon(this.data).getImage();
            }
            catch (IOException e) {
                return null;
            }
        }
    }
}

