/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.etl.content;

import com.kingdee.bos.ctrl.bibench.platform.ui.etl.actions.schedule.ScheduleDelAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.actions.schedule.ScheduleEditAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.actions.schedule.ScheduleNewAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.content.CanRefresh;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.content.ContentTable;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.context.ETLConsoleContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.exception.ETLRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.util.Util;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.console.AbstractConsoleAction;
import com.kingdee.bos.ctrl.common.ui.console.content.AbstractConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.IConsoleContent;
import com.kingdee.bos.ctrl.common.ui.console.content.ILeafContent;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.schedule.ui.JobItem;
import com.kingdee.bos.ctrl.etl.server.Server;
import com.kingdee.bos.ctrl.etl.server.facade.ETLServerFacade;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ScheduleListUI
extends AbstractConsoleContent
implements ILeafContent,
CanRefresh {
    private KDPanel tablePane = null;
    private ContentTable table = null;

    public ScheduleListUI() {
        this.initListener();
        this.initPopMenu();
    }

    private ETLServerFacade getServerBiz() throws ETLRemoteException {
        if (this.getContext() instanceof ETLConsoleContext) {
            return ((ETLConsoleContext)this.getContext()).getETLServerController();
        }
        return null;
    }

    private void initPopMenu() {
        this.addMenuItem(new ScheduleNewAction());
        this.addMenuItem(null);
        this.addMenuItem(new ScheduleDelAction());
        this.addMenuItem(null);
        this.addMenuItem(new ScheduleEditAction());
    }

    private void initListener() {
        this.getTable().addKDTMouseListener(new TableMouseListener());
    }

    public ContentTable getTable() {
        if (this.table != null) {
            return this.table;
        }
        this.table = new ContentTable();
        this.table.addColumns(new String[]{"schedulename", "jobname", "jobid", "ScheduleExpression", "IsUsed"});
        this.table.setHeadText("schedulename", "\u540d\u79f0");
        this.table.setHeadText("jobname", "\u4efb\u52a1\u5305\u540d");
        this.table.setHeadText("jobid", "JobID");
        this.table.setHeadText("ScheduleExpression", "Cron");
        this.table.setHeadText("IsUsed", "\u662f\u5426\u542f\u7528");
        this.table.getStyleAttributes().setLocked(true);
        this.table.setColumnWidth("schedulename", 150);
        this.table.setColumnWidth("jobname", 150);
        this.table.setColumnWidth("jobid", 0);
        this.table.setColumnWidth("ScheduleExpression", 0);
        this.table.setColumnWidth("IsUsed", 120);
        return this.table;
    }

    public KDPanel makeTablePane() {
        KDPanel panel = new KDPanel((LayoutManager)new BorderLayout());
        ContentTable t = this.getTable();
        panel.add((Component)((Object)t), (Object)"Center");
        t.setParent((Component)panel);
        return panel;
    }

    public void setPopMenuShow(boolean b) {
        this.getTable().setPopMenuShow(b);
    }

    protected void addMenuItem(AbstractConsoleAction action) {
        if (action == null) {
            this.getTable().getPopMenu().add((Component)new KDSeparator());
            return;
        }
        action.setUI((IConsoleContent)this);
        this.getTable().getPopMenu().add((JMenuItem)new KDMenuItem((Action)action));
    }

    public JobItem[] getJobitems() {
        JobItem[] jobitems = null;
        HashMap allAttrs = null;
        try {
            ETLServerFacade serverBiz = this.getServerBiz();
            allAttrs = serverBiz.listJobs();
        }
        catch (ETLRemoteException e) {
            WindowUtil.alert(null, (String)("\u901a\u8baf\u6545\u969c\uff01" + e.getMessage()));
            return null;
        }
        if (allAttrs != null) {
            String[] names = (String[])allAttrs.get("jobname");
            String[] ids = (String[])allAttrs.get("jobid");
            jobitems = new JobItem[names.length];
            for (int i = 0; i < names.length; ++i) {
                jobitems[i] = new JobItem();
                jobitems[i].setName(names[i]);
                jobitems[i].setID((long)Integer.parseInt(ids[i]));
            }
        }
        return jobitems;
    }

    public String[] getJobnames() {
        String[] jobnames = null;
        Server server = (Server)this.getContext();
        List jobs = server.getJobs();
        int size = jobs.size();
        jobnames = new String[size];
        int index = 0;
        for (Job job : jobs) {
            jobnames[index++] = job.getJobname();
        }
        return jobnames;
    }

    @Override
    public void refresh() {
        HashMap allAttrs = null;
        try {
            ETLServerFacade serverBiz = this.getServerBiz();
            allAttrs = serverBiz.listSchedules();
        }
        catch (ETLRemoteException e) {
            WindowUtil.alert(null, (String)("\u901a\u8baf\u6545\u969c\uff01" + e.getMessage()));
            return;
        }
        if (allAttrs == null) {
            this.getTable().removeRows();
        } else {
            this.refresh(allAttrs);
        }
    }

    protected void refresh(HashMap allAttrs) {
        ContentTable t = this.getTable();
        t.getBody().removeRows();
        String[] names = (String[])allAttrs.get("schedulename");
        int r = 0;
        for (int i = 0; i < names.length; ++i) {
            HashMap atts = Util.makeRowAtts(i, allAttrs);
            t.addRow(r);
            this.setRow(r, atts);
            ++r;
        }
    }

    public void clear() {
        this.getTable().removeRows();
    }

    public void addRow(HashMap attrs) {
        ContentTable t = this.getTable();
        t.addRow();
        int r = t.getRowCount() - 1;
        this.setRow(r, attrs);
    }

    public void setRow(int r, HashMap attrs) {
        ContentTable t = this.getTable();
        t.setRowUserObject(r, attrs);
        t.setCellValue(r, "schedulename", attrs.get("schedulename"));
        t.setCellValue(r, "jobname", attrs.get("jobname"));
        t.setCellValue(r, "jobid", attrs.get("jobid"));
        t.setCellValue(r, "ScheduleExpression", attrs.get("ScheduleExpression"));
        t.setCellValue(r, "IsUsed", attrs.get("IsUsed"));
    }

    public HashMap getRowAttrs(int r) {
        return (HashMap)this.getTable().getRowUserObject(r);
    }

    public void installCtrl(JPanel panel) {
        if (this.tablePane == null) {
            this.tablePane = this.makeTablePane();
        }
        this.refresh();
        panel.add((Component)this.tablePane, "Center");
    }

    public void deleteRowObjs() {
        int i;
        int[] rows = this.getTable().getSelectionRows();
        String names = this.makeObjsName(rows);
        if (names == null) {
            return;
        }
        if (MsgBox.confirm("ETL\u7ba1\u7406\u63a7\u5236\u53f0", names, this.getRootCtrl())) {
            for (i = 0; i < rows.length; ++i) {
                HashMap atts = (HashMap)this.getTable().getRowUserObject(rows[i]);
                String schedulename = Util.getToString(atts.get("schedulename"));
                try {
                    ETLServerFacade serverBiz = this.getServerBiz();
                    serverBiz.deleteSchedule(schedulename);
                    continue;
                }
                catch (Exception e) {
                    WindowUtil.msgboxError((Object)("\u5220\u9664" + schedulename + "\u5931\u8d25!\n\r\u539f\u56e0\uff1a" + e.getMessage()), (String)"error", (Component)((Object)this.getTable()));
                    return;
                }
            }
        }
        this.getTable().setSelectionRow(-1);
        for (i = rows.length - 1; i >= 0; --i) {
            this.deleteRowObj(rows[i]);
        }
    }

    private String makeObjsName(int[] rows) {
        HashMap atts = null;
        StringBuffer names = new StringBuffer();
        for (int i = 0; i < rows.length; ++i) {
            atts = (HashMap)this.getTable().getRowUserObject(rows[i]);
            String name = "(" + Util.getToString(atts.get("schedulename")) + ")";
            names.append(name);
            if (i == rows.length - 1) continue;
            names.append(", ");
        }
        return names.toString();
    }

    public void deleteRowObj(int r) {
        this.getTable().removeRow(r);
    }

    private class TableMouseListener
    implements KDTMouseListener {
        private TableMouseListener() {
        }

        public void tableClicked(KDTMouseEvent e) {
            ScheduleEditAction action;
            if (!ScheduleListUI.this.getTable().isPopMenuShow()) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton((MouseEvent)e) && e.getClickCount() == 2 && (action = new ScheduleEditAction()) != null) {
                action.setUI((IConsoleContent)ScheduleListUI.this);
                action.actionPerformed(new ActionEvent(e, 0, null));
            }
        }
    }
}

