/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.etl.dialog;

import com.kingdee.bos.ctrl.bibench.platform.ui.etl.content.ScheduleListUI;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.context.ETLConsoleContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.dialog.AbstractPropertyDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.exception.ETLRemoteException;
import com.kingdee.bos.ctrl.bibench.platform.ui.etl.util.Util;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.etl.schedule.entry.ScheduleEntryInterface;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpressionException;
import com.kingdee.bos.ctrl.etl.schedule.ui.CronDesignPanel;
import com.kingdee.bos.ctrl.etl.schedule.ui.JobItem;
import com.kingdee.bos.ctrl.etl.server.facade.ETLServerFacade;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.HashMap;

public class ScheduleDesignDialog
extends AbstractPropertyDialog {
    private static final long serialVersionUID = 1L;
    private KDLabel lblSchedulename = new KDLabel("\u4f5c\u4e1a\u540d\u79f0\uff1a");
    private KDTextField txtScheduleName = new KDTextField("");
    private KDLabel lblJobname = new KDLabel("\u4efb\u52a1\u5305\u540d\uff1a");
    private KDComboBox cmbJobname = new KDComboBox();
    private KDCheckBox chkUsed = new KDCheckBox("\u662f\u5426\u542f\u7528");
    private CronDesignPanel panelCronDesign = null;
    private String cronExpression = "";
    private JobItem jobitem = null;
    private String schedulename = "";
    private boolean isUsed = false;
    private ScheduleListUI ui = null;
    private static int DLG_WIDTH = 500;
    private static int DLG_HEIGHT = 400;

    public ScheduleDesignDialog() {
    }

    public ScheduleDesignDialog(Frame owner) {
        super(owner);
    }

    public ScheduleDesignDialog(Dialog owner) {
        super(owner);
    }

    protected void todoInit() {
        this.setSize(DLG_WIDTH, DLG_HEIGHT);
    }

    protected void todoAddControls(Container parent, Cell thisCell) {
        this.initUI();
        this.layoutUI(parent, thisCell);
    }

    private void initUI() {
        try {
            this.panelCronDesign = new CronDesignPanel(this.cronExpression);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.cmbJobname.removeAll();
        this.cmbJobname.addItems((Object[])this.ui.getJobitems());
        this.chkUsed.setSelected(this.isUsed);
        this.cmbJobname.setSelectedItem((Object)this.jobitem);
        this.txtScheduleName.setText(this.schedulename);
        this.txtScheduleName.setEditable(this.isNew());
        this.cmbJobname.setEnabled(this.isNew());
    }

    public void setUI(ScheduleListUI ui) {
        this.ui = ui;
    }

    @Override
    public HashMap makeDataFromCtrl() {
        this.getData().put("schedulename", this.schedulename);
        this.getData().put("jobname", this.jobitem.getName());
        this.getData().put("jobid", Integer.toString((int)this.jobitem.getID()));
        this.getData().put("IsUsed", this.isUsed ? "\u662f" : "\u5426");
        this.getData().put("ScheduleExpression", this.cronExpression);
        return this.getData();
    }

    private void layoutUI(Container parent, Cell thisCell) {
        Table tblDialog = thisCell.splitRow(2);
        tblDialog.rowStyle(0).setMarginBottom(10);
        tblDialog.rowStyle(0).setHeight(19);
        tblDialog.rowStyle(1).setPriY(1);
        Table tblJobname = tblDialog.cell(0).splitCol(5);
        tblJobname.colStyle(1).setMarginRight(10);
        tblJobname.colStyle(4).setAlignmentX((short)2);
        tblJobname.colStyle(4).setPriX(1);
        parent.add((Component)this.lblSchedulename, tblJobname.cell(0));
        parent.add((Component)this.txtScheduleName, tblJobname.cell(1));
        this.txtScheduleName.setMaxLength(20);
        this.txtScheduleName.setMinimumSize(new Dimension(100, 19));
        parent.add((Component)this.lblJobname, tblJobname.cell(2));
        this.cmbJobname.setMinimumSize(new Dimension(100, 19));
        parent.add((Component)this.cmbJobname, tblJobname.cell(3));
        this.chkUsed.setMinimumSize(new Dimension(100, 19));
        parent.add((Component)this.chkUsed, tblJobname.cell(4));
        parent.add((Component)this.panelCronDesign, tblDialog.cell(1));
    }

    public void setCronExpression(String cron) {
        this.cronExpression = cron;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public String getSchedulename() {
        return this.schedulename;
    }

    public JobItem getJobitem() {
        return this.jobitem;
    }

    public JobItem getJobItem() {
        return (JobItem)this.cmbJobname.getSelectedItem();
    }

    @Override
    public void loadData() {
        this.schedulename = this.getStrAttr("schedulename");
        this.isUsed = this.getStrAttr("IsUsed").equalsIgnoreCase("\u662f");
        long jobid = Util.toInt(this.getStrAttr("jobid"), -1);
        String jobname = this.getStrAttr("jobname");
        this.jobitem = new JobItem(jobname, jobid);
        this.cronExpression = this.getStrAttr("ScheduleExpression");
    }

    protected void onOk() {
        if (this.verify()) {
            this.makeDataFromCtrl();
            this.isOk = true;
            this.dispose();
        }
    }

    private boolean verifyCron() {
        String cron = "";
        try {
            cron = this.panelCronDesign.getCronExpression();
        }
        catch (CronExpressionException e) {
            WindowUtil.alert(null, (String)"\u8c03\u5ea6\u8868\u8fbe\u5f0f\u975e\u6cd5\uff01");
            return false;
        }
        this.cronExpression = cron;
        return true;
    }

    private boolean verifySchedulename() {
        if (!this.isNew()) {
            return true;
        }
        String name = this.txtScheduleName.getText();
        if (name.equalsIgnoreCase("")) {
            WindowUtil.alert((Component)((Object)this), (String)"\u8c03\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            return false;
        }
        try {
            if (this.getServerBiz().scheduleExist(name)) {
                WindowUtil.alert((Component)((Object)this), (String)"\u670d\u52a1\u5668\u4e2d\u5df2\u5b58\u5728\u76f8\u540c\u8c03\u5ea6\u540d\uff01");
                return false;
            }
        }
        catch (ETLRemoteException e) {
            WindowUtil.alert((Component)((Object)this), (String)("\u901a\u8baf\u6545\u969c\uff01" + e.getMessage()));
            return false;
        }
        this.schedulename = name;
        return true;
    }

    private ETLServerFacade getServerBiz() throws ETLRemoteException {
        if (this.ui.getContext() instanceof ETLConsoleContext) {
            return ((ETLConsoleContext)this.ui.getContext()).getETLServerController();
        }
        return null;
    }

    private boolean verifyJob() {
        JobItem item = (JobItem)this.cmbJobname.getSelectedItem();
        if (item == null) {
            WindowUtil.alert(null, (String)"\u5fc5\u987b\u9009\u62e9\u9700\u8c03\u5ea6\u7684\u4efb\u52a1\u5305\uff01");
            return false;
        }
        this.jobitem = item;
        return true;
    }

    private boolean saveSchedule() {
        String scheduleType = ScheduleEntryInterface.type_desc[1];
        String user = "admin";
        try {
            ETLServerFacade serverBiz = this.getServerBiz();
            serverBiz.updateSchedule(this.schedulename, this.jobitem.getID(), scheduleType, user, this.isUsed, this.cronExpression);
        }
        catch (ETLRemoteException e) {
            WindowUtil.alert(null, (String)("\u901a\u8baf\u6545\u969c\uff01\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage()));
            return false;
        }
        catch (Exception e) {
            WindowUtil.alert(null, (String)("\u8c03\u5ea6\u4fdd\u5b58\u5230\u670d\u52a1\u5668\u65f6\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage()));
            return false;
        }
        return true;
    }

    protected boolean verify() {
        this.isUsed = this.chkUsed.isSelected();
        if (!this.verifyCron()) {
            return false;
        }
        if (!this.verifySchedulename()) {
            return false;
        }
        if (!this.verifyJob()) {
            return false;
        }
        return this.saveSchedule();
    }
}

