/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.util;

import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class MidiPlayer {
    private static MidiPlayer self = new MidiPlayer();
    private Sequencer midi;
    private boolean stopped = false;
    private boolean playing = false;
    private Thread runner;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(String file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.play(fis);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fis});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fis});
        }
        CloseUtil.close((Closeable[])new Closeable[]{fis});
    }

    public void play(InputStream is) {
        this.stop();
        this.playing = true;
        try {
            Sequence seq = MidiSystem.getSequence(is);
            this.midi = MidiSystem.getSequencer();
            this.midi.open();
            this.midi.setSequence(seq);
            if (this.runner == null) {
                this.runner = new Thread(){

                    @Override
                    public void run() {
                        MidiPlayer.this.stopped = false;
                        MidiPlayer.this.midi.start();
                        try {
                            while (!MidiPlayer.this.stopped) {
                                Thread.sleep(200L);
                            }
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            MidiPlayer.this.playing = false;
                        }
                    }
                };
                this.runner.start();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() {
        this.playing = false;
        this.stopped = true;
        try {
            if (this.runner != null) {
                this.midi.close();
                this.midi = null;
                this.runner.stop();
                this.runner = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public static void playDefault(InputStream is) {
        self.play(is);
    }

    public static void stopDefault() {
        self.stop();
    }
}

