/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.application.server;

import com.kingdee.bos.ctrl.bibench.platform.application.server.MyServerConfig;
import com.kingdee.bos.ctrl.bibench.platform.services.IDataSource;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.AbstractDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class MyDataSource
extends AbstractDataSource
implements IDataSource {
    private MyServerConfig config;
    private Connection con;

    public MyDataSource(MyServerConfig config) {
        this.config = config;
    }

    private Connection newConnection() throws SQLException {
        String driver = this.config.getDriver();
        String url = this.config.getUrl();
        String user = this.config.getUser();
        String pwd = this.config.getPassword();
        try {
            Class.forName(driver);
            return DriverManager.getConnection(url, user, pwd);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException(driver + " class not found.");
        }
    }

    @Override
    public Connection requestConnection() throws SQLException {
        if (this.con == null || this.con.isClosed()) {
            this.con = this.newConnection();
        }
        return this.con;
    }

    @Override
    public void releaseConnection(Connection con) throws SQLException {
        if (con != null) {
            con.close();
        }
    }

    public void finalize() throws Throwable {
        if (this.con != null) {
            this.con.close();
            this.con = null;
        }
        super.finalize();
    }

    @Override
    public String getUrl() {
        return this.config.getUrl();
    }

    @Override
    public String getDriver() {
        return this.config.getDriver();
    }
}

