/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services.impl;

import com.kingdee.bos.ctrl.bibench.platform.services.IDataSource;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;

public abstract class AbstractDataSource
implements IDataSource {
    private boolean useKDdriver = false;
    private int dbType = 0;
    private boolean hasInit = false;

    @Override
    public String getSql(String sql) throws SqlTranslateException {
        this.ensureInit();
        if (this.useKDdriver) {
            return sql;
        }
        if (this.dbType != 0) {
            return TransUtil.Translate((String)sql, (int)this.dbType);
        }
        return sql;
    }

    private void ensureInit() {
        if (!this.hasInit) {
            String url;
            this.hasInit = true;
            this.useKDdriver = this.getDriver().indexOf("kingdee") != -1;
            String string = url = this.useKDdriver ? this.getUrl().toLowerCase() : this.getDriver().toLowerCase();
            if (url.indexOf("db2.") != -1) {
                this.dbType = 1;
            } else if (url.indexOf("microsoft.") != -1) {
                this.dbType = 3;
            } else if (url.indexOf("oracle.") != -1) {
                this.dbType = 2;
            }
        }
    }

    public abstract String getUrl();

    public abstract String getDriver();
}

