/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.services.impl.local;

import com.kingdee.bos.ctrl.bibench.platform.services.IImplementLocator;
import com.kingdee.bos.ctrl.bibench.platform.services.IServiceManager;
import com.kingdee.bos.ctrl.bibench.platform.services.ServiceContext;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.IMiniServer;
import com.kingdee.bos.ctrl.bibench.platform.services.impl.ImplementLocatorImpl;
import com.kingdee.bos.ctrl.bibench.platform.services.util.Util;
import com.kingdee.bos.ctrl.common.util.CommonLogger;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class MiniLocalObjectServer
implements IMiniServer {
    private static Map serviceRegistry = new Hashtable();
    private static Map objectMap = new Hashtable();
    private static IImplementLocator locator = null;
    private static Logger log = CommonLogger.getLogger((String)MiniLocalObjectServer.class.getName());

    @Override
    public Object addService(String serviceInterface, IServiceManager manager, ServiceContext context) {
        try {
            Class<?> clazzInterface = Class.forName(serviceInterface);
            String serviceObjectClass = MiniLocalObjectServer.locateImplementClass(clazzInterface, context);
            return this.addService(serviceInterface, serviceObjectClass, manager);
        }
        catch (Exception e) {
            String s = "The service-interface: " + serviceInterface + " with default implement(locator=" + locator + ") can't added.";
            throw new RuntimeException(s, e);
        }
    }

    @Override
    public Object addService(String serviceInterface, String serviceObjectClass, IServiceManager manager) {
        try {
            Class<?> clazzInterface = Class.forName(serviceInterface);
            MiniLocalObjectServer.addServiceRealObject(clazzInterface, serviceObjectClass);
            Object service = manager.createService(clazzInterface);
            this.addService(clazzInterface, service);
            return service;
        }
        catch (Exception e) {
            String s = "The service-interface: " + serviceInterface + " or the service-impl:" + serviceObjectClass + " can't added.";
            throw new RuntimeException(s, e);
        }
    }

    public void addService(Class anInterface, Object serviceObject) {
        serviceRegistry.put(anInterface, serviceObject);
    }

    @Override
    public Object getServiceByInterface(Class aInterface) {
        return serviceRegistry.get(aInterface);
    }

    public static Object getServiceRealObjectByInterface(Class aInterface, ServiceContext context) {
        Object obj = objectMap.get(aInterface);
        if (obj == null) {
            return MiniLocalObjectServer.addServiceRealObject(aInterface, MiniLocalObjectServer.locateImplementClass(aInterface, context));
        }
        return obj;
    }

    public void removeService(Class anInterface) {
        serviceRegistry.remove(anInterface);
    }

    private static Object addServiceRealObject(Class clazzInterface, String serviceObjectClass) {
        try {
            Object serviceObject = Util.createObject(serviceObjectClass);
            objectMap.put(clazzInterface, serviceObject);
            return serviceObject;
        }
        catch (Exception e) {
            String s = "Create " + clazzInterface + "'s service-impl:" + serviceObjectClass + " failed.";
            throw new RuntimeException(s, e);
        }
    }

    private static String locateImplementClass(Class serviceInterface, ServiceContext context) {
        String implLocator;
        if (locator == null && !Util.isEmpty(implLocator = Util.trim(context.getServiceConfig().getDefaultImplementLocatorClass()))) {
            try {
                locator = (IImplementLocator)Util.createObject(implLocator, IImplementLocator.class);
            }
            catch (Exception e) {
                log.warn((Object)"", (Throwable)e);
                e.printStackTrace();
            }
            if (locator == null) {
                locator = new ImplementLocatorImpl();
            }
        }
        return locator.getImplementName(serviceInterface.getName());
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        serviceRegistry.clear();
    }
}

