/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.dsselector;

import com.kingdee.bos.ctrl.bibench.platform.common.RDRowSet;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsAbstractNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsEntityNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsEtlNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.RDdsQueryNode;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.datasource.XFieldNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.DSValue;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.dsselector.RecordTreeIndex;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.fs.datasource.DSSqlBuilder;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JScrollBar;
import javax.swing.KeyStroke;

public class RecordSelectorPanel
extends KDPanel {
    public static final String VALUE_SELECTED_EVENT = "VALUE_SELECTED_EVENT";
    private RDdsAbstractNode ds;
    private DSValue dv;
    private KDTable tbl = new KDTable();
    private String[] colsName;
    private RDRowSet rs;
    private int cols;

    public RecordSelectorPanel(RDdsAbstractNode ds, DSValue dv) {
        this.setLayout(new BorderLayout());
        KDContainer c = FaceUtil.createContainer(ds.getName(), (Component)this.tbl);
        this.tbl.getSelectManager().setSelectMode(2);
        this.tbl.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tbl.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.tbl.setEditable(false);
        this.tbl.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 2) {
                    RecordSelectorPanel.this.firePropertyChange(RecordSelectorPanel.VALUE_SELECTED_EVENT, null, null);
                }
            }
        });
        this.tbl.addShortcutKey(KeyStroke.getKeyStroke(10, 0), VALUE_SELECTED_EVENT);
        this.tbl.getActionMap().put(VALUE_SELECTED_EVENT, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecordSelectorPanel.this.firePropertyChange(RecordSelectorPanel.VALUE_SELECTED_EVENT, null, null);
            }
        });
        this.add((Component)c, "Center");
        this.ds = ds;
        this.dv = dv;
    }

    public void init(PaltformWorkBenchContext ctx) throws Exception {
        String sql = this.ds.getDataSourceConfig().getSql();
        String caller = null;
        if (this.ds instanceof RDdsEtlNode) {
            caller = ctx.getUserID() + ((Object)((Object)this)).hashCode();
            sql = DSSqlBuilder.getETLSql(sql, "result", caller, ctx);
        } else {
            sql = this.ds instanceof RDdsEntityNode || this.ds instanceof RDdsQueryNode ? DSSqlBuilder.getMetaSql(sql, ctx) : DSSqlBuilder.getVarSql(sql, null, ctx);
        }
        this.rs = ctx.getPlatformFacade().executeQuery(sql);
        this.tbl.setUserObject((Object)this.rs);
        if (caller != null) {
            ctx.getPlatformFacade().releaseETLResource(caller);
        }
        this.tbl.setRefresh(false);
        this.tbl.removeRows();
        this.cols = this.dv.listFieldSize();
        for (int i = 0; i < this.cols; ++i) {
            this.tbl.addColumn();
        }
        IRow row = this.tbl.addHeadRow();
        this.colsName = new String[this.cols];
        for (int i = 0; i < this.cols; ++i) {
            XFieldNode f = this.ds.getDataSourceConfig().getField(this.dv.getListField(i));
            this.colsName[i] = f.getName();
            row.getCell(i).setValue((Object)f.getLabel());
        }
        while (this.rs.next()) {
            this.addNormalRow();
        }
        if (this.tbl.getRowCount() > 0) {
            this.tbl.getSelectManager().select(0, 0);
        }
        this.tbl.reLayoutAndPaint();
    }

    private IRow addNormalRow() {
        IRow row = this.tbl.addRow();
        for (int i = 0; i < this.cols; ++i) {
            row.getCell(i).setValue(this.rs.getObject(this.colsName[i]));
        }
        row.setUserObject((Object)new Integer(this.rs.getRow()));
        return row;
    }

    private void addTreeRow(RecordTreeIndex rti) {
        this.rs.moveTo(rti.getIndex());
        IRow row = this.addNormalRow();
        boolean f = rti.elementSize() > 0;
        CellTreeNode node = new CellTreeNode();
        node.setValue(row.getCell(0).getValue());
        node.setTreeLevel(rti.getLevel());
        node.setHasChildren(f);
        node.setCollapse(f);
        row.getCell(0).setValue((Object)node);
        if (f) {
            Iterator iter = rti.elements();
            while (iter.hasNext()) {
                this.addTreeRow((RecordTreeIndex)iter.next());
            }
        }
    }

    public Object getSelectedValue() {
        int r;
        KDTSelectBlock b = this.tbl.getSelectManager().get();
        if (b != null && (r = b.getTop()) >= 0) {
            this.rs.moveTo((Integer)this.tbl.getRow(r).getUserObject());
            HashMap map = new HashMap(this.rs.toRowMap()){

                @Override
                public String toString() {
                    return String.valueOf(this.get(RecordSelectorPanel.this.dv.getDisplayField()));
                }
            };
            return map;
        }
        return null;
    }
}

