/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.fs;

import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.bibench.platform.model.listener.ICatalogNodePropertyListener;
import com.kingdee.bos.ctrl.bibench.platform.model.nodes.RDBaseNode;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class RDBaseInternalFrame
extends KDPanel
implements ICatalogNodePropertyListener {
    protected PaltformWorkBenchContext ctx;
    protected RDBaseNode item;
    protected KDToolBar toolBar = new KDToolBar();
    protected KDPanel statusBar = new KDPanel();
    protected KDPanel topPanel = new KDPanel();
    protected KDLabel statuslbl = new KDLabel();
    protected KDWorkButton btnSave;

    public RDBaseInternalFrame(RDBaseNode item) {
        this.item = item;
        this.initUI();
    }

    public RDBaseNode getRDBaseNodeItem() {
        return this.item;
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.topPanel, "North");
        this.statusBar.setBorder((Border)new BevelBorder(1));
        this.statusBar.setLayout((LayoutManager)new FlowLayout(0, 1, 1));
        this.add((Component)this.statusBar, "South");
        this.statusBar.add((Component)this.statuslbl);
        this.statusBar.setVisible(false);
        this.initToolBar(this.toolBar);
        this.item.addPropertyListener(this);
    }

    public KDToolBar getToolBar() {
        return this.toolBar;
    }

    public void initToolBar(KDToolBar bar) {
        this.initToolBar_addSave(bar);
        this.initToolBar_addExit(bar);
    }

    protected void initToolBar_addSave(KDToolBar bar) {
        this.btnSave = new KDWorkButton("\u4fdd\u5b58");
        this.btnSave.setIcon(Resources.getIcon((String)"icon/tbtn_save.gif"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDBaseInternalFrame.this.save();
            }
        });
        bar.add((Component)this.btnSave);
        this.btnSave.setEnabled(this.item.isModified());
    }

    protected void initToolBar_addExit(KDToolBar bar) {
        KDWorkButton btnExit = new KDWorkButton("\u5173\u95ed");
        btnExit.setIcon(Resources.getIcon((String)"icon/tbtn_quit.gif"));
        btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDBaseInternalFrame.this.close();
            }
        });
        bar.add((Component)btnExit);
    }

    public void save() {
        this.ctx.getTree().saveNode(this.item);
        this.btnSave.setEnabled(this.item.isModified());
    }

    public boolean close() {
        return this.close(false);
    }

    public boolean close(boolean forceClose) {
        if (!forceClose && this.item.isModified()) {
            int re = JOptionPane.showConfirmDialog((Component)((Object)this), "\u662f\u5426\u4fdd\u5b58?", "\u5173\u95ed", 1, 3);
            if (re == 0) {
                this.save();
            } else if (re != 1) {
                return false;
            }
        }
        this.item.removePropertyListener(this);
        this.dispose();
        return true;
    }

    public void dispose() {
        this.ctx.getFrame().close(this.item);
    }

    public void setStauts(String msg) {
        this.statuslbl.setText(msg);
    }

    public void onLoad() throws Exception {
        this.setStauts("hello");
    }

    public PaltformWorkBenchContext getWorkBenchContext() {
        return this.ctx;
    }

    public void setWorkBenchContext(PaltformWorkBenchContext workBenchContext) {
        this.ctx = workBenchContext;
    }

    @Override
    public void valueChanged(String name, RDBaseNode source) {
        this.btnSave.setEnabled(true);
    }
}

