/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.metadata;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.metadata.IRDMetaDataSource;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.reportone.data.meta.bmd.BmdMetaEnv;
import com.kingdee.bos.ctrl.reportone.data.meta.bmd.BmdMetaLibrary;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLazyLoadCache;

public class RDMetaDataSource
implements IRDMetaDataSource {
    private AbstractMetaLazyLoader loader;

    public RDMetaDataSource(Context ctx) {
        this.loader = new ContextMetaLazyLoader(ctx);
    }

    public RDMetaDataSource(String metaDataPath) {
        this.loader = new PathMetaLazyLoader(metaDataPath);
    }

    @Override
    public MetaLibrary getMetaLibrary() {
        return this.loader.getLib();
    }

    @Override
    public IMetaDataLoader getMetaDataLoader() {
        return this.loader.getMetaDataLoader();
    }

    class PathMetaLazyLoader
    extends ContextMetaLazyLoader {
        PathMetaLazyLoader(String path) {
            super(new Context());
            this.ctx.put((Object)"METADATAPATH", (Object)path);
        }
    }

    class ContextMetaLazyLoader
    extends AbstractMetaLazyLoader {
        Context ctx;
        IMetaDataLoader metaLoader;

        ContextMetaLazyLoader(Context ctx) {
            this.ctx = ctx;
        }

        @Override
        MetaLibrary loadMetaData() {
            return new BmdMetaLibrary(new BmdMetaEnv(this.ctx));
        }

        @Override
        IMetaDataLoader getMetaDataLoader() {
            if (this.metaLoader == null) {
                this.metaLoader = new MetaDataLazyLoadCache(this.ctx);
            }
            return this.metaLoader;
        }
    }

    abstract class AbstractMetaLazyLoader {
        MetaLibrary lib;

        AbstractMetaLazyLoader() {
        }

        MetaLibrary getLib() {
            if (this.lib == null) {
                this.lib = this.loadMetaData();
            }
            return this.lib;
        }

        abstract MetaLibrary loadMetaData();

        abstract IMetaDataLoader getMetaDataLoader();
    }
}

