/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.n;

import com.kingdee.bos.ctrl.analysis.resource.Resources;
import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.RDBaseAction;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.filter.FilterItemCollection;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.DefaultPrintConfigProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IRDReportActor;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.IRDReportContentPanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.RDPrinter;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.n.INormalReportAllProvider;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitlePanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.KDTableUtil;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Action;

public class RDReportPanelN
extends KDPanel
implements IRDReportContentPanel {
    private KDToolBar toolBar = new KDToolBar();
    private KDTable table = new KDTable();
    private IRDReportActor actor;
    private PaltformWorkBenchContext ctx;
    private INormalReportAllProvider provider;
    private TitlePanel titlePanel = new TitlePanel();
    private String title;
    private RDBaseAction filterAction = null;
    private FilterDialog filterDialog;

    public RDReportPanelN(String title, IRDReportActor actor, PaltformWorkBenchContext ctx) {
        this.actor = actor;
        this.ctx = ctx;
        this.titlePanel.setPaltformWorkBenchContext(this.ctx);
        this.title = title;
        this.init();
    }

    @Override
    public KDTable getTable() {
        return this.table;
    }

    public TitlePanel getTitlePanel() {
        return this.titlePanel;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.titlePanel), "North");
        this.add((Component)this.table, "Center");
        this.table.getStyleAttributes().setLocked(true);
        this.table.getSelectManager().setSelectMode(2);
        this.initToolBar();
    }

    public KDToolBar getToolBar() {
        return this.toolBar;
    }

    public Component[] getToolBarComponentForEmbed() {
        Component[] cs = this.toolBar.getComponents();
        ArrayList<Component> list = new ArrayList<Component>();
        for (int i = 0; i < cs.length; ++i) {
            AbstractButton b;
            if (cs[i] instanceof AbstractButton && (b = (AbstractButton)cs[i]).getAction() instanceof RDBaseAction && ((RDBaseAction)b.getAction()).onlyForStandalone()) continue;
            list.add(cs[i]);
        }
        return list.toArray(new Component[0]);
    }

    private void initToolBar() {
        this.toolBar.add((Action)new RDBaseAction("\u5173\u95ed", Resources.getIcon((String)"icon/tbtn_quit.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDReportPanelN.this.exit();
            }

            @Override
            public boolean onlyForStandalone() {
                return true;
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u5237\u65b0", Resources.getIcon((String)"icon/tbtn_refresh.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDReportPanelN.this.actor != null) {
                    try {
                        RDReportPanelN.this.actor.refresh();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MsgBox.error(RDReportPanelN.this.getName(), e1, (Component)((Object)RDReportPanelN.this));
                    }
                }
            }
        });
        this.filterAction = new RDBaseAction("\u8fc7\u6ee4", Resources.getIcon((String)"icon/tbtn_filter.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RDReportPanelN.this.actor != null) {
                    try {
                        RDReportPanelN.this.actor.showQueryDialog();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MsgBox.error(RDReportPanelN.this.getName(), e1, (Component)((Object)RDReportPanelN.this));
                    }
                }
            }
        };
        this.toolBar.add((Action)this.filterAction);
        this.toolBar.add((Action)new RDBaseAction("\u6253\u5370\u9884\u89c8", Resources.getIcon((String)"icon/preview.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDPrinter rd = new RDPrinter();
                rd.setPrintConfigProvider(new DefaultPrintConfigProvider(RDReportPanelN.this.title, RDReportPanelN.this.titlePanel));
                try {
                    rd.doPrint(RDReportPanelN.this.table, null, true, (Component)((Object)RDReportPanelN.this));
                }
                catch (Exception _) {
                    _.printStackTrace();
                    MsgBox.error("\u6253\u5370\u9884\u89c8", _, (Component)((Object)RDReportPanelN.this));
                }
            }
        });
        this.toolBar.add((Action)new RDBaseAction("\u6253\u5370", Resources.getIcon((String)"icon/tbtn_print.gif")){

            @Override
            public void actionPerformed(ActionEvent e) {
                RDPrinter rd = new RDPrinter();
                rd.setPrintConfigProvider(new DefaultPrintConfigProvider(RDReportPanelN.this.title, RDReportPanelN.this.titlePanel));
                try {
                    rd.doPrint(RDReportPanelN.this.table, null, false, (Component)((Object)RDReportPanelN.this));
                }
                catch (Exception _) {
                    _.printStackTrace();
                    MsgBox.error("\u6253\u5370", _, (Component)((Object)RDReportPanelN.this));
                }
            }
        });
    }

    public void refreshContent(INormalReportAllProvider provider, FilterDialog filterDialog) {
        this.provider = provider;
        this.filterDialog = filterDialog;
        this.filterAction.setEnabled(filterDialog.isFilterEnabled());
        this.refreshUI();
    }

    public void refreshUI() {
        KDTableUtil.setTableData(this.provider.getRowSet(), this.provider.getColumnMap(), this.table);
    }

    @Override
    public void exit() {
        if (this.actor != null) {
            this.actor.exit();
        }
    }

    @Override
    public void refresh() throws Exception {
        this.provider.refresh();
        this.refreshUI();
    }

    @Override
    public void showQueryDialog() throws Exception {
        FilterItemCollection cc = this.filterDialog.showQueryDialog();
        if (cc != null) {
            this.provider.refresh(cc);
            this.refreshUI();
        }
    }
}

