/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title;

import com.kingdee.bos.ctrl.bibench.platform.ui.PaltformWorkBenchContext;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.ITitleModifyListener;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitileCellEditorDialog;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitlePanel;
import com.kingdee.bos.ctrl.bibench.platform.ui.content.onview.title.TitleScriptExecutor;
import com.kingdee.bos.ctrl.bibench.platform.ui.util.FaceUtil;
import com.kingdee.bos.ctrl.script.miniscript.MiniScriptParseException;
import com.kingdee.bos.ctrl.script.miniscript.ScriptResult;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class TitleCellPanel
extends KDPanel {
    private int align;
    private KDLabel lbl = new KDLabel();
    private ITitleModifyListener listener;
    private int row;
    private int col;
    private boolean useVar = false;
    private TitlePanel.Cell cell;
    private boolean forDesign = false;
    private PaltformWorkBenchContext ctx;
    private Map envMap = null;
    private TitileCellEditorDialog cellEditorDlg;

    public TitleCellPanel(boolean forDesign) {
        this.forDesign = forDesign;
        this.setLayout(new BorderLayout());
        this.add((Component)this.lbl, "Center");
        if (forDesign) {
            this.setBackground(Color.LIGHT_GRAY);
            this.setBorder(LineBorder.createGrayLineBorder());
            this.lbl.setBackground(Color.GRAY);
            this.lbl.setBorder((Border)new LineBorder(Color.GRAY.darker(), 1));
            MyMouseAdapter mma = new MyMouseAdapter();
            this.lbl.addMouseListener((MouseListener)mma);
            this.addMouseListener(mma);
        }
        this.lbl.setOpaque(true);
        this.lbl.setHorizontalAlignment(0);
    }

    public void setEnvMap(Map envMap) {
        this.envMap = envMap;
    }

    public void setCell(TitlePanel.Cell cell) {
        this.cell = cell;
    }

    public void setTitleModifyListener(ITitleModifyListener l) {
        this.listener = l;
    }

    public void setCellPostion(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public int getHorizontalAlignment() {
        return this.align;
    }

    public Font getCellFont() {
        return this.lbl.getFont();
    }

    public void setCellFont(Font f) {
        this.lbl.setFont(f);
        if (this.cell != null) {
            this.cell.fontBold = f.isBold();
            this.cell.fontSize = f.getSize();
        }
    }

    private void onEdit() {
        if (this.cellEditorDlg == null) {
            this.cellEditorDlg = new TitileCellEditorDialog(FaceUtil.peekFrame((Component)((Object)this)), this, this.listener, this.ctx);
            FaceUtil.center((Window)((Object)this.cellEditorDlg));
        }
        this.cellEditorDlg.showDialog();
    }

    public boolean isUseVar() {
        return this.useVar;
    }

    public void setUseVar(boolean b) {
        this.useVar = b;
        if (this.cell != null) {
            this.cell.useVar = b;
        }
    }

    public void setHorizontalAlignment(int align) {
        if (this.align == align) {
            return;
        }
        this.align = align;
        if (this.cell != null) {
            this.cell.align = align;
        }
        this.remove((Component)this.lbl);
        switch (align) {
            case 0: {
                this.add((Component)this.lbl, "Center");
                break;
            }
            case 11: {
                this.add((Component)this.lbl, "East");
                break;
            }
            default: {
                this.add((Component)this.lbl, "West");
            }
        }
        this.updateUI();
    }

    public void setPaltformWorkBenchContext(PaltformWorkBenchContext ctx) {
        this.ctx = ctx;
    }

    public void setText(String text) {
        if (!this.forDesign && this.useVar && text != null && text.length() > 0) {
            TitleScriptExecutor e = new TitleScriptExecutor(this.ctx);
            if (this.envMap != null) {
                e.putVar(this.envMap);
            }
            String name = "__$RET__CELL_VALUE";
            try {
                ScriptResult rs = e.execute(name + "=" + text);
                text = String.valueOf(rs.getVar(name));
            }
            catch (MiniScriptParseException e1) {
                text = e1.getMessage();
            }
        }
        this.lbl.setText(text);
        this.lbl.setToolTipText(text);
        if (this.cell != null) {
            this.cell.value = text;
        }
    }

    public String getText() {
        return this.lbl.getText();
    }

    public String genScript() {
        String alignS = this.align == 0 ? "center" : (this.align == 11 ? "right" : "left");
        String value = "'" + this.lbl.getText().replaceAll("'", "\"") + "'";
        StringBuffer s = new StringBuffer();
        String name = "R" + this.row + "C" + this.col;
        s.append("var ").append(name).append("=").append("title").append(".setCell(").append(this.row).append(",").append(this.col).append("," + value + "," + alignS + ");\r\n");
        s.append(name).append(".setFontBold(" + (this.lbl.getFont().isBold() ? "true" : "false") + ");\r\n");
        s.append(name).append(".setFontSize(" + this.lbl.getFont().getSize() + ");\r\n");
        if (this.useVar) {
            s.append(name).append(".setUseVar(true);");
        }
        return s.toString();
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TitleCellPanel.this.onEdit();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            TitleCellPanel.this.lbl.setBackground(TitleCellPanel.this.lbl.getBackground().brighter());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            TitleCellPanel.this.lbl.setBackground(TitleCellPanel.this.lbl.getBackground().darker());
        }
    }
}

